/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.HjToJimple.jimple.ForEachRegionExpr;
import soot.HjToJimple.jimple.LoopRegionExpr;
import soot.HjToJimple.jimple.NextRegionExpr;
import soot.HjToJimple.jimple.RegionEntry;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.util.CFGNode;
import soot.HjToJimple.util.RSTNode;
import soot.Unit;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.InverseGraph;
import soot.toolkits.graph.MHGPostDominatorsFinder;
import soot.toolkits.scalar.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFGNode_c
implements CFGNode {
    private CFGNode inNode;
    private CFGNode outNode;
    private ArrayList<CFGNode> inNodeList;
    private ArrayList<CFGNode> outNodeList;
    private CFGNode mergeNode;
    private ArrayList<Stmt> predList;
    private ArrayList<Stmt> succList;
    private ArrayList<Pair<CFGNode, Pair<Stmt, Stmt>>> branchExecPairs;
    private Stmt nodeStmt;

    public CFGNode_c() {
    }

    public CFGNode_c(Stmt nodeStmt) {
        this.nodeStmt = nodeStmt;
    }

    public CFGNode_c(Stmt nodeStmt, CFGNode inNode, CFGNode outNode) {
        this.nodeStmt = nodeStmt;
        this.inNode = inNode;
        this.outNode = outNode;
    }

    @Override
    public Stmt getNodeStmt() {
        return this.nodeStmt;
    }

    @Override
    public void setNodeStmt(Stmt nodeStmt) {
        this.nodeStmt = nodeStmt;
    }

    @Override
    public CFGNode getIn() {
        return this.inNode;
    }

    @Override
    public CFGNode getOut() {
        return this.outNode;
    }

    @Override
    public int getNumOfIns() {
        if (this.inNodeList != null) {
            return this.inNodeList.size();
        }
        if (this.inNode != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getNumOfOuts() {
        if (this.outNodeList != null) {
            return this.outNodeList.size();
        }
        if (this.outNode != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public List<CFGNode> getIns() {
        return this.inNodeList;
    }

    @Override
    public List<CFGNode> getOuts() {
        return this.outNodeList;
    }

    @Override
    public void clearIns() {
        if (this.inNodeList != null) {
            this.inNodeList.clear();
        }
        if (this.inNode != null) {
            this.inNode = null;
        }
    }

    @Override
    public void clearOuts() {
        if (this.outNodeList != null) {
            this.outNodeList.clear();
        }
        if (this.outNode != null) {
            this.outNode = null;
        }
    }

    @Override
    public void addIn(CFGNode node) {
        if (this.getNodeStmt() == node.getNodeStmt()) {
            return;
        }
        if (this.inNode == null) {
            this.inNode = node;
        } else if (this.inNodeList == null) {
            if (this.inNode != null && this.inNode.getNodeStmt() == node.getNodeStmt()) {
                return;
            }
            this.inNodeList = new ArrayList();
            this.inNodeList.add(this.inNode);
            this.inNodeList.add(node);
        } else {
            Iterator<CFGNode> nodeIter = this.inNodeList.iterator();
            while (nodeIter.hasNext()) {
                if (nodeIter.next().getNodeStmt() != node.getNodeStmt()) continue;
                return;
            }
            this.inNodeList.add(node);
        }
        if (this.hasOut(node)) {
            throw new Error("wrong connect: " + this + " --> " + node);
        }
    }

    public boolean hasIn(CFGNode node) {
        if (this.inNodeList != null) {
            Iterator<CFGNode> nodeIter = this.inNodeList.iterator();
            while (nodeIter.hasNext()) {
                if (nodeIter.next().getNodeStmt() != node.getNodeStmt()) continue;
                return true;
            }
        } else if (this.inNode != null) {
            return this.inNode.getNodeStmt() == node.getNodeStmt();
        }
        return false;
    }

    @Override
    public void addOut(CFGNode node) {
        if (this.getNodeStmt() == node.getNodeStmt()) {
            return;
        }
        if (this.outNode == null) {
            this.outNode = node;
        } else if (this.outNodeList == null) {
            if (this.outNode != null && this.outNode.getNodeStmt() == node.getNodeStmt()) {
                return;
            }
            this.outNodeList = new ArrayList();
            this.outNodeList.add(this.outNode);
            this.outNodeList.add(node);
        } else {
            Iterator<CFGNode> nodeIter = this.outNodeList.iterator();
            while (nodeIter.hasNext()) {
                if (nodeIter.next().getNodeStmt() != node.getNodeStmt()) continue;
                return;
            }
            this.outNodeList.add(node);
        }
        if (this.hasIn(node)) {
            throw new Error("wrong connect: " + this + " --> " + node);
        }
    }

    public boolean hasOut(CFGNode node) {
        if (this.outNodeList != null) {
            Iterator<CFGNode> nodeIter = this.outNodeList.iterator();
            while (nodeIter.hasNext()) {
                if (nodeIter.next().getNodeStmt() != node.getNodeStmt()) continue;
                return true;
            }
        } else if (this.outNode != null) {
            return this.outNode.getNodeStmt() == node.getNodeStmt();
        }
        return false;
    }

    @Override
    public void addIns(List<CFGNode> nodeList) {
        if (this.inNodeList == null) {
            this.inNodeList = new ArrayList();
        }
        this.inNodeList.addAll(nodeList);
    }

    @Override
    public void addOuts(List<CFGNode> nodeList) {
        if (this.outNodeList == null) {
            this.outNodeList = new ArrayList();
        }
        this.outNodeList.addAll(nodeList);
    }

    @Override
    public void removeIn(CFGNode node) {
        if (this.inNode == node) {
            this.inNode = null;
        }
        if (this.inNodeList != null) {
            this.inNodeList.remove(node);
        }
    }

    @Override
    public void removeOut(CFGNode node) {
        if (this.outNode == node) {
            this.outNode = null;
        }
        if (this.outNodeList != null) {
            this.outNodeList.remove(node);
        }
    }

    @Override
    public boolean isRegionNode() {
        return this.nodeStmt instanceof RegionStmt;
    }

    @Override
    public boolean isForEachNode() {
        if (this.nodeStmt instanceof RegionStmt) {
            RegionEntry regionEntry = (RegionEntry)((RegionStmt)this.nodeStmt).getRegionExpr();
            return regionEntry instanceof ForEachRegionExpr;
        }
        return false;
    }

    @Override
    public boolean isForLoopNode() {
        if (this.nodeStmt instanceof RegionStmt) {
            RegionEntry regionEntry = (RegionEntry)((RegionStmt)this.nodeStmt).getRegionExpr();
            return regionEntry instanceof LoopRegionExpr;
        }
        return false;
    }

    @Override
    public boolean isNextNode() {
        if (this.nodeStmt instanceof RegionStmt) {
            RegionEntry regionEntry = (RegionEntry)((RegionStmt)this.nodeStmt).getRegionExpr();
            return regionEntry instanceof NextRegionExpr;
        }
        return false;
    }

    @Override
    public CFGNode getMergeNode() {
        return this.mergeNode;
    }

    @Override
    public void setMergeNode(CFGNode mergeNode) {
        this.mergeNode = mergeNode;
    }

    @Override
    public boolean isBranchNode() {
        return this.nodeStmt instanceof IfStmt;
    }

    @Override
    public List<Stmt> getPreds() {
        return this.predList;
    }

    @Override
    public List<Stmt> getSuccs() {
        return this.succList;
    }

    @Override
    public void buildPreds(InverseGraph graph) {
        if (this.predList != null) {
            this.predList.clear();
        } else {
            this.predList = new ArrayList();
        }
        for (Stmt stmt : graph.getSuccsOf(this.getMergeNode().getNodeStmt())) {
            this.predList.add(stmt);
        }
    }

    @Override
    public void buildSuccs(InverseGraph graph) {
        if (this.succList != null) {
            this.succList.clear();
        } else {
            this.succList = new ArrayList();
        }
        for (Stmt stmt : graph.getPredsOf(this.nodeStmt)) {
            this.succList.add(stmt);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void rebuildBranch(Body body, MHGPostDominatorsFinder dominator) {
        NopStmt end0Label;
        Stmt succStmt;
        Stmt predStmt;
        int i;
        if (!this.isBranchNode()) {
            return;
        }
        InverseGraph graph = (InverseGraph)dominator.getGraph();
        this.buildPreds(graph);
        this.buildSuccs(graph);
        if (this.succList.size() != 2) {
            throw new RuntimeException("The number of branch entries is not 2?");
        }
        ArrayList<Pair<Object, Stmt>> branchPairs = new ArrayList<Pair<Object, Stmt>>();
        Stmt succStmt0 = this.succList.get(0);
        Stmt succStmt1 = this.succList.get(1);
        if (this.predList.size() != this.succList.size()) {
            for (i = 0; i < this.predList.size(); ++i) {
                void var10_12;
                predStmt = this.predList.get(i);
                succStmt = null;
                Object var10_13 = null;
                if (dominator.isDominatedBy(succStmt0, predStmt)) {
                    succStmt = succStmt0;
                    Stmt stmt = succStmt1;
                } else if (dominator.isDominatedBy(succStmt1, predStmt)) {
                    succStmt = succStmt1;
                    Stmt stmt = succStmt0;
                }
                if (succStmt == null) continue;
                NopStmt end1Label = Jimple.v().newNopStmt();
                body.getUnits().insertBefore(end1Label, (Unit)this.mergeNode.getNodeStmt());
                if (predStmt instanceof GotoStmt) {
                    end0Label = Jimple.v().newNopStmt();
                    body.getUnits().insertBefore(end0Label, (Unit)predStmt);
                    branchPairs.add(new Pair<Stmt, NopStmt>(succStmt, end0Label));
                    ((GotoStmt)predStmt).setTarget(this.mergeNode.getNodeStmt());
                } else if (predStmt instanceof IfStmt && succStmt == predStmt) {
                    ((IfStmt)succStmt).setTarget(this.mergeNode.getNodeStmt());
                } else {
                    throw new RuntimeException("Unsupported succ stmt: " + succStmt);
                }
                branchPairs.add(new Pair<void, NopStmt>(var10_12, end1Label));
                break;
            }
        } else {
            for (i = 0; i < this.predList.size(); ++i) {
                void var10_16;
                predStmt = this.predList.get(i);
                succStmt = null;
                Object var10_17 = null;
                if (dominator.isDominatedBy(succStmt0, predStmt)) {
                    succStmt = succStmt0;
                    Stmt stmt = succStmt1;
                } else if (dominator.isDominatedBy(succStmt1, predStmt)) {
                    succStmt = succStmt1;
                    Stmt stmt = succStmt0;
                }
                if (succStmt == null) continue;
                if (predStmt instanceof GotoStmt) {
                    NopStmt end0Label2 = Jimple.v().newNopStmt();
                    body.getUnits().insertBefore(end0Label2, (Unit)predStmt);
                    branchPairs.add(new Pair<Stmt, NopStmt>(succStmt, end0Label2));
                } else if (!(predStmt instanceof IfStmt && succStmt == predStmt || predStmt == this.getNodeStmt())) {
                    branchPairs.add(new Pair<Stmt, Stmt>(succStmt, predStmt));
                }
                Stmt nextPredStmt = null;
                nextPredStmt = i == 0 ? this.predList.get(1) : this.predList.get(0);
                if (nextPredStmt instanceof GotoStmt) {
                    end0Label = Jimple.v().newNopStmt();
                    body.getUnits().insertBefore(end0Label, (Unit)nextPredStmt);
                    branchPairs.add(new Pair<void, NopStmt>(var10_16, end0Label));
                    break;
                }
                if (nextPredStmt instanceof IfStmt && var10_16 == nextPredStmt || nextPredStmt == this.getNodeStmt()) break;
                branchPairs.add(new Pair<void, Stmt>(var10_16, nextPredStmt));
                break;
            }
        }
        this.branchExecPairs = new ArrayList();
        ArrayList<CFGNode> succNodes = this.outNodeList;
        for (int i2 = 0; i2 < succNodes.size(); ++i2) {
            void var10_23;
            CFGNode succNode = (CFGNode)succNodes.get(i2);
            Object var10_22 = null;
            if (succNode.getNodeStmt() == this.getMergeNode().getNodeStmt()) continue;
            for (Pair pair : branchPairs) {
                Stmt entryStmt = (Stmt)pair.getO1();
                if (!dominator.isDominatedBy(entryStmt, succNode.getNodeStmt())) continue;
                this.branchExecPairs.add(new Pair<CFGNode, Pair>(succNode, pair));
                break;
            }
            branchPairs.remove(var10_23);
            if (branchPairs.size() <= 0) continue;
            if (i2 == 0) {
                this.branchExecPairs.add(new Pair(succNodes.get(1), branchPairs.get(0)));
                continue;
            }
            this.branchExecPairs.add(new Pair(succNodes.get(0), branchPairs.get(0)));
        }
    }

    @Override
    public List<Pair<CFGNode, Pair<Stmt, Stmt>>> getBranchPairs() {
        return this.branchExecPairs;
    }

    @Override
    public boolean hasBranchSuccStmt() {
        if (this.succList != null) {
            Iterator<Stmt> stmtIter = this.succList.iterator();
            while (stmtIter.hasNext()) {
                if (!(stmtIter.next() instanceof IfStmt)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Stmt> getBranchSuccStmt() {
        ArrayList<Stmt> stmtList = new ArrayList<Stmt>();
        if (this.succList != null) {
            for (Stmt stmt : this.succList) {
                if (!(stmt instanceof IfStmt)) continue;
                stmtList.add(stmt);
            }
        }
        return stmtList;
    }

    @Override
    public boolean hasBranchSuccNode() {
        if (this.outNodeList != null) {
            Iterator<CFGNode> nodeIter = this.outNodeList.iterator();
            while (nodeIter.hasNext()) {
                if (!nodeIter.next().isBranchNode()) continue;
                return true;
            }
        } else if (this.outNode != null) {
            return this.outNode.isBranchNode();
        }
        return false;
    }

    @Override
    public List<CFGNode> getBranchSuccNode() {
        ArrayList<CFGNode> nodeList = new ArrayList<CFGNode>();
        if (this.outNodeList != null) {
            for (CFGNode node : this.outNodeList) {
                if (!node.isBranchNode()) continue;
                nodeList.add(node);
            }
        } else if (this.outNode != null && this.outNode.isBranchNode()) {
            nodeList.add(this.outNode);
        }
        return nodeList;
    }

    @Override
    public List<RSTNode> collectRSTNodes() {
        ArrayList<RSTNode> rstNodeList = new ArrayList<RSTNode>();
        if (this.isRegionNode()) {
            rstNodeList.add(((RegionStmt)this.getNodeStmt()).getRSTNode());
        } else if (this.isBranchNode()) {
            Iterator<CFGNode> nodeIter = this.getOuts().iterator();
            while (nodeIter.hasNext()) {
                this.collectRSTNodes(nodeIter.next(), this.mergeNode, rstNodeList);
            }
        }
        return rstNodeList;
    }

    @Override
    public void collectRSTNodes(CFGNode startNode, CFGNode mergeNode, List<RSTNode> rstNodeList) {
        if (startNode.getNodeStmt() != mergeNode.getNodeStmt()) {
            if (startNode.isRegionNode()) {
                rstNodeList.add(((RegionStmt)startNode.getNodeStmt()).getRSTNode());
            }
            if (startNode.getNumOfOuts() == 0) {
                return;
            }
            if (startNode.getNumOfOuts() == 1) {
                this.collectRSTNodes(startNode.getOut(), mergeNode, rstNodeList);
            } else {
                Iterator<CFGNode> nodeIter = startNode.getOuts().iterator();
                while (nodeIter.hasNext()) {
                    this.collectRSTNodes(nodeIter.next(), mergeNode, rstNodeList);
                }
            }
        }
    }

    @Override
    public String toString() {
        return "CFG Node: " + this.nodeStmt;
    }
}

