/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Annotation;
import soot.JastAddJ.List;
import soot.JastAddJ.Modifier;
import soot.JastAddJ.TypeDecl;
import soot.PhaseOptions;
import soot.options.JBOptions;
import soot.tagkit.AnnotationTag;
import soot.tagkit.VisibilityAnnotationTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modifiers
extends ASTNode<ASTNode>
implements Cloneable {
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    private int getNumModifier = 0;
    protected boolean isPublic_computed = false;
    protected boolean isPublic_value;
    protected boolean isPrivate_computed = false;
    protected boolean isPrivate_value;
    protected boolean isProtected_computed = false;
    protected boolean isProtected_value;
    protected boolean isStatic_computed = false;
    protected boolean isStatic_value;
    protected boolean isFinal_computed = false;
    protected boolean isFinal_value;
    protected boolean isAbstract_computed = false;
    protected boolean isAbstract_value;
    protected boolean isVolatile_computed = false;
    protected boolean isVolatile_value;
    protected boolean isTransient_computed = false;
    protected boolean isTransient_value;
    protected boolean isStrictfp_computed = false;
    protected boolean isStrictfp_value;
    protected boolean isSynchronized_computed = false;
    protected boolean isSynchronized_value;
    protected boolean isNative_computed = false;
    protected boolean isNative_value;
    protected boolean isSynthetic_computed = false;
    protected boolean isSynthetic_value;
    protected Map numModifier_String_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.isPublic_computed = false;
        this.isPrivate_computed = false;
        this.isProtected_computed = false;
        this.isStatic_computed = false;
        this.isFinal_computed = false;
        this.isAbstract_computed = false;
        this.isVolatile_computed = false;
        this.isTransient_computed = false;
        this.isStrictfp_computed = false;
        this.isSynchronized_computed = false;
        this.isNative_computed = false;
        this.isSynthetic_computed = false;
        this.numModifier_String_values = null;
    }

    @Override
    public Modifiers clone() throws CloneNotSupportedException {
        Modifiers node = (Modifiers)super.clone();
        node.isPublic_computed = false;
        node.isPrivate_computed = false;
        node.isProtected_computed = false;
        node.isStatic_computed = false;
        node.isFinal_computed = false;
        node.isAbstract_computed = false;
        node.isVolatile_computed = false;
        node.isTransient_computed = false;
        node.isStrictfp_computed = false;
        node.isSynchronized_computed = false;
        node.isNative_computed = false;
        node.isSynthetic_computed = false;
        node.numModifier_String_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public Modifiers copy() {
        try {
            Modifiers node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Modifiers fullCopy() {
        Modifiers res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    @Override
    public void checkModifiers() {
        super.checkModifiers();
        if (this.numProtectionModifiers() > 1) {
            this.error("only one public, protected, private allowed");
        }
        if (this.numModifier("static") > 1) {
            this.error("only one static allowed");
        }
        if (this.numCompletenessModifiers() > 1) {
            this.error("only one of final, abstract, volatile allowed");
        }
        if (this.numModifier("synchronized") > 1) {
            this.error("only one synchronized allowed");
        }
        if (this.numModifier("transient") > 1) {
            this.error("only one transient allowed");
        }
        if (this.numModifier("native") > 1) {
            this.error("only one native allowed");
        }
        if (this.numModifier("strictfp") > 1) {
            this.error("only one strictfp allowed");
        }
        if (this.isPublic() && !this.mayBePublic()) {
            this.error("modifier public not allowed in this context");
        }
        if (this.isPrivate() && !this.mayBePrivate()) {
            this.error("modifier private not allowed in this context");
        }
        if (this.isProtected() && !this.mayBeProtected()) {
            this.error("modifier protected not allowed in this context");
        }
        if (this.isStatic() && !this.mayBeStatic()) {
            this.error("modifier static not allowed in this context");
        }
        if (this.isFinal() && !this.mayBeFinal()) {
            this.error("modifier final not allowed in this context");
        }
        if (this.isAbstract() && !this.mayBeAbstract()) {
            this.error("modifier abstract not allowed in this context");
        }
        if (this.isVolatile() && !this.mayBeVolatile()) {
            this.error("modifier volatile not allowed in this context");
        }
        if (this.isTransient() && !this.mayBeTransient()) {
            this.error("modifier transient not allowed in this context");
        }
        if (this.isStrictfp() && !this.mayBeStrictfp()) {
            this.error("modifier strictfp not allowed in this context");
        }
        if (this.isSynchronized() && !this.mayBeSynchronized()) {
            this.error("modifier synchronized not allowed in this context");
        }
        if (this.isNative() && !this.mayBeNative()) {
            this.error("modifier native not allowed in this context");
        }
    }

    @Override
    public void toString(StringBuffer s) {
        for (int i = 0; i < this.getNumModifier(); ++i) {
            this.getModifier(i).toString(s);
            s.append(" ");
        }
    }

    public void addSourceOnlyAnnotations(Collection c) {
        if (new JBOptions(PhaseOptions.v().getPhaseOptions("jb")).preserve_source_annotations()) {
            for (int i = 0; i < this.getNumModifier(); ++i) {
                Annotation a;
                if (!(this.getModifier(i) instanceof Annotation) || (a = (Annotation)this.getModifier(i)).isRuntimeVisible() || a.isRuntimeInvisible()) continue;
                VisibilityAnnotationTag tag = new VisibilityAnnotationTag(2);
                ArrayList elements = new ArrayList(1);
                a.appendAsAttributeTo(elements);
                tag.addAnnotation((AnnotationTag)elements.get(0));
                c.add(tag);
            }
        }
    }

    public void addAllAnnotations(Collection c) {
        for (int i = 0; i < this.getNumModifier(); ++i) {
            if (!(this.getModifier(i) instanceof Annotation)) continue;
            Annotation a = (Annotation)this.getModifier(i);
            a.appendAsAttributeTo(c);
        }
    }

    public void addRuntimeVisibleAnnotationsAttribute(Collection c) {
        Collection annotations = this.runtimeVisibleAnnotations();
        if (!annotations.isEmpty()) {
            VisibilityAnnotationTag tag = new VisibilityAnnotationTag(0);
            for (Annotation annotation2 : annotations) {
                ArrayList elements = new ArrayList(1);
                annotation2.appendAsAttributeTo(elements);
                tag.addAnnotation((AnnotationTag)elements.get(0));
            }
            c.add(tag);
        }
    }

    public void addRuntimeInvisibleAnnotationsAttribute(Collection c) {
        Collection annotations = this.runtimeInvisibleAnnotations();
        if (!annotations.isEmpty()) {
            VisibilityAnnotationTag tag = new VisibilityAnnotationTag(1);
            for (Annotation annotation2 : annotations) {
                ArrayList elements = new ArrayList(1);
                annotation2.appendAsAttributeTo(elements);
                tag.addAnnotation((AnnotationTag)elements.get(0));
            }
            c.add(tag);
        }
    }

    public Collection runtimeVisibleAnnotations() {
        ArrayList<Modifier> annotations = new ArrayList<Modifier>();
        for (int i = 0; i < this.getNumModifier(); ++i) {
            if (!this.getModifier(i).isRuntimeVisible()) continue;
            annotations.add(this.getModifier(i));
        }
        return annotations;
    }

    public Collection runtimeInvisibleAnnotations() {
        ArrayList<Modifier> annotations = new ArrayList<Modifier>();
        for (int i = 0; i < this.getNumModifier(); ++i) {
            if (!this.getModifier(i).isRuntimeInvisible()) continue;
            annotations.add(this.getModifier(i));
        }
        return annotations;
    }

    public Modifiers() {
        this.setChild(new List(), 0);
    }

    public Modifiers(List<Modifier> p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setModifierList(List<Modifier> list) {
        this.setChild(list, 0);
    }

    public int getNumModifier() {
        return this.getModifierList().getNumChild();
    }

    public Modifier getModifier(int i) {
        return (Modifier)this.getModifierList().getChild(i);
    }

    public void addModifier(Modifier node) {
        List<Modifier> list = this.getModifierList();
        list.addChild(node);
    }

    public void setModifier(Modifier node, int i) {
        List<Modifier> list = this.getModifierList();
        list.setChild(node, i);
    }

    public List<Modifier> getModifiers() {
        return this.getModifierList();
    }

    public List<Modifier> getModifiersNoTransform() {
        return this.getModifierListNoTransform();
    }

    public List<Modifier> getModifierList() {
        return (List)this.getChild(0);
    }

    public List<Modifier> getModifierListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public boolean isPublic() {
        if (this.isPublic_computed) {
            return this.isPublic_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isPublic_value = this.isPublic_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isPublic_computed = true;
        }
        return this.isPublic_value;
    }

    private boolean isPublic_compute() {
        return this.numModifier("public") != 0;
    }

    public boolean isPrivate() {
        if (this.isPrivate_computed) {
            return this.isPrivate_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isPrivate_value = this.isPrivate_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isPrivate_computed = true;
        }
        return this.isPrivate_value;
    }

    private boolean isPrivate_compute() {
        return this.numModifier("private") != 0;
    }

    public boolean isProtected() {
        if (this.isProtected_computed) {
            return this.isProtected_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isProtected_value = this.isProtected_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isProtected_computed = true;
        }
        return this.isProtected_value;
    }

    private boolean isProtected_compute() {
        return this.numModifier("protected") != 0;
    }

    public boolean isStatic() {
        if (this.isStatic_computed) {
            return this.isStatic_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isStatic_value = this.isStatic_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isStatic_computed = true;
        }
        return this.isStatic_value;
    }

    private boolean isStatic_compute() {
        return this.numModifier("static") != 0;
    }

    public boolean isFinal() {
        if (this.isFinal_computed) {
            return this.isFinal_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isFinal_value = this.isFinal_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isFinal_computed = true;
        }
        return this.isFinal_value;
    }

    private boolean isFinal_compute() {
        return this.numModifier("final") != 0;
    }

    public boolean isAbstract() {
        if (this.isAbstract_computed) {
            return this.isAbstract_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isAbstract_value = this.isAbstract_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isAbstract_computed = true;
        }
        return this.isAbstract_value;
    }

    private boolean isAbstract_compute() {
        return this.numModifier("abstract") != 0;
    }

    public boolean isVolatile() {
        if (this.isVolatile_computed) {
            return this.isVolatile_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isVolatile_value = this.isVolatile_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isVolatile_computed = true;
        }
        return this.isVolatile_value;
    }

    private boolean isVolatile_compute() {
        return this.numModifier("volatile") != 0;
    }

    public boolean isTransient() {
        if (this.isTransient_computed) {
            return this.isTransient_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isTransient_value = this.isTransient_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isTransient_computed = true;
        }
        return this.isTransient_value;
    }

    private boolean isTransient_compute() {
        return this.numModifier("transient") != 0;
    }

    public boolean isStrictfp() {
        if (this.isStrictfp_computed) {
            return this.isStrictfp_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isStrictfp_value = this.isStrictfp_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isStrictfp_computed = true;
        }
        return this.isStrictfp_value;
    }

    private boolean isStrictfp_compute() {
        return this.numModifier("strictfp") != 0;
    }

    public boolean isSynchronized() {
        if (this.isSynchronized_computed) {
            return this.isSynchronized_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isSynchronized_value = this.isSynchronized_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isSynchronized_computed = true;
        }
        return this.isSynchronized_value;
    }

    private boolean isSynchronized_compute() {
        return this.numModifier("synchronized") != 0;
    }

    public boolean isNative() {
        if (this.isNative_computed) {
            return this.isNative_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isNative_value = this.isNative_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isNative_computed = true;
        }
        return this.isNative_value;
    }

    private boolean isNative_compute() {
        return this.numModifier("native") != 0;
    }

    public boolean isSynthetic() {
        if (this.isSynthetic_computed) {
            return this.isSynthetic_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isSynthetic_value = this.isSynthetic_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isSynthetic_computed = true;
        }
        return this.isSynthetic_value;
    }

    private boolean isSynthetic_compute() {
        return this.numModifier("synthetic") != 0;
    }

    public int numProtectionModifiers() {
        int numProtectionModifiers_value = this.numProtectionModifiers_compute();
        return numProtectionModifiers_value;
    }

    private int numProtectionModifiers_compute() {
        return this.numModifier("public") + this.numModifier("protected") + this.numModifier("private");
    }

    public int numCompletenessModifiers() {
        int numCompletenessModifiers_value = this.numCompletenessModifiers_compute();
        return numCompletenessModifiers_value;
    }

    private int numCompletenessModifiers_compute() {
        return this.numModifier("abstract") + this.numModifier("final") + this.numModifier("volatile");
    }

    public int numModifier(String name) {
        String _parameters = name;
        if (this.numModifier_String_values == null) {
            this.numModifier_String_values = new HashMap(4);
        }
        if (this.numModifier_String_values.containsKey(_parameters)) {
            return (Integer)this.numModifier_String_values.get(_parameters);
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        int numModifier_String_value = this.numModifier_compute(name);
        if (isFinal && num == boundariesCrossed) {
            this.numModifier_String_values.put(_parameters, new Integer(numModifier_String_value));
        }
        return numModifier_String_value;
    }

    private int numModifier_compute(String name) {
        int n = 0;
        for (int i = 0; i < this.getNumModifier(); ++i) {
            String s = this.getModifier(i).getID();
            if (!s.equals(name)) continue;
            ++n;
        }
        return n;
    }

    public Annotation annotation(TypeDecl typeDecl) {
        Annotation annotation_TypeDecl_value = this.annotation_compute(typeDecl);
        return annotation_TypeDecl_value;
    }

    private Annotation annotation_compute(TypeDecl typeDecl) {
        for (int i = 0; i < this.getNumModifier(); ++i) {
            Annotation a;
            if (!(this.getModifier(i) instanceof Annotation) || (a = (Annotation)this.getModifier(i)).type() != typeDecl) continue;
            return a;
        }
        return null;
    }

    public boolean hasAnnotationSuppressWarnings(String s) {
        boolean hasAnnotationSuppressWarnings_String_value = this.hasAnnotationSuppressWarnings_compute(s);
        return hasAnnotationSuppressWarnings_String_value;
    }

    private boolean hasAnnotationSuppressWarnings_compute(String s) {
        Annotation a = this.annotation(this.lookupType("java.lang", "SuppressWarnings"));
        if (a != null && a.getNumElementValuePair() == 1 && a.getElementValuePair(0).getName().equals("value")) {
            return a.getElementValuePair(0).getElementValue().hasValue(s);
        }
        return false;
    }

    public boolean hasDeprecatedAnnotation() {
        boolean hasDeprecatedAnnotation_value = this.hasDeprecatedAnnotation_compute();
        return hasDeprecatedAnnotation_value;
    }

    private boolean hasDeprecatedAnnotation_compute() {
        return this.annotation(this.lookupType("java.lang", "Deprecated")) != null;
    }

    public boolean mayBePublic() {
        boolean mayBePublic_value = this.getParent().Define_boolean_mayBePublic(this, null);
        return mayBePublic_value;
    }

    public boolean mayBePrivate() {
        boolean mayBePrivate_value = this.getParent().Define_boolean_mayBePrivate(this, null);
        return mayBePrivate_value;
    }

    public boolean mayBeProtected() {
        boolean mayBeProtected_value = this.getParent().Define_boolean_mayBeProtected(this, null);
        return mayBeProtected_value;
    }

    public boolean mayBeStatic() {
        boolean mayBeStatic_value = this.getParent().Define_boolean_mayBeStatic(this, null);
        return mayBeStatic_value;
    }

    public boolean mayBeFinal() {
        boolean mayBeFinal_value = this.getParent().Define_boolean_mayBeFinal(this, null);
        return mayBeFinal_value;
    }

    public boolean mayBeAbstract() {
        boolean mayBeAbstract_value = this.getParent().Define_boolean_mayBeAbstract(this, null);
        return mayBeAbstract_value;
    }

    public boolean mayBeVolatile() {
        boolean mayBeVolatile_value = this.getParent().Define_boolean_mayBeVolatile(this, null);
        return mayBeVolatile_value;
    }

    public boolean mayBeTransient() {
        boolean mayBeTransient_value = this.getParent().Define_boolean_mayBeTransient(this, null);
        return mayBeTransient_value;
    }

    public boolean mayBeStrictfp() {
        boolean mayBeStrictfp_value = this.getParent().Define_boolean_mayBeStrictfp(this, null);
        return mayBeStrictfp_value;
    }

    public boolean mayBeSynchronized() {
        boolean mayBeSynchronized_value = this.getParent().Define_boolean_mayBeSynchronized(this, null);
        return mayBeSynchronized_value;
    }

    public boolean mayBeNative() {
        boolean mayBeNative_value = this.getParent().Define_boolean_mayBeNative(this, null);
        return mayBeNative_value;
    }

    public TypeDecl lookupType(String packageName, String typeName) {
        TypeDecl lookupType_String_String_value = this.getParent().Define_TypeDecl_lookupType(this, null, packageName, typeName);
        return lookupType_String_String_value;
    }

    public TypeDecl hostType() {
        TypeDecl hostType_value = this.getParent().Define_TypeDecl_hostType(this, null);
        return hostType_value;
    }

    @Override
    public Annotation Define_Annotation_lookupAnnotation(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        if (caller == this.getModifierListNoTransform()) {
            int index = caller.getIndexOfChild(child);
            return this.annotation(typeDecl);
        }
        return this.getParent().Define_Annotation_lookupAnnotation(this, caller, typeDecl);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

