/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Immediate;
import soot.PatchingChain;
import soot.Unit;
import soot.Value;
import soot.jimple.BinopExpr;
import soot.jimple.EqExpr;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.jimple.NeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.nullcheck.NullnessAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;

public class NullCheckEliminator
extends BodyTransformer {
    private AnalysisFactory analysisFactory;

    public NullCheckEliminator() {
        this(new AnalysisFactory());
    }

    public NullCheckEliminator(AnalysisFactory f) {
        this.analysisFactory = f;
    }

    public void internalTransform(Body body, String phaseName, Map options) {
        boolean changed;
        do {
            changed = false;
            NullnessAnalysis analysis = this.analysisFactory.newAnalysis(new ExceptionalUnitGraph(body));
            PatchingChain<Unit> units = body.getUnits();
            Stmt s = (Stmt)units.getFirst();
            while (s != null) {
                IfStmt is;
                Value c;
                if (s instanceof IfStmt && ((c = (is = (IfStmt)s).getCondition()) instanceof EqExpr || c instanceof NeExpr)) {
                    BinopExpr e = (BinopExpr)c;
                    Immediate i = null;
                    if (e.getOp1() instanceof NullConstant) {
                        i = (Immediate)e.getOp2();
                    }
                    if (e.getOp2() instanceof NullConstant) {
                        i = (Immediate)e.getOp1();
                    }
                    if (i != null) {
                        boolean alwaysNull = analysis.isAlwaysNullBefore(s, i);
                        boolean alwaysNonNull = analysis.isAlwaysNonNullBefore(s, i);
                        int elim = 0;
                        if (alwaysNonNull) {
                            int n = elim = c instanceof EqExpr ? -1 : 1;
                        }
                        if (alwaysNull) {
                            elim = c instanceof EqExpr ? 1 : -1;
                        }
                        Stmt newstmt = null;
                        if (elim == -1) {
                            newstmt = Jimple.v().newNopStmt();
                        }
                        if (elim == 1) {
                            newstmt = Jimple.v().newGotoStmt(is.getTarget());
                        }
                        if (newstmt != null) {
                            units.swapWith(s, newstmt);
                            s = newstmt;
                            changed = true;
                        }
                    }
                }
                s = (Stmt)units.getSuccOf(s);
            }
        } while (changed);
    }

    public static class AnalysisFactory {
        public NullnessAnalysis newAnalysis(UnitGraph g) {
            return new NullnessAnalysis(g);
        }
    }
}

