/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ConfigurationElement;
import lpg.runtime.ConfigurationStack;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.ParseErrorCodes;
import lpg.runtime.ParseTable;
import lpg.runtime.TokenStream;

public class DiagnoseParser
implements ParseErrorCodes {
    protected Monitor monitor = null;
    protected TokenStream tokStream;
    protected ParseTable prs;
    protected int ERROR_SYMBOL;
    protected int SCOPE_SIZE;
    protected int MAX_NAME_LENGTH;
    protected int NT_OFFSET;
    protected int LA_STATE_OFFSET;
    protected int NUM_RULES;
    protected int NUM_SYMBOLS;
    protected int START_STATE;
    protected int EOFT_SYMBOL;
    protected int EOLT_SYMBOL;
    protected int ACCEPT_ACTION;
    protected int ERROR_ACTION;
    protected int[] list;
    protected int maxErrors;
    protected long maxTime;
    protected static final int STACK_INCREMENT = 256;
    protected static final int BUFF_UBOUND = 31;
    protected static final int BUFF_SIZE = 32;
    protected static final int MAX_DISTANCE = 30;
    protected static final int MIN_DISTANCE = 3;
    protected int stateStackTop;
    protected int[] stateStack;
    protected int[] locationStack;
    protected int tempStackTop;
    protected int[] tempStack;
    protected int prevStackTop;
    protected int[] prevStack;
    protected int nextStackTop;
    protected int[] nextStack;
    protected int scopeStackTop;
    protected int[] scopeIndex;
    protected int[] scopePosition;
    protected int[] buffer = new int[32];
    protected ConfigurationStack main_configuration_stack;
    private static final int NIL = -1;
    private int[] stateSeen;
    private int statePoolTop;
    private StateInfo[] statePool;

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public DiagnoseParser(TokenStream tokStream, ParseTable prs) {
        this(null, tokStream, prs);
    }

    public DiagnoseParser(Monitor monitor, TokenStream tokStream, ParseTable prs) {
        this(monitor, tokStream, prs, 0, 0L);
    }

    public DiagnoseParser(TokenStream tokStream, ParseTable prs, int maxErrors, long maxTime) {
        this(null, tokStream, prs, maxErrors, maxTime);
    }

    public DiagnoseParser(Monitor monitor, TokenStream tokStream, ParseTable prs, int maxErrors, long maxTime) {
        this.monitor = monitor;
        this.maxErrors = maxErrors;
        this.maxTime = maxTime;
        this.tokStream = tokStream;
        this.prs = prs;
        this.main_configuration_stack = new ConfigurationStack(prs);
        this.ERROR_SYMBOL = prs.getErrorSymbol();
        this.SCOPE_SIZE = prs.getScopeSize();
        this.MAX_NAME_LENGTH = prs.getMaxNameLength();
        this.NT_OFFSET = prs.getNtOffset();
        this.LA_STATE_OFFSET = prs.getLaStateOffset();
        this.NUM_RULES = prs.getNumRules();
        this.NUM_SYMBOLS = prs.getNumSymbols();
        this.START_STATE = prs.getStartState();
        this.EOFT_SYMBOL = prs.getEoftSymbol();
        this.EOLT_SYMBOL = prs.getEoltSymbol();
        this.ACCEPT_ACTION = prs.getAcceptAction();
        this.ERROR_ACTION = prs.getErrorAction();
        this.list = new int[this.NUM_SYMBOLS + 1];
    }

    public int rhs(int index) {
        return this.prs.rhs(index);
    }

    public int baseAction(int index) {
        return this.prs.baseAction(index);
    }

    public int baseCheck(int index) {
        return this.prs.baseCheck(index);
    }

    public int lhs(int index) {
        return this.prs.lhs(index);
    }

    public int termCheck(int index) {
        return this.prs.termCheck(index);
    }

    public int termAction(int index) {
        return this.prs.termAction(index);
    }

    public int asb(int index) {
        return this.prs.asb(index);
    }

    public int asr(int index) {
        return this.prs.asr(index);
    }

    public int nasb(int index) {
        return this.prs.nasb(index);
    }

    public int nasr(int index) {
        return this.prs.nasr(index);
    }

    public int terminalIndex(int index) {
        return this.prs.terminalIndex(index);
    }

    public int nonterminalIndex(int index) {
        return this.prs.nonterminalIndex(index);
    }

    public int symbolIndex(int index) {
        return index > this.NT_OFFSET ? this.nonterminalIndex(index - this.NT_OFFSET) : this.terminalIndex(index);
    }

    public int scopePrefix(int index) {
        return this.prs.scopePrefix(index);
    }

    public int scopeSuffix(int index) {
        return this.prs.scopeSuffix(index);
    }

    public int scopeLhs(int index) {
        return this.prs.scopeLhs(index);
    }

    public int scopeLa(int index) {
        return this.prs.scopeLa(index);
    }

    public int scopeStateSet(int index) {
        return this.prs.scopeStateSet(index);
    }

    public int scopeRhs(int index) {
        return this.prs.scopeRhs(index);
    }

    public int scopeState(int index) {
        return this.prs.scopeState(index);
    }

    public int inSymb(int index) {
        return this.prs.inSymb(index);
    }

    public String name(int index) {
        return this.prs.name(index);
    }

    public int originalState(int state) {
        return this.prs.originalState(state);
    }

    public int asi(int state) {
        return this.prs.asi(state);
    }

    public int nasi(int state) {
        return this.prs.nasi(state);
    }

    public int inSymbol(int state) {
        return this.prs.inSymbol(state);
    }

    public int ntAction(int state, int sym) {
        return this.prs.ntAction(state, sym);
    }

    public boolean isNullable(int symbol) {
        return this.prs.isNullable(symbol);
    }

    protected void reallocateStacks() {
        int old_stack_length = this.stateStack == null ? 0 : this.stateStack.length;
        int stack_length = old_stack_length + 256;
        if (this.stateStack == null) {
            this.stateStack = new int[stack_length];
            this.locationStack = new int[stack_length];
            this.tempStack = new int[stack_length];
            this.prevStack = new int[stack_length];
            this.nextStack = new int[stack_length];
            this.scopeIndex = new int[stack_length];
            this.scopePosition = new int[stack_length];
        } else {
            this.stateStack = new int[stack_length];
            System.arraycopy(this.stateStack, 0, this.stateStack, 0, old_stack_length);
            this.locationStack = new int[stack_length];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, old_stack_length);
            this.tempStack = new int[stack_length];
            System.arraycopy(this.tempStack, 0, this.tempStack, 0, old_stack_length);
            this.prevStack = new int[stack_length];
            System.arraycopy(this.prevStack, 0, this.prevStack, 0, old_stack_length);
            this.nextStack = new int[stack_length];
            System.arraycopy(this.nextStack, 0, this.nextStack, 0, old_stack_length);
            this.scopeIndex = new int[stack_length];
            System.arraycopy(this.scopeIndex, 0, this.scopeIndex, 0, old_stack_length);
            this.scopePosition = new int[stack_length];
            System.arraycopy(this.scopePosition, 0, this.scopePosition, 0, old_stack_length);
        }
    }

    public void diagnose() {
        this.diagnoseEntry(0, 0);
    }

    public void diagnose(int error_token) {
        this.diagnoseEntry(0, error_token);
    }

    public void diagnoseEntry(int marker_kind) {
        int current_kind;
        this.reallocateStacks();
        this.tempStackTop = 0;
        this.tempStack[this.tempStackTop] = this.START_STATE;
        this.tokStream.reset();
        if (marker_kind == 0) {
            int current_token = this.tokStream.getToken();
            current_kind = this.tokStream.getKind(current_token);
        } else {
            int current_token = this.tokStream.peek();
            current_kind = marker_kind;
        }
        int error_token = this.parseForError(current_kind);
        if (error_token != 0) {
            this.diagnoseEntry(marker_kind, error_token);
        }
    }

    public void diagnoseEntry(int marker_kind, int error_token) {
        int act;
        int current_kind;
        int current_token;
        IntTuple action = new IntTuple(262144);
        long startTime = System.currentTimeMillis();
        int errorCount = 0;
        if (this.stateStack == null) {
            this.reallocateStacks();
        }
        this.tempStackTop = 0;
        this.tempStack[this.tempStackTop] = this.START_STATE;
        this.tokStream.reset();
        if (marker_kind == 0) {
            current_token = this.tokStream.getToken();
            current_kind = this.tokStream.getKind(current_token);
        } else {
            current_token = this.tokStream.peek();
            current_kind = marker_kind;
        }
        this.parseUpToError(action, current_kind, error_token);
        this.stateStackTop = 0;
        this.stateStack[this.stateStackTop] = this.START_STATE;
        this.tempStackTop = this.stateStackTop;
        System.arraycopy(this.tempStack, 0, this.stateStack, 0, this.tempStackTop + 1);
        this.tokStream.reset();
        if (marker_kind == 0) {
            current_token = this.tokStream.getToken();
            current_kind = this.tokStream.getKind(current_token);
        } else {
            current_token = this.tokStream.peek();
            current_kind = marker_kind;
        }
        this.locationStack[this.stateStackTop] = current_token;
        do {
            int prev_pos = -1;
            this.prevStackTop = -1;
            int next_pos = -1;
            this.nextStackTop = -1;
            int pos = this.stateStackTop;
            this.tempStackTop = this.stateStackTop - 1;
            System.arraycopy(this.stateStack, 0, this.tempStack, 0, this.stateStackTop + 1);
            int action_index = 0;
            act = action.get(action_index++);
            while (act <= this.NUM_RULES) {
                do {
                    this.tempStackTop -= this.rhs(act) - 1;
                } while ((act = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(act))) <= this.NUM_RULES);
                if (this.tempStackTop + 1 >= this.stateStack.length) {
                    this.reallocateStacks();
                }
                pos = pos < this.tempStackTop ? pos : this.tempStackTop;
                this.tempStack[this.tempStackTop + 1] = act;
                act = action.get(action_index++);
            }
            while (act > this.ERROR_ACTION || act < this.ACCEPT_ACTION) {
                if (this.monitor != null && this.monitor.isCancelled()) {
                    return;
                }
                this.nextStackTop = this.tempStackTop + 1;
                int i = next_pos + 1;
                while (i <= this.nextStackTop) {
                    this.nextStack[i] = this.tempStack[i];
                    ++i;
                }
                int k = pos + 1;
                while (k <= this.nextStackTop) {
                    this.locationStack[k] = this.locationStack[this.stateStackTop];
                    ++k;
                }
                if (act > this.ERROR_ACTION) {
                    act -= this.ERROR_ACTION;
                    do {
                        this.nextStackTop -= this.rhs(act) - 1;
                    } while ((act = this.ntAction(this.nextStack[this.nextStackTop], this.lhs(act))) <= this.NUM_RULES);
                    int n = pos = pos < this.nextStackTop ? pos : this.nextStackTop;
                }
                if (this.nextStackTop + 1 >= this.stateStack.length) {
                    this.reallocateStacks();
                }
                this.tempStackTop = this.nextStackTop++;
                this.nextStack[this.nextStackTop] = act;
                next_pos = this.nextStackTop;
                current_token = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(current_token);
                act = action.get(action_index++);
                while (act <= this.NUM_RULES) {
                    int lhs_symbol;
                    do {
                        lhs_symbol = this.lhs(act);
                        this.tempStackTop -= this.rhs(act) - 1;
                        int n = act = this.tempStackTop > next_pos ? this.tempStack[this.tempStackTop] : this.nextStack[this.tempStackTop];
                    } while ((act = this.ntAction(act, lhs_symbol)) <= this.NUM_RULES);
                    if (this.tempStackTop + 1 >= this.stateStack.length) {
                        this.reallocateStacks();
                    }
                    next_pos = next_pos < this.tempStackTop ? next_pos : this.tempStackTop;
                    this.tempStack[this.tempStackTop + 1] = act;
                    act = action.get(action_index++);
                }
                if (act == this.ERROR_ACTION) continue;
                this.prevStackTop = this.stateStackTop;
                i = prev_pos + 1;
                while (i <= this.prevStackTop) {
                    this.prevStack[i] = this.stateStack[i];
                    ++i;
                }
                prev_pos = pos;
                this.stateStackTop = this.nextStackTop;
                k = pos + 1;
                while (k <= this.stateStackTop) {
                    this.stateStack[k] = this.nextStack[k];
                    ++k;
                }
                this.locationStack[this.stateStackTop] = current_token;
                pos = next_pos;
            }
            if (act != this.ERROR_ACTION) continue;
            if (++errorCount > 1 && (this.maxErrors > 0 && errorCount > this.maxErrors || this.maxTime > 0L && System.currentTimeMillis() - startTime > this.maxTime)) break;
            RepairCandidate candidate = this.errorRecovery(current_token);
            if (this.monitor != null && this.monitor.isCancelled()) {
                return;
            }
            act = this.stateStack[this.stateStackTop];
            if (candidate.symbol == 0) break;
            if (candidate.symbol > this.NT_OFFSET) {
                int lhs_symbol = candidate.symbol - this.NT_OFFSET;
                act = this.ntAction(act, lhs_symbol);
                while (act <= this.NUM_RULES) {
                    this.stateStackTop -= this.rhs(act) - 1;
                    act = this.ntAction(this.stateStack[this.stateStackTop], this.lhs(act));
                }
                this.stateStack[++this.stateStackTop] = act;
                current_token = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(current_token);
                this.locationStack[this.stateStackTop] = current_token;
            } else {
                current_kind = candidate.symbol;
                this.locationStack[this.stateStackTop] = candidate.location;
            }
            int next_token = this.tokStream.peek();
            this.tempStackTop = this.stateStackTop;
            System.arraycopy(this.stateStack, 0, this.tempStack, 0, this.stateStackTop + 1);
            error_token = this.parseForError(current_kind);
            if (error_token != 0) {
                this.tokStream.reset(next_token);
                this.tempStackTop = this.stateStackTop;
                System.arraycopy(this.stateStack, 0, this.tempStack, 0, this.stateStackTop + 1);
                this.parseUpToError(action, current_kind, error_token);
                this.tokStream.reset(next_token);
                continue;
            }
            act = this.ACCEPT_ACTION;
        } while (act != this.ACCEPT_ACTION);
    }

    int parseForError(int current_kind) {
        int error_token = 0;
        int curtok = this.tokStream.getPrevious(this.tokStream.peek());
        int act = this.tAction(this.tempStack[this.tempStackTop], current_kind);
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        while (true) {
            if (act <= this.NUM_RULES) {
                --this.tempStackTop;
                do {
                    this.tempStackTop -= this.rhs(act) - 1;
                } while ((act = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(act))) <= this.NUM_RULES);
            } else if (act > this.ERROR_ACTION) {
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                act -= this.ERROR_ACTION;
                do {
                    this.tempStackTop -= this.rhs(act) - 1;
                } while ((act = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(act))) <= this.NUM_RULES);
            } else if (act < this.ACCEPT_ACTION) {
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
            } else {
                if (act == this.ERROR_ACTION) {
                    error_token = error_token > curtok ? error_token : curtok;
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    this.tempStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.tempStack);
                    act = configuration.act;
                    curtok = configuration.curtok;
                    current_kind = this.tokStream.getKind(curtok);
                    this.tokStream.reset(this.tokStream.getNext(curtok));
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(this.tempStack, this.tempStackTop, curtok)) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(this.tempStack, this.tempStackTop, act + 1, curtok, 0);
                act = this.baseAction(act);
                continue;
            }
            try {
                this.tempStack[++this.tempStackTop] = act;
            }
            catch (IndexOutOfBoundsException e) {
                this.reallocateStacks();
                this.tempStack[this.tempStackTop] = act;
            }
            act = this.tAction(act, current_kind);
        }
        return act == this.ERROR_ACTION ? error_token : 0;
    }

    void parseUpToError(IntTuple action, int current_kind, int error_token) {
        int curtok = this.tokStream.getPrevious(this.tokStream.peek());
        int act = this.tAction(this.tempStack[this.tempStackTop], current_kind);
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        action.reset();
        while (true) {
            if (act <= this.NUM_RULES) {
                action.add(act);
                --this.tempStackTop;
                do {
                    this.tempStackTop -= this.rhs(act) - 1;
                } while ((act = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(act))) <= this.NUM_RULES);
            } else if (act > this.ERROR_ACTION) {
                action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                act -= this.ERROR_ACTION;
                do {
                    this.tempStackTop -= this.rhs(act) - 1;
                } while ((act = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(act))) <= this.NUM_RULES);
            } else if (act < this.ACCEPT_ACTION) {
                action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
            } else {
                if (act == this.ERROR_ACTION) {
                    if (curtok == error_token) break;
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    this.tempStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.tempStack);
                    act = configuration.act;
                    curtok = configuration.curtok;
                    action.reset(configuration.action_length);
                    current_kind = this.tokStream.getKind(curtok);
                    this.tokStream.reset(this.tokStream.getNext(curtok));
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(this.tempStack, this.tempStackTop, curtok)) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(this.tempStack, this.tempStackTop, act + 1, curtok, action.size());
                act = this.baseAction(act);
                continue;
            }
            try {
                this.tempStack[++this.tempStackTop] = act;
            }
            catch (IndexOutOfBoundsException e) {
                this.reallocateStacks();
                this.tempStack[this.tempStackTop] = act;
            }
            act = this.tAction(act, current_kind);
        }
        action.add(this.ERROR_ACTION);
    }

    protected int parseCheck(int[] stack, int stack_top, int first_symbol, int buffer_position) {
        int current_kind;
        int buffer_index;
        int[] local_stack = new int[stack.length];
        int local_stack_top = stack_top;
        int i = 0;
        while (i <= stack_top) {
            local_stack[i] = stack[i];
            ++i;
        }
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        int act = local_stack[local_stack_top];
        if (first_symbol > this.NT_OFFSET) {
            int lhs_symbol = first_symbol - this.NT_OFFSET;
            buffer_index = buffer_position;
            current_kind = this.tokStream.getKind(this.buffer[buffer_index]);
            this.tokStream.reset(this.tokStream.getNext(this.buffer[buffer_index]));
            act = this.ntAction(act, lhs_symbol);
            while (act <= this.NUM_RULES) {
                act = this.ntAction(local_stack[local_stack_top -= this.rhs(act) - 1], this.lhs(act));
            }
        } else {
            --local_stack_top;
            buffer_index = buffer_position - 1;
            current_kind = first_symbol;
            this.tokStream.reset(this.buffer[buffer_position]);
        }
        if (++local_stack_top >= local_stack.length) {
            return buffer_index;
        }
        local_stack[local_stack_top] = act;
        act = this.tAction(act, current_kind);
        while (true) {
            if (act <= this.NUM_RULES) {
                local_stack_top -= this.rhs(act);
                act = this.ntAction(local_stack[local_stack_top], this.lhs(act));
                while (act <= this.NUM_RULES) {
                    act = this.ntAction(local_stack[local_stack_top -= this.rhs(act) - 1], this.lhs(act));
                }
            } else if (act > this.ERROR_ACTION) {
                if (buffer_index++ == 30) break;
                current_kind = this.tokStream.getKind(this.buffer[buffer_index]);
                this.tokStream.reset(this.tokStream.getNext(this.buffer[buffer_index]));
                act -= this.ERROR_ACTION;
                while ((act = this.ntAction(local_stack[local_stack_top -= this.rhs(act) - 1], this.lhs(act))) <= this.NUM_RULES) {
                }
            } else if (act < this.ACCEPT_ACTION) {
                if (buffer_index++ == 30) break;
                current_kind = this.tokStream.getKind(this.buffer[buffer_index]);
                this.tokStream.reset(this.tokStream.getNext(this.buffer[buffer_index]));
            } else {
                if (act == this.ERROR_ACTION) {
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    local_stack_top = configuration.stack_top;
                    configuration.retrieveStack(local_stack);
                    act = configuration.act;
                    buffer_index = configuration.curtok;
                    current_kind = this.tokStream.getKind(this.buffer[buffer_index]);
                    this.tokStream.reset(this.tokStream.getNext(this.buffer[buffer_index]));
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(local_stack, local_stack_top, buffer_index)) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(local_stack, local_stack_top, act + 1, buffer_index, 0);
                act = this.baseAction(act);
                continue;
            }
            if (++local_stack_top >= local_stack.length) break;
            local_stack[local_stack_top] = act;
            act = this.tAction(act, current_kind);
        }
        return act == this.ACCEPT_ACTION ? 30 : buffer_index;
    }

    /*
     * Unable to fully structure code
     */
    protected RepairCandidate errorRecovery(int error_token) {
        prevtok = this.tokStream.getPrevious(error_token);
        candidate = this.primaryPhase(error_token);
        if (candidate.symbol != 0) {
            return candidate;
        }
        candidate = this.secondaryPhase(error_token);
        if (candidate.symbol != 0) {
            return candidate;
        }
        if (this.tokStream.getKind(error_token) != this.EOFT_SYMBOL) ** GOTO lbl16
        this.emitError(10, this.terminalIndex(this.EOFT_SYMBOL), prevtok, prevtok);
        candidate.symbol = 0;
        candidate.location = error_token;
        return candidate;
lbl-1000:
        // 1 sources

        {
            candidate = this.secondaryPhase(this.buffer[29]);
            if (candidate.symbol == 0) continue;
            return candidate;
lbl16:
            // 2 sources

            ** while (this.tokStream.getKind((int)this.buffer[31]) != this.EOFT_SYMBOL)
        }
lbl17:
        // 1 sources

        i = 31;
        while (this.tokStream.getKind(this.buffer[i]) == this.EOFT_SYMBOL) {
            --i;
        }
        this.emitError(6, this.terminalIndex(this.tokStream.getKind(prevtok)), error_token, this.buffer[i]);
        candidate.symbol = 0;
        candidate.location = this.buffer[i];
        return candidate;
    }

    protected RepairCandidate primaryPhase(int error_token) {
        int i = this.nextStackTop >= 0 ? 3 : 2;
        this.buffer[i] = error_token;
        int j = i;
        while (j > 0) {
            this.buffer[j - 1] = this.tokStream.getPrevious(this.buffer[j]);
            --j;
        }
        int k = i + 1;
        while (k < 32) {
            this.buffer[k] = this.tokStream.getNext(this.buffer[k - 1]);
            ++k;
        }
        PrimaryRepairInfo repair = new PrimaryRepairInfo();
        if (this.nextStackTop >= 0) {
            repair.bufferPosition = 3;
            this.checkPrimaryDistance(repair, this.nextStack, this.nextStackTop);
        }
        PrimaryRepairInfo base_repair = new PrimaryRepairInfo(repair);
        base_repair.bufferPosition = 2;
        this.checkPrimaryDistance(base_repair, this.stateStack, this.stateStackTop);
        if (base_repair.distance > repair.distance || base_repair.misspellIndex > repair.misspellIndex) {
            repair = base_repair;
        }
        if (this.prevStackTop >= 0) {
            PrimaryRepairInfo prev_repair = new PrimaryRepairInfo(repair);
            prev_repair.bufferPosition = 1;
            this.checkPrimaryDistance(prev_repair, this.prevStack, this.prevStackTop);
            if (prev_repair.distance > repair.distance || prev_repair.misspellIndex > repair.misspellIndex) {
                repair = prev_repair;
            }
        }
        RepairCandidate candidate = new RepairCandidate();
        if (this.nextStackTop >= 0 ? this.secondaryCheck(this.nextStack, this.nextStackTop, 3, repair.distance) : this.secondaryCheck(this.stateStack, this.stateStackTop, 2, repair.distance)) {
            return candidate;
        }
        repair.distance = repair.distance - repair.bufferPosition + 1;
        if (repair.code == 4 || repair.code == 6 || repair.code == 5 || repair.code == 7) {
            --repair.distance;
        }
        if (repair.distance < 3) {
            return candidate;
        }
        if (repair.code == 3 && this.tokStream.getKind(this.buffer[repair.bufferPosition - 1]) == 0) {
            repair.code = 2;
        }
        if (repair.bufferPosition == 1) {
            this.stateStackTop = this.prevStackTop;
            System.arraycopy(this.prevStack, 0, this.stateStack, 0, this.stateStackTop + 1);
        } else if (this.nextStackTop >= 0 && repair.bufferPosition >= 3) {
            this.stateStackTop = this.nextStackTop;
            System.arraycopy(this.nextStack, 0, this.stateStack, 0, this.stateStackTop + 1);
            this.locationStack[this.stateStackTop] = this.buffer[3];
        }
        return this.primaryDiagnosis(repair);
    }

    protected int mergeCandidate(int state, int buffer_position) {
        String str = String.valueOf(this.tokStream.getName(this.buffer[buffer_position])) + this.tokStream.getName(this.buffer[buffer_position + 1]);
        int k = this.asi(state);
        while (this.asr(k) != 0) {
            int i = this.terminalIndex(this.asr(k));
            if (str.length() == this.name(i).length() && str.toLowerCase().equals(this.name(i).toLowerCase())) {
                return this.asr(k);
            }
            ++k;
        }
        return 0;
    }

    protected void checkPrimaryDistance(PrimaryRepairInfo repair, int[] stck, int stack_top) {
        int n;
        int m;
        int k;
        int j;
        int symbol;
        PrimaryRepairInfo scope_repair = new PrimaryRepairInfo(repair);
        this.scopeTrial(scope_repair, stck, stack_top);
        if (scope_repair.distance > repair.distance) {
            repair.copy(scope_repair);
        }
        if ((symbol = this.mergeCandidate(stck[stack_top], repair.bufferPosition)) != 0 && ((j = this.parseCheck(stck, stack_top, symbol, repair.bufferPosition + 2)) > repair.distance || j == repair.distance && repair.misspellIndex < 10)) {
            repair.misspellIndex = 10;
            repair.symbol = symbol;
            repair.distance = j;
            repair.code = 7;
        }
        j = this.parseCheck(stck, stack_top, this.tokStream.getKind(this.buffer[repair.bufferPosition + 1]), repair.bufferPosition + 2);
        int n2 = k = this.tokStream.getKind(this.buffer[repair.bufferPosition]) == this.EOLT_SYMBOL && this.tokStream.afterEol(this.buffer[repair.bufferPosition + 1]) ? 10 : 0;
        if (j > repair.distance || j == repair.distance && k > repair.misspellIndex) {
            repair.misspellIndex = k;
            repair.code = 6;
            repair.distance = j;
        }
        int next_state = stck[stack_top];
        int max_pos = stack_top;
        this.tempStackTop = stack_top - 1;
        this.tokStream.reset(this.buffer[repair.bufferPosition + 1]);
        int tok = this.tokStream.getKind(this.buffer[repair.bufferPosition]);
        int act = this.tAction(next_state, tok);
        while (act <= this.NUM_RULES) {
            int lhs_symbol;
            do {
                lhs_symbol = this.lhs(act);
                this.tempStackTop -= this.rhs(act) - 1;
                int n3 = act = this.tempStackTop > max_pos ? this.tempStack[this.tempStackTop] : stck[this.tempStackTop];
            } while ((act = this.ntAction(act, lhs_symbol)) <= this.NUM_RULES);
            max_pos = max_pos < this.tempStackTop ? max_pos : this.tempStackTop;
            this.tempStack[this.tempStackTop + 1] = act;
            next_state = act;
            act = this.tAction(next_state, tok);
        }
        int root = 0;
        int i = this.asi(next_state);
        while (this.asr(i) != 0) {
            symbol = this.asr(i);
            if (symbol != this.EOFT_SYMBOL && symbol != this.ERROR_SYMBOL) {
                if (root == 0) {
                    this.list[symbol] = symbol;
                } else {
                    this.list[symbol] = this.list[root];
                    this.list[root] = symbol;
                }
                root = symbol;
            }
            ++i;
        }
        if (stck[stack_top] != next_state) {
            i = this.asi(stck[stack_top]);
            while (this.asr(i) != 0) {
                symbol = this.asr(i);
                if (symbol != this.EOFT_SYMBOL && symbol != this.ERROR_SYMBOL && this.list[symbol] == 0) {
                    if (root == 0) {
                        this.list[symbol] = symbol;
                    } else {
                        this.list[symbol] = this.list[root];
                        this.list[root] = symbol;
                    }
                    root = symbol;
                }
                ++i;
            }
        }
        int head = this.list[root];
        this.list[root] = 0;
        symbol = root = head;
        while (symbol != 0) {
            m = this.parseCheck(stck, stack_top, symbol, repair.bufferPosition);
            int n4 = n = symbol == this.EOLT_SYMBOL && this.tokStream.afterEol(this.buffer[repair.bufferPosition]) ? 10 : 0;
            if (m > repair.distance || m == repair.distance && n > repair.misspellIndex) {
                repair.misspellIndex = n;
                repair.distance = m;
                repair.symbol = symbol;
                repair.code = 3;
            }
            symbol = this.list[symbol];
        }
        symbol = root;
        while (symbol != 0) {
            m = this.parseCheck(stck, stack_top, symbol, repair.bufferPosition + 1);
            int n5 = n = symbol == this.EOLT_SYMBOL && this.tokStream.afterEol(this.buffer[repair.bufferPosition + 1]) ? 10 : this.misspell(symbol, this.buffer[repair.bufferPosition]);
            if (m > repair.distance || m == repair.distance && n > repair.misspellIndex) {
                repair.misspellIndex = n;
                repair.distance = m;
                repair.symbol = symbol;
                repair.code = 5;
            }
            int s = symbol;
            symbol = this.list[symbol];
            this.list[s] = 0;
        }
        int nt_index = this.nasi(stck[stack_top]);
        while (this.nasr(nt_index) != 0) {
            symbol = this.nasr(nt_index) + this.NT_OFFSET;
            n = this.parseCheck(stck, stack_top, symbol, repair.bufferPosition + 1);
            if (n > repair.distance) {
                repair.misspellIndex = 0;
                repair.distance = n;
                repair.symbol = symbol;
                repair.code = 4;
            }
            if ((n = this.parseCheck(stck, stack_top, symbol, repair.bufferPosition)) > repair.distance || n == repair.distance && repair.code == 4) {
                repair.misspellIndex = 0;
                repair.distance = n;
                repair.symbol = symbol;
                repair.code = 3;
            }
            ++nt_index;
        }
    }

    protected RepairCandidate primaryDiagnosis(PrimaryRepairInfo repair) {
        int prevtok = this.buffer[repair.bufferPosition - 1];
        int current_token = this.buffer[repair.bufferPosition];
        switch (repair.code) {
            case 2: 
            case 3: {
                int name_index = repair.symbol > this.NT_OFFSET ? this.getNtermIndex(this.stateStack[this.stateStackTop], repair.symbol, repair.bufferPosition) : this.getTermIndex(this.stateStack, this.stateStackTop, repair.symbol, repair.bufferPosition);
                int tok = repair.code == 3 ? prevtok : current_token;
                this.emitError(repair.code, name_index, tok, tok);
                break;
            }
            case 4: {
                int name_index = this.getNtermIndex(this.stateStack[this.stateStackTop], repair.symbol, repair.bufferPosition + 1);
                this.emitError(repair.code, name_index, current_token, current_token);
                break;
            }
            case 5: {
                int name_index;
                if (repair.misspellIndex >= 6) {
                    name_index = this.terminalIndex(repair.symbol);
                } else {
                    name_index = this.getTermIndex(this.stateStack, this.stateStackTop, repair.symbol, repair.bufferPosition + 1);
                    if (name_index != this.terminalIndex(repair.symbol)) {
                        repair.code = 4;
                    }
                }
                this.emitError(repair.code, name_index, current_token, current_token);
                break;
            }
            case 7: {
                this.emitError(repair.code, this.terminalIndex(repair.symbol), current_token, this.tokStream.getNext(current_token));
                break;
            }
            case 9: {
                int i = 0;
                while (i < this.scopeStackTop) {
                    this.emitError(repair.code, -this.scopeIndex[i], this.locationStack[this.scopePosition[i]], prevtok, this.nonterminalIndex(this.scopeLhs(this.scopeIndex[i])));
                    ++i;
                }
                repair.symbol = this.scopeLhs(this.scopeIndex[this.scopeStackTop]) + this.NT_OFFSET;
                this.stateStackTop = this.scopePosition[this.scopeStackTop];
                this.emitError(repair.code, -this.scopeIndex[this.scopeStackTop], this.locationStack[this.scopePosition[this.scopeStackTop]], prevtok, this.getNtermIndex(this.stateStack[this.stateStackTop], repair.symbol, repair.bufferPosition));
                break;
            }
            default: {
                this.emitError(repair.code, this.terminalIndex(this.ERROR_SYMBOL), current_token, current_token);
            }
        }
        RepairCandidate candidate = new RepairCandidate();
        switch (repair.code) {
            case 2: 
            case 3: 
            case 9: {
                candidate.symbol = repair.symbol;
                candidate.location = this.buffer[repair.bufferPosition];
                this.tokStream.reset(this.buffer[repair.bufferPosition]);
                break;
            }
            case 4: 
            case 5: {
                candidate.symbol = repair.symbol;
                candidate.location = this.buffer[repair.bufferPosition];
                this.tokStream.reset(this.buffer[repair.bufferPosition + 1]);
                break;
            }
            case 7: {
                candidate.symbol = repair.symbol;
                candidate.location = this.buffer[repair.bufferPosition];
                this.tokStream.reset(this.buffer[repair.bufferPosition + 2]);
                break;
            }
            default: {
                candidate.location = this.buffer[repair.bufferPosition + 1];
                candidate.symbol = this.tokStream.getKind(this.buffer[repair.bufferPosition + 1]);
                this.tokStream.reset(this.buffer[repair.bufferPosition + 2]);
            }
        }
        return candidate;
    }

    protected int getTermIndex(int[] stck, int stack_top, int tok, int buffer_position) {
        int act = stck[stack_top];
        int max_pos = stack_top;
        int highest_symbol = tok;
        this.tempStackTop = stack_top - 1;
        this.tokStream.reset(this.buffer[buffer_position]);
        act = this.tAction(act, tok);
        while (act <= this.NUM_RULES) {
            int lhs_symbol;
            do {
                lhs_symbol = this.lhs(act);
                this.tempStackTop -= this.rhs(act) - 1;
                int n = act = this.tempStackTop > max_pos ? this.tempStack[this.tempStackTop] : stck[this.tempStackTop];
            } while ((act = this.ntAction(act, lhs_symbol)) <= this.NUM_RULES);
            max_pos = max_pos < this.tempStackTop ? max_pos : this.tempStackTop;
            this.tempStack[this.tempStackTop + 1] = act;
            act = this.tAction(act, tok);
        }
        ++this.tempStackTop;
        int threshold = this.tempStackTop;
        tok = this.tokStream.getKind(this.buffer[buffer_position]);
        this.tokStream.reset(this.buffer[buffer_position + 1]);
        if (act > this.ERROR_ACTION) {
            act -= this.ERROR_ACTION;
        } else if (act < this.ACCEPT_ACTION) {
            this.tempStack[this.tempStackTop + 1] = act;
            act = this.tAction(act, tok);
        }
        while (act <= this.NUM_RULES) {
            int lhs_symbol;
            do {
                lhs_symbol = this.lhs(act);
                this.tempStackTop -= this.rhs(act) - 1;
                if (this.tempStackTop < threshold) {
                    return highest_symbol > this.NT_OFFSET ? this.nonterminalIndex(highest_symbol - this.NT_OFFSET) : this.terminalIndex(highest_symbol);
                }
                if (this.tempStackTop == threshold) {
                    highest_symbol = lhs_symbol + this.NT_OFFSET;
                }
                int n = act = this.tempStackTop > max_pos ? this.tempStack[this.tempStackTop] : stck[this.tempStackTop];
            } while ((act = this.ntAction(act, lhs_symbol)) <= this.NUM_RULES);
            this.tempStack[this.tempStackTop + 1] = act;
            act = this.tAction(act, tok);
        }
        return highest_symbol > this.NT_OFFSET ? this.nonterminalIndex(highest_symbol - this.NT_OFFSET) : this.terminalIndex(highest_symbol);
    }

    protected int getNtermIndex(int start, int sym, int buffer_position) {
        int highest_symbol = sym - this.NT_OFFSET;
        int tok = this.tokStream.getKind(this.buffer[buffer_position]);
        this.tokStream.reset(this.buffer[buffer_position + 1]);
        this.tempStackTop = 0;
        this.tempStack[this.tempStackTop] = start;
        int act = this.ntAction(start, highest_symbol);
        if (act > this.NUM_RULES) {
            this.tempStack[this.tempStackTop + 1] = act;
            act = this.tAction(act, tok);
        }
        while (act <= this.NUM_RULES) {
            do {
                this.tempStackTop -= this.rhs(act) - 1;
                if (this.tempStackTop < 0) {
                    return this.nonterminalIndex(highest_symbol);
                }
                if (this.tempStackTop != 0) continue;
                highest_symbol = this.lhs(act);
            } while ((act = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(act))) <= this.NUM_RULES);
            this.tempStack[this.tempStackTop + 1] = act;
            act = this.tAction(act, tok);
        }
        return this.nonterminalIndex(highest_symbol);
    }

    protected int misspell(int sym, int tok) {
        String s1 = new String(this.name(this.terminalIndex(sym))).toLowerCase();
        int n = s1.length();
        s1 = String.valueOf(s1) + '\u0000';
        String s2 = new String(this.tokStream.getName(tok)).toLowerCase();
        int m = s2.length() < this.MAX_NAME_LENGTH ? s2.length() : this.MAX_NAME_LENGTH;
        s2 = String.valueOf(s2.substring(0, m)) + '\u0000';
        if (n == 1 && m == 1 && (s1.charAt(0) == ';' && s2.charAt(0) == ',' || s1.charAt(0) == ',' && s2.charAt(0) == ';' || s1.charAt(0) == ';' && s2.charAt(0) == ':' || s1.charAt(0) == ':' && s2.charAt(0) == ';' || s1.charAt(0) == '.' && s2.charAt(0) == ',' || s1.charAt(0) == ',' && s2.charAt(0) == '.' || s1.charAt(0) == '\'' && s2.charAt(0) == '\"' || s1.charAt(0) == '\"' && s2.charAt(0) == '\'')) {
            return 3;
        }
        int count = 0;
        int prefix_length = 0;
        int num_errors = 0;
        int i = 0;
        int j = 0;
        while (i < n && j < m) {
            if (s1.charAt(i) == s2.charAt(j)) {
                ++count;
                ++i;
                ++j;
                if (num_errors != 0) continue;
                ++prefix_length;
                continue;
            }
            if (s1.charAt(i + 1) == s2.charAt(j) && s1.charAt(i) == s2.charAt(j + 1)) {
                count += 2;
                i += 2;
                j += 2;
                ++num_errors;
                continue;
            }
            if (s1.charAt(i + 1) == s2.charAt(j + 1)) {
                i += 2;
                j += 2;
                ++num_errors;
                continue;
            }
            if (n - i > m - j) {
                ++i;
            } else if (m - j > n - i) {
                ++j;
            } else {
                ++i;
                ++j;
            }
            ++num_errors;
        }
        if (i < n || j < m) {
            ++num_errors;
        }
        if (num_errors > (n < m ? n : m) / 6 + 1) {
            count = prefix_length;
        }
        return count * 10 / ((n < s1.length() ? s1.length() : n) + num_errors);
    }

    protected void scopeTrial(PrimaryRepairInfo repair, int[] stack, int stack_top) {
        if (this.stateSeen == null || this.stateSeen.length < this.stateStack.length) {
            this.stateSeen = new int[this.stateStack.length];
        }
        int i = 0;
        while (i < this.stateStack.length) {
            this.stateSeen[i] = -1;
            ++i;
        }
        this.statePoolTop = 0;
        if (this.statePool == null || this.statePool.length < this.stateStack.length) {
            this.statePool = new StateInfo[this.stateStack.length];
        }
        this.scopeTrialCheck(repair, stack, stack_top, 0);
        repair.code = 9;
        repair.misspellIndex = 10;
    }

    protected void scopeTrialCheck(PrimaryRepairInfo repair, int[] stack, int stack_top, int indx) {
        int i = this.stateSeen[stack_top];
        while (i != -1) {
            if (this.statePool[i].state == stack[stack_top]) {
                return;
            }
            i = this.statePool[i].next;
        }
        int old_state_pool_top = this.statePoolTop++;
        if (this.statePoolTop >= this.statePool.length) {
            this.statePool = new StateInfo[this.statePoolTop * 2];
            System.arraycopy(this.statePool, 0, this.statePool, 0, this.statePoolTop);
        }
        this.statePool[old_state_pool_top] = new StateInfo(stack[stack_top], this.stateSeen[stack_top]);
        this.stateSeen[stack_top] = old_state_pool_top;
        IntTuple action = new IntTuple(8);
        int i2 = 0;
        while (i2 < this.SCOPE_SIZE) {
            action.reset();
            int act = this.tAction(stack[stack_top], this.scopeLa(i2));
            if (act > this.ACCEPT_ACTION && act < this.ERROR_ACTION) {
                do {
                    action.add(this.baseAction(act++));
                } while (this.baseAction(act) != 0);
            } else {
                action.add(act);
            }
            int action_index = 0;
            while (action_index < action.size()) {
                this.tokStream.reset(this.buffer[repair.bufferPosition]);
                this.tempStackTop = stack_top - 1;
                int max_pos = stack_top;
                act = action.get(action_index);
                while (act <= this.NUM_RULES) {
                    int lhs_symbol;
                    do {
                        lhs_symbol = this.lhs(act);
                        this.tempStackTop -= this.rhs(act) - 1;
                        int n = act = this.tempStackTop > max_pos ? this.tempStack[this.tempStackTop] : stack[this.tempStackTop];
                    } while ((act = this.ntAction(act, lhs_symbol)) <= this.NUM_RULES);
                    if (this.tempStackTop + 1 >= this.stateStack.length) {
                        return;
                    }
                    max_pos = max_pos < this.tempStackTop ? max_pos : this.tempStackTop;
                    this.tempStack[this.tempStackTop + 1] = act;
                    act = this.tAction(act, this.scopeLa(i2));
                }
                if (act != this.ERROR_ACTION) {
                    int marked_pos;
                    int k = this.scopePrefix(i2);
                    int j = this.tempStackTop + 1;
                    while (j >= max_pos + 1 && this.inSymbol(this.tempStack[j]) == this.scopeRhs(k)) {
                        ++k;
                        --j;
                    }
                    if (j == max_pos) {
                        j = max_pos;
                        while (j >= 1 && this.inSymbol(stack[j]) == this.scopeRhs(k)) {
                            ++k;
                            --j;
                        }
                    }
                    int n = marked_pos = max_pos < stack_top ? max_pos + 1 : stack_top;
                    if (this.scopeRhs(k) == 0 && j < marked_pos) {
                        int stack_position = j;
                        j = this.scopeStateSet(i2);
                        while (stack[stack_position] != this.scopeState(j) && this.scopeState(j) != 0) {
                            ++j;
                        }
                        if (this.scopeState(j) != 0) {
                            int previous_distance = repair.distance;
                            int distance = this.parseCheck(stack, stack_position, this.scopeLhs(i2) + this.NT_OFFSET, repair.bufferPosition);
                            if (distance - repair.bufferPosition + 1 < 3) {
                                int top = stack_position;
                                act = this.ntAction(stack[top], this.scopeLhs(i2));
                                while (act <= this.NUM_RULES) {
                                    act = this.ntAction(stack[top -= this.rhs(act) - 1], this.lhs(act));
                                }
                                j = act;
                                act = stack[++top];
                                stack[top] = j;
                                this.scopeTrialCheck(repair, stack, top, indx + 1);
                                stack[top] = act;
                            } else if (distance > repair.distance) {
                                this.scopeStackTop = indx;
                                repair.distance = distance;
                            }
                            if (this.main_configuration_stack.size() == 0 && this.tokStream.getKind(this.buffer[repair.bufferPosition]) == this.EOFT_SYMBOL && repair.distance == previous_distance) {
                                this.scopeStackTop = indx;
                                repair.distance = 30;
                            }
                            if (repair.distance > previous_distance) {
                                this.scopeIndex[indx] = i2;
                                this.scopePosition[indx] = stack_position;
                                return;
                            }
                        }
                    }
                }
                ++action_index;
            }
            ++i2;
        }
    }

    protected boolean secondaryCheck(int[] stack, int stack_top, int buffer_position, int distance) {
        int top = stack_top - 1;
        while (top >= 0) {
            int j = this.parseCheck(stack, top, this.tokStream.getKind(this.buffer[buffer_position]), buffer_position + 1);
            if (j - buffer_position + 1 > 3 && j > distance) {
                return true;
            }
            --top;
        }
        PrimaryRepairInfo scope_repair = new PrimaryRepairInfo();
        scope_repair.bufferPosition = buffer_position + 1;
        scope_repair.distance = distance;
        this.scopeTrial(scope_repair, stack, stack_top);
        return scope_repair.distance - buffer_position > 3 && scope_repair.distance > distance;
    }

    protected RepairCandidate secondaryPhase(int error_token) {
        int k;
        SecondaryRepairInfo repair = new SecondaryRepairInfo();
        SecondaryRepairInfo misplaced_repair = new SecondaryRepairInfo();
        int next_last_index = 0;
        if (this.nextStackTop >= 0) {
            this.buffer[2] = error_token;
            this.buffer[1] = this.tokStream.getPrevious(this.buffer[2]);
            this.buffer[0] = this.tokStream.getPrevious(this.buffer[1]);
            k = 3;
            while (k < 31) {
                this.buffer[k] = this.tokStream.getNext(this.buffer[k - 1]);
                ++k;
            }
            this.buffer[31] = this.tokStream.badToken();
            next_last_index = 29;
            while (next_last_index >= 1 && this.tokStream.getKind(this.buffer[next_last_index]) == this.EOFT_SYMBOL) {
                --next_last_index;
            }
            int save_location = this.locationStack[this.nextStackTop];
            this.locationStack[this.nextStackTop] = this.buffer[2];
            misplaced_repair.numDeletions = this.nextStackTop;
            this.misplacementRecovery(misplaced_repair, this.nextStack, this.nextStackTop, ++next_last_index, true);
            if (misplaced_repair.recoveryOnNextStack) {
                ++misplaced_repair.distance;
            }
            repair.numDeletions = this.nextStackTop + 31;
            this.secondaryRecovery(repair, this.nextStack, this.nextStackTop, next_last_index, true);
            if (repair.recoveryOnNextStack) {
                ++repair.distance;
            }
            this.locationStack[this.nextStackTop] = save_location;
        } else {
            misplaced_repair.numDeletions = this.stateStackTop;
            repair.numDeletions = this.stateStackTop + 31;
        }
        this.buffer[3] = error_token;
        this.buffer[2] = this.tokStream.getPrevious(this.buffer[3]);
        this.buffer[1] = this.tokStream.getPrevious(this.buffer[2]);
        this.buffer[0] = this.tokStream.getPrevious(this.buffer[1]);
        int k2 = 4;
        while (k2 < 32) {
            this.buffer[k2] = this.tokStream.getNext(this.buffer[k2 - 1]);
            ++k2;
        }
        int last_index = 29;
        while (last_index >= 1 && this.tokStream.getKind(this.buffer[last_index]) == this.EOFT_SYMBOL) {
            --last_index;
        }
        this.misplacementRecovery(misplaced_repair, this.stateStack, this.stateStackTop, ++last_index, false);
        this.secondaryRecovery(repair, this.stateStack, this.stateStackTop, last_index, false);
        if (misplaced_repair.distance > 3 && (misplaced_repair.numDeletions <= repair.numDeletions || misplaced_repair.distance - misplaced_repair.numDeletions >= repair.distance - repair.numDeletions)) {
            repair.code = 8;
            repair.stackPosition = misplaced_repair.stackPosition;
            repair.bufferPosition = 2;
            repair.numDeletions = misplaced_repair.numDeletions;
            repair.distance = misplaced_repair.distance;
            repair.recoveryOnNextStack = misplaced_repair.recoveryOnNextStack;
        }
        if (repair.recoveryOnNextStack) {
            this.stateStackTop = this.nextStackTop;
            System.arraycopy(this.nextStack, 0, this.stateStack, 0, this.stateStackTop + 1);
            this.buffer[2] = error_token;
            this.buffer[1] = this.tokStream.getPrevious(this.buffer[2]);
            this.buffer[0] = this.tokStream.getPrevious(this.buffer[1]);
            k = 3;
            while (k < 31) {
                this.buffer[k] = this.tokStream.getNext(this.buffer[k - 1]);
                ++k;
            }
            this.buffer[31] = this.tokStream.badToken();
            this.locationStack[this.nextStackTop] = this.buffer[2];
            last_index = next_last_index;
        }
        if (repair.code == 5 || repair.code == 6) {
            PrimaryRepairInfo scope_repair = new PrimaryRepairInfo();
            scope_repair.bufferPosition = 2;
            while (scope_repair.bufferPosition <= repair.bufferPosition && repair.code != 9) {
                this.scopeTrial(scope_repair, this.stateStack, this.stateStackTop);
                int j = scope_repair.distance == 30 ? last_index : scope_repair.distance;
                int k3 = scope_repair.bufferPosition - 1;
                if (scope_repair.distance - k3 > 3 && j - k3 > repair.distance - repair.numDeletions) {
                    int i = this.scopeIndex[this.scopeStackTop];
                    repair.code = 9;
                    repair.symbol = this.scopeLhs(i) + this.NT_OFFSET;
                    repair.stackPosition = this.stateStackTop;
                    repair.bufferPosition = scope_repair.bufferPosition;
                }
                ++scope_repair.bufferPosition;
            }
        }
        if (repair.code == 0 && this.tokStream.getKind(this.buffer[last_index]) == this.EOFT_SYMBOL) {
            PrimaryRepairInfo scope_repair = new PrimaryRepairInfo();
            scope_repair.bufferPosition = last_index;
            int top = this.stateStackTop;
            while (top >= 0 && repair.code == 0) {
                this.scopeTrial(scope_repair, this.stateStack, top);
                if (scope_repair.distance > 0) {
                    int i = this.scopeIndex[this.scopeStackTop];
                    repair.code = 9;
                    repair.symbol = this.scopeLhs(i) + this.NT_OFFSET;
                    repair.stackPosition = top;
                    repair.bufferPosition = scope_repair.bufferPosition;
                }
                --top;
            }
        }
        RepairCandidate candidate = new RepairCandidate();
        if (repair.code == 0) {
            return candidate;
        }
        this.secondaryDiagnosis(repair);
        switch (repair.code) {
            case 8: {
                candidate.location = this.buffer[2];
                candidate.symbol = this.tokStream.getKind(this.buffer[2]);
                this.tokStream.reset(this.tokStream.getNext(this.buffer[2]));
                break;
            }
            case 6: {
                candidate.location = this.buffer[repair.bufferPosition];
                candidate.symbol = this.tokStream.getKind(this.buffer[repair.bufferPosition]);
                this.tokStream.reset(this.tokStream.getNext(this.buffer[repair.bufferPosition]));
                break;
            }
            default: {
                candidate.symbol = repair.symbol;
                candidate.location = this.buffer[repair.bufferPosition];
                this.tokStream.reset(this.buffer[repair.bufferPosition]);
            }
        }
        return candidate;
    }

    protected void misplacementRecovery(SecondaryRepairInfo repair, int[] stack, int stack_top, int last_index, boolean stack_flag) {
        int previous_loc = this.buffer[2];
        int stack_deletions = 0;
        int top = stack_top - 1;
        while (top >= 0) {
            int j;
            if (this.locationStack[top] < previous_loc) {
                ++stack_deletions;
            }
            previous_loc = this.locationStack[top];
            int parse_distance = this.parseCheck(stack, top, this.tokStream.getKind(this.buffer[2]), 3);
            int n = j = parse_distance == 30 ? last_index : parse_distance;
            if (parse_distance > 3 && j - stack_deletions > repair.distance - repair.numDeletions) {
                repair.stackPosition = top;
                repair.distance = j;
                repair.numDeletions = stack_deletions;
                repair.recoveryOnNextStack = stack_flag;
            }
            --top;
        }
    }

    protected void secondaryRecovery(SecondaryRepairInfo repair, int[] stack, int stack_top, int last_index, boolean stack_flag) {
        int previous_loc = this.buffer[2];
        int stack_deletions = 0;
        int top = stack_top;
        while (top >= 0 && repair.numDeletions >= stack_deletions) {
            if (this.locationStack[top] < previous_loc) {
                ++stack_deletions;
            }
            previous_loc = this.locationStack[top];
            int i = 2;
            while (i <= last_index - 3 + 1 && repair.numDeletions >= stack_deletions + i - 1) {
                int k;
                int j;
                int parse_distance = this.parseCheck(stack, top, this.tokStream.getKind(this.buffer[i]), i + 1);
                int n = j = parse_distance == 30 ? last_index : parse_distance;
                if (parse_distance - i + 1 > 3 && ((k = stack_deletions + i - 1) < repair.numDeletions || j - k > repair.distance - repair.numDeletions || repair.code == 5 && j - k == repair.distance - repair.numDeletions)) {
                    repair.code = 6;
                    repair.distance = j;
                    repair.stackPosition = top;
                    repair.bufferPosition = i;
                    repair.numDeletions = k;
                    repair.recoveryOnNextStack = stack_flag;
                }
                int l = this.nasi(stack[top]);
                while (l >= 0 && this.nasr(l) != 0) {
                    int k2;
                    int symbol = this.nasr(l) + this.NT_OFFSET;
                    parse_distance = this.parseCheck(stack, top, symbol, i);
                    int n2 = j = parse_distance == 30 ? last_index : parse_distance;
                    if (parse_distance - i + 1 > 3 && ((k2 = stack_deletions + i - 1) < repair.numDeletions || j - k2 > repair.distance - repair.numDeletions)) {
                        repair.code = 5;
                        repair.symbol = symbol;
                        repair.distance = j;
                        repair.stackPosition = top;
                        repair.bufferPosition = i;
                        repair.numDeletions = k2;
                        repair.recoveryOnNextStack = stack_flag;
                    }
                    ++l;
                }
                ++i;
            }
            --top;
        }
    }

    protected void secondaryDiagnosis(SecondaryRepairInfo repair) {
        switch (repair.code) {
            case 9: {
                if (repair.stackPosition < this.stateStackTop) {
                    this.emitError(6, this.terminalIndex(this.ERROR_SYMBOL), this.locationStack[repair.stackPosition], this.buffer[1]);
                }
                int i = 0;
                while (i < this.scopeStackTop) {
                    this.emitError(9, -this.scopeIndex[i], this.locationStack[this.scopePosition[i]], this.buffer[1], this.nonterminalIndex(this.scopeLhs(this.scopeIndex[i])));
                    ++i;
                }
                repair.symbol = this.scopeLhs(this.scopeIndex[this.scopeStackTop]) + this.NT_OFFSET;
                this.stateStackTop = this.scopePosition[this.scopeStackTop];
                this.emitError(9, -this.scopeIndex[this.scopeStackTop], this.locationStack[this.scopePosition[this.scopeStackTop]], this.buffer[1], this.getNtermIndex(this.stateStack[this.stateStackTop], repair.symbol, repair.bufferPosition));
                break;
            }
            default: {
                this.emitError(repair.code, repair.code == 5 ? this.getNtermIndex(this.stateStack[repair.stackPosition], repair.symbol, repair.bufferPosition) : this.terminalIndex(this.ERROR_SYMBOL), this.locationStack[repair.stackPosition], this.buffer[repair.bufferPosition - 1]);
                this.stateStackTop = repair.stackPosition;
            }
        }
    }

    protected void emitError(int msg_code, int name_index, int left_token, int right_token, int scope_name_index) {
        String token_name;
        int left_token_loc = left_token > right_token ? right_token : left_token;
        int right_token_loc = right_token;
        String string = token_name = name_index >= 0 && !this.name(name_index).equalsIgnoreCase("ERROR") ? "\"" + this.name(name_index) + "\"" : "";
        if (msg_code == 4) {
            int n = msg_code = token_name.length() == 0 ? 4 : 11;
        }
        if (msg_code == 9) {
            token_name = "\"";
            int i = this.scopeSuffix(-name_index);
            while (this.scopeRhs(i) != 0) {
                if (!this.isNullable(this.scopeRhs(i))) {
                    int symbol_index;
                    int n = symbol_index = this.scopeRhs(i) > this.NT_OFFSET ? this.nonterminalIndex(this.scopeRhs(i) - this.NT_OFFSET) : this.terminalIndex(this.scopeRhs(i));
                    if (this.name(symbol_index).length() > 0) {
                        if (token_name.length() > 1) {
                            token_name = String.valueOf(token_name) + " ";
                        }
                        token_name = String.valueOf(token_name) + this.name(symbol_index);
                    }
                }
                ++i;
            }
            token_name = String.valueOf(token_name) + "\"";
        }
        this.tokStream.reportError(msg_code, left_token, right_token, token_name);
    }

    protected void emitError(int msgCode, int nameIndex, int leftToken, int rightToken) {
        this.emitError(msgCode, nameIndex, leftToken, rightToken, 0);
    }

    private int lookahead(int act, int token) {
        return (act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(token))) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.getNext(token)) : act;
    }

    protected int tAction(int act, int sym) {
        return (act = this.prs.tAction(act, sym)) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.peek()) : act;
    }

    protected class PrimaryRepairInfo {
        public int distance;
        public int misspellIndex;
        public int code;
        public int bufferPosition;
        public int symbol;

        public PrimaryRepairInfo() {
        }

        public PrimaryRepairInfo(PrimaryRepairInfo clone) {
            this.copy(clone);
        }

        public void copy(PrimaryRepairInfo clone) {
            this.distance = clone.distance;
            this.misspellIndex = clone.misspellIndex;
            this.code = clone.code;
            this.bufferPosition = clone.bufferPosition;
            this.symbol = clone.symbol;
        }
    }

    protected class RepairCandidate {
        public int symbol;
        public int location;

        protected RepairCandidate() {
        }
    }

    protected class SecondaryRepairInfo {
        public int code;
        public int distance;
        public int bufferPosition;
        public int stackPosition;
        public int numDeletions;
        public int symbol;
        boolean recoveryOnNextStack;

        protected SecondaryRepairInfo() {
        }
    }

    protected class StateInfo {
        int state;
        int next;

        public StateInfo(int state, int next) {
            this.state = state;
            this.next = next;
        }
    }
}

