/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.MultiDimRegion;
import hj.array.Region0Base;
import hj.lang.RankMismatchException;
import hj.lang.point;
import hj.lang.region;

public class Region3D0Base
extends MultiDimRegion
implements Region0Base {
    public final int I;
    public final int J;
    public final int K;

    public Region3D0Base(region[] d) {
        super(d, true);
        assert (d.length == 3);
        assert (d[0].low() == 0 && d[1].low() == 0 && d[2].low() == 0);
        this.I = d[0].high();
        this.J = d[1].high();
        this.K = d[2].high();
    }

    public region rank(int i) {
        assert (i < 3);
        assert (i >= 0);
        return this.dims_[i];
    }

    public boolean contains(region r) {
        assert (r != null);
        if (r.rank != this.rank) {
            throw new RankMismatchException(r, this.rank);
        }
        if (r instanceof Region3D0Base) {
            Region3D0Base other = (Region3D0Base)r;
            return this.dims_[0].high() >= other.dims_[0].high() && this.dims_[1].high() >= other.dims_[1].high() && this.dims_[2].high() >= other.dims_[2].high();
        }
        return super.contains(r);
    }

    public boolean contains(point p) {
        return this.contains(p.val());
    }

    public boolean contains(int[] v) {
        return v.length == 3 && v[0] <= this.I && v[1] <= this.J && v[2] <= this.K;
    }

    public int ordinal(point p) {
        return this.ordinal(p.val());
    }

    public int ordinal(int[] v) {
        assert (v.length == 3);
        return v[0] + (this.J + 1) * (v[1] + (this.K + 1) * v[2]);
    }

    public region convexHull() {
        return this;
    }

    public int high() {
        throw new UnsupportedOperationException();
    }

    public int low() {
        throw new UnsupportedOperationException();
    }

    public boolean isConvex() {
        return true;
    }

    public point coord(int ordinal) throws ArrayIndexOutOfBoundsException {
        assert (ordinal < this.size());
        int[] ret = new int[this.rank];
        int rest = ordinal;
        boolean base = false;
        for (int i = 0; i < this.rank; ++i) {
            region r = this.dims_[i];
            int tmp = rest / this.base_[i];
            rest %= this.base_[i];
            ret[i] = r.coord(tmp).get(0);
        }
        return point.factory.point(ret);
    }
}

