/*
 * Decompiled with CFR 0.152.
 */
package hj.lang;

import hj.array.Operator;
import hj.lang.DoubleReferenceArray;
import hj.lang.dist;
import hj.lang.hjArray;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;

public abstract class doubleArray
extends hjArray {
    public static final Operator.Binary sub = new Operator.Binary(){

        public double apply(double r, double s) {
            return r - s;
        }
    };
    public static final Operator.Binary add = new Operator.Binary(){

        public double apply(double r, double s) {
            return r + s;
        }
    };
    public static final Operator.Binary mul = new Operator.Binary(){

        public double apply(double r, double s) {
            return r * s;
        }
    };
    public static final Operator.Binary div = new Operator.Binary(){

        public double apply(double r, double s) {
            return r / s;
        }
    };
    public static final Operator.Binary max = new Operator.Binary(){

        public double apply(double r, double s) {
            return Math.max(r, s);
        }
    };
    public static final Operator.Unary abs = new Operator.Unary(){

        public double apply(double r) {
            return Math.abs(r);
        }
    };
    public static final Operator.Unary id = new Operator.Unary(){

        public double apply(double r) {
            return r;
        }
    };

    protected doubleArray(dist D, boolean mutable) {
        super(D, mutable);
    }

    public abstract double[] getBackingArray();

    public abstract double get(point var1);

    public abstract double getOrdinal(int var1);

    public abstract double get(int var1);

    public abstract double get(int var1, int var2);

    public abstract double get(int var1, int var2, int var3);

    public abstract double get(int var1, int var2, int var3, int var4);

    public double sum() {
        return this.reduce(add, 0.0);
    }

    public double sum(region r) {
        return this.reduce(add, 0.0, r);
    }

    public double max() {
        return this.reduce(max, 0.0);
    }

    public double max(region r) {
        return this.reduce(max, 0.0, r);
    }

    public double max(Operator.Unary fun) {
        return this.lift(fun).reduce(max, 0.0);
    }

    public DoubleReferenceArray abs() {
        return this.lift(abs);
    }

    public DoubleReferenceArray sub(doubleArray s) {
        return this.lift(sub, s);
    }

    public DoubleReferenceArray add(doubleArray s) {
        return this.lift(add, s);
    }

    public DoubleReferenceArray mul(doubleArray s) {
        return this.lift(mul, s);
    }

    public DoubleReferenceArray pow(int k) {
        return k <= 0 ? this.lift(id) : this.mul(this.pow(k - 1));
    }

    public DoubleReferenceArray div(doubleArray s) {
        return this.lift(div, s);
    }

    public DoubleReferenceArray scale(final int k) {
        return this.lift(new Operator.Unary(){

            public double apply(double r) {
                return r * (double)k;
            }
        });
    }

    public double maxAbs() {
        return this.max(abs);
    }

    public double reduce(Operator.Binary fun, double unit) {
        return this.reduce(fun, unit, this.distribution.region);
    }

    public abstract double reduce(Operator.Binary var1, double var2, region var4);

    public abstract DoubleReferenceArray scan(Operator.Binary var1, double var2);

    public abstract DoubleReferenceArray restriction(region var1);

    public DoubleReferenceArray restriction(dist D) {
        return this.restriction(D.region);
    }

    public DoubleReferenceArray restriction(place P) {
        return this.restriction(this.distribution.restriction(P));
    }

    public abstract DoubleReferenceArray union(doubleArray var1);

    public abstract DoubleReferenceArray overlay(doubleArray var1);

    public abstract void update(doubleArray var1);

    public abstract DoubleReferenceArray lift(Operator.Binary var1, doubleArray var2);

    public abstract DoubleReferenceArray lift(Operator.Unary var1);

    public abstract doubleArray toValueArray();

    public static class Constant
    extends Operator.Pointwise {
        private final double c_;

        public Constant(double c) {
            this.c_ = c;
        }

        public double apply(point p, double i) {
            return this.c_;
        }
    }
}

