/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.PhaserException;
import hj.lang.Runtime;
import hj.lang.accumulator;
import hj.lang.phaser;
import hj.runtime.wsh.AccumCell;
import hj.runtime.wsh.AccumCellD;
import hj.runtime.wsh.AccumCellI;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.AtomicDouble;
import hj.runtime.wsh.PhaserImpl;
import hj.runtime.wsh.WshRuntime_c;
import java.util.concurrent.atomic.AtomicInteger;

public class Accumulator
extends accumulator {
    private final accumulator.Operator ope;
    private final Class type;
    private final phaser ph;
    private final PhaserImpl phi;
    private Number resultVal;
    private Number resultTmp;
    private final Number[] resultBuff;
    private final Number initVal;
    private int sigPhase;
    public final AtomicInteger atomI;
    public final AtomicDouble atomD;
    public final AtomicInteger[] atomIbuff;
    public final AtomicDouble[] atomDbuff;
    private final int func;
    private final double delay;
    private final double coef;
    private final int buffsize;
    private int arrsize = 0;
    private final Number[][] resultArrBuff;
    private final int[][] resultArrBuffInt;

    public Accumulator(accumulator.Operator ope, Class type, phaser ph) {
        this(ope, type, ph, 1, 50.0, 2.0, 0);
    }

    public Accumulator(accumulator.Operator ope, Class type, phaser ph, int arrsize) {
        this(ope, type, ph, 1, 50.0, 2.0, arrsize);
    }

    public Accumulator(accumulator.Operator ope, Class type0, phaser ph, int func, double delay, double coef, int arrsize) {
        double initD;
        int initI;
        if (ope != accumulator.Operator.ANY && ope != accumulator.Operator.SUM && ope != accumulator.Operator.PROD && ope != accumulator.Operator.MIN && ope != accumulator.Operator.MAX) {
            throw new PhaserException("Accumulator: Not supported operator.");
        }
        Class ty = null;
        if (type0 == Integer.TYPE || type0 == Integer.class) {
            ty = Integer.class;
        } else if (type0 == Double.TYPE || type0 == Double.class) {
            ty = Double.class;
        } else {
            throw new PhaserException("Accumulator: Not supported data type " + type0 + ".");
        }
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl phiTmp = (PhaserImpl)ph.getPhaser();
        PhaserImpl.Mode mode = phiTmp.getMode(a);
        if (mode == PhaserImpl.Mode.TRANSMIT) {
            throw new PhaserException("Accumulator: TRANSMIT mode isn't permitted.");
        }
        int bound = phiTmp.getBound();
        if (bound == 0 && (mode == PhaserImpl.Mode.SIG || mode == PhaserImpl.Mode.WAIT)) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        if (arrsize > 0 && (ope != accumulator.Operator.ANY || bound == 0)) assert (false);
        this.ope = ope;
        this.type = ty;
        this.ph = ph;
        this.phi = phiTmp;
        this.phi.addAccums(this, ope);
        this.sigPhase = -1;
        int n = this.buffsize = bound > 0 ? bound * 3 + 2 : 0;
        if (ope == accumulator.Operator.SUM || ope == accumulator.Operator.ANY) {
            initI = 0;
            initD = 0.0;
        } else if (ope == accumulator.Operator.PROD) {
            initI = 1;
            initD = 1.0;
        } else if (ope == accumulator.Operator.MIN) {
            initI = Integer.MAX_VALUE;
            initD = Double.MAX_VALUE;
        } else if (ope == accumulator.Operator.MAX) {
            initI = Integer.MIN_VALUE;
            initD = Double.MIN_VALUE;
        } else {
            initI = 0;
            initD = 0.0;
            assert (false);
        }
        if (this.type == Integer.class) {
            this.initVal = new Integer(initI);
        } else if (this.type == Double.class) {
            this.initVal = new Double(initD);
        } else {
            this.initVal = null;
            assert (false);
        }
        if (this.buffsize == 0) {
            if (this.type == Integer.class) {
                this.atomI = new AtomicInteger(initI);
                this.atomD = null;
            } else if (this.type == Double.class) {
                this.atomI = null;
                this.atomD = new AtomicDouble(initD, func, delay, coef);
            } else {
                this.atomI = null;
                this.atomD = null;
                assert (false);
            }
            this.resultVal = this.initVal;
            this.atomIbuff = null;
            this.atomDbuff = null;
            this.resultBuff = null;
        } else {
            int i;
            this.atomI = null;
            this.atomD = null;
            this.resultVal = null;
            this.resultBuff = new Number[this.buffsize];
            if (this.type == Integer.class) {
                for (i = 0; i < this.buffsize; ++i) {
                    this.resultBuff[i] = new Integer(initI);
                }
            } else if (this.type == Double.class) {
                for (i = 0; i < this.buffsize; ++i) {
                    this.resultBuff[i] = new Double(initD);
                }
            } else assert (false);
            if (ope == accumulator.Operator.ANY) {
                this.atomIbuff = null;
                this.atomDbuff = null;
            } else if (this.type == Integer.class) {
                this.atomIbuff = new AtomicInteger[this.buffsize];
                this.atomDbuff = null;
                for (i = 0; i < this.buffsize; ++i) {
                    this.atomIbuff[i] = new AtomicInteger(initI);
                }
            } else if (this.type == Double.class) {
                this.atomIbuff = null;
                this.atomDbuff = new AtomicDouble[this.buffsize];
                for (i = 0; i < this.buffsize; ++i) {
                    this.atomDbuff[i] = new AtomicDouble(initD, func, delay, coef);
                }
            } else {
                this.atomIbuff = null;
                this.atomDbuff = null;
                assert (false);
            }
        }
        this.func = func;
        this.delay = delay;
        this.coef = coef;
        if (mode != PhaserImpl.Mode.WAIT) {
            AccumCell cell = null;
            if (this.type == Integer.class) {
                cell = new AccumCellI();
            } else if (this.type == Double.class) {
                cell = new AccumCellD();
            } else assert (false);
            a.putAccumCell(this, cell);
        }
        this.arrsize = arrsize;
        this.resultArrBuff = arrsize > 0 ? new Number[this.buffsize][] : (Number[][])null;
        this.resultArrBuffInt = arrsize > 0 ? (Object)new int[this.buffsize][] : (int[][])null;
    }

    public void register(Activity a, PhaserImpl.Mode mode) {
        if (this.buffsize == 0 && (mode == PhaserImpl.Mode.SIG || mode == PhaserImpl.Mode.WAIT)) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        if (mode != PhaserImpl.Mode.WAIT) {
            AccumCell cell = null;
            if (this.type == Integer.class) {
                cell = new AccumCellI();
            } else if (this.type == Double.class) {
                cell = new AccumCellD();
            } else assert (false);
            a.putAccumCell(this, cell);
        }
    }

    public accumulator.Operator getOperator() {
        return this.ope;
    }

    public Class getType() {
        return this.type;
    }

    public int getSigPhase() {
        return this.sigPhase;
    }

    public int getBuffsize() {
        return this.buffsize;
    }

    public int getRound() {
        Activity a = (Activity)WshRuntime_c.getCurrentActivity();
        return a.round;
    }

    public void setResultAndSigPhase(Number val, int mSigP, int mSigC) {
        this.sigPhase = mSigP;
        if (this.buffsize == 0) {
            this.resultVal = val;
        } else {
            this.resultBuff[mSigC] = val;
        }
    }

    public void moveTmp2Result() {
        if (this.buffsize > 0) assert (false);
        this.resultVal = this.resultTmp;
        this.resultTmp = null;
    }

    public void initAtomicVar(int mWaitCycle) {
        if (this.type == Integer.class) {
            AtomicInteger aI = this.buffsize == 0 ? this.atomI : this.atomIbuff[mWaitCycle];
            aI.set(this.initVal.intValue());
        } else if (this.type == Double.class) {
            AtomicDouble aD = this.buffsize == 0 ? this.atomD : this.atomDbuff[mWaitCycle];
            aD.set(this.initVal.doubleValue());
        } else assert (false);
    }

    private int localSpin(double round, double exp, Activity a) {
        int n = 0;
        int length = (int)this.delay;
        switch (this.func) {
            case 1: {
                length = (int)(this.delay * (1.0 + this.coef * a.rand.nextDouble()));
                break;
            }
            case 2: {
                length = (int)(this.delay * (1.0 + this.coef * (round - 1.0)));
                break;
            }
            case 3: {
                length = (int)(this.delay * (1.0 + this.coef * round * a.rand.nextDouble()));
                break;
            }
            case 4: {
                length = (int)Math.min(exp * this.coef, this.delay);
                break;
            }
            case 5: {
                length = (int)(Math.min(exp * this.coef, this.delay) * a.rand.nextDouble());
            }
        }
        for (int i = 0; i < length; ++i) {
            n += i;
        }
        return n;
    }

    public void send(int val) {
        this.send(val, false);
    }

    public void send(int val, boolean purge) {
        block27: {
            AtomicInteger aI;
            AccumCell cell;
            Activity a = (Activity)Runtime.getCurrentActivity();
            PhaserImpl.Mode mode = this.phi.getMode(a);
            if ((mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SINGLE) && this.phi.quiescent(a)) {
                throw new PhaserException("Accumulator: SIG_WAIT can't perform send after signal.");
            }
            if (mode == PhaserImpl.Mode.WAIT) {
                return;
            }
            if (this.type != Integer.class) {
                throw new PhaserException("Accumulator: Integer type send method on " + this.type + " type accumulator isn't permitted.");
            }
            AccumCell accumCell = cell = purge ? a.getAccumCell(this) : null;
            if (purge && cell == null) {
                throw new PhaserException("Accumulator: Activity " + a + " isn't registered on Accumulator " + this + ".");
            }
            double round = 1.0;
            double exp = 2.0;
            int sigP = this.phi.getSigPhase(a);
            int sigC = this.phi.getSigCycle(a);
            AtomicInteger atomicInteger = aI = this.buffsize == 0 || this.ope == accumulator.Operator.ANY ? this.atomI : this.atomIbuff[sigC];
            if (this.ope == accumulator.Operator.ANY) {
                this.sigPhase = sigP;
                if (this.buffsize == 0) {
                    this.resultTmp = new Integer(val);
                } else {
                    this.resultBuff[sigC] = new Integer(val);
                }
            } else {
                if (this.ope == accumulator.Operator.SUM) {
                    if (purge && cell.sigPhase == sigP) {
                        val += ((AccumCellI)cell).val;
                        cell.sigPhase = -1;
                    }
                    while (true) {
                        int neo;
                        int cur;
                        if (aI.compareAndSet(cur = aI.get(), neo = cur + val)) {
                            a.round = (int)round;
                            break block27;
                        }
                        a.tmpForDelay = this.localSpin(round, exp, a);
                        round += 1.0;
                        exp *= 2.0;
                    }
                }
                if (this.ope == accumulator.Operator.PROD) {
                    if (purge && cell.sigPhase == sigP) {
                        val *= ((AccumCellI)cell).val;
                        cell.sigPhase = -1;
                    }
                    while (true) {
                        int neo;
                        int cur;
                        if (aI.compareAndSet(cur = aI.get(), neo = cur * val)) {
                            a.round = (int)round;
                            break block27;
                        }
                        a.tmpForDelay = this.localSpin(round, exp, a);
                        round += 1.0;
                        exp *= 2.0;
                    }
                }
                if (this.ope == accumulator.Operator.MIN) {
                    if (purge && cell.sigPhase == sigP) {
                        int v = ((AccumCellI)cell).val;
                        if (v < val) {
                            val = v;
                        }
                        cell.sigPhase = -1;
                    }
                    while (true) {
                        int cur;
                        if (val >= (cur = aI.get()) || aI.compareAndSet(cur, val)) {
                            a.round = (int)round;
                            break block27;
                        }
                        a.tmpForDelay = this.localSpin(round, exp, a);
                        round += 1.0;
                        exp *= 2.0;
                    }
                }
                if (this.ope == accumulator.Operator.MAX) {
                    if (purge && cell.sigPhase == sigP) {
                        int v = ((AccumCellI)cell).val;
                        if (v > val) {
                            val = v;
                        }
                        cell.sigPhase = -1;
                    }
                    while (true) {
                        int cur;
                        if (val <= (cur = aI.get()) || aI.compareAndSet(cur, val)) {
                            a.round = (int)round;
                            break block27;
                        }
                        a.tmpForDelay = this.localSpin(round, exp, a);
                        round += 1.0;
                        exp *= 2.0;
                    }
                }
                assert (false);
            }
        }
    }

    public void send(double val) {
        this.send(val, false);
    }

    public void send(double val, boolean purge) {
        AtomicDouble aD;
        AccumCell cell;
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if ((mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SINGLE) && this.phi.quiescent(a)) {
            throw new PhaserException("Accumulator: SIG_WAIT can't perform send after signal.");
        }
        if (mode == PhaserImpl.Mode.WAIT) {
            return;
        }
        if (this.type != Double.class) {
            throw new PhaserException("Accumulator: Double type send method on " + this.type + " type accumulator isn't permitted.");
        }
        AccumCell accumCell = cell = purge ? a.getAccumCell(this) : null;
        if (purge && cell == null) {
            throw new PhaserException("Accumulator: Activity " + a + " isn't registered on Accumulator " + this + ".");
        }
        int sigP = this.phi.getSigPhase(a);
        int sigC = this.phi.getSigCycle(a);
        AtomicDouble atomicDouble = aD = this.buffsize == 0 || this.ope == accumulator.Operator.ANY ? this.atomD : this.atomDbuff[sigC];
        if (this.ope == accumulator.Operator.ANY) {
            this.sigPhase = sigP;
            if (this.buffsize == 0) {
                this.resultTmp = new Double(val);
            } else {
                this.resultBuff[sigC] = new Double(val);
            }
        } else if (this.ope == accumulator.Operator.SUM) {
            if (purge && cell.sigPhase == sigP) {
                val += ((AccumCellD)cell).val;
                cell.sigPhase = -1;
            }
            aD.addAndGet(val);
        } else if (this.ope == accumulator.Operator.PROD) {
            if (purge && cell.sigPhase == sigP) {
                val *= ((AccumCellD)cell).val;
                cell.sigPhase = -1;
            }
            aD.mulAndGet(val);
        } else if (this.ope == accumulator.Operator.MIN) {
            if (purge && cell.sigPhase == sigP) {
                double v = ((AccumCellD)cell).val;
                if (v < val) {
                    val = v;
                }
                cell.sigPhase = -1;
            }
            aD.minAndGet(val);
        } else if (this.ope == accumulator.Operator.MAX) {
            if (purge && cell.sigPhase == sigP) {
                double v = ((AccumCellD)cell).val;
                if (v > val) {
                    val = v;
                }
                cell.sigPhase = -1;
            }
            aD.maxAndGet(val);
        } else assert (false);
    }

    public void send(Number val) {
        this.send(val, false);
    }

    public void send(Number val, boolean purge) {
        Class<?> ty = val.getClass();
        if (ty == Integer.class) {
            this.send(val.intValue(), purge);
        } else if (ty == Double.class) {
            this.send(val.doubleValue(), purge);
        } else assert (false);
    }

    public void lsend(int val) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if ((mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SINGLE) && this.phi.quiescent(a)) {
            throw new PhaserException("Accumulator: SIG_WAIT can't perform send after signal.");
        }
        if (mode == PhaserImpl.Mode.WAIT) {
            return;
        }
        if (this.type != Integer.class) {
            throw new PhaserException("Accumulator: Integer type lsend method on " + this.type + " type accumulator isn't permitted.");
        }
        AccumCell cell = a.getAccumCell(this);
        if (cell == null) {
            throw new PhaserException("Accumulator: Activity " + a + " isn't registered on Accumulator " + this + ".");
        }
        if (this.ope == accumulator.Operator.ANY) {
            return;
        }
        int sigP = this.phi.getSigPhase(a);
        if (cell.sigPhase < sigP) {
            cell.sigPhase = sigP;
            ((AccumCellI)cell).val = val;
        } else if (this.ope == accumulator.Operator.SUM) {
            ((AccumCellI)cell).val += val;
        } else if (this.ope == accumulator.Operator.PROD) {
            ((AccumCellI)cell).val *= val;
        } else if (this.ope == accumulator.Operator.MIN) {
            int v = ((AccumCellI)cell).val;
            if (val < v) {
                ((AccumCellI)cell).val = v;
            }
        } else if (this.ope == accumulator.Operator.MAX) {
            int v = ((AccumCellI)cell).val;
            if (val > v) {
                ((AccumCellI)cell).val = v;
            }
        } else assert (false);
    }

    public void lsend(double val) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if ((mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SINGLE) && this.phi.quiescent(a)) {
            throw new PhaserException("Accumulator: SIG_WAIT can't perform send after signal.");
        }
        if (mode == PhaserImpl.Mode.WAIT) {
            return;
        }
        if (this.type != Double.class) {
            throw new PhaserException("Accumulator: Double type lsend method on " + this.type + " type accumulator isn't permitted.");
        }
        AccumCell cell = a.getAccumCell(this);
        if (cell == null) {
            throw new PhaserException("Accumulator: Activity " + a + " isn't registered on Accumulator " + this + ".");
        }
        if (this.ope == accumulator.Operator.ANY) {
            return;
        }
        int sigP = this.phi.getSigPhase(a);
        if (cell.sigPhase < sigP) {
            cell.sigPhase = sigP;
            ((AccumCellD)cell).val = val;
        } else if (this.ope == accumulator.Operator.SUM) {
            ((AccumCellD)cell).val += val;
        } else if (this.ope == accumulator.Operator.PROD) {
            ((AccumCellD)cell).val *= val;
        } else if (this.ope == accumulator.Operator.MIN) {
            double v = ((AccumCellD)cell).val;
            if (val < v) {
                ((AccumCellD)cell).val = v;
            }
        } else if (this.ope == accumulator.Operator.MAX) {
            double v = ((AccumCellD)cell).val;
            if (val > v) {
                ((AccumCellD)cell).val = v;
            }
        } else assert (false);
    }

    public void lsend(Number val) {
        Class<?> ty = val.getClass();
        if (ty == Integer.class) {
            this.lsend(val.intValue());
        } else if (ty == Double.class) {
            this.lsend(val.doubleValue());
        } else assert (false);
    }

    public Number result() {
        return this.result(0);
    }

    public Number result(int offset) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        if (this.phi.getMode(a) == PhaserImpl.Mode.SIG) {
            return this.initVal;
        }
        if (this.buffsize == 0) {
            return this.resultVal;
        }
        if (offset < -this.buffsize || offset > 0) {
            throw new PhaserException("Accumulator: offset for result method must be " + -this.buffsize + " <= offset <= 0");
        }
        int tmp = this.phi.getWaitCycle(a) + offset - 1;
        int cyc = tmp >= 0 ? tmp : tmp + this.buffsize;
        return this.resultBuff[cyc];
    }

    public void send(Number[] arr) {
        if (this.ope == accumulator.Operator.ANY && this.buffsize > 0) {
            Activity a = (Activity)Runtime.getCurrentActivity();
            int sigP = this.phi.getSigPhase(a);
            int sigC = this.phi.getSigCycle(a);
            this.sigPhase = sigP;
            if (this.arrsize != arr.length) assert (false);
            this.resultArrBuff[sigC] = arr;
        } else assert (false);
    }

    public void send(int[] arr) {
        if (this.ope == accumulator.Operator.ANY && this.buffsize > 0) {
            Activity a = (Activity)Runtime.getCurrentActivity();
            int sigP = this.phi.getSigPhase(a);
            int sigC = this.phi.getSigCycle(a);
            this.sigPhase = sigP;
            if (this.arrsize != arr.length) assert (false);
            this.resultArrBuffInt[sigC] = arr;
        } else assert (false);
    }

    public Number[] resultArr() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        if (this.phi.getMode(a) == PhaserImpl.Mode.SIG || this.buffsize == 0) assert (false);
        int waitC = this.phi.getWaitCycle(a);
        int waitCm1 = waitC == 0 ? this.buffsize - 1 : waitC - 1;
        return this.resultArrBuff[waitCm1];
    }

    public int[] resultArrInt() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        if (this.phi.getMode(a) == PhaserImpl.Mode.SIG || this.buffsize == 0) assert (false);
        int waitC = this.phi.getWaitCycle(a);
        int waitCm1 = waitC == 0 ? this.buffsize - 1 : waitC - 1;
        return this.resultArrBuffInt[waitCm1];
    }
}

