/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.adaptive;

import hj.lang.Exception;
import hj.lang.Object;
import hj.lang.Runtime;
import hj.lang.place;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.WshConfiguration;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wst.WstConfiguration;
import hj.runtime.wst.adaptive.ActivationFrame;
import hj.runtime.wst.adaptive.Closure;
import hj.runtime.wst.adaptive.FinishTreeNode;
import hj.runtime.wst.adaptive.Worker;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class Runtime
extends hj.lang.Runtime {
    public static Runtime singleton;
    private final Worker[] allWorkers;
    private final int numWorkers;
    public final boolean reserveBottom = WstConfiguration.RESERVE_BOTTOM;
    public static volatile boolean done;
    private static long intervalTimer;

    public Runtime() {
        this.numWorkers = WstConfiguration.NPROC;
        this.allWorkers = new Worker[this.numWorkers];
        done = false;
        this.startHjWorkSharingRuntime();
        singleton = this;
    }

    public void startWorkers(ActivationFrame mainAF) {
        int i;
        Closure initClosure = new Closure();
        initClosure.setFinishScope(FinishTreeNode.mainFinishScope);
        initClosure.head = mainAF;
        this.allWorkers[0] = new Worker(0, initClosure);
        initClosure = null;
        for (i = 1; i < this.numWorkers; ++i) {
            this.allWorkers[i] = new Worker(i, null);
        }
        for (i = 1; i < this.numWorkers; ++i) {
            this.allWorkers[i].start();
        }
        this.allWorkers[0].run();
        for (i = 0; i < this.numWorkers; ++i) {
            try {
                this.allWorkers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                --i;
            }
        }
        this.stopRuntime();
        if (WstConfiguration.EXECUTION_STATS) {
            this.dumpStatistics();
        }
    }

    public static int getNumWorkers() {
        return Runtime.singleton.numWorkers;
    }

    public static Worker getWorker(int i) {
        return Runtime.singleton.allWorkers[i];
    }

    public int getStealCounts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sum += this.allWorkers[i].getNumSteals();
        }
        return sum;
    }

    public int getStealAttempts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sum += this.allWorkers[i].getNumStealAttempts();
        }
        return sum;
    }

    private void dumpStatistics() {
        int sumSteals = 0;
        int sumStealAttempts = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sumSteals += this.allWorkers[i].getNumSteals();
            sumStealAttempts += this.allWorkers[i].getNumStealAttempts();
        }
        System.out.println("StealAttempts=" + sumStealAttempts + "\t NumSteals=" + sumSteals);
        Runtime.printProfilingStats();
    }

    public static void startTimer() {
        intervalTimer = -System.nanoTime();
    }

    public static void stopTimer() {
        intervalTimer += System.nanoTime();
    }

    public long getTimer() {
        return intervalTimer;
    }

    private void startHjWorkSharingRuntime() {
        WshConfiguration.NUMBER_OF_LOCAL_PLACES = 1;
        hj.lang.Runtime.runtime = new WshRuntime_c();
        hj.lang.Runtime.factory = hj.lang.Runtime.runtime.getFactory();
        hj.lang.Runtime.runtime.prepareForBoot();
    }

    private void stopRuntime() {
        hj.lang.Runtime.runtime.shutdown();
    }

    public static void printProfilingStats() {
        System.out.println("stack bound = " + WstConfiguration.POLICY_STACK_DEPTH);
        System.out.println("task bound = " + WstConfiguration.POLICY_DEQUE_LIMIT);
        System.out.println("re-evaluation interval = " + WstConfiguration.POLICY_INTERVAL);
        for (int i = 0; i < Runtime.getNumWorkers(); ++i) {
            Worker worker = Runtime.getWorker(i);
            System.out.println();
            System.out.println(worker + " re-evaluate policy " + worker.PROFILE_eval + " times");
            System.out.println("------ stack bound (switch/total)= " + worker.PROFILE_stack_bound_switch + "/" + worker.PROFILE_stack_bound);
            System.out.println("------ task bound (switch/total)= " + worker.PROFILE_task_bound_switch + "/" + worker.PROFILE_task_bound);
            System.out.println("------ steal rate fast (switch/total)= " + worker.PROFILE_steal_rate_fast_switch + "/" + worker.PROFILE_steal_rate_fast);
            System.out.println("------ steal rate slow (switch/total)= " + worker.PROFILE_steal_rate_slow_switch + "/" + worker.PROFILE_steal_rate_slow);
            System.out.println("------ reset (switch/total)= " + worker.PROFILE_reset_switch + "/" + worker.PROFILE_reset);
            System.out.println("------ workfirst asyncs = " + worker.PROFILE_work_first_asyncs);
            System.out.println("------ helpfirst asyncs = " + worker.PROFILE_help_first_asyncs);
        }
    }

    public Activity currentActivity() {
        return null;
    }

    public Place currentPlace() {
        return null;
    }

    public Runtime.Factory getFactory() {
        return null;
    }

    protected Place getPlace0() {
        return null;
    }

    protected Place[] getPlaces() {
        return null;
    }

    protected void initialize() {
    }

    public void prepareForBoot() {
    }

    protected void run(String[] args) throws Exception {
        try {
            String mainClassName = Configuration.MAIN_CLASS_NAME;
            Class<?> main = Class.forName(mainClassName + "$mainframe");
            Constructor<?> c = main.getDeclaredConstructor(String[].class);
            ActivationFrame maf = (ActivationFrame)c.newInstance(new java.lang.Object[]{args});
            maf.pc = 0;
            this.startWorkers(maf);
        }
        catch (ClassNotFoundException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (SecurityException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
        catch (Exception e) {
            Runtime.setExitCode(201);
            e.printStackTrace();
        }
    }

    public void setCurrentPlace(place p) {
        throw new RuntimeException("setCurrentPlace not yet implemented");
    }

    public void shutdown() {
    }

    public void startIsolation_() {
        throw new RuntimeException("startIsolation_ not yet implemented");
    }

    public int[] startIsolation_(Object[] objs) {
        throw new RuntimeException("startIsolation_ not yet implemented");
    }

    public int[] startIsolation_(List objs) {
        throw new RuntimeException("startIsolation_ not yet implemented");
    }

    public int startIsolation_(Object obj) {
        throw new RuntimeException("startIsolation_ not yet implemented");
    }

    public int[] startIsolation_(Object obj1, Object obj2) {
        throw new RuntimeException("startIsolation_ not yet implemented");
    }

    public void stopIsolation_() {
        throw new RuntimeException("stopIsolation_ not yet implemented");
    }

    public void stopIsolation_(int[] placeIDs) {
        throw new RuntimeException("stopIsolation_ not yet implemented");
    }

    public void stopIsolation_(int placeID) {
        throw new RuntimeException("stopIsolation_ not yet implemented");
    }

    static {
        done = false;
    }
}

