/*
 * Decompiled with CFR 0.152.
 */
package hj.ant.utils;

public class HjPlatformHelper {
    public static final String OS_NAME_MAC = "Mac OS X";
    public static final String OS_NAME_LINUX = "Linux";
    public static final String OS_NAME_AIX = "AIX";
    private static final String OS_NAME_WINDOWS = "Windows";
    public static final String HJ_OS_NAME_MAC = "macosx";
    public static final String HJ_OS_NAME_LINUX = "linux";
    public static final String HJ_OS_NAME_AIX = "aix";
    public static final String HJ_OS_NAME_WINDOWS = "win32";
    public static final String OS_ARCH_I386 = "i386";
    public static final String OS_ARCH_AMD64 = "amd64";
    private static final String OS_ARCH_PPC = "ppc";
    private static final String OS_ARCH_POWERPC = "PowerPC";
    private static final String HJ_ARCH_PPC = "ppc";
    private static final String HJ_ARCH_X86 = "x86";

    public static String hjPlatform() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        String string3 = HjPlatformHelper.determineHjArch(string2);
        String string4 = HjPlatformHelper.determineHjOs(string);
        return string4 + "_" + string3;
    }

    private static String determineHjOs(String string) {
        if (HjPlatformHelper.osWindows(string)) {
            return HJ_OS_NAME_WINDOWS;
        }
        if (HjPlatformHelper.osAix(string)) {
            return HJ_OS_NAME_AIX;
        }
        if (HjPlatformHelper.osMac(string)) {
            return HJ_OS_NAME_MAC;
        }
        return HJ_OS_NAME_LINUX;
    }

    private static boolean osWindows(String string) {
        return OS_NAME_WINDOWS.equals(string);
    }

    private static boolean osAix(String string) {
        return OS_NAME_AIX.equals(string);
    }

    private static boolean osMac(String string) {
        return OS_NAME_MAC.equals(string);
    }

    private static boolean osLinux(String string) {
        return OS_NAME_LINUX.equals(string);
    }

    private static String determineHjArch(String string) {
        if (HjPlatformHelper.archPowerPc(string)) {
            return "ppc";
        }
        return HJ_ARCH_X86;
    }

    private static boolean archPowerPc(String string) {
        return string.equals("ppc") || string.equals(OS_ARCH_POWERPC);
    }
}

