/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.ArbitraryRegion;
import hj.lang.point;
import hj.lang.region;

public abstract class Range
extends region {
    public final int size;
    public final int lo;
    public final int hi;

    public Range(int h) {
        this(0, h, h);
    }

    public Range(int l, int h) {
        this(l, h, h - l + 1);
    }

    public Range(int l, int h, int c) {
        super(1, true, l == 0);
        this.lo = l;
        this.hi = h;
        this.size = c;
        assert (this.size == this.hi - this.lo + 1);
        assert (this.hi >= this.lo);
    }

    public int size() {
        return this.size;
    }

    public int ordinal(int j) {
        int ret = j - this.lo;
        if (ret < 0 || ret >= this.size) {
            throw new ArrayIndexOutOfBoundsException(j);
        }
        return ret;
    }

    public boolean contains(int i) {
        return this.lo <= i && i <= this.hi;
    }

    public boolean contains(int[] p) {
        return this.contains(point.factory.point(p));
    }

    public int high() {
        return this.hi;
    }

    public int low() {
        return this.lo;
    }

    public region union(region r) {
        assert (r != null);
        return ArbitraryRegion.union(this, r);
    }

    public region intersection(region r) {
        assert (r != null);
        return ArbitraryRegion.intersection(this, r);
    }

    public region difference(region r) {
        assert (r != null);
        return ArbitraryRegion.difference(this, r);
    }

    public boolean disjoint(region r) {
        assert (r != null);
        return this.intersection(r).size() == 0;
    }

    public region rank(int i) {
        assert (i == 0);
        return this;
    }
}

