/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.Distribution_c;
import hj.array.DoubleArray;
import hj.array.Operator;
import hj.array.Region3D0Base;
import hj.array.sharedmemory.DoubleArray_c;
import hj.lang.DoubleReferenceArray;
import hj.lang.RankMismatchException;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.doubleArray;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Place;

public final class DoubleArray3d_c
extends DoubleArray_c {
    protected final int I;
    protected final int J;
    protected final int K;

    public DoubleArray3d_c(dist d, Operator.Pointwise c, boolean mutable, boolean ignored) {
        this(d, c, mutable);
    }

    private DoubleArray3d_c(dist d, Operator.Pointwise c, boolean mutable) {
        super(d, c, mutable);
        if (d.rank != 3) {
            throw new RankMismatchException(d, 3);
        }
        if (d.region.rank(0).low() != 0 || d.region.rank(1).low() != 0 || d.region.rank(2).low() != 0) {
            throw new IllegalArgumentException("Region " + d.region + " is not 0-based");
        }
        this.I = d.region.rank(0).high() + 1;
        this.J = d.region.rank(1).high() + 1;
        this.K = d.region.rank(2).high() + 1;
    }

    public DoubleArray3d_c(dist d, double c, boolean mutable) {
        super(d, c, mutable);
        if (d.rank != 3) {
            throw new RankMismatchException(d, 3);
        }
        if (d.region.rank(0).low() != 0 || d.region.rank(1).low() != 0 || d.region.rank(2).low() != 0) {
            throw new IllegalArgumentException("Region " + d.region + " is not 0-based");
        }
        this.I = d.region.rank(0).high() + 1;
        this.J = d.region.rank(1).high() + 1;
        this.K = d.region.rank(2).high() + 1;
    }

    private DoubleArray3d_c(dist d, double[] a, boolean mutable) {
        super(d, a, mutable);
        if (d.rank != 3) {
            throw new RankMismatchException(d, 3);
        }
        if (d.region.rank(0).low() != 0 || d.region.rank(1).low() != 0 || d.region.rank(2).low() != 0) {
            throw new IllegalArgumentException("Region " + d.region + " is not 0-based");
        }
        this.I = d.region.rank(0).high() + 1;
        this.J = d.region.rank(1).high() + 1;
        this.K = d.region.rank(2).high() + 1;
    }

    public static DoubleArray3d_c DoubleArray3d_c(double[] a, boolean mutable) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new DoubleArray3d_c(d, a, mutable);
    }

    protected void assign(DoubleArray rhs) {
        assert (rhs instanceof DoubleArray3d_c);
        super.assign(rhs);
    }

    protected DoubleArray newInstance(dist d) {
        assert (d instanceof Distribution_c);
        assert (d.region instanceof Region3D0Base);
        return new DoubleArray3d_c(d, (Operator.Pointwise)null, true);
    }

    protected DoubleArray newInstance(dist d, double c) {
        assert (d instanceof Distribution_c);
        assert (d.region instanceof Region3D0Base);
        return new DoubleArray3d_c(d, c, true);
    }

    public double get(int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        if (chkAOB && (d0 < 0 || d1 < 0 || d2 < 0 || d0 >= this.I || d1 >= this.J || d2 >= this.K)) {
            throw new ArrayIndexOutOfBoundsException("[" + d0 + "," + d1 + "," + d2 + "] is not in [" + (this.I - 1) + "," + (this.J - 1) + "," + (this.K - 1) + "]");
        }
        return this.arr_[d2 + this.K * (d1 + this.J * d0)];
    }

    public double get(int d0, int d1, int d2) {
        return this.arr_[d2 + this.K * (d1 + this.J * d0)];
    }

    public double get(int d0, boolean chkPl, boolean chkAOB) {
        throw new RankMismatchException(this.distribution.region, 1);
    }

    public double get(int d0, int d1, boolean chkPl, boolean chkAOB) {
        throw new RankMismatchException(this.distribution.region, 2);
    }

    public double get(int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        throw new RankMismatchException(this.distribution.region, 4);
    }

    public double get(point pos, boolean chkPl, boolean chkAOB) {
        if (pos.rank != 3) {
            throw new RankMismatchException(pos, 3);
        }
        int[] pos1 = pos.val();
        return this.get(pos1[0], pos1[1], pos1[2], chkPl, chkAOB);
    }

    public double set(double v, int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        if (chkAOB && (d0 < 0 || d1 < 0 || d2 < 0 || d0 >= this.I || d1 >= this.J || d2 >= this.K)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double d = v;
        this.arr_[d2 + this.K * (d1 + this.J * d0)] = d;
        return d;
    }

    public double set(double v, int d0, int d1, int d2) {
        return this.set(v, d0, d1, d2, true, true);
    }

    public double set(double v, int d0, boolean chkPl, boolean chkAOB) {
        throw new RankMismatchException(this.distribution.region, 1);
    }

    public double set(double v, int d0, int d1, boolean chkPl, boolean chkAOB) {
        throw new RankMismatchException(this.distribution.region, 2);
    }

    public double set(double v, int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        throw new RankMismatchException(this.distribution.region, 4);
    }

    public double set(double a, point pos) {
        if (pos.rank != 3) {
            throw new RankMismatchException(pos, 3);
        }
        int[] v = pos.val();
        return this.set(a, v[0], v[1], v[2], false, false);
    }

    public double set(double a, point pos, boolean chkPl, boolean chkAOB) {
        if (pos.rank != 3) {
            throw new RankMismatchException(pos, 3);
        }
        int[] v = pos.val();
        return this.set(a, v[0], v[1], v[2], chkPl, chkAOB);
    }

    public int ord(int i, int j, int k) {
        return k + this.K * (j + this.J * i);
    }

    public int[] coord(int p) {
        int[] r = new int[3];
        r[2] = p % this.K;
        r[1] = (p /= this.K) % this.J;
        r[0] = p /= this.J;
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(doubleArray d) {
        assert (this.region.contains(d.region));
        Place here = Runtime.runtime.currentPlace();
        try {
            for (int i = 0; i < this.I; ++i) {
                for (int j = 0; j < this.J; ++j) {
                    for (int k = 0; k < this.K; ++k) {
                        place pl = this.distribution.get(i, j, k);
                        Runtime.runtime.setCurrentPlace(pl);
                        this.set(d.get(i, j, k), i, j, k);
                    }
                }
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleReferenceArray lift(Operator.Binary op, doubleArray arg) {
        assert (arg.distribution.equals(this.distribution));
        DoubleArray result = this.newInstance(this.distribution);
        Place here = Runtime.runtime.currentPlace();
        try {
            for (int i = 0; i < this.I; ++i) {
                for (int j = 0; j < this.J; ++j) {
                    for (int k = 0; k < this.K; ++k) {
                        place pl = this.distribution.get(i, j, k);
                        Runtime.runtime.setCurrentPlace(pl);
                        result.set(op.apply(this.get(i, j, k), arg.get(i, j, k)), i, j, k);
                    }
                }
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleReferenceArray lift(Operator.Unary op) {
        DoubleArray result = this.newInstance(this.distribution);
        Place here = Runtime.runtime.currentPlace();
        try {
            for (int i = 0; i < this.I; ++i) {
                for (int j = 0; j < this.J; ++j) {
                    for (int k = 0; k < this.K; ++k) {
                        place pl = this.distribution.get(i, j, k);
                        Runtime.runtime.setCurrentPlace(pl);
                        result.set(op.apply(this.get(i, j, k)), i, j, k);
                    }
                }
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double reduce(Operator.Binary op, double unit, region r) {
        double result = unit;
        Place here = Runtime.runtime.currentPlace();
        try {
            for (int i = 0; i < this.I; ++i) {
                for (int j = 0; j < this.J; ++j) {
                    for (int k = 0; k < this.K; ++k) {
                        place pl = this.distribution.get(i, j, k);
                        Runtime.runtime.setCurrentPlace(pl);
                        result = op.apply(this.get(i, j, k), result);
                    }
                }
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleReferenceArray scan(Operator.Binary op, double unit) {
        double temp = unit;
        DoubleArray result = this.newInstance(this.distribution);
        Place here = Runtime.runtime.currentPlace();
        try {
            for (int i = 0; i < this.I; ++i) {
                for (int j = 0; j < this.J; ++j) {
                    for (int k = 0; k < this.K; ++k) {
                        place pl = this.distribution.get(i, j, k);
                        Runtime.runtime.setCurrentPlace(pl);
                        temp = op.apply(this.get(i, j, k), temp);
                        result.set(temp, i, j, k);
                    }
                }
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    public DoubleReferenceArray restriction(region r) {
        return super.restriction(r);
    }

    public DoubleReferenceArray overlay(doubleArray d) {
        return super.overlay(d);
    }

    public DoubleReferenceArray union(doubleArray d) {
        return super.union(d);
    }

    public doubleArray toValueArray() {
        if (!this.mutable_) {
            return this;
        }
        return new DoubleArray3d_c(this.distribution, this.arr_, false);
    }
}

