/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.Distribution_c;
import hj.array.FloatArray;
import hj.array.Operator;
import hj.base.UnsafeContainer;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.floatArray;
import hj.runtime.common.Configuration;

public class FloatArray_c
extends FloatArray
implements UnsafeContainer,
Cloneable {
    public final float[] arr_;
    public final int[] descriptor_;

    protected FloatArray_c(dist d, float c, boolean mutable) {
        this(d, new floatArray.Constant(c), mutable);
    }

    public FloatArray_c(dist d, Operator.Pointwise c, boolean mutable, boolean ignored) {
        this(d, c, mutable);
    }

    protected FloatArray_c(dist d, Operator.Pointwise c, boolean mutable) {
        this(d, mutable, null);
        if (c != null) {
            this.scan((FloatArray)this, c);
        }
    }

    private FloatArray_c(dist d, boolean mutable, float[] ignored) {
        super(d, mutable);
        assert (d instanceof Distribution_c);
        int count = d.region.size();
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = new float[count];
    }

    private FloatArray_c(dist d, float[] a, boolean mutable) {
        this(d, mutable, a);
    }

    public static FloatArray_c FloatArray_c(float[] a, boolean mutable) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new FloatArray_c(d, a, mutable);
    }

    public boolean valueEquals(Indexable other) {
        FloatArray_c o = (FloatArray_c)other;
        if (o.arr_.length != this.arr_.length) {
            return false;
        }
        for (int i = this.arr_.length - 1; i >= 0; --i) {
            if (this.arr_[i] == o.arr_[i]) continue;
            return false;
        }
        return true;
    }

    public float[] getBackingArray() {
        return this.arr_;
    }

    public int[] getDescriptor() {
        return this.descriptor_;
    }

    public float setOrdinal(float v, int rawIndex) {
        this.arr_[rawIndex] = v;
        return this.arr_[rawIndex];
    }

    public float getOrdinal(int rawIndex) {
        return this.arr_[rawIndex];
    }

    protected FloatArray newInstance(dist d) {
        return new FloatArray_c(d, (Operator.Pointwise)null, true);
    }

    protected FloatArray newInstance(dist d, float c) {
        return new FloatArray_c(d, c, true);
    }

    protected void assign(FloatArray rhs) {
        assert (rhs.getClass() == this.getClass());
        FloatArray_c rhs_t = (FloatArray_c)rhs;
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK && rhs.distribution.equals(this.distribution)) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                this.arr_[i] = rhs_t.arr_[i];
            }
        } else {
            super.assign(rhs);
        }
    }

    public void reduction(Operator.Reduction op) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                op.apply(this.arr_[i]);
            }
        } else {
            super.reduction(op);
        }
    }
}

