/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.BandedRegion;
import hj.array.ContiguousRange;
import hj.array.EmptyRegion;
import hj.array.MultiDimRegion;
import hj.array.StridedRange;
import hj.array.TriangularRegion;
import hj.lang.region;

public class RegionFactory
extends region.factory {
    public region emptyRegion(int k) {
        return new EmptyRegion(k);
    }

    public region region(int low, int high) {
        region result = this.region(low, high, 1);
        assert (result.rank == 1);
        return result;
    }

    public region region(int low, int high, int stride) {
        if (low > high) {
            return this.emptyRegion(1);
        }
        return stride == 1 ? new ContiguousRange(low, high) : new StridedRange(low, high, stride);
    }

    public region region(region[] regions) {
        boolean zeroBased = true;
        for (int i = 0; i < regions.length; ++i) {
            zeroBased &= regions[i].zeroBased;
        }
        return new MultiDimRegion(regions, zeroBased);
    }

    public region region(region a, region b) {
        return new MultiDimRegion(new region[]{a, b}, a.zeroBased && b.zeroBased);
    }

    public region upperTriangular(int rank, int size) {
        if (rank != 2) {
            throw new Error("Triangular region of dimension != 2 not supported.");
        }
        ContiguousRange cr = new ContiguousRange(0, size - 1);
        region[] r = new region[]{cr, cr};
        TriangularRegion ret = new TriangularRegion(r, false);
        return ret;
    }

    public region lowerTriangular(int rank, int size) {
        if (rank != 2) {
            throw new Error("Triangular region of dimension != 2 not supported.");
        }
        ContiguousRange cr = new ContiguousRange(0, size - 1);
        region[] r = new region[]{cr, cr};
        TriangularRegion ret = new TriangularRegion(r, true);
        return ret;
    }

    public region banded(int rank, int size, int width) {
        if (rank != 2) {
            throw new Error("Banded region of dimension != 2 not supported.");
        }
        ContiguousRange cr = new ContiguousRange(0, size - 1);
        region[] r = new region[]{cr, cr};
        BandedRegion ret = new BandedRegion(r, width, true);
        return ret;
    }
}

