/*
 * Decompiled with CFR 0.152.
 */
package hj.lang;

import hj.base.TypeArgument;
import hj.lang.Object;
import hj.lang.Runtime;
import hj.lang.ValueType;
import hj.lang.dist;
import hj.lang.point;
import java.util.Iterator;

public abstract class region
extends Object
implements TypeArgument,
ValueType {
    public static final int UNKNOWN = 0;
    public static final int RANGE = 1;
    public static final int ARBITRARY = 2;
    public static final int BANDED = 3;
    public static final int MULTIDIM = 4;
    public static final int TRIANGULAR = 5;
    public final int rank;
    public final boolean rect;
    public final boolean zeroBased;
    public static final String propertyNames$ = " rank rect zeroBased ";
    public static final factory factory = Runtime.factory.getRegionFactory();

    protected region(int rank, boolean rect, boolean zeroB) {
        assert (rank >= 1);
        this.rank = rank;
        this.rect = rect;
        this.zeroBased = zeroB;
    }

    public abstract int size();

    public abstract region rank(int var1);

    public abstract boolean isConvex();

    public abstract int low() throws UnsupportedOperationException;

    public abstract int high() throws UnsupportedOperationException;

    public abstract region union(region var1);

    public abstract region intersection(region var1);

    public abstract region difference(region var1);

    public abstract region convexHull();

    public point startPoint() {
        Iterator it = this.iterator();
        return it.hasNext() ? (point)it.next() : null;
    }

    public boolean contains(region r) {
        boolean ret = true;
        Iterator it = r.iterator();
        while (ret && it.hasNext()) {
            point p = (point)it.next();
            if (this.contains(p)) continue;
            ret = false;
        }
        return ret;
    }

    public abstract boolean contains(point var1);

    public abstract boolean contains(int[] var1);

    public abstract boolean disjoint(region var1);

    public boolean equal(region r) {
        return this.contains(r) && r.contains(this);
    }

    public abstract int ordinal(point var1) throws ArrayIndexOutOfBoundsException;

    public abstract point coord(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract Iterator iterator();

    public abstract String toString();

    public boolean equals(java.lang.Object o) {
        boolean ret;
        if (!(o instanceof region)) {
            return false;
        }
        boolean bl = ret = o == this;
        if (!ret) {
            region rhs = (region)o;
            if (rhs.rank == this.rank && rhs.size() == this.size()) {
                ret = true;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    point p = (point)it.next();
                    if (rhs.contains(p)) continue;
                    ret = false;
                    break;
                }
            }
        }
        return ret;
    }

    public final int hashCode() {
        return this.rank;
    }

    public region[] partition(int n, int dim) {
        System.err.println("this should not be called");
        assert (false);
        return null;
    }

    public dist toDistribution() {
        return dist.factory.local(this);
    }

    public int rank() {
        return this.rank;
    }

    public boolean rect() {
        return this.rect;
    }

    public boolean zeroBased() {
        return this.zeroBased;
    }

    public static abstract class factory
    implements ValueType {
        public abstract region emptyRegion(int var1);

        public region region(int high) {
            return this.region(1, high, 1);
        }

        public region region(int low, int high) {
            region result = this.region(low, high, 1);
            assert (result.rank == 1);
            return this.region(low, high, 1);
        }

        public abstract region region(int var1, int var2, int var3);

        public region upperTriangular(int size) {
            region result = this.upperTriangular(2, size);
            assert (result.rank == 2);
            return result;
        }

        public region lowerTriangular(int size) {
            region result = this.lowerTriangular(2, size);
            assert (result.rank == 2);
            return result;
        }

        public region banded(int size, int width) {
            region result = this.banded(2, size, width);
            assert (result.rank == 2);
            return result;
        }

        public region region(region a, region b) {
            return this.region(new region[]{a, b});
        }

        public region region(region a) {
            region ret = a;
            return ret;
        }

        public region region(region a, region b, region c) {
            return this.region(new region[]{a, b, c});
        }

        public region region(region a, region b, region c, region d) {
            return this.region(new region[]{a, b, c, d});
        }

        public region region(region a, region b, region c, region d, region e) {
            return this.region(new region[]{a, b, c, d, e});
        }

        public abstract region region(region[] var1);

        public abstract region upperTriangular(int var1, int var2);

        public abstract region lowerTriangular(int var1, int var2);

        public abstract region banded(int var1, int var2, int var3);
    }
}

