/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.VMInterface;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class HjThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(0);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private final String namePrefix;

    public HjThreadFactory() {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
    }

    public Thread newThread(Runnable workerRunnable) {
        int x = this.threadNumber.getAndIncrement();
        String threadName = this.namePrefix + x;
        Runnable r = VMInterface.mapPoolThreadToCPU(workerRunnable, poolNumber.get(), x, threadName);
        PoolRunner t = new PoolRunner(this.group, r, threadName);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

