/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.phaser;

import hj.lang.Runtime;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.PhaserImpl;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.phaser.PhaserManager;
import hj.runtime.wsh.phaser.PhaserRegMode;
import java.util.LinkedList;
import java.util.List;

public class PhaserManagerImpl
implements PhaserManager {
    protected Activity activity;
    private PhaserRegMode singlePhaserRegMode;
    private List phaserRegModeList;

    public PhaserManagerImpl(Activity activity2) {
        this.activity = activity2;
    }

    public PhaserManagerImpl(Activity activity2, List phaserRegModes) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " adding phaserRegModes " + phaserRegModes + " to " + activity2);
        }
        this.phaserRegModeList = phaserRegModes;
    }

    public PhaserManagerImpl(Activity activity2, PhaserRegMode phaserRegMode) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " adding phaserRegMode " + phaserRegMode + " to " + activity2);
        }
        this.singlePhaserRegMode = phaserRegMode;
    }

    private void switchFromSingleToListStrategy() {
        this.phaserRegModeList = new LinkedList();
        this.phaserRegModeList.add(this.singlePhaserRegMode);
        this.singlePhaserRegMode = null;
    }

    public List clonePhasers() {
        LinkedList<PhaserRegMode> L = new LinkedList<PhaserRegMode>();
        Activity current = (Activity)Runtime.getCurrentActivity();
        for (Object o : this.phaserRegModeList) {
            PhaserRegMode pr = current.checkPhaserUse((PhaserRegMode)o);
            PhaserImpl ph = (PhaserImpl)pr.getPhaser();
            PhaserRegMode ppr = new PhaserRegMode(ph, pr.getMode());
            L.add(ppr);
        }
        return L;
    }

    public void addPhaser(PhaserRegMode pr) {
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this.activity + " adds " + pr + ".");
        }
        if (this.singlePhaserRegMode != null) {
            this.switchFromSingleToListStrategy();
        }
        this.phaserRegModeList.add(pr);
    }

    public void dropPhaser(PhaserImpl ph) {
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this.activity + " drops " + ph + ".");
        }
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (singlePh.equals(ph)) {
                this.singlePhaserRegMode = null;
            } else if (Report.should_report("Phaser", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + " dropPhaser attempt failed because phaser to drop is not known by the activity " + ph + ".");
            }
        } else {
            PhaserRegMode pr = null;
            for (PhaserRegMode tpr : this.phaserRegModeList) {
                PhaserImpl ph2 = (PhaserImpl)tpr.getPhaser();
                if (!ph2.equals(ph)) continue;
                pr = tpr;
                break;
            }
            if (pr != null) {
                this.phaserRegModeList.remove(pr);
            }
        }
    }

    public void dropAllPhasers() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            singlePh.drop(this.activity);
            this.singlePhaserRegMode = null;
        } else {
            PhaserRegMode[] arr = this.phaserRegModeList.toArray(new PhaserRegMode[0]);
            for (int i = 0; i < arr.length; ++i) {
                PhaserImpl ph = (PhaserImpl)arr[i].getPhaser();
                ph.drop(this.activity);
            }
            arr = null;
            this.phaserRegModeList = null;
        }
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this.activity + " drops all phasers.");
        }
    }

    public void doSignal() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".signal() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserImpl.Mode.SIG || (mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SINGLE) && !singlePh.quiescent()) {
                singlePh.signal();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".signal() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode mode = pr.getMode();
                if (mode != PhaserImpl.Mode.SIG && (mode != PhaserImpl.Mode.SIG_WAIT && mode != PhaserImpl.Mode.SINGLE || ph.quiescent())) continue;
                ph.signal();
            }
        }
    }

    public void doWait() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doWait() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserImpl.Mode.WAIT || (mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SINGLE) && singlePh.quiescent()) {
                singlePh.doWait();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doWait() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode mode = pr.getMode();
                if (mode != PhaserImpl.Mode.WAIT && (mode != PhaserImpl.Mode.SIG_WAIT && mode != PhaserImpl.Mode.SINGLE || !ph.quiescent())) continue;
                ph.doWait();
            }
        }
    }

    public void doNext() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserImpl.Mode.SIG || (mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SINGLE) && !singlePh.quiescent()) {
                singlePh.signal();
            }
            if (mode != PhaserImpl.Mode.SIG) {
                singlePh.doWait();
            }
        } else {
            PhaserImpl.Mode mode;
            PhaserImpl ph;
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                mode = pr.getMode();
                if (mode != PhaserImpl.Mode.SIG && (mode != PhaserImpl.Mode.SIG_WAIT && mode != PhaserImpl.Mode.SINGLE || ph.quiescent())) continue;
                ph.signal();
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                mode = pr.getMode();
                if (mode == PhaserImpl.Mode.SIG) continue;
                ph.doWait();
            }
        }
    }

    public int doNext1(String loc) {
        int ret = 0;
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext1() on " + singlePh);
            }
            if (!singlePh.quiescent()) {
                singlePh.signal();
            }
            if (singlePh.doWaitSingle1(loc)) {
                ++ret;
            }
        } else {
            PhaserImpl ph;
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext1() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                if (ph.quiescent()) continue;
                ph.signal();
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                if (!ph.doWaitSingle1(loc)) continue;
                ++ret;
            }
        }
        return ret;
    }

    public void doNext2() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext2() on " + singlePh);
            }
            singlePh.doWaitSingle2();
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext2() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                ph.doWaitSingle2();
            }
        }
    }

    public void registerPhasers() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            PhaserImpl.Mode mode = this.singlePhaserRegMode.getMode();
            singlePh.register(this.activity, mode);
        } else {
            for (PhaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode mode = pr.getMode();
                ph.register(this.activity, mode);
            }
        }
    }

    public PhaserImpl checkPhaserUse(PhaserImpl ph) {
        assert (false);
        return null;
    }

    public int getNbRegisteredPhasers() {
        if (this.singlePhaserRegMode != null) {
            return 1;
        }
        if (this.phaserRegModeList != null) {
            return this.phaserRegModeList.size();
        }
        return 0;
    }
}

