/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.LexStream;
import lpg.runtime.MismatchedInputCharsException;
import lpg.runtime.UnknownStreamType;

public abstract class AbstractToken
implements IToken {
    private int kind = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int tokenIndex = 0;
    private int adjunctIndex;
    private IPrsStream prsStream;

    public AbstractToken() {
    }

    public AbstractToken(IPrsStream prsStream, int startOffset, int endOffset, int kind) {
        this.prsStream = prsStream;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.kind = kind;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public void setTokenIndex(int tokenIndex) {
        this.tokenIndex = tokenIndex;
    }

    public void setAdjunctIndex(int adjunctIndex) {
        this.adjunctIndex = adjunctIndex;
    }

    public int getAdjunctIndex() {
        return this.adjunctIndex;
    }

    public IPrsStream getPrsStream() {
        return this.prsStream;
    }

    public int getLine() {
        return this.prsStream == null ? 0 : this.prsStream.getLexStream().getLineNumberOfCharAt(this.startOffset);
    }

    public int getColumn() {
        return this.prsStream == null ? 0 : this.prsStream.getLexStream().getColumnOfCharAt(this.startOffset);
    }

    public int getEndLine() {
        return this.prsStream == null ? 0 : this.prsStream.getLexStream().getLineNumberOfCharAt(this.endOffset);
    }

    public int getEndColumn() {
        return this.prsStream == null ? 0 : this.prsStream.getLexStream().getColumnOfCharAt(this.endOffset);
    }

    public String getValue(char[] inputChars) {
        if (this.prsStream != null) {
            return this.toString();
        }
        if (this.prsStream.getLexStream() instanceof LexStream) {
            LexStream lex_stream = (LexStream)this.prsStream.getLexStream();
            if (inputChars != lex_stream.getInputChars()) {
                throw new MismatchedInputCharsException();
            }
            return this.toString();
        }
        throw new UnknownStreamType("Unknown stream type " + this.prsStream.getLexStream().getClass().toString());
    }

    public String toString() {
        return this.prsStream == null ? "<toString>" : this.prsStream.toString(this, this);
    }
}

