/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.HjToJimple.HabLocalGenerator;
import soot.HjToJimple.jimple.HjArrayRef;
import soot.HjToJimple.jimple.HjOperator;
import soot.Singletons;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Stmt;

public class HjArrayTranslator
extends BodyTransformer {
    public HjArrayTranslator(Singletons.Global g) {
    }

    public static HjArrayTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjArrayTranslator();
    }

    protected void internalTransform(Body body, String phaseName, Map opts) {
        SootMethod method = body.getMethod();
        this.hjArrayTransform(body, phaseName, opts);
    }

    protected void hjArrayTransform(Body body, String phaseName, Map opts) {
        HabLocalGenerator lg = new HabLocalGenerator(body);
        Iterator<Unit> stmtIt = body.getUnits().snapshotIterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (stmt.containsInvokeExpr()) {
                this.handleInvoke(body, stmt, lg);
                continue;
            }
            if (!(stmt instanceof AssignStmt)) continue;
            this.handleAssign(body, (AssignStmt)stmt, lg);
        }
    }

    protected void handleInvoke(Body body, Stmt stmt, HabLocalGenerator lg) {
        InvokeExpr invokeExpr = stmt.getInvokeExpr();
        if (invokeExpr instanceof HjOperator) {
            if (stmt instanceof AssignStmt) {
                this.invokeWithReturn((HjOperator)invokeExpr, body, stmt, lg);
            } else if (stmt instanceof InvokeStmt) {
                this.simpleInvoke((HjOperator)invokeExpr, body, stmt, lg);
            } else {
                throw new RuntimeException("Unsupport stmt for Hj Operations " + stmt);
            }
        }
    }

    protected void invokeWithReturn(HjOperator invokeExpr, Body body, Stmt stmt, HabLocalGenerator lg) {
        Value retValue = ((AssignStmt)stmt).getLeftOp();
        Stmt newStmt = invokeExpr.generateStmt(retValue);
        if (newStmt != null) {
            body.getUnits().swapWith(stmt, newStmt);
        } else {
            List<Stmt> newStmtList = invokeExpr.generateStmts(retValue, lg);
            if (newStmtList != null) {
                Iterator<Stmt> stmtIter = newStmtList.iterator();
                while (stmtIter.hasNext()) {
                    body.getUnits().insertBefore(stmtIter.next(), (Unit)stmt);
                }
                body.getUnits().remove(stmt);
            }
        }
    }

    protected void simpleInvoke(HjOperator invokeExpr, Body body, Stmt stmt, HabLocalGenerator lg) {
        Stmt newStmt = invokeExpr.generateStmt();
        if (newStmt != null) {
            body.getUnits().swapWith(stmt, newStmt);
        } else {
            List<Stmt> newStmtList = invokeExpr.generateStmts(lg);
            if (newStmtList != null) {
                Iterator<Stmt> stmtIter = newStmtList.iterator();
                while (stmtIter.hasNext()) {
                    body.getUnits().insertBefore(stmtIter.next(), (Unit)stmt);
                }
                body.getUnits().remove(stmt);
            }
        }
    }

    protected void handleAssign(Body body, AssignStmt stmt, HabLocalGenerator lg) {
        Value leftVal = stmt.getLeftOpBox().getValue();
        Value rightVal = stmt.getRightOpBox().getValue();
        if (leftVal instanceof HjArrayRef) {
            List<Stmt> stmts = ((HjArrayRef)leftVal).genRightOpStmts(rightVal, lg);
            Iterator<Stmt> stmtIter = stmts.iterator();
            while (stmtIter.hasNext()) {
                body.getUnits().insertBefore(stmtIter.next(), (Unit)stmt);
            }
            body.getUnits().remove(stmt);
        } else if (rightVal instanceof HjArrayRef) {
            List<Stmt> stmts = ((HjArrayRef)rightVal).genLeftOpStmts(leftVal, lg);
            Iterator<Stmt> stmtIter = stmts.iterator();
            while (stmtIter.hasNext()) {
                body.getUnits().insertBefore(stmtIter.next(), (Unit)stmt);
            }
            body.getUnits().remove(stmt);
        }
    }
}

