/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.ByteType;
import soot.DoubleType;
import soot.G;
import soot.HjToJimple.HabLocalGenerator;
import soot.HjToJimple.jimple.ForEachRegionExpr;
import soot.HjToJimple.jimple.ForLoopRegionExpr;
import soot.HjToJimple.jimple.HjRCFGBuilder;
import soot.HjToJimple.jimple.HjRSTTranslator;
import soot.HjToJimple.jimple.HjRegionStmt;
import soot.HjToJimple.jimple.LoopRegionExpr;
import soot.HjToJimple.jimple.RegionEntry;
import soot.HjToJimple.jimple.RegionExit;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.jimple.factory.HjClassFactory;
import soot.HjToJimple.jimple.factory.HjStmtFactory;
import soot.HjToJimple.util.CFGNode;
import soot.HjToJimple.util.ForEachNode;
import soot.HjToJimple.util.ForEachNode_c;
import soot.HjToJimple.util.HjValueBox;
import soot.HjToJimple.util.LoopDomain;
import soot.HjToJimple.util.Phaser;
import soot.HjToJimple.util.RSTNode;
import soot.Immediate;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DoubleConstant;
import soot.jimple.EqExpr;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LtExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.jimple.SubExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.MHGPostDominatorsFinder;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.Pair;
import soot.toolkits.scalar.SimpleLocalDefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjFELCTranslator
extends BodyTransformer {
    protected LocalDefs gLocalDefs;
    protected MHGPostDominatorsFinder gMHGDominator;
    private int count = 0;
    public static final int NP = 32;

    public HjFELCTranslator(Singletons.Global g) {
    }

    public static HjFELCTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjFELCTranslator();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map opts) {
        HabLocalGenerator lg = new HabLocalGenerator(body);
        HjRSTTranslator.v().rebuildRST(body, phaseName, null);
        HjRCFGBuilder.v().buildRCFG(body.getMethod().getRSTNode(), null);
        this.gLocalDefs = new SimpleLocalDefs(new CompleteUnitGraph(body));
        this.gMHGDominator = new MHGPostDominatorsFinder(new BriefUnitGraph(body));
        this.hjFELCTransform(body.getMethod().getRSTNode(), body, lg, phaseName, opts);
    }

    protected void hjFELCTransform(RSTNode rootNode, Body body, HabLocalGenerator lg, String phaseName, Map opts) {
        if (rootNode.isForEachNode()) {
            HjRCFGBuilder.v().buildRCFG(rootNode, body, this.gMHGDominator, null, false);
            if (this.checkForEachLoop(rootNode, ((ForEachRegionExpr)rootNode.getRegionStmt().getRegionExpr()).getLocals(), body, rootNode.getRegionStmt())) {
                List<Value> initValues = rootNode.getLoopDomains().collectInitValues();
                ArrayList<Local> sizeLocals = this.stripMining(rootNode, body, lg);
                ForEachNode loopNode = (ForEachNode)rootNode.getSubNodes().get(0);
                this.loopChunking(rootNode, loopNode, body, lg, sizeLocals, null, initValues);
                return;
            }
        }
        Iterator<RSTNode> nodeIter = rootNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            this.hjFELCTransform(nodeIter.next(), body, lg, phaseName, opts);
        }
    }

    private void buildRCFG(RSTNode rstNode, Body body) {
        if (rstNode.getRCFG() == null && (!rstNode.isForLoopNode() || rstNode.isLabeledForLoopNode())) {
            HjRCFGBuilder.v().buildRCFG(rstNode, body, this.gMHGDominator, null, false);
        }
        Iterator<RSTNode> nodeIter = rstNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            this.buildRCFG(nodeIter.next(), body);
        }
    }

    protected Local createExcpFlags(ArrayList<Local> sizeLocals, Body body, HabLocalGenerator lg, Stmt finalLabel) {
        Local excpFlagsLocal;
        int numDim = sizeLocals.size();
        if (numDim > 1) {
            excpFlagsLocal = lg.generateLocal(ArrayType.v(BooleanType.v(), numDim));
            ArrayList<Local> valueList = new ArrayList<Local>();
            valueList.addAll(sizeLocals);
            NewMultiArrayExpr newMultiArrayExpr = Jimple.v().newNewMultiArrayExpr(ArrayType.v(BooleanType.v(), numDim), valueList);
            body.getUnits().insertBefore(Jimple.v().newAssignStmt(excpFlagsLocal, newMultiArrayExpr), (Unit)finalLabel);
        } else {
            Local sizeLocal = sizeLocals.get(0);
            excpFlagsLocal = lg.generateLocal(ArrayType.v(BooleanType.v(), 1));
            NewArrayExpr newArrayExpr = Jimple.v().newNewArrayExpr(BooleanType.v(), sizeLocal);
            body.getUnits().insertBefore(Jimple.v().newAssignStmt(excpFlagsLocal, newArrayExpr), (Unit)finalLabel);
        }
        return excpFlagsLocal;
    }

    protected boolean interChangable(Set<Local> defsSet, RSTNode subNode) {
        if (!this.hasNextOperation(subNode, true)) {
            return false;
        }
        LoopDomain domain = null;
        RegionEntry regionExpr = (RegionEntry)subNode.getRegionStmt().getRegionExpr();
        if (regionExpr instanceof LoopRegionExpr) {
            if (!((LoopRegionExpr)regionExpr).isLabeled()) {
                return false;
            }
            domain = ((LoopRegionExpr)regionExpr).getDomains();
        } else if (regionExpr instanceof ForLoopRegionExpr) {
            domain = ((ForLoopRegionExpr)regionExpr).getDomains();
        } else {
            throw new RuntimeException("The inter-changed target should be loop");
        }
        ArrayList<Local> localList = new ArrayList<Local>();
        domain.collectInitLocals(localList);
        domain.collectTermLocals(localList);
        domain.collectStrideLocals(localList);
        return true;
    }

    protected RSTNode loopInterChange(RSTNode rootNode, RSTNode loopNode, Body body, HabLocalGenerator lg, ArrayList<Local> sizeLocals, Local excpFlagsLocal, List<Value> initValues) {
        RSTNode subNode;
        List<RSTNode> subNodes = loopNode.getSubNodes();
        if (subNodes.size() == 1 && (subNode = subNodes.get(0)).isForLoopNode() && this.interChangable(rootNode.collectDefs(body), subNode)) {
            Stmt prevLabel;
            Stmt forLoopContLabel;
            rootNode.getSubNodes().remove(loopNode);
            rootNode.getSubNodes().add(subNode);
            loopNode.setParent(subNode);
            subNode.setParent(rootNode);
            loopNode.getSubNodes().clear();
            loopNode.addSubNodes(subNode.getSubNodes());
            subNode.getSubNodes().clear();
            subNode.addSubNode(loopNode);
            RegionStmt forEachRegionEntry = loopNode.getRegionStmt();
            RegionStmt forEachRegionExit = (RegionStmt)forEachRegionEntry.getConnect();
            RegionStmt forLoopRegionEntry = subNode.getRegionStmt();
            body.getUnits().remove(forEachRegionEntry);
            body.getUnits().insertAfter(forEachRegionEntry, (Unit)forLoopRegionEntry);
            body.getUnits().remove(forEachRegionExit);
            if (forLoopRegionEntry.getRegionExpr() instanceof LoopRegionExpr) {
                LoopRegionExpr loopRegionExpr = (LoopRegionExpr)forLoopRegionEntry.getRegionExpr();
                forLoopContLabel = loopRegionExpr.getBackEdges().get(0);
                prevLabel = (Stmt)body.getUnits().getPredOf(forLoopContLabel);
                body.getUnits().insertAfter(forEachRegionExit, (Unit)prevLabel);
                loopRegionExpr.setLoopEntry(forEachRegionEntry);
            } else if (forLoopRegionEntry.getRegionExpr() instanceof ForLoopRegionExpr) {
                ForLoopRegionExpr forLoopRegionExpr = (ForLoopRegionExpr)forLoopRegionEntry.getRegionExpr();
                forLoopContLabel = forLoopRegionExpr.getBackEdges().get(0);
                prevLabel = (Stmt)body.getUnits().getPredOf(forLoopContLabel);
                body.getUnits().insertAfter(forEachRegionExit, (Unit)prevLabel);
                forLoopRegionExpr.setLoopEntry(forEachRegionEntry);
            } else {
                throw new RuntimeException("Unknow region label");
            }
            if (subNode.isForLoopNode()) {
                Iterator<Local> localIter = subNode.collectDefs(body).iterator();
                RegionStmt regionStmt = subNode.getRegionStmt();
                while (localIter.hasNext()) {
                    Local local = localIter.next();
                    if (local.getType() == IntType.v()) {
                        body.getUnits().insertBefore(Jimple.v().newAssignStmt(local, IntConstant.v(0)), (Unit)regionStmt);
                        continue;
                    }
                    if (local.getType() == DoubleType.v()) {
                        body.getUnits().insertBefore(Jimple.v().newAssignStmt(local, DoubleConstant.v(0.0)), (Unit)regionStmt);
                        continue;
                    }
                    if (local.getType() != ByteType.v()) continue;
                    body.getUnits().insertBefore(Jimple.v().newAssignStmt(local, IntConstant.v(0)), (Unit)regionStmt);
                }
            }
            this.loopChunking(subNode, loopNode, body, lg, sizeLocals, excpFlagsLocal, initValues);
            return subNode;
        }
        return loopNode;
    }

    private void checkAll(RSTNode rootNode) {
        Iterator<RSTNode> nodeIter = rootNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            this.checkAll(nodeIter.next());
        }
        System.out.print("] ");
    }

    protected void loopChunking(RSTNode rootNode, RSTNode loopNode, Body body, HabLocalGenerator lg, ArrayList<Local> sizeLocals, Local excpFlagsLocal, List<Value> initValues) {
        this.loopDist(loopNode, body);
        if (rootNode.getSubNodes().size() > 1) {
            if (excpFlagsLocal == null) {
                excpFlagsLocal = this.createExcpFlags(sizeLocals, body, lg, rootNode.getRegionStmt());
            }
            ArrayList<RSTNode> tempList = new ArrayList<RSTNode>();
            tempList.addAll(rootNode.getSubNodes());
            for (RSTNode subNode : tempList) {
                RSTNode icNode;
                if (!(subNode instanceof ForEachNode) || (icNode = this.loopInterChange(rootNode, subNode, body, lg, sizeLocals, excpFlagsLocal, initValues)) != subNode) continue;
                this.loopMutation(subNode, body, lg, excpFlagsLocal, initValues);
            }
        } else {
            loopNode = this.loopInterChange(rootNode, loopNode, body, lg, sizeLocals, excpFlagsLocal, initValues);
            this.loopMutation(loopNode, body, lg, excpFlagsLocal, initValues);
        }
    }

    protected ArrayList<Local> stripMining(RSTNode rootNode, Body body, HabLocalGenerator lg) {
        Immediate endVal;
        Immediate npVal;
        LoopDomain loopDomain;
        ArrayList<Local> sizeLocalList = new ArrayList<Local>();
        Stmt insertLabel = rootNode.getRegionStmt();
        ForEachRegionExpr forEachRegion = (ForEachRegionExpr)insertLabel.getRegionExpr();
        ForEachRegionExpr newForEachRegion = Jimple.v().newForEachRegionExpr();
        RegionExit forEachExit = Jimple.v().newRegionExitExpr(newForEachRegion);
        newForEachRegion.setExit(forEachExit);
        forEachExit.setEntry(newForEachRegion);
        newForEachRegion.setPlaces(forEachRegion.getPlaces());
        newForEachRegion.setPhasers(forEachRegion.getPhasers());
        newForEachRegion.setLocals(forEachRegion.getLocals());
        RegionStmt newRegionEntryStmt = Jimple.v().newRegionStmt(newForEachRegion);
        RegionStmt newRegionExitStmt = Jimple.v().newRegionStmt(forEachExit);
        HjRegionStmt.setConnect(newRegionEntryStmt, newRegionExitStmt);
        LoopDomain calDomain = loopDomain = forEachRegion.getDomains();
        Iterator<LoopDomain> domainIter = null;
        while (calDomain.getInitialValue() == null) {
            if (calDomain.getSubDomains() == null) {
                throw new Error(" " + rootNode);
            }
            domainIter = calDomain.getSubDomains().iterator();
            calDomain = domainIter.next();
        }
        Value initVal = calDomain.getInitialValue();
        Value termVal = calDomain.getTerminalValue();
        FieldRef npFieldRef = this.getFieldRef(body.getMethod().getDeclaringClass(), "NPFIELD", IntType.v());
        if (npFieldRef == null) {
            npVal = IntConstant.v(32);
            endVal = IntConstant.v(31);
        } else {
            npVal = lg.generateLocal("np", IntType.v());
            body.getUnits().insertBefore(Jimple.v().newAssignStmt((Local)npVal, npFieldRef), (Unit)insertLabel);
            endVal = lg.generateLocal(IntType.v());
            SubExpr binExpr = Jimple.v().newSubExpr(npVal, IntConstant.v(1));
            body.getUnits().insertBefore(Jimple.v().newAssignStmt((Local)endVal, binExpr), (Unit)insertLabel);
        }
        Local oldPLocal = forEachRegion.getLocals().get(0);
        Local pLocal = lg.generateLocal(oldPLocal.getName() + "_", IntType.v());
        Local sizeLocal = lg.generateLocal("size", IntType.v());
        Local stepLocal = lg.generateLocal("step", IntType.v());
        BinopExpr binExpr = Jimple.v().newSubExpr(termVal, initVal);
        AssignStmt assignStmt = Jimple.v().newAssignStmt(sizeLocal, binExpr);
        body.getUnits().insertBefore(assignStmt, (Unit)insertLabel);
        binExpr = Jimple.v().newAddExpr(sizeLocal, IntConstant.v(1));
        assignStmt = Jimple.v().newAssignStmt(sizeLocal, binExpr);
        body.getUnits().insertBefore(assignStmt, (Unit)insertLabel);
        binExpr = Jimple.v().newDivExpr(sizeLocal, npVal);
        assignStmt = Jimple.v().newAssignStmt(stepLocal, binExpr);
        body.getUnits().insertBefore(assignStmt, (Unit)insertLabel);
        binExpr = Jimple.v().newAddExpr(stepLocal, IntConstant.v(1));
        assignStmt = Jimple.v().newAssignStmt(stepLocal, binExpr);
        body.getUnits().insertBefore(assignStmt, (Unit)insertLabel);
        sizeLocalList.add(sizeLocal);
        while (domainIter != null && domainIter.hasNext()) {
            Local lSizeLocal = lg.generateLocal(IntType.v());
            LoopDomain lDomain = domainIter.next();
            Value lInitVal = lDomain.getInitialValue();
            Value lTermVal = lDomain.getTerminalValue();
            binExpr = Jimple.v().newSubExpr(lTermVal, lInitVal);
            assignStmt = Jimple.v().newAssignStmt(lSizeLocal, binExpr);
            body.getUnits().insertBefore(assignStmt, (Unit)insertLabel);
            binExpr = Jimple.v().newAddExpr(lSizeLocal, IntConstant.v(1));
            assignStmt = Jimple.v().newAssignStmt(lSizeLocal, binExpr);
            body.getUnits().insertBefore(assignStmt, (Unit)insertLabel);
            sizeLocalList.add(lSizeLocal);
        }
        Local startLocal = lg.generateLocal("start", IntType.v());
        binExpr = Jimple.v().newMulExpr(stepLocal, pLocal);
        assignStmt = Jimple.v().newAssignStmt(startLocal, binExpr);
        body.getUnits().insertAfter(assignStmt, (Unit)insertLabel);
        insertLabel = assignStmt;
        binExpr = Jimple.v().newAddExpr(startLocal, initVal);
        assignStmt = Jimple.v().newAssignStmt(startLocal, binExpr);
        body.getUnits().insertAfter(assignStmt, (Unit)insertLabel);
        insertLabel = assignStmt;
        Local endLocal = lg.generateLocal("end", IntType.v());
        binExpr = Jimple.v().newAddExpr(startLocal, stepLocal);
        assignStmt = Jimple.v().newAssignStmt(endLocal, binExpr);
        body.getUnits().insertAfter(assignStmt, (Unit)insertLabel);
        insertLabel = assignStmt;
        binExpr = Jimple.v().newSubExpr(endLocal, IntConstant.v(1));
        assignStmt = Jimple.v().newAssignStmt(endLocal, binExpr);
        body.getUnits().insertAfter(assignStmt, (Unit)insertLabel);
        insertLabel = assignStmt;
        LtExpr condExpr = Jimple.v().newLtExpr(endLocal, termVal);
        NopStmt branchLabel = Jimple.v().newNopStmt();
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, branchLabel);
        body.getUnits().insertAfter(ifStmt, (Unit)insertLabel);
        insertLabel = ifStmt;
        assignStmt = Jimple.v().newAssignStmt(endLocal, termVal);
        body.getUnits().insertAfter(assignStmt, (Unit)insertLabel);
        insertLabel = assignStmt;
        body.getUnits().insertAfter(branchLabel, (Unit)insertLabel);
        insertLabel = branchLabel;
        newForEachRegion.setDomains(loopDomain.clone());
        calDomain.setInitialValue(IntConstant.v(0));
        calDomain.setTerminalValue(endVal);
        calDomain.setStrideValue(IntConstant.v(1));
        ArrayList<Local> localList = new ArrayList<Local>();
        localList.add(pLocal);
        localList.addAll(forEachRegion.getLocals());
        localList.remove(oldPLocal);
        forEachRegion.setLocals(localList);
        for (Phaser phaser : forEachRegion.getPhasers()) {
            if (!phaser.isArrayAccess() || phaser.getArrayIndex() != oldPLocal) continue;
            phaser.setArrayIndex(pLocal);
        }
        calDomain = newForEachRegion.getDomains();
        while (calDomain.getInitialValue() == null) {
            calDomain = calDomain.getSubDomains().get(0);
        }
        calDomain.setInitialValue(startLocal);
        calDomain.setTerminalValue(endLocal);
        RegionStmt regionEntryStmt = rootNode.getRegionStmt();
        RegionStmt regionExitStmt = (RegionStmt)regionEntryStmt.getConnect();
        body.getUnits().insertAfter(newRegionEntryStmt, (Unit)insertLabel);
        body.getUnits().insertBefore(newRegionExitStmt, (Unit)regionExitStmt);
        ForEachNode_c innerLoopNode = new ForEachNode_c(newRegionEntryStmt);
        innerLoopNode.addSubNodes(rootNode.getSubNodes());
        rootNode.getSubNodes().clear();
        rootNode.addSubNode(innerLoopNode);
        innerLoopNode.setParent(rootNode);
        return sizeLocalList;
    }

    protected void loopDistribution(RSTNode loopNode, Body body) {
        ArrayList<RSTNode> nodeList = new ArrayList<RSTNode>();
        ArrayList<RSTNode> tempList = new ArrayList<RSTNode>();
        tempList.addAll(loopNode.getSubNodes());
        for (RSTNode subNode : tempList) {
            Stmt endStmt;
            if (subNode.isNextNode()) {
                endStmt = subNode.getRegionStmt();
                loopNode = this.splitForEachNode(loopNode, body, loopNode.getRegionStmt(), endStmt, nodeList);
                nodeList.clear();
                endStmt = endStmt.getConnect() != null ? (Stmt)body.getUnits().getSuccOf(endStmt.getConnect()) : (Stmt)body.getUnits().getSuccOf(endStmt);
                nodeList.add(subNode);
                loopNode = this.splitForEachNode(loopNode, body, loopNode.getRegionStmt(), endStmt, nodeList);
                nodeList.clear();
                continue;
            }
            if (subNode.isForLoopNode() && this.hasNextOperation(subNode, true)) {
                endStmt = subNode.getRegionStmt();
                loopNode = this.splitForEachNode(loopNode, body, loopNode.getRegionStmt(), endStmt, nodeList);
                nodeList.clear();
                nodeList.add(subNode);
                endStmt = (RegionStmt)body.getUnits().getSuccOf(endStmt.getConnect());
                loopNode = this.splitForEachNode(loopNode, body, loopNode.getRegionStmt(), endStmt, nodeList);
                nodeList.clear();
                continue;
            }
            nodeList.add(subNode);
        }
    }

    protected void loopDist(RSTNode rstNode, Body body) {
        if (this.hasNextOperation(rstNode, true)) {
            this.loopDistribution(rstNode, rstNode.getParent().getRCFG(), rstNode.getRegionStmt(), body, null);
        } else {
            this.loopDistribution(rstNode, body);
        }
    }

    protected CFGNode loopDistribution(RSTNode loopNode, CFGNode loopCFGNode, Stmt startStmt, Body body, CFGNode endNode) {
        ArrayList<RSTNode> nodeList = new ArrayList<RSTNode>();
        while (loopCFGNode != endNode && endNode == null || loopCFGNode != null && endNode != null && loopCFGNode.getNodeStmt() != endNode.getNodeStmt()) {
            Stmt endStmt;
            if (loopCFGNode.isNextNode()) {
                endStmt = loopCFGNode.getNodeStmt();
                loopNode = this.splitForEachNode(loopNode, body, startStmt, endStmt, nodeList);
                nodeList.clear();
                startStmt = loopNode.getRegionStmt();
                endStmt = ((RegionStmt)endStmt).getConnect() != null ? (Stmt)body.getUnits().getSuccOf(((RegionStmt)endStmt).getConnect()) : (Stmt)body.getUnits().getSuccOf(endStmt);
                nodeList.add(((RegionStmt)loopCFGNode.getNodeStmt()).getRSTNode());
                loopNode = this.splitForEachNode(loopNode, body, loopNode.getRegionStmt(), endStmt, nodeList);
                nodeList.clear();
                loopCFGNode = loopCFGNode.getOut();
                continue;
            }
            if (loopCFGNode.isForLoopNode() && this.hasNextOperation(((RegionStmt)loopCFGNode.getNodeStmt()).getRSTNode(), true)) {
                endStmt = (RegionStmt)loopCFGNode.getNodeStmt();
                loopNode = this.splitForEachNode(loopNode, body, loopNode.getRegionStmt(), endStmt, nodeList);
                nodeList.clear();
                RSTNode tempNode = ((RegionStmt)loopCFGNode.getNodeStmt()).getRSTNode();
                nodeList.add(tempNode);
                endStmt = (RegionStmt)body.getUnits().getSuccOf(endStmt.getConnect());
                loopNode = this.splitForEachNode(loopNode, body, loopNode.getRegionStmt(), endStmt, nodeList);
                nodeList.clear();
                loopCFGNode = loopCFGNode.getOut();
                return null;
            }
            if (loopCFGNode.isRegionNode()) {
                nodeList.add(((RegionStmt)loopCFGNode.getNodeStmt()).getRSTNode());
                loopCFGNode = loopCFGNode.getOut();
                continue;
            }
            if (loopCFGNode.isBranchNode()) {
                IfStmt ifStmt = (IfStmt)loopCFGNode.getNodeStmt();
                CFGNode mergeNode = loopCFGNode.getMergeNode();
                if (mergeNode == null) {
                    loopCFGNode = loopCFGNode.getOut();
                    continue;
                }
                loopNode = this.splitNode(loopNode, body, mergeNode.getNodeStmt(), (Stmt)body.getUnits().getPredOf(ifStmt), nodeList, true);
                List<RSTNode> branchRSTList = loopCFGNode.collectRSTNodes();
                loopNode.getSubNodes().removeAll(branchRSTList);
                if (loopCFGNode.getBranchPairs() != null) {
                    for (Pair<CFGNode, Pair<Stmt, Stmt>> branchExecPair : loopCFGNode.getBranchPairs()) {
                        CFGNode nextCFGNode = branchExecPair.getO1();
                        Pair<Stmt, Stmt> branchPair = branchExecPair.getO2();
                        nodeList.clear();
                        loopCFGNode.collectRSTNodes(nextCFGNode, mergeNode, nodeList);
                        RSTNode subLoopNode = this.splitNode(loopNode, body, branchPair.getO1(), branchPair.getO2(), nodeList, false);
                        if (nextCFGNode.getNodeStmt() == mergeNode.getNodeStmt()) continue;
                        this.loopDistribution(subLoopNode, nextCFGNode, nextCFGNode.getNodeStmt(), body, mergeNode);
                    }
                }
                loopCFGNode = mergeNode;
                continue;
            }
            if (loopCFGNode.getNumOfIns() <= 1) continue;
            loopCFGNode = loopCFGNode.getOut();
        }
        return loopCFGNode;
    }

    protected RSTNode splitNode(RSTNode loopNode, Body body, Stmt startStmt, Stmt endStmt, List<RSTNode> nodeList, boolean needConnect) {
        if (needConnect) {
            RegionStmt regionEntryStmt = loopNode.getRegionStmt();
            RegionStmt regionExitStmt = (RegionStmt)regionEntryStmt.getConnect();
            ForEachRegionExpr forEachRegion = (ForEachRegionExpr)regionEntryStmt.getRegionExpr();
            RegionExit forEachExit = forEachRegion.getExit();
            RegionExit newForEachExit = Jimple.v().newRegionExitExpr(forEachRegion);
            forEachRegion.setExit(newForEachExit);
            newForEachExit.setEntry(forEachRegion);
            RegionStmt newRegionExitStmt = Jimple.v().newRegionStmt(newForEachExit);
            HjRegionStmt.setConnect(regionEntryStmt, newRegionExitStmt);
            ForEachRegionExpr newForEachRegion = (ForEachRegionExpr)forEachRegion.clone();
            newForEachRegion.setExit(forEachExit);
            forEachExit.setEntry(newForEachRegion);
            RegionStmt newRegionEntryStmt = Jimple.v().newRegionStmt(newForEachRegion);
            HjRegionStmt.setConnect(newRegionEntryStmt, regionExitStmt);
            Stmt predStmt = (Stmt)body.getUnits().getPredOf(startStmt);
            if (predStmt == regionExitStmt) {
                startStmt = predStmt;
            }
            body.getUnits().insertAfter(newRegionExitStmt, (Unit)endStmt);
            body.getUnits().insertBefore(newRegionEntryStmt, (Unit)startStmt);
            ForEachNode_c distNode = new ForEachNode_c(newRegionEntryStmt, loopNode.getParent());
            distNode.addSubNodes(loopNode.getSubNodes());
            distNode.getSubNodes().removeAll(nodeList);
            loopNode.getSubNodes().clear();
            loopNode.addSubNodes(nodeList);
            loopNode = distNode;
        } else {
            RegionStmt regionEntryStmt = loopNode.getRegionStmt();
            ForEachRegionExpr forEachRegion = (ForEachRegionExpr)regionEntryStmt.getRegionExpr();
            ForEachRegionExpr newForEachRegion = (ForEachRegionExpr)forEachRegion.clone();
            RegionExit newForEachExit = Jimple.v().newRegionExitExpr(newForEachRegion);
            newForEachRegion.setExit(newForEachExit);
            newForEachExit.setEntry(newForEachRegion);
            RegionStmt newRegionEntryStmt = Jimple.v().newRegionStmt(newForEachRegion);
            RegionStmt newRegionExitStmt = Jimple.v().newRegionStmt(newForEachExit);
            HjRegionStmt.setConnect(newRegionEntryStmt, newRegionExitStmt);
            body.getUnits().insertBefore(newRegionEntryStmt, (Unit)startStmt);
            body.getUnits().insertAfter(newRegionExitStmt, (Unit)endStmt);
            ForEachNode_c distNode = new ForEachNode_c(newRegionEntryStmt, loopNode.getParent());
            distNode.addSubNodes(nodeList);
            loopNode = distNode;
        }
        return loopNode;
    }

    protected RSTNode splitForEachNode(RSTNode loopNode, Body body, Stmt startStmt, Stmt endStmt, ArrayList<RSTNode> nodeList) {
        if (endStmt != loopNode.getRegionStmt().getConnect()) {
            RegionStmt regionEntryStmt = loopNode.getRegionStmt();
            RegionStmt regionExitStmt = (RegionStmt)regionEntryStmt.getConnect();
            ForEachRegionExpr forEachRegion = (ForEachRegionExpr)regionEntryStmt.getRegionExpr();
            RegionExit forEachExit = forEachRegion.getExit();
            RegionExit newForEachExit = Jimple.v().newRegionExitExpr(forEachRegion);
            forEachRegion.setExit(newForEachExit);
            newForEachExit.setEntry(forEachRegion);
            RegionStmt newRegionExitStmt = Jimple.v().newRegionStmt(newForEachExit);
            HjRegionStmt.setConnect(regionEntryStmt, newRegionExitStmt);
            ForEachRegionExpr newForEachRegion = (ForEachRegionExpr)forEachRegion.clone();
            newForEachRegion.setExit(forEachExit);
            forEachExit.setEntry(newForEachRegion);
            RegionStmt newRegionEntryStmt = Jimple.v().newRegionStmt(newForEachRegion);
            HjRegionStmt.setConnect(newRegionEntryStmt, regionExitStmt);
            body.getUnits().insertBefore(newRegionExitStmt, (Unit)endStmt);
            body.getUnits().insertBefore(newRegionEntryStmt, (Unit)endStmt);
            ForEachNode_c distNode = new ForEachNode_c(newRegionEntryStmt, loopNode.getParent());
            distNode.addSubNodes(loopNode.getSubNodes());
            distNode.getSubNodes().removeAll(nodeList);
            loopNode.getSubNodes().clear();
            loopNode.addSubNodes(nodeList);
            loopNode = distNode;
        }
        return loopNode;
    }

    protected RSTNode splitForEachNode_(RSTNode loopNode, Body body, Stmt startStmt, Stmt endStmt, ArrayList<RSTNode> nodeList) {
        if (endStmt != loopNode.getRegionStmt().getConnect()) {
            RegionStmt regionEntryStmt = loopNode.getRegionStmt();
            RegionStmt regionExitStmt = (RegionStmt)regionEntryStmt.getConnect();
            ForEachRegionExpr forEachRegion = (ForEachRegionExpr)regionEntryStmt.getRegionExpr();
            RegionExit forEachExit = forEachRegion.getExit();
            RegionExit newForEachExit = Jimple.v().newRegionExitExpr(forEachRegion);
            forEachRegion.setExit(newForEachExit);
            newForEachExit.setEntry(forEachRegion);
            RegionStmt newRegionExitStmt = Jimple.v().newRegionStmt(newForEachExit);
            HjRegionStmt.setConnect(regionEntryStmt, newRegionExitStmt);
            ForEachRegionExpr newForEachRegion = (ForEachRegionExpr)forEachRegion.clone();
            newForEachRegion.setExit(forEachExit);
            forEachExit.setEntry(newForEachRegion);
            RegionStmt newRegionEntryStmt = Jimple.v().newRegionStmt(newForEachRegion);
            HjRegionStmt.setConnect(newRegionEntryStmt, regionExitStmt);
            body.getUnits().insertBefore(newRegionExitStmt, (Unit)endStmt);
            body.getUnits().insertBefore(newRegionEntryStmt, (Unit)endStmt);
            ForEachNode_c distNode = new ForEachNode_c(newRegionEntryStmt, loopNode.getParent());
            distNode.addSubNodes(loopNode.getSubNodes());
            distNode.getSubNodes().removeAll(nodeList);
            loopNode.getSubNodes().clear();
            loopNode.addSubNodes(nodeList);
            loopNode = distNode;
        }
        return loopNode;
    }

    protected void loopMutation(RSTNode loopNode, Body body, HabLocalGenerator lg, Local excpFlagsLocal, List<Value> initValues) {
        Stmt assignStmt;
        RSTNode subNode;
        RegionStmt regionEntryStmt = loopNode.getRegionStmt();
        RegionStmt regionExitStmt = (RegionStmt)regionEntryStmt.getConnect();
        Stmt loopEntryStmt = (Stmt)body.getUnits().getSuccOf(regionEntryStmt);
        Stmt loopExitStmt = (Stmt)body.getUnits().getPredOf(regionExitStmt);
        Stmt entryStmt = (Stmt)body.getUnits().getSuccOf(regionEntryStmt);
        if (entryStmt == regionExitStmt) {
            RSTNode parentNode = loopNode.getParent();
            parentNode.getSubNodes().remove(loopNode);
            body.getUnits().remove(regionEntryStmt);
            body.getUnits().remove(regionExitStmt);
            return;
        }
        if (loopNode.getSubNodes().size() == 1 && (subNode = loopNode.getSubNodes().get(0)).isNextNode()) {
            RSTNode parentNode = loopNode.getParent();
            parentNode.getSubNodes().remove(loopNode);
            parentNode.addSubNode(subNode);
            subNode.setParent(parentNode);
            body.getUnits().remove(regionEntryStmt);
            body.getUnits().remove(regionExitStmt);
            return;
        }
        ForEachRegionExpr forEachRegion = (ForEachRegionExpr)loopNode.getRegionStmt().getRegionExpr();
        ForLoopRegionExpr forLoopRegion = Jimple.v().newForLoopRegionExpr();
        RegionExit regionExit = forEachRegion.getExit();
        forLoopRegion.setExit(regionExit);
        regionExit.setEntry(forLoopRegion);
        forLoopRegion.setPhasers(forEachRegion.getPhasers());
        forLoopRegion.setPlaces(forEachRegion.getPlaces());
        forLoopRegion.setDomains(forEachRegion.getDomains());
        forLoopRegion.setLocals(forEachRegion.getLocals());
        regionEntryStmt.getRegionExprBox().setValue(forLoopRegion);
        RegionStmt contLabel = Jimple.v().newRegionStmt(Jimple.v().newNopRegionExpr("mutate for loop cont "));
        body.getUnits().insertBefore(contLabel, (Unit)regionExitStmt);
        RegionStmt exitLabel = Jimple.v().newRegionStmt(Jimple.v().newNopRegionExpr("mutate for loop exit"));
        body.getUnits().insertBefore(exitLabel, (Unit)regionExitStmt);
        forLoopRegion.addLoopExit(exitLabel);
        if (excpFlagsLocal != null) {
            Local flagIndexLocal = lg.generateLocal(IntType.v());
            Local currentIndexLocal = forLoopRegion.getLocals().get(0);
            Value initValue = initValues.get(0);
            SubExpr binExpr = Jimple.v().newSubExpr(currentIndexLocal, initValue);
            AssignStmt initStmt = Jimple.v().newAssignStmt(flagIndexLocal, binExpr);
            body.getUnits().insertAfter(initStmt, (Unit)regionEntryStmt);
            Local excpFlagLocal = lg.generateLocal(BooleanType.v());
            ArrayRef excpFlagsRef = Jimple.v().newArrayRef(excpFlagsLocal, flagIndexLocal);
            assignStmt = Jimple.v().newAssignStmt(excpFlagLocal, excpFlagsRef);
            body.getUnits().insertAfter(assignStmt, (Unit)initStmt);
            EqExpr condExpr = Jimple.v().newEqExpr(excpFlagLocal, IntConstant.v(1));
            IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, contLabel);
            body.getUnits().insertAfter(ifStmt, (Unit)assignStmt);
        }
        CaughtExceptionRef exceptRef = Jimple.v().newCaughtExceptionRef();
        SootClass hjThrowableClass = Scene.v().getSootClass("java.lang.Throwable");
        Local exceptLocal = lg.generateLocal(hjThrowableClass.getType());
        IdentityStmt catchLabel = Jimple.v().newIdentityStmt(exceptLocal, exceptRef);
        body.getUnits().insertBefore(catchLabel, (Unit)contLabel);
        if (excpFlagsLocal != null) {
            Local flagIndexLocal = lg.generateLocal(IntType.v());
            Local currentIndexLocal = forLoopRegion.getLocals().get(0);
            Value initValue = initValues.get(0);
            SubExpr binExpr = Jimple.v().newSubExpr(currentIndexLocal, initValue);
            body.getUnits().insertBefore(Jimple.v().newAssignStmt(flagIndexLocal, binExpr), (Unit)contLabel);
            ArrayRef excpFlagsRef = Jimple.v().newArrayRef(excpFlagsLocal, flagIndexLocal);
            body.getUnits().insertBefore(Jimple.v().newAssignStmt(excpFlagsRef, IntConstant.v(1)), (Unit)contLabel);
        }
        Local langActivityLocal = lg.generateLocal(HjClassFactory.hjLangActivity().getType());
        Local activityLocal = lg.generateLocal(HjClassFactory.hjWshActivity().getType());
        Stmt assignStmtLang = HjStmtFactory.getCurrentActivity_HjLangActivity(langActivityLocal);
        body.getUnits().insertBefore(assignStmtLang, (Unit)contLabel);
        assignStmt = HjStmtFactory.assignLangActivityToActivityWsh(activityLocal, langActivityLocal);
        body.getUnits().insertBefore(assignStmt, (Unit)contLabel);
        ArrayList<Local> pushExpParamList = new ArrayList<Local>();
        pushExpParamList.add(exceptLocal);
        ArrayList<RefType> inputParamTypes = new ArrayList<RefType>();
        inputParamTypes.add(hjThrowableClass.getType());
        SootMethod pushExceptionMethod = HjClassFactory.hjWshActivity().getMethod("pushException", inputParamTypes, VoidType.v());
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(activityLocal, pushExceptionMethod.makeRef(), pushExpParamList);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(virtualInvoke);
        body.getUnits().insertBefore(invokeStmt, (Unit)contLabel);
        body.getUnits().insertBefore(Jimple.v().newGotoStmt(contLabel), (Unit)catchLabel);
        forLoopRegion.addBackEdge(contLabel);
        Stmt entryLabel = (Stmt)body.getUnits().getSuccOf(regionEntryStmt);
        body.getTraps().add(Jimple.v().newTrap(hjThrowableClass, entryLabel, catchLabel, catchLabel));
    }

    protected boolean checkForEachLoop(RSTNode loopNode, List<Local> iterLocals, Body body, Stmt regionStmt) {
        if (this.hasConditionalNext(loopNode, loopNode) && !this.invariantCondition(loopNode, loopNode, body)) {
            return false;
        }
        for (RSTNode subNode : loopNode.getSubNodes()) {
            if (subNode.isMethodNode() && this.hasNextOperation(subNode, true)) {
                return false;
            }
            if (subNode.isForLoopNode()) {
                if (!this.hasNextOperation(subNode, false)) continue;
                if (subNode.isLabeledForLoopNode()) {
                    if (this.checkForEachLoop(subNode, iterLocals, body, regionStmt)) continue;
                    return false;
                }
                return false;
            }
            if (!subNode.isAtEachNode()) continue;
            return false;
        }
        return true;
    }

    protected boolean hasNextOperation(RSTNode loopNode, boolean checkSubNode) {
        for (RSTNode subNode : loopNode.getSubNodes()) {
            if (subNode.isNextNode()) {
                return true;
            }
            if (!checkSubNode || !this.hasNextOperation(subNode, checkSubNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDomainLocals(RSTNode loopNode, List<Local> locals, Body body, Stmt upperStmt) {
        if (loopNode.isForLoopNode()) {
            Stmt lowerStmt = loopNode.getRegionStmt().getConnect();
            HashSet<Local> localsSet = new HashSet<Local>();
            localsSet.addAll(locals);
            RegionEntry regionExpr = (RegionEntry)loopNode.getRegionStmt().getRegionExpr();
            Iterator valueIter = regionExpr instanceof ForLoopRegionExpr ? ((ForLoopRegionExpr)regionExpr).getDomains().getUseBoxes().iterator() : ((LoopRegionExpr)regionExpr).getDomains().getUseBoxes().iterator();
            while (valueIter.hasNext()) {
                Value value = ((HjValueBox)valueIter.next()).getValue();
                if (!(value instanceof Local) || !this.checkDef((Local)value, localsSet, lowerStmt, upperStmt)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasConditionalNext(RSTNode rootNode, RSTNode checkNode) {
        if (checkNode.isNextNode()) {
            return !this.gMHGDominator.isDominatedBy(rootNode.getRegionStmt(), checkNode.getRegionStmt());
        }
        Iterator<RSTNode> nodeIter = checkNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            if (!this.hasConditionalNext(rootNode, nodeIter.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean invariantCondition(RSTNode rootNode, RSTNode loopNode, Body body) {
        if (this.hasLocalCondition(loopNode.getRCFG(), rootNode, body)) {
            return false;
        }
        Iterator<RSTNode> nodeIter = loopNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            if (this.invariantCondition(rootNode, nodeIter.next(), body)) continue;
            return false;
        }
        return true;
    }

    protected boolean hasLocalCondition(CFGNode rcfgNode, RSTNode loopNode, Body body) {
        if (rcfgNode != null && rcfgNode.getNumOfOuts() > 0) {
            if (rcfgNode.getNumOfOuts() > 1) {
                Stmt branchStmt = rcfgNode.getNodeStmt();
                Iterator<CFGNode> nodeList = rcfgNode.getOuts().iterator();
                while (nodeList.hasNext()) {
                    if (!this.hasLocalCondition(nodeList.next(), loopNode, body)) continue;
                    return true;
                }
            } else if (this.hasLocalCondition(rcfgNode.getOut(), loopNode, body)) {
                return true;
            }
        }
        return false;
    }

    protected boolean checkDef(Local local, Set<Local> locals, Stmt lowerStmt, Stmt upperStmt) {
        return false;
    }

    protected FieldRef getFieldRef(SootClass currentClass, String fieldName, Type fieldType) {
        SootField field = null;
        try {
            field = currentClass.getField(fieldName, fieldType);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (field != null && field.isStatic()) {
            return Jimple.v().newStaticFieldRef(field.makeRef());
        }
        for (SootClass sc : Scene.v().getApplicationClasses()) {
            if (sc == currentClass) continue;
            try {
                field = sc.getField(fieldName, fieldType);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (field == null || !field.isStatic() || !field.isPublic()) continue;
            return Jimple.v().newStaticFieldRef(field.makeRef());
        }
        return null;
    }

    protected boolean containsLocal(Set<Local> defsSet, List<Local> localList) {
        Iterator<Local> localIter = localList.iterator();
        while (localIter.hasNext()) {
            if (!defsSet.contains(localIter.next())) continue;
            return true;
        }
        return false;
    }
}

