/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import soot.JastAddJ.PathPart;

public class FolderPart
extends PathPart {
    private HashMap map = new HashMap();
    private File folder;

    public FolderPart(File folder) {
        this.folder = folder;
    }

    public boolean hasPackage(String name) {
        return this.filesInPackage(name) != null;
    }

    public boolean hasCompilationUnit(String canonicalName) {
        int index = canonicalName.lastIndexOf(46);
        String packageName = index == -1 ? "" : canonicalName.substring(0, index);
        String typeName = canonicalName.substring(index + 1, canonicalName.length());
        Collection c = this.filesInPackage(packageName);
        boolean result = c != null && c.contains(typeName + this.fileSuffix());
        return result;
    }

    private Collection filesInPackage(String packageName) {
        if (!this.map.containsKey(packageName)) {
            File f = new File(this.folder, packageName.replace('.', File.separatorChar));
            Collection<String> c = Collections.EMPTY_LIST;
            if (f.exists() && f.isDirectory()) {
                String[] files = f.list();
                if (files.length > 0) {
                    c = new HashSet();
                    for (int i = 0; i < files.length; ++i) {
                        c.add(files[i]);
                    }
                }
            } else {
                c = null;
            }
            this.map.put(packageName, c);
        }
        return (Collection)this.map.get(packageName);
    }

    public boolean selectCompilationUnit(String canonicalName) throws IOException {
        String fileName;
        File classFile;
        if (this.hasCompilationUnit(canonicalName) && (classFile = new File(this.folder, (fileName = canonicalName.replace('.', File.separatorChar)) + this.fileSuffix())).isFile()) {
            this.is = new FileInputStream(classFile);
            this.age = classFile.lastModified();
            this.pathName = classFile.getAbsolutePath();
            this.relativeName = fileName + this.fileSuffix();
            this.fullName = canonicalName;
            return true;
        }
        return false;
    }
}

