/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import soot.Body;
import soot.BodyPack;
import soot.CompilationDeathException;
import soot.G;
import soot.HasPhaseOptions;
import soot.HjToJimple.jimple.HjArrayTranslator;
import soot.HjToJimple.jimple.HjFELCTranslator;
import soot.HjToJimple.jimple.HjHPIRToMPIRTranslator;
import soot.HjToJimple.jimple.HjMHPTranslator;
import soot.HjToJimple.jimple.HjNextTranslator;
import soot.HjToJimple.jimple.HjRSTTranslator;
import soot.HjToJimple.jimple.HjRuntimeTranslator;
import soot.HjToJimple.jimple.HjWSTranslator;
import soot.HjToJimple.jimple.TargetedHjRuntime;
import soot.JavaToJimpleBodyPack;
import soot.JimpleBodyPack;
import soot.Pack;
import soot.PhaseOptions;
import soot.Printer;
import soot.Scene;
import soot.ScenePack;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.Transform;
import soot.XMLAttributesPrinter;
import soot.baf.Baf;
import soot.baf.toolkits.base.LoadStoreOptimizer;
import soot.baf.toolkits.base.PeepholeOptimizer;
import soot.coffi.CFG;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.DavaBuildFile;
import soot.dava.DavaPrinter;
import soot.dava.DavaStaticBlockCleaner;
import soot.dava.toolkits.base.AST.interProcedural.InterProceduralAnalyses;
import soot.dava.toolkits.base.AST.transformations.RemoveEmptyBodyDefaultConstructor;
import soot.dava.toolkits.base.AST.transformations.VoidReturnRemover;
import soot.dava.toolkits.base.misc.PackageNamer;
import soot.dava.toolkits.base.misc.ThrowFinder;
import soot.grimp.Grimp;
import soot.grimp.toolkits.base.ConstructorFolder;
import soot.jbco.Main;
import soot.jimple.JasminClass;
import soot.jimple.JimpleBody;
import soot.jimple.paddle.PaddleHook;
import soot.jimple.spark.SparkTransformer;
import soot.jimple.spark.fieldrw.FieldTagAggregator;
import soot.jimple.spark.fieldrw.FieldTagger;
import soot.jimple.toolkits.annotation.AvailExprTagger;
import soot.jimple.toolkits.annotation.DominatorsTagger;
import soot.jimple.toolkits.annotation.LineNumberAdder;
import soot.jimple.toolkits.annotation.arraycheck.ArrayBoundsChecker;
import soot.jimple.toolkits.annotation.arraycheck.RectangularArrayFinder;
import soot.jimple.toolkits.annotation.callgraph.CallGraphGrapher;
import soot.jimple.toolkits.annotation.callgraph.CallGraphTagger;
import soot.jimple.toolkits.annotation.defs.ReachingDefsTagger;
import soot.jimple.toolkits.annotation.fields.UnreachableFieldsTagger;
import soot.jimple.toolkits.annotation.liveness.LiveVarsTagger;
import soot.jimple.toolkits.annotation.logic.LoopInvariantFinder;
import soot.jimple.toolkits.annotation.methods.UnreachableMethodsTagger;
import soot.jimple.toolkits.annotation.nullcheck.NullCheckEliminator;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerChecker;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerColorer;
import soot.jimple.toolkits.annotation.parity.ParityTagger;
import soot.jimple.toolkits.annotation.profiling.ProfilingGenerator;
import soot.jimple.toolkits.annotation.purity.PurityAnalysis;
import soot.jimple.toolkits.annotation.qualifiers.TightestQualifiersTagger;
import soot.jimple.toolkits.annotation.tags.ArrayNullTagAggregator;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.callgraph.CHATransformer;
import soot.jimple.toolkits.callgraph.CallGraphPack;
import soot.jimple.toolkits.callgraph.UnreachableMethodTransformer;
import soot.jimple.toolkits.invoke.StaticInliner;
import soot.jimple.toolkits.invoke.StaticMethodBinder;
import soot.jimple.toolkits.pointer.CastCheckEliminatorDumper;
import soot.jimple.toolkits.pointer.DependenceTagAggregator;
import soot.jimple.toolkits.pointer.ParameterAliasTagger;
import soot.jimple.toolkits.pointer.SideEffectTagger;
import soot.jimple.toolkits.scalar.CommonSubexpressionEliminator;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.jimple.toolkits.scalar.pre.BusyCodeMotion;
import soot.jimple.toolkits.scalar.pre.LazyCodeMotion;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.Options;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleTransformer;
import soot.shimple.toolkits.scalar.SConstantPropagatorAndFolder;
import soot.tagkit.InnerClassTagAggregator;
import soot.tagkit.LineNumberTagAggregator;
import soot.toolkits.exceptions.TrapTightener;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.LocalPacker;
import soot.toolkits.scalar.LocalSplitter;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.util.Chain;
import soot.util.EscapedWriter;
import soot.util.JasminOutputStream;
import soot.util.PhaseDumper;
import soot.util.StringTools;
import soot.workstealing.FinishAsyncTransformer;
import soot.xml.TagCollector;
import soot.xml.XMLPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackManager {
    public static boolean DEBUG = false;
    private boolean onlyStandardPacks = false;
    private final Map<String, Pack> packNameToPack = new HashMap<String, Pack>();
    private final List<Pack> packList = new LinkedList<Pack>();
    private ZipOutputStream jarFile = null;

    public PackManager(Singletons.Global g) {
        PhaseOptions.v().setPackManager(this);
        this.init();
    }

    public boolean onlyStandardPacks() {
        return this.onlyStandardPacks;
    }

    void notifyAddPack() {
        this.onlyStandardPacks = false;
    }

    private void init() {
        Pack p = new JimpleBodyPack();
        this.addPack(p);
        p.add(new Transform("jb.tt", TrapTightener.v()));
        p.add(new Transform("jb.ls", LocalSplitter.v()));
        p.add(new Transform("jb.a", Aggregator.v()));
        p.add(new Transform("jb.ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jb.tr", TypeAssigner.v()));
        p.add(new Transform("jb.ulp", LocalPacker.v()));
        p.add(new Transform("jb.lns", LocalNameStandardizer.v()));
        p.add(new Transform("jb.cp", CopyPropagator.v()));
        p.add(new Transform("jb.dae", DeadAssignmentEliminator.v()));
        p.add(new Transform("jb.cp-ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jb.lp", LocalPacker.v()));
        p.add(new Transform("jb.ne", NopEliminator.v()));
        p.add(new Transform("jb.uce", UnreachableCodeEliminator.v()));
        p = new JavaToJimpleBodyPack();
        this.addPack(p);
        p.add(new Transform("jj.ls", LocalSplitter.v()));
        p.add(new Transform("jj.a", Aggregator.v()));
        p.add(new Transform("jj.ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jj.ne", NopEliminator.v()));
        p.add(new Transform("jj.tr", TypeAssigner.v()));
        p.add(new Transform("jj.ulp", LocalPacker.v()));
        p.add(new Transform("jj.lns", LocalNameStandardizer.v()));
        p.add(new Transform("jj.cp", CopyPropagator.v()));
        p.add(new Transform("jj.dae", DeadAssignmentEliminator.v()));
        p.add(new Transform("jj.cp-ule", UnusedLocalEliminator.v()));
        p.add(new Transform("jj.lp", LocalPacker.v()));
        p.add(new Transform("jj.uce", UnreachableCodeEliminator.v()));
        p = new CallGraphPack("cg");
        this.addPack(p);
        p.add(new Transform("cg.cha", CHATransformer.v()));
        p.add(new Transform("cg.spark", SparkTransformer.v()));
        p.add(new Transform("cg.paddle", PaddleHook.v()));
        p = new ScenePack("wstp");
        this.addPack(p);
        p = new ScenePack("wsop");
        this.addPack(p);
        p = new ScenePack("wjtp");
        this.addPack(p);
        p.add(new Transform("wjtp.finishAsyncTransformer", FinishAsyncTransformer.v()));
        p = new ScenePack("wjop");
        this.addPack(p);
        p.add(new Transform("wjop.smb", StaticMethodBinder.v()));
        p.add(new Transform("wjop.si", StaticInliner.v()));
        p = new ScenePack("wjap");
        this.addPack(p);
        p.add(new Transform("wjap.ra", RectangularArrayFinder.v()));
        p.add(new Transform("wjap.umt", UnreachableMethodsTagger.v()));
        p.add(new Transform("wjap.uft", UnreachableFieldsTagger.v()));
        p.add(new Transform("wjap.tqt", TightestQualifiersTagger.v()));
        p.add(new Transform("wjap.cgg", CallGraphGrapher.v()));
        p.add(new Transform("wjap.purity", PurityAnalysis.v()));
        p = new BodyPack("shimple");
        this.addPack(p);
        p = new BodyPack("stp");
        this.addPack(p);
        p = new BodyPack("sop");
        this.addPack(p);
        p.add(new Transform("sop.cpf", SConstantPropagatorAndFolder.v()));
        p = new BodyPack("jtp");
        this.addPack(p);
        p = new BodyPack("jop");
        this.addPack(p);
        p.add(new Transform("jop.cse", CommonSubexpressionEliminator.v()));
        p.add(new Transform("jop.bcm", BusyCodeMotion.v()));
        p.add(new Transform("jop.lcm", LazyCodeMotion.v()));
        p.add(new Transform("jop.cp", CopyPropagator.v()));
        p.add(new Transform("jop.cpf", ConstantPropagatorAndFolder.v()));
        p.add(new Transform("jop.cbf", ConditionalBranchFolder.v()));
        p.add(new Transform("jop.dae", DeadAssignmentEliminator.v()));
        p.add(new Transform("jop.nce", new NullCheckEliminator()));
        p.add(new Transform("jop.uce1", UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf1", UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.uce2", UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf2", UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.ule", UnusedLocalEliminator.v()));
        p = new BodyPack("hj");
        this.addPack(p);
        p.add(new Transform("hj.rst", HjRSTTranslator.v()));
        p.add(new Transform("hj.mhp", HjMHPTranslator.v()));
        p.add(new Transform("hj.felc", HjFELCTranslator.v()));
        p.add(new Transform("hj.hpir2mpir", HjHPIRToMPIRTranslator.v()));
        p.add(new Transform("hj.phasercommand", HjNextTranslator.v()));
        p.add(new Transform("hj.internalobjects", HjArrayTranslator.v()));
        p = new BodyPack("wshrt");
        this.addPack(p);
        p.add(new Transform("wshrt.mpir2lpir", HjRuntimeTranslator.v()));
        p = new ScenePack("wstrt");
        this.addPack(p);
        p.add(new Transform("wstrt.wf", HjWSTranslator.v()));
        p = new BodyPack("jap");
        this.addPack(p);
        p.add(new Transform("jap.npc", NullPointerChecker.v()));
        p.add(new Transform("jap.npcolorer", NullPointerColorer.v()));
        p.add(new Transform("jap.abc", ArrayBoundsChecker.v()));
        p.add(new Transform("jap.profiling", ProfilingGenerator.v()));
        p.add(new Transform("jap.sea", SideEffectTagger.v()));
        p.add(new Transform("jap.fieldrw", FieldTagger.v()));
        p.add(new Transform("jap.cgtagger", CallGraphTagger.v()));
        p.add(new Transform("jap.parity", ParityTagger.v()));
        p.add(new Transform("jap.pat", ParameterAliasTagger.v()));
        p.add(new Transform("jap.rdtagger", ReachingDefsTagger.v()));
        p.add(new Transform("jap.lvtagger", LiveVarsTagger.v()));
        p.add(new Transform("jap.che", CastCheckEliminatorDumper.v()));
        p.add(new Transform("jap.umt", new UnreachableMethodTransformer()));
        p.add(new Transform("jap.lit", LoopInvariantFinder.v()));
        p.add(new Transform("jap.aet", AvailExprTagger.v()));
        p.add(new Transform("jap.dmt", DominatorsTagger.v()));
        p = new BodyPack("gb");
        this.addPack(p);
        p.add(new Transform("gb.a1", Aggregator.v()));
        p.add(new Transform("gb.cf", ConstructorFolder.v()));
        p.add(new Transform("gb.a2", Aggregator.v()));
        p.add(new Transform("gb.ule", UnusedLocalEliminator.v()));
        p = new BodyPack("gop");
        this.addPack(p);
        p = new BodyPack("bb");
        this.addPack(p);
        p.add(new Transform("bb.lso", LoadStoreOptimizer.v()));
        p.add(new Transform("bb.pho", PeepholeOptimizer.v()));
        p.add(new Transform("bb.ule", UnusedLocalEliminator.v()));
        p.add(new Transform("bb.lp", LocalPacker.v()));
        p = new BodyPack("bop");
        this.addPack(p);
        p = new BodyPack("tag");
        this.addPack(p);
        p.add(new Transform("tag.ln", LineNumberTagAggregator.v()));
        p.add(new Transform("tag.an", ArrayNullTagAggregator.v()));
        p.add(new Transform("tag.dep", DependenceTagAggregator.v()));
        p.add(new Transform("tag.fieldrw", FieldTagAggregator.v()));
        p = new BodyPack("db");
        this.addPack(p);
        p.add(new Transform("db.transformations", null));
        p.add(new Transform("db.renamer", null));
        p.add(new Transform("db.deobfuscate", null));
        p.add(new Transform("db.force-recompile", null));
        this.onlyStandardPacks = true;
    }

    public static PackManager v() {
        return G.v().soot_PackManager();
    }

    private void addPack(Pack p) {
        if (this.packNameToPack.containsKey(p.getPhaseName())) {
            throw new RuntimeException("Duplicate pack " + p.getPhaseName());
        }
        this.packNameToPack.put(p.getPhaseName(), p);
        this.packList.add(p);
    }

    public boolean hasPack(String phaseName) {
        return this.getPhase(phaseName) != null;
    }

    public Pack getPack(String phaseName) {
        Pack p = this.packNameToPack.get(phaseName);
        return p;
    }

    public boolean hasPhase(String phaseName) {
        return this.getPhase(phaseName) != null;
    }

    public HasPhaseOptions getPhase(String phaseName) {
        int index = phaseName.indexOf(".");
        if (index < 0) {
            return this.getPack(phaseName);
        }
        String packName = phaseName.substring(0, index);
        if (!this.hasPack(packName)) {
            return null;
        }
        return this.getPack(packName).get(phaseName);
    }

    public Transform getTransform(String phaseName) {
        return (Transform)this.getPhase(phaseName);
    }

    public Collection<Pack> allPacks() {
        return Collections.unmodifiableList(this.packList);
    }

    public void runPacks() {
        if (Options.v().src_prec() == 2 && Options.v().keep_line_number()) {
            LineNumberAdder lineNumAdder = LineNumberAdder.v();
            lineNumAdder.internalTransform("", null);
        }
        if (Options.v().whole_program() || Options.v().whole_shimple()) {
            // empty if block
        }
        this.retrieveAllBodies();
        if (Main.metrics) {
            this.coffiMetrics();
            System.exit(0);
        }
        this.preProcessDAVA();
        if (Options.v().interactive_mode()) {
            if (InteractionHandler.v().getInteractionListener() == null) {
                G.v().out.println("Cannot run in interactive mode. No listeners available. Continuing in regular mode.");
                Options.v().set_interactive_mode(false);
            } else {
                G.v().out.println("Running in interactive mode.");
            }
        }
        this.runHJPIRPacks();
        this.handleInnerClasses();
    }

    public void coffiMetrics() {
        int tV = 0;
        int tE = 0;
        int hM = 0;
        double aM = 0.0;
        HashMap<SootMethod, int[]> hashVem = CFG.methodsToVEM;
        Iterator<SootMethod> it = hashVem.keySet().iterator();
        while (it.hasNext()) {
            int[] vem = hashVem.get(it.next());
            tV += vem[0];
            tE += vem[1];
            aM += (double)vem[2];
            if (vem[2] <= hM) continue;
            hM = vem[2];
        }
        if (hashVem.size() > 0) {
            aM /= (double)hashVem.size();
        }
        G.v().out.println("Vertices, Edges, Avg Degree, Highest Deg:    " + tV + "  " + tE + "  " + aM + "  " + hM);
    }

    public void runBodyPacks() {
        this.runBodyPacks(this.reachableClasses());
    }

    private void addExtraClasses() {
        Iterator<SootClass> extraClassIter = Scene.v().extraClasses.iterator();
        while (extraClassIter.hasNext()) {
            Scene.v().getApplicationClasses().add(extraClassIter.next());
        }
        Scene.v().extraClasses.clear();
        for (SootClass cl : Scene.v().getApplicationClasses()) {
            cl.addAdditionalMethods();
        }
    }

    private void runHJPIRPacks() {
        SootMethod method;
        Iterator<SootMethod> methodIter;
        Transform transform;
        Iterator classIter = this.reachableClasses();
        while (classIter.hasNext()) {
            Iterator<SootMethod> methodIter2 = ((SootClass)classIter.next()).methodIterator();
            while (methodIter2.hasNext()) {
                SootMethod method2 = methodIter2.next();
                if (!method2.isConcrete()) continue;
                Body body = method2.retrieveActiveBody();
            }
        }
        this.addExtraClasses();
        Iterator tranIter = PackManager.v().getPack("hj").iterator();
        while (tranIter.hasNext()) {
            transform = (Transform)tranIter.next();
            classIter = this.reachableClasses();
            while (classIter.hasNext()) {
                methodIter = ((SootClass)classIter.next()).methodIterator();
                while (methodIter.hasNext()) {
                    method = methodIter.next();
                    if (!method.isConcrete()) continue;
                    transform.apply(method.retrieveActiveBody());
                }
            }
        }
        if (TargetedHjRuntime.isRuntimeWorkStealing()) {
            this.getPack("cg").apply();
            this.getPack("wstrt").apply();
            PaddleHook.v().finishPhases();
        } else {
            tranIter = PackManager.v().getPack("wshrt").iterator();
            while (tranIter.hasNext()) {
                transform = (Transform)tranIter.next();
                classIter = this.reachableClasses();
                while (classIter.hasNext()) {
                    methodIter = ((SootClass)classIter.next()).snapMethodIter();
                    while (methodIter.hasNext()) {
                        method = methodIter.next();
                        if (!method.isConcrete()) continue;
                        transform.apply(method.retrieveActiveBody());
                    }
                }
            }
        }
        this.addExtraClasses();
    }

    public void runHJBodyPacks() {
        Iterator classes = this.reachableClasses();
        while (classes.hasNext()) {
            this.runHJHMPIRPacks((SootClass)classes.next());
        }
        this.addExtraClasses();
        if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
            this.getPack("cg").apply();
            this.getPack("wjtp").apply();
            PaddleHook.v().finishPhases();
        }
        classes = this.reachableClasses();
        while (classes.hasNext()) {
            classes.next();
        }
    }

    private void runHJHMPIRPacks(SootClass sc) {
        Iterator<SootMethod> methodIt = sc.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod m = methodIt.next();
            if (!m.isConcrete()) continue;
            Body body = m.retrieveActiveBody();
        }
    }

    private void runHJLPIRPacks(SootClass sc) {
        this.runBodyPacks(sc);
    }

    public void writeOutput() {
        if (Options.v().output_jar()) {
            System.out.println("check 0");
            String outFileName = SourceLocator.v().getOutputDir();
            try {
                this.jarFile = new ZipOutputStream(new FileOutputStream(outFileName));
            }
            catch (FileNotFoundException e) {
                throw new CompilationDeathException("Cannot open output Jar file " + outFileName);
            }
        } else {
            this.jarFile = null;
        }
        if (Options.v().verbose()) {
            PhaseDumper.v().dumpBefore("output");
        }
        if (Options.v().output_format() == 13) {
            this.postProcessDAVA();
        } else {
            this.writeOutput(this.reachableClasses());
        }
        this.postProcessXML(this.reachableClasses());
        this.releaseBodies(this.reachableClasses());
        if (Options.v().verbose()) {
            PhaseDumper.v().dumpAfter("output");
        }
    }

    private void runWholeProgramPacks() {
        if (Options.v().whole_shimple()) {
            ShimpleTransformer.v().transform();
            this.getPack("cg").apply();
            this.getPack("wstp").apply();
            this.getPack("wsop").apply();
        } else {
            this.getPack("cg").apply();
            this.getPack("wjtp").apply();
            this.getPack("wjop").apply();
            this.getPack("wjap").apply();
        }
        PaddleHook.v().finishPhases();
    }

    private void preProcessDAVA() {
        if (Options.v().output_format() == 13) {
            Map options = PhaseOptions.v().getPhaseOptions("db");
            boolean isSourceJavac = PhaseOptions.getBoolean(options, "source_is_javac");
            if (!isSourceJavac) {
                if (DEBUG) {
                    System.out.println("Source is not Javac hence invoking ThrowFinder");
                }
                ThrowFinder.v().find();
            } else if (DEBUG) {
                System.out.println("Source is javac hence we dont need to invoke ThrowFinder");
            }
            PackageNamer.v().fixNames();
            G.v().out.println();
        }
    }

    private void runBodyPacks(Iterator classes) {
        while (classes.hasNext()) {
            SootClass cl = (SootClass)classes.next();
            this.runBodyPacks(cl);
        }
    }

    private void handleInnerClasses() {
        InnerClassTagAggregator agg = InnerClassTagAggregator.v();
        agg.internalTransform("", null);
    }

    private void writeOutput(Iterator classes) {
        while (classes.hasNext()) {
            SootClass cl = (SootClass)classes.next();
            this.writeClass(cl);
        }
        try {
            if (this.jarFile != null) {
                this.jarFile.close();
            }
        }
        catch (IOException e) {
            throw new CompilationDeathException("Error closing output jar: " + e);
        }
    }

    private void releaseBodies(Iterator classes) {
        while (classes.hasNext()) {
            SootClass cl = (SootClass)classes.next();
            this.releaseBodies(cl);
        }
    }

    private Iterator reachableClasses() {
        return Scene.v().getApplicationClasses().iterator();
    }

    private void postProcessDAVA() {
        G.v().out.println();
        Chain<SootClass> appClasses = Scene.v().getApplicationClasses();
        Map options = PhaseOptions.v().getPhaseOptions("db.transformations");
        boolean transformations = PhaseOptions.getBoolean(options, "enabled");
        for (SootClass s : appClasses) {
            String fileName = SourceLocator.v().getFileNameFor(s, Options.v().output_format());
            DavaStaticBlockCleaner.v().staticBlockInlining(s);
            VoidReturnRemover.cleanClass(s);
            RemoveEmptyBodyDefaultConstructor.checkAndRemoveDefault(s);
            G.v().out.println("Analyzing " + fileName + "... ");
            Iterator<SootMethod> methodIt = s.methodIterator();
            while (methodIt.hasNext()) {
                SootMethod m = methodIt.next();
                if (!m.hasActiveBody()) continue;
                DavaBody body = (DavaBody)m.getActiveBody();
                if (transformations) {
                    body.analyzeAST();
                    continue;
                }
                body.applyBugFixes();
            }
        }
        if (transformations) {
            InterProceduralAnalyses.applyInterProceduralAnalyses();
        }
        this.outputDava();
    }

    private void outputDava() {
        PrintWriter writerOut;
        OutputStream streamOut;
        Chain<SootClass> appClasses = Scene.v().getApplicationClasses();
        String pathForBuild = null;
        ArrayList<String> decompiledClasses = new ArrayList<String>();
        for (SootClass s : appClasses) {
            streamOut = null;
            writerOut = null;
            String fileName = SourceLocator.v().getFileNameFor(s, Options.v().output_format());
            decompiledClasses.add(fileName.substring(fileName.lastIndexOf(47) + 1));
            if (pathForBuild == null) {
                pathForBuild = fileName.substring(0, fileName.lastIndexOf(47) + 1);
            }
            if (Options.v().gzip()) {
                fileName = fileName + ".gz";
            }
            try {
                if (this.jarFile != null) {
                    ZipEntry entry = new ZipEntry(StringTools.replaceAll(fileName, "\\", "/"));
                    this.jarFile.putNextEntry(entry);
                    streamOut = this.jarFile;
                } else {
                    streamOut = new FileOutputStream(fileName);
                }
                if (Options.v().gzip()) {
                    streamOut = new GZIPOutputStream(streamOut);
                }
                writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
            }
            catch (IOException e) {
                throw new CompilationDeathException("Cannot output file " + fileName);
            }
            G.v().out.print("Generating " + fileName + "... ");
            G.v().out.flush();
            DavaPrinter.v().printTo(s, writerOut);
            G.v().out.println();
            G.v().out.flush();
            try {
                writerOut.flush();
                if (this.jarFile != null) continue;
                streamOut.close();
            }
            catch (IOException e) {
                throw new CompilationDeathException("Cannot close output file " + fileName);
            }
        }
        G.v().out.println();
        if (pathForBuild.endsWith("src/")) {
            pathForBuild = pathForBuild.substring(0, pathForBuild.length() - 4);
        }
        String fileName = pathForBuild + "build.xml";
        try {
            streamOut = new FileOutputStream(fileName);
            writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
            DavaBuildFile.generate(writerOut, decompiledClasses);
            writerOut.flush();
            streamOut.close();
        }
        catch (IOException e) {
            throw new CompilationDeathException("Cannot output file " + fileName);
        }
    }

    private void runBodyPacks(SootClass c) {
        SootMethod m;
        int format = Options.v().output_format();
        if (format == 13) {
            G.v().out.print("Decompiling ");
            G.v().SootMethodAddedByDava = false;
        } else {
            G.v().out.print("Transforming ");
        }
        G.v().out.println(c.getName() + "... ");
        boolean produceBaf = false;
        boolean produceGrimp = false;
        boolean produceDava = false;
        boolean produceJimple = true;
        boolean produceShimple = false;
        switch (format) {
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                produceShimple = true;
                produceJimple = false;
                break;
            }
            case 13: {
                produceDava = true;
            }
            case 7: 
            case 8: {
                produceGrimp = true;
                break;
            }
            case 5: 
            case 6: {
                produceBaf = true;
                break;
            }
            case 11: 
            case 12: {
                produceGrimp = Options.v().via_grimp();
                produceBaf = !produceGrimp;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        TagCollector tc = new TagCollector();
        boolean wholeShimple = Options.v().whole_shimple();
        if (Options.v().via_shimple()) {
            produceShimple = true;
        }
        Iterator<SootMethod> methodIt = c.methodIterator();
        while (methodIt.hasNext()) {
            m = methodIt.next();
            if (DEBUG && m.getExceptions().size() != 0) {
                System.out.println("PackManager printing out jimple body exceptions for method " + m.toString() + " " + m.getExceptions().toString());
            }
            if (!m.isConcrete()) continue;
            if (produceShimple || wholeShimple) {
                ShimpleBody sBody = null;
                Body body = m.retrieveActiveBody();
                if (body instanceof ShimpleBody) {
                    sBody = (ShimpleBody)body;
                    if (!sBody.isSSA()) {
                        sBody.rebuild();
                    }
                } else {
                    sBody = Shimple.v().newBody(body);
                }
                m.setActiveBody(sBody);
                PackManager.v().getPack("stp").apply(sBody);
                PackManager.v().getPack("sop").apply(sBody);
                if (produceJimple || wholeShimple && !produceShimple) {
                    m.setActiveBody(sBody.toJimpleBody());
                }
            }
            if (produceJimple) {
                JimpleBody body = (JimpleBody)m.retrieveActiveBody();
                PackManager.v().getPack("jtp").apply(body);
                if (Options.v().validate()) {
                    body.validate();
                }
                PackManager.v().getPack("jop").apply(body);
                PackManager.v().getPack("jap").apply(body);
                if (Options.v().xml_attributes() && Options.v().output_format() != 1) {
                    tc.collectBodyTags(body);
                }
            }
            if (produceGrimp) {
                System.out.println("GRIMP");
                m.setActiveBody(Grimp.v().newBody(m.getActiveBody(), "gb"));
                PackManager.v().getPack("gop").apply(m.getActiveBody());
                continue;
            }
            if (!produceBaf) continue;
            System.out.println("BAF");
            m.setActiveBody(Baf.v().newBody((JimpleBody)m.getActiveBody()));
            PackManager.v().getPack("bop").apply(m.getActiveBody());
            PackManager.v().getPack("tag").apply(m.getActiveBody());
            if (!Options.v().validate()) continue;
            m.getActiveBody().validate();
        }
        if (Options.v().xml_attributes() && Options.v().output_format() != 1) {
            this.processXMLForClass(c, tc);
        }
        if (produceDava) {
            methodIt = c.methodIterator();
            while (methodIt.hasNext()) {
                m = methodIt.next();
                if (!m.isConcrete()) continue;
                m.setActiveBody(Dava.v().newBody(m.getActiveBody()));
            }
            if (G.v().SootMethodAddedByDava) {
                ArrayList sootMethodsAdded = G.v().SootMethodsAdded;
                Iterator it = sootMethodsAdded.iterator();
                while (it.hasNext()) {
                    c.addMethod((SootMethod)it.next());
                }
                G.v().SootMethodsAdded = new ArrayList();
                G.v().SootMethodAddedByDava = false;
            }
        }
    }

    private void writeClass(SootClass c) {
        int format;
        if (Options.v().info()) {
            System.out.println("SOOT writing class: " + c);
        }
        if ((format = Options.v().output_format()) == 10) {
            return;
        }
        if (format == 13) {
            return;
        }
        OutputStream streamOut = null;
        PrintWriter writerOut = null;
        boolean noOutputFile = false;
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        if (Options.v().gzip()) {
            fileName = fileName + ".gz";
        }
        try {
            if (this.jarFile != null) {
                ZipEntry entry = new ZipEntry(fileName);
                this.jarFile.putNextEntry(entry);
                streamOut = this.jarFile;
            } else {
                new File(fileName).getParentFile().mkdirs();
                streamOut = new FileOutputStream(fileName);
            }
            if (Options.v().gzip()) {
                streamOut = new GZIPOutputStream(streamOut);
            }
            if (format == 12) {
                streamOut = new JasminOutputStream(streamOut);
            }
            writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
            if (Options.v().info()) {
                G.v().out.println("Writing to " + fileName);
            }
        }
        catch (IOException e) {
            throw new CompilationDeathException("Cannot output file " + fileName);
        }
        if (Options.v().xml_attributes()) {
            Printer.v().setOption(16);
        }
        switch (format) {
            case 11: 
            case 12: {
                if (c.containsBafBody()) {
                    new soot.baf.JasminClass(c).print(writerOut);
                    break;
                }
                new JasminClass(c).print(writerOut);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                Printer.v().setOption(1);
                Printer.v().printTo(c, writerOut);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                writerOut = new PrintWriter(new EscapedWriter(new OutputStreamWriter(streamOut)));
                Printer.v().printTo(c, writerOut);
                break;
            }
            case 9: {
                writerOut = new PrintWriter(new EscapedWriter(new OutputStreamWriter(streamOut)));
                XMLPrinter.v().printJimpleStyleTo(c, writerOut);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        try {
            writerOut.flush();
            streamOut.close();
        }
        catch (IOException e) {
            throw new CompilationDeathException("Cannot close output file " + fileName);
        }
    }

    private void postProcessXML(Iterator classes) {
        if (!Options.v().xml_attributes()) {
            return;
        }
        if (Options.v().output_format() != 1) {
            return;
        }
        while (classes.hasNext()) {
            SootClass c = (SootClass)classes.next();
            this.processXMLForClass(c);
        }
    }

    private void processXMLForClass(SootClass c, TagCollector tc) {
        int format = Options.v().output_format();
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        XMLAttributesPrinter xap = new XMLAttributesPrinter(fileName, SourceLocator.v().getOutputDir());
        xap.printAttrs(c, tc);
    }

    private void processXMLForClass(SootClass c) {
        int format = Options.v().output_format();
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        XMLAttributesPrinter xap = new XMLAttributesPrinter(fileName, SourceLocator.v().getOutputDir());
        xap.printAttrs(c);
    }

    private void releaseBodies(SootClass cl) {
        Iterator<SootMethod> methodIt = cl.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod m = methodIt.next();
            if (!m.hasActiveBody()) continue;
            m.releaseActiveBody();
        }
    }

    private void retrieveAllBodies() {
        Iterator clIt = this.reachableClasses();
        while (clIt.hasNext()) {
            SootClass cl = (SootClass)clIt.next();
            Iterator<SootMethod> methodIt = cl.methodIterator();
            while (methodIt.hasNext()) {
                SootMethod m = methodIt.next();
                if (DEBUG && cl.isApplicationClass()) {
                    if (m.getExceptions().size() != 0) {
                        System.out.println("PackManager printing out from within retrieveAllBodies exceptions for method " + m.toString() + " " + m.getExceptions().toString());
                    } else {
                        System.out.println("in retrieveAllBodies......Currently Method " + m.toString() + " has no exceptions ");
                    }
                }
                if (!m.isConcrete()) continue;
            }
        }
        this.addExtraClasses();
    }
}

