/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.List;
import soot.ByteType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.PrimType;
import soot.ShortType;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.grimp.internal.GCastExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

public class TypeCastingError
extends DepthFirstAdapter {
    public boolean myDebug = false;

    public TypeCastingError() {
    }

    public TypeCastingError(boolean verbose) {
        super(verbose);
    }

    public void inASTStatementSequenceNode(ASTStatementSequenceNode node) {
        List<Object> stmts = node.getStatements();
        for (AugmentedStmt augmentedStmt : stmts) {
            Stmt s = augmentedStmt.get_Stmt();
            if (!(s instanceof DefinitionStmt)) continue;
            DefinitionStmt ds = (DefinitionStmt)s;
            if (this.myDebug) {
                System.out.println("Definition stmt" + ds);
            }
            ValueBox rightBox = ds.getRightOpBox();
            ValueBox leftBox = ds.getLeftOpBox();
            Value right = rightBox.getValue();
            Value left = leftBox.getValue();
            if (!(left.getType() instanceof PrimType) || !(right.getType() instanceof PrimType)) {
                if (!this.myDebug) continue;
                System.out.println("\tDefinition stmt does not contain prims no need to modify");
                continue;
            }
            Type leftType = left.getType();
            Type rightType = right.getType();
            if (this.myDebug) {
                System.out.println("Left type is: " + leftType);
            }
            if (this.myDebug) {
                System.out.println("Right type is: " + rightType);
            }
            if (leftType.equals(rightType)) {
                if (this.myDebug) {
                    System.out.println("\tTypes are the same");
                }
                if (this.myDebug) {
                    System.out.println("Right value is of instance" + right.getClass());
                }
            }
            if (leftType.equals(rightType)) continue;
            if (this.myDebug) {
                System.out.println("\tDefinition stmt has to be modified");
            }
            if (leftType instanceof ByteType && (rightType instanceof DoubleType || rightType instanceof FloatType || rightType instanceof IntType || rightType instanceof LongType || rightType instanceof ShortType)) {
                if (this.DEBUG) {
                    System.out.println("Explicit casting to BYTE required");
                }
                rightBox.setValue(new GCastExpr(right, (Type)ByteType.v()));
                if (!this.DEBUG) continue;
                System.out.println("New right expr is " + rightBox.getValue().toString());
                continue;
            }
            if (leftType instanceof ShortType && (rightType instanceof DoubleType || rightType instanceof FloatType || rightType instanceof IntType || rightType instanceof LongType)) {
                if (this.DEBUG) {
                    System.out.println("Explicit casting to SHORT required");
                }
                rightBox.setValue(new GCastExpr(right, (Type)ShortType.v()));
                if (!this.DEBUG) continue;
                System.out.println("New right expr is " + rightBox.getValue().toString());
                continue;
            }
            if (leftType instanceof IntType && (rightType instanceof DoubleType || rightType instanceof FloatType || rightType instanceof LongType)) {
                if (this.myDebug) {
                    System.out.println("Explicit casting to INT required");
                }
                rightBox.setValue(new GCastExpr(right, (Type)IntType.v()));
                if (!this.myDebug) continue;
                System.out.println("New right expr is " + rightBox.getValue().toString());
                continue;
            }
            if (leftType instanceof LongType && (rightType instanceof DoubleType || rightType instanceof FloatType)) {
                if (this.DEBUG) {
                    System.out.println("Explicit casting to LONG required");
                }
                rightBox.setValue(new GCastExpr(right, (Type)LongType.v()));
                if (!this.DEBUG) continue;
                System.out.println("New right expr is " + rightBox.getValue().toString());
                continue;
            }
            if (!(leftType instanceof FloatType) || !(rightType instanceof DoubleType)) continue;
            if (this.DEBUG) {
                System.out.println("Explicit casting to FLOAT required");
            }
            rightBox.setValue(new GCastExpr(right, (Type)FloatType.v()));
            if (!this.DEBUG) continue;
            System.out.println("New right expr is " + rightBox.getValue().toString());
        }
    }
}

