/*
 * Decompiled with CFR 0.152.
 */
package soot.hj;

import soot.ClassProvider;
import soot.ClassSource;
import soot.HjToJimple.InitialResolver;
import soot.JavaClassProvider;
import soot.JavaClassSource;
import soot.SourceLocator;

public class HjClassProvider
implements ClassProvider {
    public static final String HJ_EXTENSION = ".hj";

    public static String toHjFileName(String hjClassName) {
        return hjClassName.replace('.', '/') + HJ_EXTENSION;
    }

    public static String removeHjExtension(String classnameOrFilename) {
        if (classnameOrFilename.endsWith(HJ_EXTENSION)) {
            return classnameOrFilename.substring(0, classnameOrFilename.length() - HJ_EXTENSION.length());
        }
        return classnameOrFilename;
    }

    public ClassSource find(String className) {
        if (InitialResolver.v().hasASTForSootName(className)) {
            InitialResolver.v().setASTForSootName(className);
            return new JavaClassSource(className);
        }
        boolean checkAgain = className.indexOf(36) >= 0;
        String hjClassName = SourceLocator.v().getSourceForClass(className);
        String fileName = HjClassProvider.toHjFileName(hjClassName);
        SourceLocator.FoundFile file = SourceLocator.v().lookupInClassPath(fileName);
        if (file == null && checkAgain) {
            fileName = HjClassProvider.toHjFileName(hjClassName);
            file = SourceLocator.v().lookupInClassPath(fileName);
        }
        if (file == null) {
            return null;
        }
        if (file.file == null) {
            throw new JavaClassProvider.JarException(className);
        }
        JavaClassSource hjClassSource = new JavaClassSource(className, file.file);
        return hjClassSource;
    }
}

