/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.ReachingTypeDumper;
import soot.jimple.Stmt;
import soot.jimple.spark.builder.ContextInsensitiveBuilder;
import soot.jimple.spark.ondemand.DemandCSPointsTo;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.PAG2HTML;
import soot.jimple.spark.pag.PAGDumper;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.EBBCollapser;
import soot.jimple.spark.solver.PropAlias;
import soot.jimple.spark.solver.PropCycle;
import soot.jimple.spark.solver.PropIter;
import soot.jimple.spark.solver.PropMerge;
import soot.jimple.spark.solver.PropWorklist;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.SCCCollapser;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.options.SparkOptions;
import soot.tagkit.Host;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparkTransformer
extends SceneTransformer {
    public SparkTransformer(Singletons.Global g) {
    }

    public static SparkTransformer v() {
        return G.v().soot_jimple_spark_SparkTransformer();
    }

    @Override
    protected void internalTransform(String phaseName, Map options) {
        SparkOptions opts = new SparkOptions(options);
        String output_dir = SourceLocator.v().getOutputDir();
        ContextInsensitiveBuilder b = new ContextInsensitiveBuilder();
        if (opts.pre_jimplify()) {
            b.preJimplify();
        }
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        Date startBuild = new Date();
        PAG pag = b.setup(opts);
        b.build();
        Date endBuild = new Date();
        SparkTransformer.reportTime("Pointer Assignment Graph", startBuild, endBuild);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        Date startTM = new Date();
        pag.getTypeManager().makeTypeMask();
        Date endTM = new Date();
        SparkTransformer.reportTime("Type masks", startTM, endTM);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        if (opts.verbose()) {
            G.v().out.println("VarNodes: " + pag.getVarNodeNumberer().size());
            G.v().out.println("FieldRefNodes: " + pag.getFieldRefNodeNumberer().size());
            G.v().out.println("AllocNodes: " + pag.getAllocNodeNumberer().size());
        }
        Date startSimplify = new Date();
        if (opts.simplify_sccs() && !opts.on_fly_cg() || opts.vta()) {
            new SCCCollapser(pag, opts.ignore_types_for_sccs()).collapse();
        }
        if (opts.simplify_offline() && !opts.on_fly_cg()) {
            new EBBCollapser(pag).collapse();
        }
        pag.cleanUpMerges();
        Date endSimplify = new Date();
        SparkTransformer.reportTime("Pointer Graph simplified", startSimplify, endSimplify);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        PAGDumper dumper = null;
        if (opts.dump_pag() || opts.dump_solution()) {
            dumper = new PAGDumper(pag, output_dir);
        }
        if (opts.dump_pag()) {
            dumper.dump();
        }
        Date startProp = new Date();
        Propagator[] propagator = new Propagator[1];
        switch (opts.propagator()) {
            case 1: {
                propagator[0] = new PropIter(pag);
                break;
            }
            case 2: {
                propagator[0] = new PropWorklist(pag);
                break;
            }
            case 3: {
                propagator[0] = new PropCycle(pag);
                break;
            }
            case 4: {
                propagator[0] = new PropMerge(pag);
                break;
            }
            case 5: {
                propagator[0] = new PropAlias(pag);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (propagator[0] != null) {
            propagator[0].propagate();
        }
        Date endProp = new Date();
        SparkTransformer.reportTime("Propagation", startProp, endProp);
        SparkTransformer.reportTime("Solution found", startSimplify, endProp);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        if (!opts.on_fly_cg() || opts.vta()) {
            CallGraphBuilder cgb = new CallGraphBuilder(pag);
            cgb.build();
        }
        if (opts.verbose()) {
            G.v().out.println("[Spark] Number of reachable methods: " + Scene.v().getReachableMethods().size());
        }
        if (opts.set_mass()) {
            this.findSetMass(pag);
        }
        if (opts.dump_answer()) {
            new ReachingTypeDumper(pag, output_dir).dump();
        }
        if (opts.dump_solution()) {
            dumper.dumpPointsToSets();
        }
        if (opts.dump_html()) {
            new PAG2HTML(pag, output_dir).dump();
        }
        Scene.v().setPointsToAnalysis(pag);
        if (opts.add_tags()) {
            this.addTags(pag);
        }
        if (opts.cs_demand()) {
            Date startOnDemand = new Date();
            int maxTraversal = opts.traversal();
            int maxPasses = opts.passes();
            DemandCSPointsTo onDemandAnalysis = DemandCSPointsTo.makeWithBudget(maxTraversal, maxPasses);
            Date endOndemand = new Date();
            SparkTransformer.reportTime("Initialized on-demand refinement-based context-sensitive analysis", startOnDemand, endOndemand);
            Scene.v().setPointsToAnalysis(onDemandAnalysis);
        }
    }

    protected void addTags(PAG pag) {
        final StringTag unknown = new StringTag("Untagged Spark node");
        final Map<Node, Tag> nodeToTag = pag.getNodeTags();
        for (SootClass c : Scene.v().getClasses()) {
            Iterator<SootMethod> mIt = c.methodIterator();
            while (mIt.hasNext()) {
                SootMethod m = mIt.next();
                if (!m.isConcrete() || !m.hasActiveBody()) continue;
                for (final Stmt stmt : m.getActiveBody().getUnits()) {
                    Node[] simpleSources;
                    if (!(stmt instanceof DefinitionStmt)) continue;
                    Value lhs = ((DefinitionStmt)stmt).getLeftOp();
                    VarNode v = null;
                    if (lhs instanceof Local) {
                        v = pag.findLocalVarNode(lhs);
                    } else if (lhs instanceof FieldRef) {
                        v = pag.findGlobalVarNode(((FieldRef)lhs).getField());
                    }
                    if (v == null) continue;
                    PointsToSetInternal p2set = v.getP2Set();
                    p2set.forall(new P2SetVisitor(){

                        public final void visit(Node n) {
                            SparkTransformer.this.addTag(stmt, n, nodeToTag, unknown);
                        }
                    });
                    for (Node element : simpleSources = pag.simpleInvLookup(v)) {
                        this.addTag(stmt, element, nodeToTag, unknown);
                    }
                    for (Node element : simpleSources = pag.allocInvLookup(v)) {
                        this.addTag(stmt, element, nodeToTag, unknown);
                    }
                    for (Node element : simpleSources = pag.loadInvLookup(v)) {
                        this.addTag(stmt, element, nodeToTag, unknown);
                    }
                }
            }
        }
    }

    protected static void reportTime(String desc, Date start, Date end) {
        long time = end.getTime() - start.getTime();
        G.v().out.println("[Spark] " + desc + " in " + time / 1000L + "." + time / 100L % 10L + " seconds.");
    }

    protected static void doGC() {
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    protected void addTag(Host h, Node n, Map<Node, Tag> nodeToTag, Tag unknown) {
        if (nodeToTag.containsKey(n)) {
            h.addTag(nodeToTag.get(n));
        } else {
            h.addTag(unknown);
        }
    }

    protected void findSetMass(PAG pag) {
        int mass = 0;
        int varMass = 0;
        int adfs = 0;
        int scalars = 0;
        Iterator vIt = pag.getVarNodeNumberer().iterator();
        while (vIt.hasNext()) {
            VarNode v = (VarNode)vIt.next();
            ++scalars;
            PointsToSetInternal set = v.getP2Set();
            if (set != null) {
                mass += set.size();
            }
            if (set == null) continue;
            varMass += set.size();
        }
        Iterator<Object> anIt = pag.allocSourcesIterator();
        while (anIt.hasNext()) {
            AllocNode an = (AllocNode)anIt.next();
            for (AllocDotField adf : an.getFields()) {
                PointsToSetInternal set = adf.getP2Set();
                if (set != null) {
                    mass += set.size();
                }
                if (set == null || set.size() <= 0) continue;
                ++adfs;
            }
        }
        G.v().out.println("Set mass: " + mass);
        G.v().out.println("Variable mass: " + varMass);
        G.v().out.println("Scalars: " + scalars);
        G.v().out.println("adfs: " + adfs);
        int[] deRefCounts = new int[30001];
        for (VarNode v : pag.getDereferences()) {
            PointsToSetInternal set = v.getP2Set();
            int size = 0;
            if (set != null) {
                size = set.size();
            }
            int n = size;
            deRefCounts[n] = deRefCounts[n] + 1;
        }
        int total = 0;
        for (int element : deRefCounts) {
            total += element;
        }
        G.v().out.println("Dereference counts BEFORE trimming (total = " + total + "):");
        for (int i = 0; i < deRefCounts.length; ++i) {
            if (deRefCounts[i] <= 0) continue;
            G.v().out.println("" + i + " " + deRefCounts[i] + " " + (double)deRefCounts[i] * 100.0 / (double)total + "%");
        }
    }
}

