/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp.findobject;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.NewExpr;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.PAG;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.thread.mhp.findobject.MultiCalledMethods;
import soot.jimple.toolkits.thread.mhp.findobject.MultiRunStatementsFinder;
import soot.jimple.toolkits.thread.mhp.pegcallgraph.PegCallGraph;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.FlowSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocNodesFinder {
    private final Set<AllocNode> allocNodes;
    private final Set<AllocNode> multiRunAllocNodes;
    private final Set<Object> multiCalledMethods;
    private final HashMap methodsToMultiObjsSites;
    PAG pag;

    public AllocNodesFinder(PegCallGraph pcg, CallGraph cg, PAG pag) {
        this.pag = pag;
        this.allocNodes = new HashSet<AllocNode>();
        this.multiRunAllocNodes = new HashSet<AllocNode>();
        this.multiCalledMethods = new HashSet<Object>();
        this.methodsToMultiObjsSites = new HashMap();
        MultiCalledMethods mcm = new MultiCalledMethods(pcg, this.multiCalledMethods);
        this.find(mcm.getMultiCalledMethods(), pcg, cg);
    }

    private void find(Set<Object> multiCalledMethods, PegCallGraph pcg, CallGraph callGraph) {
        Set clinitMethods = pcg.getClinitMethods();
        for (SootMethod sm : pcg) {
            AllocNode allocNode;
            if (this.methodsToMultiObjsSites.containsKey(sm)) continue;
            CompleteUnitGraph graph = new CompleteUnitGraph(sm.getActiveBody());
            Iterator<Unit> iterator = graph.iterator();
            if (multiCalledMethods.contains(sm)) {
                while (iterator.hasNext()) {
                    Type type;
                    Value rightOp;
                    Unit unit = iterator.next();
                    if (clinitMethods.contains(sm) && unit instanceof AssignStmt) {
                        rightOp = ((AssignStmt)unit).getRightOp();
                        type = ((NewExpr)rightOp).getType();
                        allocNode = this.pag.makeAllocNode("STRING_NODE", RefType.v("java.lang.String"), null);
                        this.allocNodes.add(allocNode);
                        this.multiRunAllocNodes.add(allocNode);
                        continue;
                    }
                    if (!(unit instanceof DefinitionStmt) || !((rightOp = ((DefinitionStmt)unit).getRightOp()) instanceof NewExpr)) continue;
                    type = ((NewExpr)rightOp).getType();
                    allocNode = this.pag.makeAllocNode(rightOp, type, sm);
                    this.allocNodes.add(allocNode);
                    this.multiRunAllocNodes.add(allocNode);
                }
                continue;
            }
            MultiRunStatementsFinder finder = new MultiRunStatementsFinder(graph, sm, multiCalledMethods, callGraph);
            FlowSet fs = finder.getMultiRunStatements();
            while (iterator.hasNext()) {
                Value rightOp;
                Unit unit = iterator.next();
                if (clinitMethods.contains(sm) && unit instanceof AssignStmt) {
                    allocNode = this.pag.makeAllocNode("STRING_NODE", RefType.v("java.lang.String"), null);
                    this.allocNodes.add(allocNode);
                    continue;
                }
                if (!(unit instanceof DefinitionStmt) || !((rightOp = ((DefinitionStmt)unit).getRightOp()) instanceof NewExpr)) continue;
                Type type = ((NewExpr)rightOp).getType();
                AllocNode allocNode2 = this.pag.makeAllocNode(rightOp, type, sm);
                this.allocNodes.add(allocNode2);
                if (!fs.contains(unit)) continue;
                this.multiRunAllocNodes.add(allocNode2);
            }
        }
    }

    public Set<AllocNode> getAllocNodes() {
        return this.allocNodes;
    }

    public Set<AllocNode> getMultiRunAllocNodes() {
        return this.multiRunAllocNodes;
    }

    public Set<Object> getMultiCalledMethods() {
        return this.multiCalledMethods;
    }
}

