/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import soot.ArrayType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.RefType;
import soot.SootMethodRef;
import soot.TrapManager;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.ConcreteRef;
import soot.jimple.ConditionExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.Expr;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.RemExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.jimple.toolkits.typing.ClassHierarchy;
import soot.jimple.toolkits.typing.InternalTypingException;
import soot.jimple.toolkits.typing.TypeException;
import soot.jimple.toolkits.typing.TypeNode;
import soot.jimple.toolkits.typing.TypeResolverBV;

class ConstraintCheckerBV
extends AbstractStmtSwitch {
    private final ClassHierarchy hierarchy;
    private final boolean fix;
    private JimpleBody stmtBody;

    public ConstraintCheckerBV(TypeResolverBV resolver, boolean fix) {
        this.fix = fix;
        this.hierarchy = resolver.hierarchy();
    }

    public void check(Stmt stmt, JimpleBody stmtBody) throws TypeException {
        try {
            this.stmtBody = stmtBody;
            stmt.apply(this);
        }
        catch (RuntimeTypeException e) {
            StringWriter st = new StringWriter();
            PrintWriter pw = new PrintWriter(st);
            e.printStackTrace(pw);
            pw.close();
            throw new TypeException(st.toString());
        }
    }

    static void error(String message) {
        throw new RuntimeTypeException(message);
    }

    private void handleInvokeExpr(InvokeExpr ie, Stmt invokestmt) {
        if (ie instanceof InterfaceInvokeExpr) {
            Local local;
            InterfaceInvokeExpr invoke = (InterfaceInvokeExpr)ie;
            SootMethodRef method = invoke.getMethodRef();
            Value base = invoke.getBase();
            if (base instanceof Local && !this.hierarchy.typeNode((local = (Local)base).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(method.declaringClass().getType()))) {
                if (this.fix) {
                    invoke.setBase(this.insertCast(local, method.declaringClass().getType(), invokestmt));
                } else {
                    ConstraintCheckerBV.error("Type Error(7): local " + local + " is of incompatible type " + local.getType());
                }
            }
            int count = invoke.getArgCount();
            for (int i = 0; i < count; ++i) {
                Local local2;
                if (!(invoke.getArg(i) instanceof Local) || this.hierarchy.typeNode((local2 = (Local)invoke.getArg(i)).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(method.parameterType(i)))) continue;
                if (this.fix) {
                    invoke.setArg(i, this.insertCast(local2, method.parameterType(i), invokestmt));
                    continue;
                }
                ConstraintCheckerBV.error("Type Error(8)");
            }
        } else if (ie instanceof SpecialInvokeExpr) {
            Local local;
            SpecialInvokeExpr invoke = (SpecialInvokeExpr)ie;
            SootMethodRef method = invoke.getMethodRef();
            Value base = invoke.getBase();
            if (base instanceof Local && !this.hierarchy.typeNode((local = (Local)base).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(method.declaringClass().getType()))) {
                if (this.fix) {
                    invoke.setBase(this.insertCast(local, method.declaringClass().getType(), invokestmt));
                } else {
                    ConstraintCheckerBV.error("Type Error(9)");
                }
            }
            int count = invoke.getArgCount();
            for (int i = 0; i < count; ++i) {
                Local local3;
                if (!(invoke.getArg(i) instanceof Local) || this.hierarchy.typeNode((local3 = (Local)invoke.getArg(i)).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(method.parameterType(i)))) continue;
                if (this.fix) {
                    invoke.setArg(i, this.insertCast(local3, method.parameterType(i), invokestmt));
                    continue;
                }
                ConstraintCheckerBV.error("Type Error(10)");
            }
        } else if (ie instanceof VirtualInvokeExpr) {
            Local local;
            VirtualInvokeExpr invoke = (VirtualInvokeExpr)ie;
            SootMethodRef method = invoke.getMethodRef();
            Value base = invoke.getBase();
            if (base instanceof Local && !this.hierarchy.typeNode((local = (Local)base).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(method.declaringClass().getType()))) {
                if (this.fix) {
                    invoke.setBase(this.insertCast(local, method.declaringClass().getType(), invokestmt));
                } else {
                    ConstraintCheckerBV.error("Type Error(13)");
                }
            }
            int count = invoke.getArgCount();
            for (int i = 0; i < count; ++i) {
                Local local4;
                if (!(invoke.getArg(i) instanceof Local) || this.hierarchy.typeNode((local4 = (Local)invoke.getArg(i)).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(method.parameterType(i)))) continue;
                if (this.fix) {
                    invoke.setArg(i, this.insertCast(local4, method.parameterType(i), invokestmt));
                    continue;
                }
                ConstraintCheckerBV.error("Type Error(14)");
            }
        } else if (ie instanceof StaticInvokeExpr) {
            StaticInvokeExpr invoke = (StaticInvokeExpr)ie;
            SootMethodRef method = invoke.getMethodRef();
            int count = invoke.getArgCount();
            for (int i = 0; i < count; ++i) {
                Local local;
                if (!(invoke.getArg(i) instanceof Local) || this.hierarchy.typeNode((local = (Local)invoke.getArg(i)).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(method.parameterType(i)))) continue;
                if (this.fix) {
                    invoke.setArg(i, this.insertCast(local, method.parameterType(i), invokestmt));
                    continue;
                }
                ConstraintCheckerBV.error("Type Error(15)");
            }
        } else {
            throw new RuntimeException("Unhandled invoke expression type: " + ie.getClass());
        }
    }

    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    public void caseInvokeStmt(InvokeStmt stmt) {
        this.handleInvokeExpr(stmt.getInvokeExpr(), stmt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void caseAssignStmt(AssignStmt stmt) {
        Expr ne;
        Object baseType;
        TypeNode op;
        Value index;
        TypeNode base;
        ConcreteRef ref;
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        TypeNode left = null;
        if (l instanceof ArrayRef) {
            ref = (ArrayRef)l;
            base = this.hierarchy.typeNode(((Local)ref.getBase()).getType());
            if (!base.isArray()) {
                ConstraintCheckerBV.error("Type Error(16)");
            }
            left = base.element();
            index = ref.getIndex();
            if (index instanceof Local && !this.hierarchy.typeNode(((Local)index).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) {
                ConstraintCheckerBV.error("Type Error(17)");
            }
        } else if (l instanceof Local) {
            try {
                left = this.hierarchy.typeNode(((Local)l).getType());
            }
            catch (InternalTypingException e) {
                G.v().out.println("untyped local: " + l);
                throw e;
            }
        } else if (l instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)l;
            base = this.hierarchy.typeNode(((Local)ref.getBase()).getType());
            if (!base.hasAncestorOrSelf(this.hierarchy.typeNode(ref.getField().getDeclaringClass().getType()))) {
                if (this.fix) {
                    ref.setBase(this.insertCast((Local)ref.getBase(), ref.getField().getDeclaringClass().getType(), stmt));
                } else {
                    ConstraintCheckerBV.error("Type Error(18)");
                }
            }
            left = this.hierarchy.typeNode(ref.getField().getType());
        } else {
            if (!(l instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment left hand side type: " + l.getClass());
            ref = (StaticFieldRef)l;
            left = this.hierarchy.typeNode(((StaticFieldRef)ref).getField().getType());
        }
        if (r instanceof ArrayRef) {
            ref = (ArrayRef)r;
            base = this.hierarchy.typeNode(((Local)ref.getBase()).getType());
            if (!base.isArray()) {
                ConstraintCheckerBV.error("Type Error(19): " + base + " is not an array type");
            }
            if (base == this.hierarchy.NULL) {
                return;
            }
            if (!left.hasDescendantOrSelf(base.element())) {
                if (this.fix) {
                    Type lefttype = left.type();
                    if (lefttype instanceof ArrayType) {
                        ArrayType atype = (ArrayType)lefttype;
                        ref.setBase(this.insertCast((Local)ref.getBase(), ArrayType.v(atype.baseType, atype.numDimensions + 1), stmt));
                    } else {
                        ref.setBase(this.insertCast((Local)ref.getBase(), ArrayType.v(lefttype, 1), stmt));
                    }
                } else {
                    ConstraintCheckerBV.error("Type Error(20)");
                }
            }
            if (!((index = ref.getIndex()) instanceof Local) || this.hierarchy.typeNode(((Local)index).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintCheckerBV.error("Type Error(21)");
            return;
        }
        if (r instanceof DoubleConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(DoubleType.v()))) return;
            ConstraintCheckerBV.error("Type Error(22)");
            return;
        }
        if (r instanceof FloatConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(FloatType.v()))) return;
            ConstraintCheckerBV.error("Type Error(45)");
            return;
        }
        if (r instanceof IntConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintCheckerBV.error("Type Error(23)");
            return;
        }
        if (r instanceof LongConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(LongType.v()))) return;
            ConstraintCheckerBV.error("Type Error(24)");
            return;
        }
        if (r instanceof NullConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(NullType.v()))) return;
            ConstraintCheckerBV.error("Type Error(25)");
            return;
        }
        if (r instanceof StringConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.String")))) return;
            ConstraintCheckerBV.error("Type Error(26)");
            return;
        }
        if (r instanceof ClassConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Class")))) return;
            ConstraintCheckerBV.error("Type Error(27)");
            return;
        }
        if (r instanceof BinopExpr) {
            TypeNode rop;
            TypeNode lop;
            BinopExpr be = (BinopExpr)r;
            Value lv = be.getOp1();
            Value rv = be.getOp2();
            if (lv instanceof Local) {
                lop = this.hierarchy.typeNode(((Local)lv).getType());
            } else if (lv instanceof DoubleConstant) {
                lop = this.hierarchy.typeNode(DoubleType.v());
            } else if (lv instanceof FloatConstant) {
                lop = this.hierarchy.typeNode(FloatType.v());
            } else if (lv instanceof IntConstant) {
                lop = this.hierarchy.typeNode(IntType.v());
            } else if (lv instanceof LongConstant) {
                lop = this.hierarchy.typeNode(LongType.v());
            } else if (lv instanceof NullConstant) {
                lop = this.hierarchy.typeNode(NullType.v());
            } else if (lv instanceof StringConstant) {
                lop = this.hierarchy.typeNode(RefType.v("java.lang.String"));
            } else {
                if (!(lv instanceof ClassConstant)) throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
                lop = this.hierarchy.typeNode(RefType.v("java.lang.Class"));
            }
            if (rv instanceof Local) {
                rop = this.hierarchy.typeNode(((Local)rv).getType());
            } else if (rv instanceof DoubleConstant) {
                rop = this.hierarchy.typeNode(DoubleType.v());
            } else if (rv instanceof FloatConstant) {
                rop = this.hierarchy.typeNode(FloatType.v());
            } else if (rv instanceof IntConstant) {
                rop = this.hierarchy.typeNode(IntType.v());
            } else if (rv instanceof LongConstant) {
                rop = this.hierarchy.typeNode(LongType.v());
            } else if (rv instanceof NullConstant) {
                rop = this.hierarchy.typeNode(NullType.v());
            } else if (rv instanceof StringConstant) {
                rop = this.hierarchy.typeNode(RefType.v("java.lang.String"));
            } else {
                if (!(rv instanceof ClassConstant)) throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
                rop = this.hierarchy.typeNode(RefType.v("java.lang.Class"));
            }
            if (be instanceof AddExpr || be instanceof SubExpr || be instanceof MulExpr || be instanceof DivExpr || be instanceof RemExpr || be instanceof AndExpr || be instanceof OrExpr || be instanceof XorExpr) {
                if (left.hasDescendantOrSelf(lop) && left.hasDescendantOrSelf(rop)) return;
                ConstraintCheckerBV.error("Type Error(27)");
                return;
            }
            if (be instanceof ShlExpr || be instanceof ShrExpr || be instanceof UshrExpr) {
                if (left.hasDescendantOrSelf(lop) && this.hierarchy.typeNode(IntType.v()).hasAncestorOrSelf(rop)) return;
                ConstraintCheckerBV.error("Type Error(28)");
                return;
            }
            if (!(be instanceof CmpExpr) && !(be instanceof CmpgExpr) && !(be instanceof CmplExpr) && !(be instanceof EqExpr) && !(be instanceof GeExpr) && !(be instanceof GtExpr) && !(be instanceof LeExpr) && !(be instanceof LtExpr) && !(be instanceof NeExpr)) throw new RuntimeException("Unhandled binary expression type: " + be.getClass());
            try {
                lop.lca(rop);
            }
            catch (TypeException e) {
                ConstraintCheckerBV.error(e.getMessage());
            }
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintCheckerBV.error("Type Error(29)");
            return;
        }
        if (r instanceof CastExpr) {
            CastExpr ce = (CastExpr)r;
            TypeNode cast = this.hierarchy.typeNode(ce.getCastType());
            if (ce.getOp() instanceof Local) {
                op = this.hierarchy.typeNode(((Local)ce.getOp()).getType());
                try {
                    if (cast.isClassOrInterface() || op.isClassOrInterface()) {
                        cast.lca(op);
                    }
                }
                catch (TypeException e) {
                    G.v().out.println(r + "[" + op + "<->" + cast + "]");
                    ConstraintCheckerBV.error(e.getMessage());
                }
            }
            if (left.hasDescendantOrSelf(cast)) return;
            ConstraintCheckerBV.error("Type Error(30)");
            return;
        }
        if (r instanceof InstanceOfExpr) {
            InstanceOfExpr ioe = (InstanceOfExpr)r;
            TypeNode type = this.hierarchy.typeNode(ioe.getCheckType());
            op = this.hierarchy.typeNode(ioe.getOp().getType());
            try {
                op.lca(type);
            }
            catch (TypeException e) {
                G.v().out.println(r + "[" + op + "<->" + type + "]");
                ConstraintCheckerBV.error(e.getMessage());
            }
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintCheckerBV.error("Type Error(31)");
            return;
        }
        if (r instanceof InvokeExpr) {
            InvokeExpr ie = (InvokeExpr)r;
            this.handleInvokeExpr(ie, stmt);
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(ie.getMethodRef().returnType()))) return;
            ConstraintCheckerBV.error("Type Error(32)");
            return;
        } else if (r instanceof NewArrayExpr) {
            TypeNode var;
            Value size;
            NewArrayExpr nae = (NewArrayExpr)r;
            baseType = nae.getBaseType();
            TypeNode right = baseType instanceof ArrayType ? this.hierarchy.typeNode(ArrayType.v(((ArrayType)baseType).baseType, ((ArrayType)baseType).numDimensions + 1)) : this.hierarchy.typeNode(ArrayType.v((Type)baseType, 1));
            if (!left.hasDescendantOrSelf(right)) {
                ConstraintCheckerBV.error("Type Error(33)");
            }
            if (!((size = nae.getSize()) instanceof Local) || (var = this.hierarchy.typeNode(((Local)size).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintCheckerBV.error("Type Error(34)");
            return;
        } else if (r instanceof NewExpr) {
            ne = (NewExpr)r;
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(ne.getBaseType()))) return;
            ConstraintCheckerBV.error("Type Error(35)");
            return;
        } else if (r instanceof NewMultiArrayExpr) {
            NewMultiArrayExpr nmae = (NewMultiArrayExpr)r;
            if (!left.hasDescendantOrSelf(this.hierarchy.typeNode(nmae.getBaseType()))) {
                ConstraintCheckerBV.error("Type Error(36)");
            }
            for (int i = 0; i < nmae.getSizeCount(); ++i) {
                TypeNode var;
                Value size = nmae.getSize(i);
                if (!(size instanceof Local) || (var = this.hierarchy.typeNode(((Local)size).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) continue;
                ConstraintCheckerBV.error("Type Error(37)");
            }
            return;
        } else if (r instanceof LengthExpr) {
            LengthExpr le = (LengthExpr)r;
            if (!left.hasDescendantOrSelf(this.hierarchy.typeNode(IntType.v()))) {
                ConstraintCheckerBV.error("Type Error(38)");
            }
            if (!(le.getOp() instanceof Local) || this.hierarchy.typeNode(((Local)le.getOp()).getType()).isArray()) return;
            ConstraintCheckerBV.error("Type Error(39)");
            return;
        } else if (r instanceof NegExpr) {
            TypeNode right;
            ne = (NegExpr)r;
            if (ne.getOp() instanceof Local) {
                right = this.hierarchy.typeNode(((Local)ne.getOp()).getType());
            } else if (ne.getOp() instanceof DoubleConstant) {
                right = this.hierarchy.typeNode(DoubleType.v());
            } else if (ne.getOp() instanceof FloatConstant) {
                right = this.hierarchy.typeNode(FloatType.v());
            } else if (ne.getOp() instanceof IntConstant) {
                right = this.hierarchy.typeNode(IntType.v());
            } else {
                if (!(ne.getOp() instanceof LongConstant)) throw new RuntimeException("Unhandled neg expression operand type: " + ne.getOp().getClass());
                right = this.hierarchy.typeNode(LongType.v());
            }
            if (left.hasDescendantOrSelf(right)) return;
            ConstraintCheckerBV.error("Type Error(40)");
            return;
        } else if (r instanceof Local) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(((Local)r).getType()))) return;
            if (this.fix) {
                stmt.setRightOp(this.insertCast((Local)r, left.type(), stmt));
                return;
            } else {
                ConstraintCheckerBV.error("Type Error(41)");
            }
            return;
        } else if (r instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)r;
            baseType = this.hierarchy.typeNode(((Local)ref.getBase()).getType());
            if (!((TypeNode)baseType).hasAncestorOrSelf(this.hierarchy.typeNode(ref.getField().getDeclaringClass().getType()))) {
                if (this.fix) {
                    ref.setBase(this.insertCast((Local)ref.getBase(), ref.getField().getDeclaringClass().getType(), stmt));
                } else {
                    ConstraintCheckerBV.error("Type Error(42)");
                }
            }
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(ref.getField().getType()))) return;
            ConstraintCheckerBV.error("Type Error(43)");
            return;
        } else {
            if (!(r instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment right hand side type: " + r.getClass());
            ref = (StaticFieldRef)r;
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(((StaticFieldRef)ref).getField().getType()))) return;
            ConstraintCheckerBV.error("Type Error(44)");
        }
    }

    public void caseIdentityStmt(IdentityStmt stmt) {
        TypeNode left = this.hierarchy.typeNode(((Local)stmt.getLeftOp()).getType());
        Value r = stmt.getRightOp();
        if (!(r instanceof CaughtExceptionRef)) {
            TypeNode right = this.hierarchy.typeNode(r.getType());
            if (!left.hasDescendantOrSelf(right)) {
                ConstraintCheckerBV.error("Type Error(46) [" + left + " <- " + right + "]");
            }
        } else {
            List exceptionTypes = TrapManager.getExceptionTypesOf(stmt, this.stmtBody);
            for (Type t : exceptionTypes) {
                if (left.hasDescendantOrSelf(this.hierarchy.typeNode(t))) continue;
                ConstraintCheckerBV.error("Type Error(47)");
            }
            if (!left.hasAncestorOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Throwable")))) {
                ConstraintCheckerBV.error("Type Error(48)");
            }
        }
    }

    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        TypeNode op;
        if (stmt.getOp() instanceof Local && !(op = this.hierarchy.typeNode(((Local)stmt.getOp()).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Object")))) {
            ConstraintCheckerBV.error("Type Error(49)");
        }
    }

    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        TypeNode op;
        if (stmt.getOp() instanceof Local && !(op = this.hierarchy.typeNode(((Local)stmt.getOp()).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Object")))) {
            ConstraintCheckerBV.error("Type Error(49)");
        }
    }

    public void caseGotoStmt(GotoStmt stmt) {
    }

    public void caseIfStmt(IfStmt stmt) {
        TypeNode rop;
        TypeNode lop;
        ConditionExpr cond;
        ConditionExpr expr = cond = (ConditionExpr)stmt.getCondition();
        Value lv = expr.getOp1();
        Value rv = expr.getOp2();
        if (lv instanceof Local) {
            lop = this.hierarchy.typeNode(((Local)lv).getType());
        } else if (lv instanceof DoubleConstant) {
            lop = this.hierarchy.typeNode(DoubleType.v());
        } else if (lv instanceof FloatConstant) {
            lop = this.hierarchy.typeNode(FloatType.v());
        } else if (lv instanceof IntConstant) {
            lop = this.hierarchy.typeNode(IntType.v());
        } else if (lv instanceof LongConstant) {
            lop = this.hierarchy.typeNode(LongType.v());
        } else if (lv instanceof NullConstant) {
            lop = this.hierarchy.typeNode(NullType.v());
        } else if (lv instanceof StringConstant) {
            lop = this.hierarchy.typeNode(RefType.v("java.lang.String"));
        } else if (lv instanceof ClassConstant) {
            lop = this.hierarchy.typeNode(RefType.v("java.lang.Class"));
        } else {
            throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
        }
        if (rv instanceof Local) {
            rop = this.hierarchy.typeNode(((Local)rv).getType());
        } else if (rv instanceof DoubleConstant) {
            rop = this.hierarchy.typeNode(DoubleType.v());
        } else if (rv instanceof FloatConstant) {
            rop = this.hierarchy.typeNode(FloatType.v());
        } else if (rv instanceof IntConstant) {
            rop = this.hierarchy.typeNode(IntType.v());
        } else if (rv instanceof LongConstant) {
            rop = this.hierarchy.typeNode(LongType.v());
        } else if (rv instanceof NullConstant) {
            rop = this.hierarchy.typeNode(NullType.v());
        } else if (rv instanceof StringConstant) {
            rop = this.hierarchy.typeNode(RefType.v("java.lang.String"));
        } else if (rv instanceof ClassConstant) {
            rop = this.hierarchy.typeNode(RefType.v("java.lang.Class"));
        } else {
            throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
        }
        try {
            lop.lca(rop);
        }
        catch (TypeException e) {
            ConstraintCheckerBV.error(e.getMessage());
        }
    }

    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        Value key = stmt.getKey();
        if (key instanceof Local && !this.hierarchy.typeNode(((Local)key).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) {
            ConstraintCheckerBV.error("Type Error(50)");
        }
    }

    public void caseNopStmt(NopStmt stmt) {
    }

    public void caseReturnStmt(ReturnStmt stmt) {
        if (stmt.getOp() instanceof Local && !this.hierarchy.typeNode(((Local)stmt.getOp()).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(this.stmtBody.getMethod().getReturnType()))) {
            if (this.fix) {
                stmt.setOp(this.insertCast((Local)stmt.getOp(), this.stmtBody.getMethod().getReturnType(), stmt));
            } else {
                ConstraintCheckerBV.error("Type Error(51)");
            }
        }
    }

    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
    }

    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        Value key = stmt.getKey();
        if (key instanceof Local && !this.hierarchy.typeNode(((Local)key).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) {
            ConstraintCheckerBV.error("Type Error(52)");
        }
    }

    public void caseThrowStmt(ThrowStmt stmt) {
        TypeNode op;
        if (stmt.getOp() instanceof Local && !(op = this.hierarchy.typeNode(((Local)stmt.getOp()).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Throwable")))) {
            if (this.fix) {
                stmt.setOp(this.insertCast((Local)stmt.getOp(), RefType.v("java.lang.Throwable"), stmt));
            } else {
                ConstraintCheckerBV.error("Type Error(53)");
            }
        }
    }

    public void defaultCase(Stmt stmt) {
        throw new RuntimeException("Unhandled statement type: " + stmt.getClass());
    }

    private Local insertCast(Local oldlocal, Type type, Stmt stmt) {
        Local newlocal = Jimple.v().newLocal("tmp", type);
        this.stmtBody.getLocals().add(newlocal);
        this.stmtBody.getUnits().insertBefore(Jimple.v().newAssignStmt(newlocal, Jimple.v().newCastExpr(oldlocal, type)), (Unit)stmt);
        return newlocal;
    }

    private static class RuntimeTypeException
    extends RuntimeException {
        RuntimeTypeException(String message) {
            super(message);
        }
    }
}

