/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.G;
import soot.PatchingChain;
import soot.TrapManager;
import soot.Unit;
import soot.UnitBox;
import soot.options.Options;
import soot.shimple.PhiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.internal.SUnitBox;
import soot.util.Chain;
import soot.util.HashMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPatchingChain
extends PatchingChain<Unit> {
    Body body = null;
    boolean debug;
    protected Map<UnitBox, Unit> boxToPhiNode = new HashMap<UnitBox, Unit>();
    protected Map<SUnitBox, Boolean> boxToNeedsPatching = new HashMap<SUnitBox, Boolean>();

    public SPatchingChain(Body aBody, Chain aChain) {
        super(aChain);
        this.body = aBody;
        this.debug = Options.v().debug();
        if (aBody instanceof ShimpleBody) {
            this.debug |= ((ShimpleBody)aBody).getOptions().debug();
        }
    }

    @Override
    public boolean add(Unit o) {
        this.processPhiNode(o);
        return super.add(o);
    }

    @Override
    public void swapWith(Unit out, Unit in) {
        this.processPhiNode(in);
        Shimple.redirectPointers(out, in);
        super.insertBefore(in, out);
        super.remove(out);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void insertAfter(Unit toInsert, Unit point) {
        block9: {
            this.processPhiNode(toInsert);
            super.insertAfter(toInsert, point);
            unit = point;
            if (!unit.fallsThrough()) break block9;
            if (unit.branches()) ** GOTO lbl-1000
            trappedUnits = Collections.EMPTY_SET;
            if (this.body != null) {
                trappedUnits = TrapManager.getTrappedUnitsOf(this.body);
            }
            if (!trappedUnits.contains(unit)) {
                Shimple.redirectPointers(unit, toInsert);
            } else lbl-1000:
            // 7 sources

            {
                for (UnitBox ub : boxes = unit.getBoxesPointingToThis().toArray(new UnitBox[0])) {
                    if (ub.getUnit() != unit) {
                        throw new RuntimeException("Assertion failed.");
                    }
                    if (ub.isBranchTarget()) continue;
                    box = this.getSBox(ub);
                    needsPatching = this.boxToNeedsPatching.get(box);
                    if (needsPatching == null || box.isUnitChanged()) {
                        if (!this.boxToPhiNode.containsKey(box)) {
                            this.reprocessPhiNodes();
                            if (!this.boxToPhiNode.containsKey(box) && this.debug) {
                                throw new RuntimeException("SPatchingChain has pointers from a Phi node that has never been seen.");
                            }
                        }
                        this.computeNeedsPatching();
                        needsPatching = this.boxToNeedsPatching.get(box);
                        if (needsPatching == null) {
                            if (!this.debug) continue;
                            G.v().out.println("Warning: Orphaned UnitBox to " + unit + "?  SPatchingChain will not move the pointer.");
                            continue;
                        }
                    }
                    if (!needsPatching.booleanValue()) continue;
                    box.setUnit(toInsert);
                    box.setUnitChanged(false);
                }
            }
        }
    }

    @Override
    public void insertAfter(List<Unit> toInsert, Unit point) {
        for (Unit unit : toInsert) {
            this.processPhiNode(unit);
        }
        super.insertAfter(toInsert, point);
    }

    @Override
    public void insertBefore(List<Unit> toInsert, Unit point) {
        for (Unit unit : toInsert) {
            this.processPhiNode(unit);
        }
        super.insertBefore(toInsert, point);
    }

    @Override
    public void insertBefore(Unit toInsert, Unit point) {
        this.processPhiNode(toInsert);
        super.insertBefore(toInsert, point);
    }

    @Override
    public void addFirst(Unit u) {
        this.processPhiNode(u);
        super.addFirst(u);
    }

    @Override
    public void addLast(Unit u) {
        this.processPhiNode(u);
        super.addLast(u);
    }

    public boolean remove(Unit obj) {
        if (this.contains(obj)) {
            Shimple.redirectToPreds(this.body, obj);
        }
        return super.remove(obj);
    }

    protected void processPhiNode(Unit o) {
        Unit phiNode = o;
        PhiExpr phi = Shimple.getPhiExpr(phiNode);
        if (phi == null) {
            return;
        }
        if (this.boxToPhiNode.values().contains(phiNode)) {
            return;
        }
        for (UnitBox box : phi.getUnitBoxes()) {
            this.boxToPhiNode.put(box, phiNode);
        }
    }

    protected void reprocessPhiNodes() {
        HashSet<Unit> phiNodes = new HashSet<Unit>(this.boxToPhiNode.values());
        this.boxToPhiNode = new HashMap<UnitBox, Unit>();
        this.boxToNeedsPatching = new HashMap<SUnitBox, Boolean>();
        Iterator phiNodesIt = phiNodes.iterator();
        while (phiNodesIt.hasNext()) {
            this.processPhiNode((Unit)phiNodesIt.next());
        }
    }

    protected void computeNeedsPatching() {
        Set<UnitBox> boxes = this.boxToPhiNode.keySet();
        if (boxes.isEmpty()) {
            return;
        }
        HashMultiMap trackedPhiToBoxes = new HashMultiMap();
        HashSet<UnitBox> trackedBranchTargets = new HashSet<UnitBox>();
        for (Unit u : this) {
            List<UnitBox> boxesToTrack = u.getBoxesPointingToThis();
            if (boxesToTrack != null) {
                for (UnitBox boxToTrack : boxesToTrack) {
                    if (boxToTrack.isBranchTarget()) continue;
                    trackedPhiToBoxes.put(this.boxToPhiNode.get(boxToTrack), boxToTrack);
                }
            }
            if (u.fallsThrough() && u.branches()) {
                trackedBranchTargets.addAll(u.getUnitBoxes());
            }
            if (!u.fallsThrough() || trackedBranchTargets.contains(u)) {
                Iterator boxesIt = trackedPhiToBoxes.values().iterator();
                while (boxesIt.hasNext()) {
                    SUnitBox box = this.getSBox((UnitBox)boxesIt.next());
                    this.boxToNeedsPatching.put(box, Boolean.FALSE);
                    box.setUnitChanged(false);
                }
                trackedPhiToBoxes = new HashMultiMap();
                continue;
            }
            Set boxes2 = trackedPhiToBoxes.get(u);
            if (boxes2 == null) continue;
            Iterator boxesIt = boxes2.iterator();
            while (boxesIt.hasNext()) {
                SUnitBox box = this.getSBox((UnitBox)boxesIt.next());
                this.boxToNeedsPatching.put(box, Boolean.TRUE);
                box.setUnitChanged(false);
            }
            trackedPhiToBoxes.remove(u);
        }
        Iterator boxesIt = trackedPhiToBoxes.values().iterator();
        while (boxesIt.hasNext()) {
            SUnitBox box = this.getSBox((UnitBox)boxesIt.next());
            this.boxToNeedsPatching.put(box, Boolean.FALSE);
            box.setUnitChanged(false);
        }
    }

    protected SUnitBox getSBox(UnitBox box) {
        if (!(box instanceof SUnitBox)) {
            throw new RuntimeException("Shimple box not an SUnitBox?");
        }
        return (SUnitBox)box;
    }

    @Override
    public Iterator iterator() {
        return new SPatchingIterator(this.innerChain);
    }

    @Override
    public Iterator iterator(Unit u) {
        return new SPatchingIterator(this.innerChain, u);
    }

    @Override
    public Iterator iterator(Unit head, Unit tail) {
        return new SPatchingIterator(this.innerChain, head, tail);
    }

    protected class SPatchingIterator
    extends PatchingChain.PatchingIterator {
        SPatchingIterator(Chain innerChain) {
            super(innerChain);
        }

        SPatchingIterator(Chain innerChain, Unit u) {
            super(innerChain, u);
        }

        SPatchingIterator(Chain innerChain, Unit head, Unit tail) {
            super(innerChain, head, tail);
        }

        public void remove() {
            Unit victim = (Unit)this.lastObject;
            if (!this.state) {
                throw new IllegalStateException("remove called before first next() call");
            }
            Shimple.redirectToPreds(SPatchingChain.this.body, victim);
            Unit successor = SPatchingChain.this.getSuccOf(victim);
            if (successor == null) {
                successor = SPatchingChain.this.getPredOf(victim);
            }
            this.innerIterator.remove();
            victim.redirectJumpsToThisTo(successor);
        }
    }
}

