/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.Unit;
import soot.ValueBox;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LiveLocals;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.StringGroupPair;
import soot.util.ArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastColorer {
    public static void unsplitAssignColorsToLocals(Body unitBody, Map<Local, Object> localToGroup, Map<Local, Integer> localToColor, Map<Object, Integer> groupToColorCount) {
        ExceptionalUnitGraph unitGraph = new ExceptionalUnitGraph(unitBody);
        SimpleLiveLocals liveLocals = new SimpleLiveLocals(unitGraph);
        UnitInterferenceGraph intGraph = new UnitInterferenceGraph(unitBody, localToGroup, liveLocals);
        HashMap<Local, String> localToOriginalName = new HashMap<Local, String>();
        for (Local local : intGraph.getLocals()) {
            int signIndex = local.getName().indexOf("#");
            if (signIndex != -1) {
                localToOriginalName.put(local, local.getName().substring(0, signIndex));
                continue;
            }
            localToOriginalName.put(local, local.getName());
        }
        HashMap originalNameAndGroupToColors = new HashMap();
        int[] freeColors = new int[10];
        for (Local local : intGraph.getLocals()) {
            Local[] interferences;
            if (localToColor.containsKey(local)) continue;
            Object group = localToGroup.get(local);
            int colorCount = groupToColorCount.get(group);
            if (freeColors.length < colorCount) {
                freeColors = new int[Math.max(freeColors.length * 2, colorCount)];
            }
            for (int i = 0; i < colorCount; ++i) {
                freeColors[i] = 1;
            }
            for (Local element : interferences = intGraph.getInterferencesOf(local)) {
                if (!localToColor.containsKey(element)) continue;
                int usedColor = localToColor.get(element);
                freeColors[usedColor] = 0;
            }
            String originalName = (String)localToOriginalName.get(local);
            ArrayList<Integer> originalNameColors = (ArrayList<Integer>)originalNameAndGroupToColors.get(new StringGroupPair(originalName, group));
            if (originalNameColors == null) {
                originalNameColors = new ArrayList<Integer>();
                originalNameAndGroupToColors.put(new StringGroupPair(originalName, group), originalNameColors);
            }
            boolean found = false;
            int assignedColor = 0;
            for (Integer color : originalNameColors) {
                if (freeColors[color] != 1) continue;
                found = true;
                assignedColor = color;
            }
            if (!found) {
                assignedColor = colorCount++;
                groupToColorCount.put(group, new Integer(colorCount));
                originalNameColors.add(new Integer(assignedColor));
            }
            localToColor.put(local, new Integer(assignedColor));
        }
    }

    public static void assignColorsToLocals(Body unitBody, Map<Local, Object> localToGroup, Map<Local, Integer> localToColor, Map<Object, Integer> groupToColorCount) {
        ExceptionalUnitGraph unitGraph = new ExceptionalUnitGraph(unitBody);
        SimpleLiveLocals liveLocals = new SimpleLiveLocals(unitGraph);
        UnitInterferenceGraph intGraph = new UnitInterferenceGraph(unitBody, localToGroup, liveLocals);
        int[] freeColors = new int[10];
        for (Local local : intGraph.getLocals()) {
            Local[] interferences;
            if (localToColor.containsKey(local)) continue;
            Object group = localToGroup.get(local);
            int colorCount = groupToColorCount.get(group);
            if (freeColors.length < colorCount) {
                freeColors = new int[Math.max(freeColors.length * 2, colorCount)];
            }
            for (int i = 0; i < colorCount; ++i) {
                freeColors[i] = 1;
            }
            for (Local element : interferences = intGraph.getInterferencesOf(local)) {
                if (!localToColor.containsKey(element)) continue;
                int usedColor = localToColor.get(element);
                freeColors[usedColor] = 0;
            }
            boolean found = false;
            int assignedColor = 0;
            for (int i = 0; i < colorCount; ++i) {
                if (freeColors[i] != 1) continue;
                found = true;
                assignedColor = i;
            }
            if (!found) {
                assignedColor = colorCount++;
                groupToColorCount.put(group, new Integer(colorCount));
            }
            localToColor.put(local, new Integer(assignedColor));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnitInterferenceGraph {
        Map<Local, ArraySet> localToLocals;
        List locals;

        private UnitInterferenceGraph() {
        }

        public List getLocals() {
            return this.locals;
        }

        public UnitInterferenceGraph(Body body, Map<Local, Object> localToGroup, LiveLocals liveLocals) {
            this.locals = new ArrayList();
            this.locals.addAll(body.getLocals());
            this.localToLocals = new HashMap<Local, ArraySet>(body.getLocalCount() * 2 + 1, 0.7f);
            for (Local local : body.getLocals()) {
                this.localToLocals.put(local, new ArraySet());
            }
            for (Unit unit : body.getUnits()) {
                List liveLocalsAtUnit = liveLocals.getLiveLocalsAfter(unit);
                List<ValueBox> defBoxes = unit.getDefBoxes();
                if (defBoxes.isEmpty()) continue;
                if (defBoxes.size() != 1) {
                    throw new RuntimeException("invalid number of def boxes");
                }
                if (!(defBoxes.get(0).getValue() instanceof Local)) continue;
                Local defLocal = (Local)defBoxes.get(0).getValue();
                for (Local otherLocal : liveLocalsAtUnit) {
                    if (!localToGroup.get(otherLocal).equals(localToGroup.get(defLocal))) continue;
                    this.setInterference(defLocal, otherLocal);
                }
            }
        }

        public boolean localsInterfere(Local l1, Local l2) {
            return this.localToLocals.get(l1).contains(l2);
        }

        public void setInterference(Local l1, Local l2) {
            this.localToLocals.get(l1).add(l2);
            this.localToLocals.get(l2).add(l1);
        }

        public boolean isEmpty() {
            return this.localToLocals.isEmpty();
        }

        Local[] getInterferencesOf(Local l) {
            Object[] objects = this.localToLocals.get(l).toArray();
            Local[] locals = new Local[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                locals[i] = (Local)objects[i];
            }
            return locals;
        }
    }
}

