/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.GenParameterExpr;
import polyglot.ext.hj.ast.HjTypeNode;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.types.constr.TypeTranslator;
import polyglot.ext.hj.visit.TypeElaborator;
import polyglot.main.Report;
import polyglot.parse.Name;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class HjTypeNode_c
extends TypeNode_c
implements HjTypeNode {
    protected DepParameterExpr dep;
    protected GenParameterExpr gen;

    public DepParameterExpr dep() {
        return this.dep;
    }

    public GenParameterExpr gen() {
        return this.gen;
    }

    public HjTypeNode_c(Position pos) {
        super(pos);
    }

    public HjTypeNode_c(Position pos, Name name, GenParameterExpr types, DepParameterExpr parameter) {
        super(pos);
        this.gen = types;
        this.dep = parameter;
    }

    public boolean isDisambiguated() {
        return !(this.dep != null && !this.dep.isDisambiguated() || this.gen != null && !this.gen.isDisambiguated() || !super.isDisambiguated());
    }

    public static Node disambiguateDepClause(HjTypeNode me, AmbiguityRemover sc) throws SemanticException {
        List args;
        Node newTypeNode1 = me.disambiguateBase(sc);
        HjTypeNode newType = (HjTypeNode)newTypeNode1;
        HjType baseType = (HjType)newType.type();
        if (!baseType.isCanonical()) {
            return newType;
        }
        assert (me.dep() == null || me.dep().isDisambiguated());
        HjTypeSystem xt = (HjTypeSystem)me.type().typeSystem();
        GenParameterExpr newTParameter = me.gen() == null ? null : (GenParameterExpr)me.gen().disambiguate(sc);
        LinkedList<Type> typeParameters = new LinkedList<Type>();
        if (newTParameter != null && (args = newTParameter.args()) != null) {
            Iterator it = args.iterator();
            while (it.hasNext()) {
                typeParameters.add(((TypeNode)it.next()).type());
            }
        }
        TypeTranslator eval = xt.typeTranslator();
        DepParameterExpr dep = me.dep();
        boolean inAnnotation = ((HjContext)sc.context()).inAnnotation();
        if (inAnnotation) {
            baseType.setDepGen(null, null);
            HjType newBaseType = baseType.dep(dep);
            HjTypeNode result = ((HjTypeNode)newType.type(newBaseType)).dep(null, null);
            return result;
        }
        Constraint newParameter = dep == null ? null : eval.constraint(me.dep().condition());
        baseType.setDepGen(newParameter, null);
        HjType newBaseType = baseType.makeVariant(null, typeParameters);
        HjTypeNode result = ((HjTypeNode)newType.type(newBaseType)).dep(null, null);
        return result;
    }

    public static Node typeCheckDepClause(HjTypeNode me, TypeChecker tc) throws SemanticException {
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)1, (String)("[HjTypeNode_c static] typeCheckDepClause... entering|" + me + " " + me.getClass() + "|."));
        }
        if (!(me instanceof HjTypeNode)) {
            throw new SemanticException("Argument to parametric type node does not type-check" + me.position());
        }
        HjTypeNode arg = me;
        HjType argType = (HjType)arg.type();
        HjTypeSystem ts = (HjTypeSystem)argType.typeSystem();
        if (arg.dep() == null && arg.gen() == null) {
            return arg;
        }
        LinkedList<Type> tParameters = new LinkedList<Type>();
        if (me.gen() != null && me.gen().args() != null) {
            Iterator it = me.gen().args().iterator();
            while (it.hasNext()) {
                tParameters.add(((TypeNode)it.next()).type());
            }
        }
        DepParameterExpr d = arg.dep();
        boolean inAnnotation = ((HjContext)tc.context()).inAnnotation();
        if (inAnnotation) {
            HjType newArgType = argType;
            if (!tParameters.isEmpty()) {
                newArgType = tc instanceof TypeElaborator ? argType.makeDepVariant(null, tParameters) : argType.makeVariant(null, tParameters);
            }
            newArgType = newArgType.dep(d);
            HjTypeNode result = (HjTypeNode)arg.type(newArgType);
            result = result.dep(null, null);
            if (Report.should_report((String)"debug", (int)5)) {
                Report.report((int)1, (String)("[HjTypeNode_c static] typeCheckDepClause... returning |" + result + "|."));
            }
            return result;
        }
        TypeTranslator eval = ts.typeTranslator();
        Constraint term = eval.constraint(d.condition());
        HjType newArgType = tc instanceof TypeElaborator ? argType.makeDepVariant(term, tParameters) : argType.makeVariant(term, tParameters);
        HjTypeNode result = (HjTypeNode)arg.type(newArgType);
        result = result.dep(null, null);
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)1, (String)("[HjTypeNode_c static] typeCheckDepClause... returning |" + result + "|."));
        }
        return result;
    }

    public HjTypeNode gen(GenParameterExpr expr) {
        if (expr == this.gen) {
            return this;
        }
        HjTypeNode_c n = (HjTypeNode_c)this.copy();
        n.gen = expr;
        return n;
    }

    public HjTypeNode dep(DepParameterExpr expr) {
        if (expr == this.dep) {
            return this;
        }
        HjTypeNode_c n = (HjTypeNode_c)this.copy();
        n.dep = expr;
        return n;
    }

    public HjTypeNode dep(GenParameterExpr g, DepParameterExpr d) {
        if (g == this.gen && d == this.dep) {
            return this;
        }
        HjTypeNode_c n = (HjTypeNode_c)this.copy();
        n.gen = g;
        n.dep = d;
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        GenParameterExpr gen = (GenParameterExpr)this.visitChild((Node)this.gen, v);
        DepParameterExpr dep = (DepParameterExpr)this.visitChild((Node)this.dep, v);
        return this.dep(gen, dep);
    }

    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        return HjTypeNode_c.disambiguateDepClause(this, sc);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeNode n = (HjTypeNode)this.typeCheckBase(tc);
        return HjTypeNode_c.typeCheckDepClause(n, tc);
    }

    public Node typeCheckBase(TypeChecker tc) throws SemanticException {
        return super.typeCheck(tc);
    }

    public Node disambiguateBase(AmbiguityRemover tc) throws SemanticException {
        return super.disambiguate(tc);
    }

    public String toString() {
        return "/*nullable*/" + super.toString() + "/*<" + this.gen + ">(" + this.dep + ")*/";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter ignore) {
        w.write(this.toString());
    }
}

