/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.dom;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.dom.HjDom;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Source;

public class DomReader {
    HjTypeSystem ts;
    HjNodeFactory nf;
    Source source;
    Map<String, LazyTypeObject> typeMap;

    public DomReader(HjTypeSystem ts, HjNodeFactory nf, Source source) {
        this.ts = ts;
        this.nf = nf;
        this.source = source;
    }

    public Source source() {
        return this.source;
    }

    public polyglot.ast.Node fromXML(HjDom dom, Element e) {
        Element types = dom.getChild(e, "TypeSystem");
        this.buildTypeMap(dom, types);
        Element ast = dom.getChild(e, "AbstractSyntaxTree");
        ast = dom.getFirstElement(ast);
        polyglot.ast.Node n = new HjDom.NodeLens(dom).fromXML(this, ast);
        return n;
    }

    void buildTypeMap(HjDom dom, Element e) {
        this.typeMap = new HashMap<String, LazyTypeObject>();
        for (Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Text) continue;
            Element x = (Element)child;
            Element name = dom.getChild(x, "key");
            String key = new HjDom.StringLens(dom).fromXML(this, name);
            this.typeMap.put(key, new LazyTypeObject(x, new HjDom.TypeObjectLens(dom)));
        }
    }

    class LazyTypeObject {
        Object o;
        Element e;
        HjDom.TypeObjectLens lens;

        LazyTypeObject(Element e) {
        }

        LazyTypeObject(Element e, HjDom.TypeObjectLens lens) {
            this.e = e;
            this.lens = lens;
            lens.lto = this;
        }

        Object force(HjDom dom) {
            if (this.o != null) {
                return this.o;
            }
            this.o = dom.get(this.lens, this.e, "value", DomReader.this);
            return this.o;
        }
    }
}

