/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ext.hj.types.ClosureType;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Type_c;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureType_c
extends Type_c
implements ClosureType {
    private static final long serialVersionUID = 2768150875334536668L;
    protected Type returnType;
    protected List<Type> argumentTypes;
    protected List<Type> throwTypes;

    public ClosureType_c() {
    }

    public ClosureType_c(TypeSystem ts) {
        super(ts);
    }

    public ClosureType_c(TypeSystem ts, Position pos) {
        super(ts, pos);
    }

    public ClosureType_c(TypeSystem ts, Position pos, Type returnType, List<Type> argTypes) {
        this(ts, pos, returnType, argTypes, new ArrayList<Type>());
    }

    public ClosureType_c(TypeSystem ts, Position pos, Type returnType, List<Type> argTypes, List<Type> throwTypes) {
        this(ts, pos);
        this.returnType = returnType;
        this.argumentTypes = argTypes;
        this.throwTypes = throwTypes;
    }

    @Override
    public Type returnType() {
        return this.returnType;
    }

    @Override
    public void returnType(Type returnType) {
        this.returnType = returnType;
    }

    @Override
    public List<Type> argumentTypes() {
        return Collections.unmodifiableList(this.argumentTypes);
    }

    @Override
    public void argumentTypes(List<Type> argTypes) {
        this.argumentTypes = argTypes;
    }

    @Override
    public List<Type> throwTypes() {
        return Collections.unmodifiableList(this.throwTypes);
    }

    @Override
    public void throwTypes(List<Type> argTypes) {
        this.throwTypes = argTypes;
    }

    public boolean isCanonical() {
        Type t;
        Iterator<Type> it;
        boolean result = true;
        result &= this.returnType.isCanonical();
        if (this.argumentTypes != null) {
            it = this.argumentTypes.iterator();
            while (it.hasNext() && result) {
                t = it.next();
                result &= t.isCanonical();
            }
        }
        if (this.throwTypes != null) {
            it = this.throwTypes.iterator();
            while (it.hasNext() && result) {
                t = it.next();
                result &= t.isCanonical();
            }
        }
        return result;
    }

    public String translate(Resolver c) {
        throw new InternalCompilerError("Fix Me: cannot translate() a closure type yet.");
    }

    public boolean descendsFromImpl(Type t) {
        if (!(t instanceof ClosureType)) {
            return false;
        }
        ClosureType other = (ClosureType)t;
        if (!this.typeListEquals(this.argumentTypes, other.argumentTypes())) {
            return false;
        }
        if (!this.typeListEquals(this.throwTypes, other.throwTypes())) {
            return false;
        }
        return this.ts.descendsFrom(this.returnType, other.returnType());
    }

    public boolean typeEqualsImpl(Type t) {
        if (!(t instanceof ClosureType)) {
            return false;
        }
        ClosureType other = (ClosureType)t;
        if (!this.ts.typeEquals(this.returnType, other.returnType())) {
            return false;
        }
        if (!this.typeListEquals(this.argumentTypes, other.argumentTypes())) {
            return false;
        }
        return this.typeListEquals(this.throwTypes, other.throwTypes());
    }

    protected boolean typeListEquals(List<Type> l1, List<Type> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (this.ts.typeEquals(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Type type;
        StringBuffer buff = new StringBuffer();
        buff.append(this.returnType.toString()).append('(');
        Iterator<Type> iter = this.argumentTypes.iterator();
        while (iter.hasNext()) {
            type = iter.next();
            buff.append(type.toString());
            if (!iter.hasNext()) continue;
            buff.append(',');
        }
        buff.append(')');
        if (this.throwTypes.size() > 0) {
            buff.append(" throws ");
            iter = this.throwTypes.iterator();
            while (iter.hasNext()) {
                type = iter.next();
                buff.append(type.toString());
                if (!iter.hasNext()) continue;
                buff.append(',');
            }
        }
        return buff.toString();
    }
}

