/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types.constr;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Lit;
import polyglot.ast.Local;
import polyglot.ast.Receiver;
import polyglot.ext.hj.ast.Here;
import polyglot.ext.hj.ast.HjSpecial;
import polyglot.ext.hj.types.HjLocalInstance;
import polyglot.ext.hj.types.HjLocalInstance_c;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_EQV;
import polyglot.ext.hj.types.constr.C_EQV_c;
import polyglot.ext.hj.types.constr.C_Field;
import polyglot.ext.hj.types.constr.C_Field_c;
import polyglot.ext.hj.types.constr.C_Lit;
import polyglot.ext.hj.types.constr.C_Local;
import polyglot.ext.hj.types.constr.C_Root;
import polyglot.ext.hj.types.constr.C_Special;
import polyglot.ext.hj.types.constr.C_Special_c;
import polyglot.ext.hj.types.constr.C_Term;
import polyglot.ext.hj.types.constr.C_Term_c;
import polyglot.ext.hj.types.constr.C_UnaryTerm;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.types.constr.Failure;
import polyglot.ext.hj.types.constr.Promise;
import polyglot.ext.hj.types.constr.Promise_c;
import polyglot.ext.hj.types.constr.TypeTranslator;
import polyglot.main.Report;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constraint_c
implements Constraint,
Cloneable {
    protected HashMap<C_Var, Promise> roots;
    protected boolean placePossiblyNull;
    protected boolean placeIsHere;
    protected C_Term_c placeTerm;
    protected C_Var selfVar;
    boolean consistent = true;
    boolean valid = true;
    protected final HjTypeSystem typeSystem;
    protected int eqvCount;

    @Override
    public HashMap<C_Var, Promise> roots() {
        return this.roots;
    }

    @Override
    public int eqvCount() {
        return this.eqvCount;
    }

    @Override
    public boolean placeIsHere() {
        return this.placeIsHere;
    }

    @Override
    public boolean placePossiblyNull() {
        return this.placePossiblyNull;
    }

    @Override
    public C_Term placeTerm() {
        return this.placeTerm;
    }

    public Constraint_c(HjTypeSystem xts) {
        this.typeSystem = xts;
    }

    public Constraint_c(HjTypeSystem ts, int eqvCount, boolean consistent, boolean placeIsHere, C_Term placeTerm, boolean placePossiblyNull, Map<C_Var, Promise> roots, boolean valid, C_Var selfVar) {
        this(ts);
        this.eqvCount = eqvCount;
        this.consistent = consistent;
        this.placeIsHere = placeIsHere;
        this.placeTerm = (C_Term_c)placeTerm;
        this.placePossiblyNull = placePossiblyNull;
        this.roots = new HashMap<C_Var, Promise>(roots);
        this.valid = valid;
        this.selfVar = selfVar;
    }

    @Override
    public Constraint copy() {
        return this.copyInto(new Constraint_c(this.typeSystem));
    }

    @Override
    public Constraint clone() {
        try {
            Constraint_c clone = (Constraint_c)super.clone();
            if (this.roots != null) {
                clone.roots = new HashMap();
                HashMap<Promise, Promise> renaming = new HashMap<Promise, Promise>();
                for (Map.Entry<C_Var, Promise> m : this.roots.entrySet()) {
                    C_Var var = m.getKey();
                    Promise p = m.getValue();
                    Promise q = p.cloneRecursively(renaming);
                    clone.roots.put(var, q);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException z) {
            return null;
        }
    }

    private Constraint copyInto(Constraint_c c) {
        c.addIn(this);
        c.placePossiblyNull = this.placePossiblyNull;
        c.placeIsHere = this.placeIsHere;
        c.placeTerm = this.placeTerm;
        return c;
    }

    @Override
    public Constraint addIn(Constraint c) {
        if (c != null) {
            HashMap<C_Var, C_Var> result = c.constraints();
            this.addBindings(result);
            C_Var v = c.selfVar();
            if (v != null) {
                if (this.selfVar == null) {
                    this.selfVar = v;
                } else {
                    Constraint_c.addSelfBinding(v, this, this.typeSystem);
                }
            }
        }
        return this;
    }

    @Override
    public Constraint addBindings(HashMap<C_Var, C_Var> result) {
        if (result == null || result.isEmpty()) {
            return this;
        }
        for (Map.Entry<C_Var, C_Var> entry : result.entrySet()) {
            C_Var t1 = entry.getKey();
            C_Var t2 = entry.getValue();
            this.addBinding(t1, t2);
        }
        return this;
    }

    public static Constraint makeBinding(C_Var var, C_Var val, HjTypeSystem xts) {
        Constraint_c c = new Constraint_c(xts);
        return c.addBinding(var, val);
    }

    @Override
    public C_Var selfVar() {
        return this.selfVar;
    }

    public static Constraint addSelfBinding(C_Var val, Constraint c, HjTypeSystem xts) {
        Constraint constraint = c = c == null ? new Constraint_c(xts) : c;
        if (val instanceof C_Var && !(val instanceof C_Lit)) {
            c.setSelfVar(val);
            return c;
        }
        c = c.addBinding(C_Special.Self, val);
        return c;
    }

    @Override
    public void setSelfVar(C_Var var) {
        this.selfVar = var;
    }

    @Override
    public boolean consistent() {
        return this.consistent;
    }

    @Override
    public boolean valid() {
        return this.valid;
    }

    public boolean isLocal() {
        return this.placePossiblyNull || this.placeIsHere;
    }

    public boolean isPossiblyRemote() {
        return !this.isLocal();
    }

    @Override
    public Promise intern(C_Var term) {
        return this.intern(term, null);
    }

    public Promise intern(C_Term term, Promise last) {
        Promise p;
        if (term instanceof Promise) {
            Promise q = (Promise)((Object)term);
            if (last != null) {
                try {
                    last.bind(q);
                }
                catch (Failure f) {
                    throw new InternalCompilerError("A term ( " + term + ") cannot be interned to a promise (" + last + ") whose value is not null.");
                }
            }
            return q;
        }
        if (!(term instanceof C_Var)) {
            throw new InternalCompilerError("Cannot intern  term  " + term + "; it must be a promise or a C_Var, not " + term.getClass() + ".");
        }
        C_Var var = (C_Var)term;
        C_Var[] vars = var.vars();
        C_Var baseVar = vars[0];
        if (this.roots == null) {
            this.roots = new HashMap();
        }
        if ((p = this.roots.get(baseVar)) == null) {
            p = vars.length == 1 && last != null ? last : new Promise_c(baseVar);
            this.roots.put(baseVar, p);
        }
        return p.intern(vars, 1, last);
    }

    @Override
    public void internRecursively(C_Var v) {
        this.intern(v);
        this.propagateRecursively(v);
    }

    @Override
    public Promise lookup(C_Term term) {
        Promise result = this.lookupPartialOk(term);
        if (!(result instanceof Promise_c)) {
            return result;
        }
        C_Var var = (C_Var)term;
        C_Var[] vars = var.vars();
        Promise_c resultC = (Promise_c)result;
        int index = resultC.lookupReturnValue();
        return index == vars.length ? result : null;
    }

    @Override
    public Promise lookupPartialOk(C_Term term) {
        if (term == null) {
            return null;
        }
        if (term instanceof Promise) {
            return (Promise)((Object)term);
        }
        if (!(term instanceof C_Var)) {
            throw new InternalCompilerError("Cannot lookup  term  " + term + "; it must be a promise or a C_Var");
        }
        if (this.roots == null) {
            return null;
        }
        C_Var var = (C_Var)term;
        C_Var[] vars = var.vars();
        C_Var baseVar = vars[0];
        Promise p = this.roots.get(baseVar);
        if (p == null) {
            return null;
        }
        return p.lookup(vars, 1);
    }

    @Override
    public Constraint addBinding(C_Var t1, C_Var t2) {
        Constraint_c result;
        block11: {
            result = null;
            String oldString = this.toString();
            if (this.consistent) break block11;
            Constraint_c constraint_c = result = this;
            return constraint_c;
        }
        try {
            if (this.roots == null) {
                this.roots = new HashMap();
            }
            if (t1 == null) {
                t1 = this.typeSystem.NULL();
            }
            if (t2 == null) {
                t2 = this.typeSystem.NULL();
            }
            if (this.selfVar != null) {
                t1 = t1.substitute(C_Special_c.Self, this.selfVar);
                t2 = t2.substitute(C_Special_c.Self, this.selfVar);
            }
            Promise p1 = this.intern(t1);
            Promise p2 = this.intern(t2);
            boolean modified = p1.bind(p2);
            if (t1 instanceof C_Var) {
                this.possiblyAddTypeConstraint(t1, p2);
            }
            if (t2 instanceof C_Var) {
                this.possiblyAddTypeConstraint(t2, p2);
            }
            this.valid &= !modified;
            result = this;
        }
        catch (Failure z) {
            this.consistent = false;
            throw new InternalCompilerError("Adding binding " + t1 + "=" + t2 + " to " + this + " has made it inconsistent.");
        }
        return result;
    }

    public Constraint addBindingPromise(C_Var t1, Promise p) {
        try {
            if (!this.consistent) {
                return this;
            }
            if (this.roots == null) {
                this.roots = new HashMap();
            }
            if (t1 == null) {
                t1 = this.typeSystem.NULL();
            }
            if (this.selfVar != null) {
                t1 = t1.substitute(C_Special_c.Self, this.selfVar);
            }
            Promise p1 = this.intern(t1);
            boolean modified = p1.bind(p);
        }
        catch (Failure z) {
            this.consistent = false;
            throw new InternalCompilerError("Adding binding " + t1 + "=" + p + " to " + this + " has made it inconsistent.");
        }
        return this;
    }

    private C_Var rootBindingForTerm(C_Var t1) {
        C_Var result = null;
        C_Var t1Root = t1.rootVar();
        HjType xType = (HjType)t1Root.type();
        if (t1Root.equals(C_Special_c.Self) || xType != null) {
            Constraint_c c;
            Constraint constraint = c = t1Root.equals(C_Special_c.Self) ? this : ((HjType)t1Root.type()).realClause();
            if (c != null) {
                C_Var sVar;
                Promise p;
                C_Var cVar;
                Constraint xd;
                Constraint constraint2 = xd = xType == null ? null : xType.depClause();
                if (xd != null && t1Root.equals(cVar = xd.selfVar())) {
                    t1 = t1.substitute(C_Special_c.Self, cVar);
                }
                if ((p = c.lookup(t1)) != null && (result = p.term()) instanceof C_Var && result.rootVar().equals(C_Special.Self) && xd != null && (sVar = xd.selfVar()) != null) {
                    result = result.substitute(sVar, C_Special_c.Self);
                }
            }
        }
        return result;
    }

    private void possiblyAddTypeConstraint(C_Var t1, Promise target) {
        C_Var p1Root = t1.rootVar();
        Type type = p1Root.type();
        if (type != null) {
            HjType xType = (HjType)type;
            if (p1Root.equals(C_Special.Self)) {
                return;
            }
            Constraint c = xType.realClause();
            if (c != null) {
                Promise p;
                C_Var cVar;
                C_Var t1Root = t1.rootVar();
                Constraint xd = xType.depClause();
                if (xd != null && t1Root.equals(cVar = xd.selfVar())) {
                    t1 = t1.substitute(C_Special_c.Self, cVar);
                }
                if ((p = c.lookup(t1)) != null) {
                    C_Var t3 = p.term();
                    if (t3 instanceof C_Var && t3.rootVar().equals(C_Special.Self)) {
                        C_Var sVar;
                        if (xd != null && (sVar = xd.selfVar()) != null) {
                            t3 = t3.substitute(sVar, C_Special_c.Self);
                            this.addBindingPromise(t3, target);
                        }
                    } else {
                        this.addBindingPromise(t3, target);
                    }
                }
            }
        }
    }

    @Override
    public Constraint addTerm(C_Var term) throws Failure {
        C_UnaryTerm t;
        String op;
        C_Lit val = this.typeSystem.TRUE();
        if (term instanceof C_UnaryTerm && (op = (t = (C_UnaryTerm)((Object)term)).op()).equals("!")) {
            return this.addBinding((C_Var)t.arg(), val.not());
        }
        return this.addBinding(term, val);
    }

    @Override
    public boolean entails(Constraint other) {
        if (!this.consistent()) {
            return true;
        }
        if (other == null || other.valid()) {
            return true;
        }
        boolean result = other.entailedBy(this);
        if (Report.should_report((String)"types", (int)1)) {
            Report.report((int)1, (String)(this + (result ? " entails " : " does not entail ") + other));
        }
        return result;
    }

    @Override
    public HashMap<C_Var, C_Var> constraints() {
        return this.constraints(new HashMap<C_Var, C_Var>());
    }

    @Override
    public HashMap<C_Var, C_Var> constraints(HashMap<C_Var, C_Var> result) {
        return this.constraints(result, null, null);
    }

    @Override
    public HashMap<C_Var, C_Var> constraints(HashMap<C_Var, C_Var> result, C_Var newSelf, C_Var newThis) {
        return this.constraints(result, null, newSelf, newThis);
    }

    public HashMap<C_Var, C_Var> constraints(HashMap<C_Var, C_Var> result, C_Term prefix, C_Var newSelf, C_Var newThis) {
        if (this.roots == null) {
            return result;
        }
        Iterator<Promise> it = this.roots.values().iterator();
        while (it.hasNext()) {
            it.next().dump(result, prefix, newSelf, newThis);
        }
        return result;
    }

    @Override
    public HashMap<C_Var, C_Var> constraints(C_Var y) {
        Promise p = this.lookup(y);
        if (p == null) {
            return new HashMap<C_Var, C_Var>();
        }
        C_Var rep = p.term();
        return this.constraints(rep, C_Special.Self);
    }

    @Override
    public HashMap<C_Var, C_Var> constraints(C_Var y, C_Var newSelf) {
        HashMap<C_Var, C_Var> result = new HashMap<C_Var, C_Var>();
        return this.constraints(result, y, newSelf, C_Special.This);
    }

    @Override
    public boolean entailedBy(Constraint other) {
        if (!other.consistent() || this.valid()) {
            return true;
        }
        assert (this.roots != null);
        HashMap<C_Var, C_Var> result = this.constraints();
        other.saturate();
        for (Map.Entry<C_Var, C_Var> entry : result.entrySet()) {
            if (other.entails(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean entails(C_Var t1, C_Var t2) {
        C_Var t2r;
        C_Var t1r;
        boolean result = this.entailsImmed(t1, t2);
        if (result) {
            return result;
        }
        if (t1 instanceof C_Var && (result = this.checkSelfEntails(t1, t2))) {
            return result;
        }
        if (t1 instanceof C_Var && (t1r = this.rootBindingForTerm(t1)) != null && !t1r.equals(t1) && this.entails(t1r, t2)) {
            return true;
        }
        return t2 instanceof C_Var && (t2r = this.rootBindingForTerm(t2)) != null && !t2r.equals(t2) && this.entails(t1, t2r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean entailsImmed(C_Var t1, C_Var t2) {
        Promise p2;
        Promise p1;
        boolean result = false;
        if (!this.consistent) {
            return true;
        }
        if (this.selfVar != null) {
            t1 = t1.substitute(C_Special_c.Self, this.selfVar);
            t2 = t2.substitute(C_Special_c.Self, this.selfVar);
        }
        if ((p1 = this.lookupPartialOk(t1)) == null) {
            return false;
        }
        int r1Count = 0;
        C_Var[] vars1 = null;
        if (p1 instanceof Promise_c) {
            r1Count = ((Promise_c)p1).lookupReturnValue();
            vars1 = t1.vars();
        }
        if ((p2 = this.lookupPartialOk(t2)) == null) {
            return false;
        }
        int r2Count = 0;
        C_Var[] vars2 = null;
        if (p2 instanceof Promise_c) {
            r2Count = ((Promise_c)p2).lookupReturnValue();
            vars2 = t2.vars();
        }
        if (r1Count == 0 || r1Count == vars1.length) {
            result = p1.equals(p2);
            if (r2Count == 0) return result;
            if (r2Count == vars2.length) {
                return result;
            }
        }
        if (!p1.equals(p2)) {
            return false;
        }
        int residual1 = vars1.length - r1Count;
        int residual2 = vars2.length - r2Count;
        if (residual1 != residual2) {
            return false;
        }
        int i = 0;
        while (true) {
            if (i >= residual1) {
                return true;
            }
            if (!vars1[r1Count + i].name().equals(vars2[r2Count + i].name())) {
                return false;
            }
            ++i;
        }
    }

    protected boolean checkSelfEntails(C_Var var, C_Term val) {
        if (this.selfVar == null) {
            return false;
        }
        C_Var var1 = var.substitute(this.selfVar, C_Special.Self);
        boolean result = var1.equals(val);
        return result;
    }

    @Override
    public boolean equiv(Constraint other) {
        boolean result = this.entails(other);
        if (result) {
            result = other == null ? this.valid : other.entails(this);
        }
        return result;
    }

    @Override
    public C_Var find(String varName) {
        if (!this.consistent || this.roots == null) {
            return null;
        }
        Promise self = this.roots.get(C_Special_c.Self);
        Promise result = self.lookup(varName);
        return result == null ? null : result.term();
    }

    public String toString() {
        String str = this.constraints().toString();
        return "(:" + str.substring(1, str.length() - 1) + ")";
    }

    @Override
    public C_EQV genEQV(Type type, boolean isSelfVar) {
        return this.genEQV(type, isSelfVar, true);
    }

    @Override
    public C_EQV genEQV(Type type, boolean isSelfVar, boolean hidden) {
        String name = "_" + this.eqvCount++;
        HjTypeSystem xts = (HjTypeSystem)type.typeSystem();
        HjLocalInstance_c li = new HjLocalInstance_c(xts, Position.COMPILER_GENERATED, Flags.FINAL, type, name);
        C_EQV_c result = new C_EQV_c(li, isSelfVar, hidden);
        return result;
    }

    @Override
    public Constraint substitute(C_Var y, C_Root x) {
        return this.substitute(y, x, true);
    }

    @Override
    public Constraint substitute(C_Var y, C_Root x, boolean propagate) {
        assert (y != null && x != null);
        if (y.equals(x)) {
            return this;
        }
        Promise last = this.lookupPartialOk(x);
        if (last == null) {
            return this;
        }
        Constraint result = this.clone();
        result.applySubstitution(y, x, propagate);
        return result;
    }

    @Override
    public Constraint substitute(HashMap<C_Root, C_Var> subs) {
        return this.substitute(subs, true);
    }

    @Override
    public Constraint substitute(HashMap<C_Root, C_Var> subs, boolean propagate) {
        if (subs == null || subs.isEmpty()) {
            return this;
        }
        boolean notneeded = true;
        Iterator<Map.Entry<C_Root, C_Var>> it = subs.entrySet().iterator();
        while (notneeded && it.hasNext()) {
            Map.Entry<C_Root, C_Var> e = it.next();
            C_Root x = e.getKey();
            C_Var y = e.getValue();
            notneeded = y.equals(x) || this.lookupPartialOk(x) == null;
        }
        if (notneeded) {
            return this;
        }
        Constraint result = this.clone();
        result.applySubstitution(subs, propagate);
        return result;
    }

    @Override
    public Constraint substitute(C_Var[] ys, C_Root[] xs) {
        return this.substitute(ys, xs, true);
    }

    @Override
    public Constraint substitute(C_Var[] ys, C_Root[] xs, boolean propagate) {
        assert (xs.length == ys.length);
        int n = xs.length;
        Constraint result = null;
        for (int i = 0; i < n; ++i) {
            C_Var y = ys[i];
            C_Root x = xs[i];
            if (y.equals(x) || this.lookupPartialOk(x) == null) continue;
            if (result == null) {
                result = this.clone();
            }
            result.applySubstitution(y, x, propagate);
        }
        return result == null ? this : result;
    }

    @Override
    public void applySubstitution(HashMap<C_Root, C_Var> subs, boolean propagate) {
        for (Map.Entry<C_Root, C_Var> e : subs.entrySet()) {
            C_Root x = e.getKey();
            C_Var y = e.getValue();
            this.applySubstitution(y, x, propagate);
        }
    }

    @Override
    public void applySubstitution(C_Var y, C_Root x, boolean propagate) {
        if (this.roots == null) {
            return;
        }
        Promise p = this.roots.get(x);
        if (p == null) {
            return;
        }
        this.roots.remove(x);
        Promise q = this.intern(y);
        this.replace(q, p);
        if (p instanceof C_Lit) {
            try {
                q.bind(p);
            }
            catch (Failure f) {
                throw new InternalCompilerError("Error in replacing " + x + " with " + y + " in " + this + ": binding failure with " + p);
            }
            if (propagate) {
                this.propagate(y);
            }
            return;
        }
        Promise xf = p.value();
        if (xf != null) {
            try {
                q.bind(xf);
            }
            catch (Failure f) {
                throw new InternalCompilerError("Error in replacing " + x + " with " + y + " in " + this + ": binding failure with " + xf);
            }
        } else {
            HashMap<String, Promise> fields = p.fields();
            if (fields != null) {
                for (Map.Entry<String, Promise> entry : fields.entrySet()) {
                    String s = entry.getKey();
                    Promise orphan = entry.getValue();
                    try {
                        q.addIn(s, orphan);
                        C_Field oldTerm = (C_Field)orphan.term();
                        FieldInstance oldfi = oldTerm.fieldInstance();
                        C_Field_c newTerm = new C_Field_c(oldfi, q.term());
                        orphan.setTerm(newTerm);
                    }
                    catch (Failure f) {
                        throw new InternalCompilerError("Error in replacing " + x + " with " + y + " in " + this + ": failure in forwarding " + entry);
                    }
                }
            }
        }
        if (propagate) {
            this.propagate(y);
        }
    }

    public void replace(Promise y, Promise x) {
        Collection<Promise> rootPs = this.roots.values();
        for (Promise p : rootPs) {
            if (p.equals(x)) continue;
            p.replaceDescendant(y, x);
        }
    }

    public void propagate(C_Var y) {
        HjType yType = (HjType)y.type();
        if (yType == null) {
            return;
        }
        Constraint yTypeRC = yType.realClause();
        if (yTypeRC == null) {
            return;
        }
        yTypeRC = yTypeRC.clone();
        yTypeRC.setSelfVar(null);
        yTypeRC = yTypeRC.substitute(y, C_Special.Self, false);
        this.addIn(yTypeRC);
    }

    public void propagateRecursively(C_Var y) {
        HjType yType = (HjType)y.type();
        if (yType == null) {
            return;
        }
        Constraint yTypeRC = yType.realClause();
        if (yTypeRC == null) {
            return;
        }
        yTypeRC = yTypeRC.clone();
        yTypeRC.setSelfVar(null);
        yTypeRC.saturate();
        yTypeRC = yTypeRC.substitute(y, C_Special.Self, false);
        this.addIn(yTypeRC);
    }

    @Override
    public void saturate() {
        if (this.roots != null) {
            HashMap rootSnapshot = (HashMap)this.roots.clone();
            for (C_Var var : rootSnapshot.keySet()) {
                this.propagateRecursively(var);
            }
        }
    }

    @Override
    public boolean entailsType(C_Var y) {
        assert (y != null);
        HjType yType = (HjType)y.type();
        Constraint yTypeRC = yType.realClause();
        HashMap<C_Var, C_Var> yTypeRCSubtermBindings = yTypeRC.constraints(C_Special.Self, y);
        boolean result = true;
        Iterator<Map.Entry<C_Var, C_Var>> it2 = yTypeRCSubtermBindings.entrySet().iterator();
        while (result && it2.hasNext()) {
            Map.Entry<C_Var, C_Var> e2 = it2.next();
            C_Var yp = e2.getKey();
            C_Var t1 = e2.getValue();
            result = this.entails(yp, t1);
        }
        return result;
    }

    @Override
    public Constraint instantiate(List<HjType> list) {
        String thisString = this.toString();
        HashMap<C_Local, C_Var> subs = null;
        Set<C_Var> roots = this.roots().keySet();
        for (C_Var var : roots) {
            if (!(var instanceof C_Local)) continue;
            C_Local local = (C_Local)var;
            HjLocalInstance li = local.localInstance();
            int p = li.positionInArgList();
            if (p > list.size()) {
                throw new InternalCompilerError("The argument index " + p + " in constraint " + this + " is out of bounds for " + " argument types " + li + ".");
            }
            if (p < 0) continue;
            HjType type = list.get(p);
            C_Var selfVar = type.selfVar();
            if (selfVar == null) {
                selfVar = this.genEQV(li.type(), true);
            }
            if (subs == null) {
                subs = new HashMap<C_Local, C_Var>();
            }
            subs.put(local, selfVar);
        }
        Constraint result = this;
        if (subs != null && !subs.isEmpty()) {
            result = this.substitute((HashMap<C_Root, C_Var>)subs, false);
        }
        return result;
    }

    @Override
    public boolean hasVar(C_Root v) {
        if (this.roots == null) {
            return false;
        }
        return this.roots.keySet().contains(v);
    }

    @Override
    public C_Var selfVar(Expr arg) {
        return this.selfVar(arg, true);
    }

    @Override
    public C_Var selfVar(Expr arg, boolean hidden) {
        C_Var result = null;
        if (Constraint_c.rigid(arg)) {
            try {
                result = (C_Var)new TypeTranslator(this.typeSystem).trans((Receiver)arg);
            }
            catch (SemanticException z) {
                throw new InternalCompilerError("Unexpected error " + (Object)((Object)z) + " while trying to convert the rigid term " + arg + " to a C_Var.");
            }
            return result;
        }
        if (result == null) {
            result = this.genEQV(arg.type(), true, hidden);
        }
        return result;
    }

    public static boolean rigid(Receiver arg) {
        if (arg instanceof HjType) {
            return true;
        }
        if (arg instanceof Expr) {
            return Constraint_c.rigid((Expr)arg);
        }
        assert (false);
        return false;
    }

    public static boolean rigid(Expr arg) {
        boolean result = false;
        if (arg instanceof Field) {
            Field f = (Field)arg;
            result = Constraint_c.rigid(f.target()) && f.flags().isFinal();
            return result;
        }
        if (arg instanceof Local) {
            result = ((Local)arg).flags().isFinal();
            return result;
        }
        if (arg instanceof Lit || arg instanceof HjSpecial || arg instanceof Here) {
            result = true;
            return true;
        }
        return result;
    }
}

