/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.HashSet;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.New;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ext.hj.ast.Async;
import polyglot.ext.hj.ast.Future;
import polyglot.visit.NodeVisitor;

public class AsyncElimination
extends NodeVisitor {
    private final boolean DEBUG_ = false;

    public Node leave(Node old, Node n, NodeVisitor v) {
        Node ret = n;
        if (n instanceof Async) {
            Async as = (Async)n;
            Stmt as_body = as.body();
            Stmt simple_stmt = this.checkIfSimpleBlock_(as_body);
            if (simple_stmt != null && this.isOptimizableStmt_(simple_stmt)) {
                ret = simple_stmt;
            }
        } else if (n instanceof Call) {
            Future f;
            Expr f_expr;
            Call c = (Call)n;
            List args = c.arguments();
            Receiver r = c.target();
            if ("force".equals(c.name()) && args.size() == 0 && r instanceof Future && this.isOptimizableExpr_(f_expr = (f = (Future)r).body())) {
                ret = f_expr;
            }
        }
        return ret;
    }

    private Stmt checkIfSimpleBlock_(Stmt s) {
        Stmt the_one_stmt = null;
        if (s instanceof Block) {
            Block b = (Block)s;
            List l = b.statements();
            if (l.size() == 1) {
                the_one_stmt = (Stmt)l.get(0);
            }
        } else {
            the_one_stmt = s;
        }
        return the_one_stmt;
    }

    private boolean isOptimizableStmt_(Stmt s) {
        Eval e;
        Expr e_expr;
        boolean ret = false;
        if (s instanceof Eval && (e_expr = (e = (Eval)s).expr()) instanceof Assign) {
            Assign a_expr = (Assign)e_expr;
            ret = this.isOptimizableExpr_(a_expr.right());
        }
        return ret;
    }

    private boolean isOptimizableExpr_(Expr e) {
        final HashSet critical = new HashSet();
        e.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                if (n instanceof ProcedureCall || n instanceof Future || n instanceof New || n instanceof NewArray) {
                    critical.add(n);
                }
                return n;
            }
        });
        return critical.isEmpty();
    }
}

