/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.SemanticError;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class DepParameterExpr_c
extends Expr_c
implements DepParameterExpr {
    protected List args;
    protected Expr condition;

    public DepParameterExpr_c(Position pos, List l) {
        this(pos, l, null);
    }

    public DepParameterExpr_c(Position pos, Expr cond) {
        this(pos, Collections.EMPTY_LIST, cond);
    }

    public DepParameterExpr_c(Position pos, List l, Expr cond) {
        super(pos);
        this.args = TypedList.copyAndCheck((List)l, Expr.class, (boolean)false);
        this.condition = cond;
    }

    public Expr condition() {
        return this.condition;
    }

    public List args() {
        return this.args;
    }

    public DepParameterExpr condition(Expr condition) {
        DepParameterExpr_c n = (DepParameterExpr_c)this.copy();
        n.condition = condition;
        return n;
    }

    public DepParameterExpr args(List args) {
        DepParameterExpr_c n = (DepParameterExpr_c)this.copy();
        n.args = args;
        return n;
    }

    public DepParameterExpr reconstruct(List args, Expr condition) {
        if (args == this.args && condition == this.condition) {
            return this;
        }
        DepParameterExpr_c n = (DepParameterExpr_c)this.copy();
        n.condition = condition;
        n.args = args;
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        List arguments = this.visitList(this.args, v);
        Expr condition = (Expr)this.visitChild((Node)this.condition, v);
        return this.reconstruct(arguments, condition);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        DepParameterExpr_c n = (DepParameterExpr_c)super.disambiguate(ar);
        if (((HjContext)ar.context()).inAnnotation() && this.condition == null) {
            return n.condition((Expr)ar.nodeFactory().BooleanLit(this.position(), true));
        }
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        if (this.condition == null) {
            throw new SemanticError("The condition of a dependent type clause must be non-empty.", this.position());
        }
        Type t = this.condition.type();
        if (!t.isBoolean()) {
            throw new SemanticError("The type of the depclause, " + this.condition + ", must be boolean and not " + t + ".", this.position());
        }
        return this.type(t);
    }

    public Term entry() {
        return this.args.isEmpty() ? this.condition.entry() : DepParameterExpr_c.listEntry((List)this.args, (Term)this);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.args == null) {
            if (this.condition != null) {
                v.visitCFG((Term)this.condition, (Term)this);
            }
        } else if (this.condition != null) {
            v.visitCFGList(this.args, this.condition.entry());
            v.visitCFG((Term)this.condition, (Term)this);
        } else {
            v.visitCFGList(this.args, (Term)this);
        }
        return succs;
    }

    public String toString() {
        String s = "(";
        int count = 0;
        Iterator i = this.args.iterator();
        while (i.hasNext()) {
            if (count++ > 2) {
                s = s + "...";
                break;
            }
            Expr n = (Expr)i.next();
            s = s + n.toString();
            if (!i.hasNext()) continue;
            s = s + ", ";
        }
        if (this.condition != null) {
            s = s + ":" + this.condition;
        }
        return s + ")";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.args.isEmpty() && this.condition == null) {
            return;
        }
        if (this.args.isEmpty()) {
            w.write("(:");
            this.printBlock((Node)this.condition, w, tr);
            w.write(")");
            return;
        }
        w.write("(");
        w.begin(0);
        Iterator it = this.args.iterator();
        while (it.hasNext()) {
            Expr e = (Expr)it.next();
            this.print((Node)e, w, tr);
            if (!it.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        if (this.condition != null) {
            this.print((Node)this.condition, w, tr);
        }
        w.write(")");
    }
}

