/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.ForLoop;
import polyglot.ext.hj.ast.HjLoop_c;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class ForLoop_c
extends HjLoop_c
implements ForLoop {
    public ForLoop_c(Position pos) {
        super(pos);
    }

    public ForLoop_c(Position pos, Formal formal, Expr domain, Stmt body) {
        super(pos, formal, domain, body);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.formal, this.domain.entry());
        v.visitCFG((Term)this.domain, FlowGraph.EDGE_KEY_TRUE, this.body.entry(), FlowGraph.EDGE_KEY_FALSE, (Term)this);
        v.push((Stmt)this).visitCFG((Term)this.body, this.continueTarget());
        return succs;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Expr newDomain;
        HjType type;
        ForLoop_c n = (ForLoop_c)super.typeCheck(tc);
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        if (ts.isDistribution(type = (HjType)(newDomain = n.domain).type())) {
            newDomain = (Expr)tc.nodeFactory().Field(n.position(), (Receiver)newDomain, tc.nodeFactory().Id(n.position(), "region")).del().typeCheck(tc);
        }
        return n.domain(newDomain);
    }

    public boolean condIsConstant() {
        return false;
    }

    public boolean condIsConstantTrue() {
        return false;
    }

    public String toString() {
        return "for (" + this.formal + ":" + this.domain + ")" + this.body;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("for(");
        this.printBlock((Node)this.formal, w, tr);
        w.write(" : ");
        this.printBlock((Node)this.domain, w, tr);
        w.write(") ");
        this.printSubStmt(this.body, w, tr);
    }
}

