/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.Future;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.RemoteActivityInvocation;
import polyglot.ext.hj.ast.StmtSeq;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.visit.ExprFlattener;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.ReachChecker;
import polyglot.visit.TypeChecker;

public class Future_c
extends Expr_c
implements Future {
    public Expr place;
    public Expr body;
    public StmtSeq stmt;

    public Future_c(Position p, Expr place, Expr body) {
        super(p);
        this.place = place;
        this.body = body;
    }

    public Future_c(Position p) {
        super(p);
    }

    public Node getArgument(int id) {
        if (id == 0) {
            return this.place;
        }
        if (id == 1) {
            return this.body;
        }
        assert (false);
        return null;
    }

    public Future stmt(StmtSeq stmt) {
        Future_c n = (Future_c)this.copy();
        n.stmt = stmt;
        return n;
    }

    public Future body(Expr body) {
        Future_c n = (Future_c)this.copy();
        n.body = body;
        return n;
    }

    public StmtSeq stmt() {
        return this.stmt;
    }

    public void setStmt(StmtSeq s) {
        this.stmt = s;
    }

    public void setExpr(Expr e) {
        this.body = e;
    }

    public void setPlace(Expr e) {
        this.place = e;
    }

    public Expr body() {
        return this.body;
    }

    public Expr place() {
        return this.place;
    }

    public RemoteActivityInvocation place(Expr place) {
        this.place = place;
        return this;
    }

    protected Future_c reconstruct(Expr place, Expr body, StmtSeq stmt) {
        if (place != this.place || body != this.body || stmt != this.stmt) {
            Future_c n = (Future_c)this.copy();
            n.place = place;
            n.body = body;
            n.stmt = stmt;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr place = (Expr)this.visitChild((Node)this.place, v);
        Expr body = (Expr)this.visitChild((Node)this.body, v);
        StmtSeq s = this.stmt;
        s = v instanceof ReachChecker ? (s == null ? null : (StmtSeq)this.stmt.reachable(true)) : (s == null ? null : (StmtSeq)this.visitChild((Node)this.stmt, v));
        return this.reconstruct(place, body, s);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
        Type placeType = this.place.type();
        Expr newPlace = this.place;
        boolean placeIsPlace = ts.isImplicitCastValid(placeType, (Type)ts.place());
        if (!placeIsPlace) {
            newPlace = (Expr)nf.Field(this.position(), (Receiver)this.place, nf.Id(this.position(), "location")).del().typeCheck(tc);
        }
        return ((Future_c)this.place(newPlace)).type(ts.createFutureType(this.position(), (HjNamedType)this.body.type()));
    }

    public Future flatten(ExprFlattener.Flattener fc) {
        this.place = (Expr)this.place.visit((NodeVisitor)fc);
        HjContext xc = (HjContext)fc.context();
        ExprFlattener.Flattener newVisitor = (ExprFlattener.Flattener)new ExprFlattener.Flattener(fc.job(), fc.typeSystem(), fc.nodeFactory(), (Node)this).context(xc);
        this.body = (Expr)this.body.visit((NodeVisitor)newVisitor);
        List l = newVisitor.stmtList();
        if (!l.isEmpty()) {
            if (this.stmt == null) {
                HjNodeFactory xnf = (HjNodeFactory)fc.nodeFactory();
                this.stmt = xnf.StmtSeq(Position.COMPILER_GENERATED, l);
            } else {
                List ll = this.stmt.statements();
                ll.add(l);
                this.stmt = (StmtSeq)this.stmt.statements(ll);
            }
        }
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        HjTypeSystem ts = (HjTypeSystem)av.typeSystem();
        if (child == this.place) {
            return ts.place();
        }
        return child.type();
    }

    public String toString() {
        return " future ( " + this.place + " ) { " + this.stmt + " " + this.body + "}";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("future (");
        this.printSubExpr(this.place, false, w, tr);
        w.write(" ) {  ");
        this.printSubExpr(this.body, false, w, tr);
        w.write("}");
    }

    public Term entry() {
        return this.place.entry();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.place, (Term)this.body());
        if (this.stmt != null) {
            v.visitCFG((Term)this.body, (Term)this.stmt);
            v.visitCFG((Term)this.stmt, (Term)this);
        } else {
            v.visitCFG((Term)this.body, (Term)this);
        }
        return succs;
    }
}

