/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.GenParameterExpr;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class GenParameterExpr_c
extends Expr_c
implements GenParameterExpr {
    protected List args;

    public GenParameterExpr_c(Position pos, List l) {
        super(pos);
        this.args = TypedList.copyAndCheck((List)l, TypeNode.class, (boolean)false);
    }

    public List args() {
        return this.args;
    }

    public GenParameterExpr args(List args) {
        GenParameterExpr_c n = (GenParameterExpr_c)this.copy();
        n.args = args;
        return n;
    }

    public GenParameterExpr reconstruct(List args) {
        if (args == this.args) {
            return this;
        }
        GenParameterExpr_c n = (GenParameterExpr_c)this.copy();
        n.args = args;
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        List arguments = this.visitList(this.args, v);
        return this.reconstruct(arguments);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.args == null || this.args.isEmpty()) {
            return this;
        }
        LinkedList<Node> newArgs = new LinkedList<Node>();
        for (TypeNode t : this.args) {
            newArgs.add(t.disambiguate(ar));
        }
        return this.args(newArgs);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        if (!this.type.isCanonical()) {
            return this.type((Type)ts.Object());
        }
        return this;
    }

    public Term entry() {
        return this.args.isEmpty() ? null : GenParameterExpr_c.listEntry((List)this.args, (Term)this);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.args != null) {
            v.visitCFGList(this.args, (Term)this);
        }
        return succs;
    }

    public String toString() {
        String s = "<";
        int count = 0;
        Iterator i = this.args.iterator();
        while (i.hasNext()) {
            if (count++ > 2) {
                s = s + "...";
                break;
            }
            TypeNode n = (TypeNode)i.next();
            s = s + n.toString();
            if (!i.hasNext()) continue;
            s = s + ", ";
        }
        return s + ">";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.args == null || this.args.isEmpty()) {
            return;
        }
        w.write("<");
        w.begin(0);
        Iterator it = this.args.iterator();
        while (it.hasNext()) {
            Expr e = (Expr)it.next();
            this.print((Node)e, w, tr);
            if (!it.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(">");
    }
}

