/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.HjSpecial;
import polyglot.ext.hj.ast.Isolated;
import polyglot.ext.hj.ast.ParExpr;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Isolated_c
extends Stmt_c
implements Isolated {
    public Stmt body;
    public List objects;

    public Isolated_c(Position p, List objects, Stmt body) {
        super(p);
        this.objects = objects;
        this.body = body;
    }

    public Isolated_c(Position p) {
        super(p);
    }

    public Stmt body() {
        return this.body;
    }

    public Isolated body(Stmt body) {
        Isolated_c n = (Isolated_c)this.copy();
        n.body = body;
        return n;
    }

    public List objects() {
        return this.objects;
    }

    protected Isolated reconstruct(Stmt body) {
        if (body != this.body) {
            Isolated_c n = (Isolated_c)this.copy();
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(body);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        if (this.objects != null) {
            for (Expr tn : this.objects()) {
                if (tn instanceof ParExpr) {
                    tn = ((ParExpr)tn).expr();
                }
                Type t = tn.type();
                if (tn != null && tn instanceof HjSpecial) {
                    t = ((HjContext)tc.context()).currentClass();
                }
                if (t != null && t.isSubtype((Type)ts.HjObject())) continue;
                throw new SemanticException("Type \"" + t + "\" in isolated list must be hj.lang.Object.");
            }
        }
        return this;
    }

    public Context enterScope(Context c) {
        HjContext cc = (HjContext)super.enterScope(c);
        cc = cc.pushIsolatedBlock();
        return cc;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        HjTypeSystem ts = (HjTypeSystem)av.typeSystem();
        return child.type();
    }

    public String toString() {
        return "isolated  { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("isolated ");
        this.printSubStmt(this.body, w, tr);
    }

    public Term entry() {
        return this.body.entry();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.push((Stmt)this).visitCFG((Term)this.body, (Term)this);
        return succs;
    }
}

