/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.util.Collection;
import java.util.List;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjFieldInstance;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.Context_c;
import polyglot.types.FieldInstance;
import polyglot.types.ImportTable;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CollectionUtil;

public class HjContext_c
extends Context_c
implements HjContext {
    protected HjNamedType depType = null;
    protected VarInstance varWhoseTypeIsBeingElaborated = null;
    public static final Context_c.Kind ASYNC = new Context_c.Kind("async");
    public static final Context_c.Kind WHEN = new Context_c.Kind("when");
    protected boolean inSafeCode;
    protected boolean inSequentialCode;
    protected boolean inLocalCode;
    protected boolean inNonBlockingCode;
    protected boolean inAnnotation;
    protected Context_c.Kind hjKind;
    private static final Collection TOPICS = CollectionUtil.list((Object)"types", (Object)"context");
    protected static int varCount = 0;

    public HjContext_c(TypeSystem ts) {
        super(ts);
    }

    public boolean inDepType() {
        return this.depType != null;
    }

    public boolean inAsync() {
        return this.hjKind != null && this.hjKind == ASYNC;
    }

    public boolean inWhen() {
        return this.hjKind != null && this.hjKind == WHEN;
    }

    public boolean inSafeCode() {
        return this.inSafeCode;
    }

    public boolean inSequentialCode() {
        return this.inSequentialCode;
    }

    public boolean inNonBlockingCode() {
        return this.inNonBlockingCode;
    }

    public boolean inLocalCode() {
        return this.inLocalCode;
    }

    public boolean inAnnotation() {
        return this.inAnnotation;
    }

    public void setSafeCode() {
        this.inSafeCode = true;
    }

    public void setSequentialCode() {
        this.inSequentialCode = true;
    }

    public void setNonBlockingCode() {
        this.inNonBlockingCode = true;
    }

    public void setLocalCode() {
        this.inLocalCode = true;
    }

    public void setAnnotation() {
        this.inAnnotation = true;
    }

    public void clearAnnotation() {
        this.inAnnotation = false;
    }

    protected Context_c push() {
        HjContext_c v = (HjContext_c)super.push();
        v.depType = null;
        v.hjKind = null;
        v.varWhoseTypeIsBeingElaborated = null;
        return v;
    }

    public HjNamedType currentDepType() {
        return this.depType;
    }

    public VarInstance varWhoseTypeIsBeingElaborated() {
        return this.varWhoseTypeIsBeingElaborated;
    }

    public boolean isLocal(String name) {
        return this.depType == null ? this.isLocalInternal(name) : this.pop().isLocal(name);
    }

    private boolean isLocalInternal(String name) {
        if (this.isClass()) {
            return false;
        }
        if ((this.isBlock() || this.isCode()) && (this.findVariableInThisScope(name) != null || this.findInThisScope(name) != null)) {
            return true;
        }
        if (this.outer == null) {
            return false;
        }
        boolean outerRes = this.outer.isLocal(name);
        if (this.hjKind == ASYNC && outerRes) {
            return false;
        }
        return outerRes;
    }

    public MethodInstance findMethod(String name, List argTypes) throws SemanticException {
        MethodInstance result = this.depType == null ? super.findMethod(name, argTypes) : this.pop().findMethod(name, argTypes);
        return result;
    }

    public LocalInstance findLocal(String name) throws SemanticException {
        return this.depType == null ? super.findLocal(name) : this.pop().findLocal(name);
    }

    public ClassType type() {
        return this.type;
    }

    public ClassType findFieldScope(String name) throws SemanticException {
        ClassType result = super.findFieldScope(name);
        if (result == null) {
            ClassType r = this.type;
            result = ((HjContext_c)this.pop()).type();
        }
        return result;
    }

    public ClassType findMethodScope(String name) throws SemanticException {
        ClassType result = super.findMethodScope(name);
        if (result == null) {
            ClassType r = this.type;
            result = ((HjContext_c)this.pop()).type();
        }
        return result;
    }

    public FieldInstance findField(String name) throws SemanticException {
        return super.findField(name);
    }

    public VarInstance findVariable(String name) throws SemanticException {
        VarInstance vi = super.findVariable(name);
        return vi;
    }

    public VarInstance findVariableSilent(String name) {
        return super.findVariableSilent(name);
    }

    public Named find(String name) throws SemanticException {
        return super.find(name);
    }

    public Context pushSource(ImportTable it) {
        assert (this.depType == null);
        return super.pushSource(it);
    }

    public Context pushClass(ParsedClassType classScope, ClassType type) {
        assert (this.depType == null);
        return super.pushClass(classScope, type);
    }

    public Context pushBlock() {
        assert (this.depType == null);
        return super.pushBlock();
    }

    public HjContext pushWhenBlock() {
        assert (this.depType == null);
        HjContext_c c = (HjContext_c)this.pushBlock();
        c.hjKind = WHEN;
        return c;
    }

    public HjContext pushAtomicBlock() {
        assert (this.depType == null);
        HjContext c = (HjContext)super.pushBlock();
        c.setLocalCode();
        c.setNonBlockingCode();
        c.setSequentialCode();
        return c;
    }

    public HjContext pushIsolatedBlock() {
        assert (this.depType == null);
        HjContext c = (HjContext)super.pushBlock();
        c.setLocalCode();
        c.setNonBlockingCode();
        c.setSequentialCode();
        return c;
    }

    public Context pushStatic() {
        assert (this.depType == null);
        return super.pushStatic();
    }

    public Context pushCode(CodeInstance ci) {
        assert (this.depType == null);
        return super.pushCode(ci);
    }

    public Context pushAsync(CodeInstance asyncCodeInstance) {
        if (Report.should_report((Collection)TOPICS, (int)4)) {
            Report.report((int)4, (String)"push async");
        }
        HjContext_c c = (HjContext_c)this.pushCode(asyncCodeInstance);
        c.hjKind = ASYNC;
        return c;
    }

    public CodeInstance currentCode() {
        return this.depType == null ? super.currentCode() : this.pop().currentCode();
    }

    public boolean inCode() {
        return this.depType == null ? super.inCode() : this.pop().inCode();
    }

    public boolean inStaticContext() {
        return this.depType == null ? super.inStaticContext() : this.pop().inStaticContext();
    }

    public ClassType currentClass() {
        return this.depType == null ? super.currentClass() : this.pop().currentClass();
    }

    public ParsedClassType currentClassScope() {
        return this.depType == null ? super.currentClassScope() : this.pop().currentClassScope();
    }

    public void addVariable(VarInstance vi) {
        assert (this.depType == null);
        super.addVariable(vi);
    }

    public void addNamed(Named t) {
        assert (this.depType == null);
        super.addNamed(t);
    }

    public Named findInThisScope(String name) {
        return super.findInThisScope(name);
    }

    public void addNamedToThisScope(Named type) {
        super.addNamedToThisScope(type);
    }

    public ClassType findMethodContainerInThisScope(String name) {
        return super.findMethodContainerInThisScope(name);
    }

    public VarInstance findVariableInThisScope(String name) {
        if (this.depType == null) {
            return super.findVariableInThisScope(name);
        }
        VarInstance vi = ((HjContext_c)this.pop()).findVariableInThisScope(name);
        if (vi instanceof LocalInstance) {
            return vi;
        }
        try {
            HjClassType dep;
            FieldInstance myVi;
            if (this.depType instanceof HjClassType && (myVi = this.ts.findField((ReferenceType)(dep = (HjClassType)((Object)this.depType)), name, (ClassType)dep)) != null) {
                return myVi;
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        return vi;
    }

    public void addVariableToThisScope(VarInstance var) {
        assert (this.depType == null);
        super.addVariableToThisScope(var);
    }

    public void setVarWhoseTypeIsBeingElaborated(VarInstance var) {
        this.varWhoseTypeIsBeingElaborated = var;
    }

    public HjFieldInstance findProperty(String name) throws SemanticException {
        HjFieldInstance pi = null;
        FieldInstance fi = this.findField(name);
        if (fi instanceof HjFieldInstance) {
            // empty if block
        }
        return pi;
    }

    public ClassType findPropertyScope(String name) throws SemanticException {
        return this.findFieldScope(name);
    }

    public HjContext pushDepType(HjNamedType type) {
        HjContext_c v = (HjContext_c)this.push();
        v.depType = type;
        v.varWhoseTypeIsBeingElaborated = this.varWhoseTypeIsBeingElaborated;
        v.type = type instanceof ClassType ? (ClassType)type : null;
        v.inCode = false;
        return v;
    }

    public String toString() {
        return "(" + (this.depType != null ? "depType" + this.depType : this.kind.toString()) + " " + this.mapsToString() + " " + this.outer + ")";
    }

    public String getNewVarName() {
        return "hj$__var" + varCount++;
    }
}

