/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.util.Set;
import java.util.TreeSet;
import polyglot.types.Flags;

public class HjFlags
extends Flags {
    public static final Set Hj_FLAGS = new TreeSet();
    public static final Flags VALUE = HjFlags.createFlag("value", null);
    public static final Flags REFERENCE = HjFlags.createFlag("reference", null);
    public static final Flags ATOMIC = HjFlags.createFlag("atomic", null);
    public static final Flags PURE = HjFlags.createFlag("pure", null);
    public static final Flags MUTABLE = HjFlags.createFlag("mutable", null);
    public static final Flags SAFE = HjFlags.createFlag("safe", null);
    public static final Flags LOCAL = HjFlags.createFlag("local", null);
    public static final Flags NON_BLOCKING = HjFlags.createFlag("nonblocking", null);
    public static final Flags SEQUENTIAL = HjFlags.createFlag("sequential", null);

    public static Flags createFlag(String name, Flags after) {
        HjFlags.addToOrder((String)name, (Flags)after);
        Hj_FLAGS.add(name);
        return new HjFlags(name);
    }

    public static HjFlags toHjFlags(Flags f) {
        if (f instanceof HjFlags) {
            return (HjFlags)f;
        }
        HjFlags result = new HjFlags();
        return result.setX(f);
    }

    public static boolean isHjFlag(Flags f) {
        return f instanceof HjFlags;
    }

    private HjFlags() {
    }

    protected HjFlags(String name) {
        super(name);
    }

    public HjFlags setX(Flags other) {
        HjFlags f = new HjFlags();
        f.flags.addAll(this.flags);
        f.flags.addAll(other.flags());
        return f;
    }

    public HjFlags clearX(Flags other) {
        HjFlags f = new HjFlags();
        f.flags.addAll(this.flags);
        f.flags.removeAll(other.flags());
        return f;
    }

    public HjFlags retainX(Flags other) {
        HjFlags f = new HjFlags();
        f.flags.addAll(this.flags);
        f.flags.retainAll(other.flags());
        return f;
    }

    public HjFlags Value() {
        return this.setX(VALUE);
    }

    public HjFlags clearValue() {
        return this.clearX(VALUE);
    }

    public boolean isValue() {
        return this.contains(VALUE);
    }

    public static boolean isValue(Flags flags) {
        return flags.contains(VALUE);
    }

    public HjFlags Reference() {
        return this.setX(REFERENCE);
    }

    public HjFlags clearReference() {
        return this.clearX(REFERENCE);
    }

    public boolean isReference() {
        return this.contains(REFERENCE);
    }

    public HjFlags Atomic() {
        return this.setX(ATOMIC);
    }

    public HjFlags clearAtomic() {
        return this.clearX(ATOMIC);
    }

    public boolean isAtomic() {
        return this.contains(ATOMIC);
    }

    public HjFlags Pure() {
        return this.setX(PURE);
    }

    public HjFlags clearPure() {
        return this.clearX(PURE);
    }

    public boolean isPure() {
        return this.contains(PURE);
    }

    public HjFlags Safe() {
        return this.setX(SAFE);
    }

    public HjFlags clearSafe() {
        return this.clearX(SAFE);
    }

    public boolean isSafe() {
        return this.contains(SAFE);
    }

    public HjFlags Local() {
        return this.setX(LOCAL);
    }

    public HjFlags clearLocal() {
        return this.clearX(LOCAL);
    }

    public boolean isLocal() {
        return this.contains(LOCAL) || this.contains(SAFE);
    }

    public HjFlags NonBlocking() {
        return this.setX(NON_BLOCKING);
    }

    public HjFlags clearNonBlocking() {
        return this.clearX(NON_BLOCKING);
    }

    public boolean isNonBlocking() {
        return this.contains(NON_BLOCKING) || this.contains(SAFE);
    }

    public HjFlags Sequential() {
        return this.setX(SEQUENTIAL);
    }

    public HjFlags clearSequential() {
        return this.clearX(SEQUENTIAL);
    }

    public boolean isSequential() {
        return this.contains(SEQUENTIAL) || this.contains(SAFE);
    }

    public String translate() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.flags) {
            if (Hj_FLAGS.contains(s)) continue;
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }

    public boolean hasAllAnnotationsOf(HjFlags f) {
        boolean result = !(f.isSequential() && !this.isSequential() && !this.isSafe() || f.isLocal() && !this.isLocal() && !this.isSafe() || f.isNonBlocking() && !this.isNonBlocking() && !this.isSafe() || f.isSafe() && !this.isSafe());
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.flags) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }
}

