/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ArrayAccess;
import polyglot.ast.Binary;
import polyglot.ast.Binary_c;
import polyglot.ast.Call;
import polyglot.ast.Call_c;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Field_c;
import polyglot.ast.Formal;
import polyglot.ast.MethodDecl_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.Configuration;
import polyglot.ext.hj.ast.ArrayConstructor_c;
import polyglot.ext.hj.ast.Async_c;
import polyglot.ext.hj.ast.AtEach_c;
import polyglot.ext.hj.ast.Atomic_c;
import polyglot.ext.hj.ast.Await_c;
import polyglot.ext.hj.ast.Closure;
import polyglot.ext.hj.ast.Closure_c;
import polyglot.ext.hj.ast.Finish_c;
import polyglot.ext.hj.ast.ForEach_c;
import polyglot.ext.hj.ast.ForLoop_c;
import polyglot.ext.hj.ast.FutureNode_c;
import polyglot.ext.hj.ast.Future_c;
import polyglot.ext.hj.ast.Here_c;
import polyglot.ext.hj.ast.HjArrayAccess1Assign_c;
import polyglot.ext.hj.ast.HjArrayAccess1Unary_c;
import polyglot.ext.hj.ast.HjArrayAccess1_c;
import polyglot.ext.hj.ast.HjArrayAccessAssign_c;
import polyglot.ext.hj.ast.HjArrayAccessUnary_c;
import polyglot.ext.hj.ast.HjArrayAccess_c;
import polyglot.ext.hj.ast.HjBinary_c;
import polyglot.ext.hj.ast.HjCanonicalTypeNode_c;
import polyglot.ext.hj.ast.HjCast_c;
import polyglot.ext.hj.ast.HjFormal;
import polyglot.ext.hj.ast.HjInstanceof_c;
import polyglot.ext.hj.ast.HjPhasedLoop;
import polyglot.ext.hj.ast.NextWithSingle_c;
import polyglot.ext.hj.ast.Next_c;
import polyglot.ext.hj.ast.Now_c;
import polyglot.ext.hj.ast.NullableNode_c;
import polyglot.ext.hj.ast.Phased;
import polyglot.ext.hj.ast.PropertyDecl_c;
import polyglot.ext.hj.ast.RemoteCall_c;
import polyglot.ext.hj.ast.Signal_c;
import polyglot.ext.hj.ast.Wait_c;
import polyglot.ext.hj.ast.When_c;
import polyglot.ext.hj.query.QueryEngine;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjReferenceType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.NullableType;
import polyglot.ext.hj.visit.HjDelegatingVisitor;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.NoMemberException;
import polyglot.types.PrimitiveType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;

public class HjPrettyPrinterVisitor
extends HjDelegatingVisitor {
    private final CodeWriter w;
    private final Translator tr;
    private static int nextId_;
    private static final String USER_DEFINED = "user-defined";
    private static final HashMap arrayTypeToRuntimeName;
    static HashMap translationCache_;

    private static Integer getUniqueId_() {
        return new Integer(nextId_++);
    }

    public static String getId() {
        return "__var" + HjPrettyPrinterVisitor.getUniqueId_() + "__";
    }

    public HjPrettyPrinterVisitor(CodeWriter w, Translator tr) {
        this.w = w;
        this.tr = tr;
    }

    public void visit(Node n) {
        n.translate(this.w, this.tr);
    }

    public void visit(HjCast_c c) {
        this.visit((Node)c);
    }

    public void visit(HjInstanceof_c c) {
        this.visit((Node)c);
    }

    public void visit(RemoteCall_c c) {
        throw new InternalCompilerError("not implemented", c.position());
    }

    public void visit(Call_c c) {
        boolean is_check_cast;
        assert (!(c instanceof RemoteCall_c));
        Receiver target = c.target();
        Type t = target.type();
        boolean base = false;
        String f_name = c.methodInstance().name();
        ReferenceType f_container = c.methodInstance().container();
        boolean is_location_access = f_name != null && "getLocation".equals(f_name) && f_container instanceof HjReferenceType;
        HjTypeSystem xts = (HjTypeSystem)t.typeSystem();
        boolean bl = is_check_cast = f_name != null && "checkCast".equals(f_name) && f_container instanceof HjReferenceType;
        if (!(target instanceof TypeNode || target instanceof Future_c || !(t instanceof HjReferenceType) || c.isTargetImplicit() || target instanceof Special || t.isClass() && t.toClass().isAnonymous() || is_location_access || is_check_cast || !QueryEngine.INSTANCE().needsHereCheck((Call)c))) {
            new Template("place-check", t.translate(null), target).expand();
            this.w.write(".");
            this.w.write(c.name());
            this.w.write("(");
            this.w.begin(0);
            List l = c.arguments();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                Expr e = (Expr)i.next();
                c.print((Node)e, this.w, (PrettyPrinter)this.tr);
                if (!i.hasNext()) continue;
                this.w.write(",");
                this.w.allowBreak(0, " ");
            }
            this.w.end();
            this.w.write(")");
        } else {
            this.visit((Node)c);
        }
    }

    protected Object handleArrayInitClosure(Closure_c n) {
        if (n == null) {
            return n;
        }
        HjTypeSystem hjts = (HjTypeSystem)this.tr.typeSystem();
        ClassType parmType = n.returnType().type().isPrimitive() ? n.returnType().type() : hjts.parameter1();
        return new Template("array_init_closure", new Object[]{parmType.toString(), new Join("\n", n.formals()), n.body()});
    }

    public void visit(Closure_c n) {
        new Template("closure", new Object[]{n.returnType(), new Join("\n", n.formals()), n.body()}).expand();
    }

    public void visit(Binary_c binary) {
        if ((binary.operator().equals((Object)Binary.EQ) || binary.operator().equals((Object)Binary.NE)) && binary.left().type() instanceof ReferenceType && binary.right().type() instanceof ReferenceType) {
            new Template(binary.operator().equals((Object)Binary.EQ) ? "equalsequals" : "notequalsequals", binary.left(), binary.right()).expand();
        } else {
            this.visit((Node)binary);
        }
    }

    public void visit(MethodDecl_c dec) {
        TypeSystem ts = this.tr.typeSystem();
        if (dec.name().equals("main") && dec.flags().isPublic() && dec.flags().isStatic() && dec.returnType().type().isVoid() && dec.formals().size() == 1 && ((Formal)dec.formals().get(0)).type().type().equals(ts.arrayOf((Type)ts.String()))) {
            if (Configuration.HJ) {
                new Template("Main-hab", dec.formals().get(0), dec.body()).expand();
            } else {
                new Template("Main", dec.formals().get(0), dec.body()).expand();
            }
        } else {
            this.visit((Node)dec);
        }
    }

    public void visit(PropertyDecl_c dec) {
        Context c = this.tr.context();
        if (c.currentClass().flags().isInterface()) {
            return;
        }
        super.visit(dec);
    }

    private Template processPhasers(Phased c) {
        assert (null != c.phasers());
        Template phasers = null;
        if (c.phasers().isEmpty()) {
            phasers = null;
        } else if (c.phasers().size() == 2) {
            phasers = new Template("phaser", c.phasers().get(1), c.phasers().get(0));
        } else {
            Integer id = HjPrettyPrinterVisitor.getUniqueId_();
            ArrayList modeList = new ArrayList();
            ArrayList phaserList = new ArrayList();
            Iterator it = c.phasers().iterator();
            while (it.hasNext()) {
                modeList.add(it.next());
                assert (it.hasNext());
                phaserList.add(it.next());
            }
            phasers = new Template("phased", new Loop("phased-loop", phaserList, modeList, new CircularList(id)), id);
        }
        return phasers;
    }

    public void visit(Async_c a) {
        if (a.phasers() == null) {
            new Template("Async-phased", a.place(), a.body()).expand();
        } else {
            new Template("Async", a.place(), this.processPhasers(a), a.body()).expand();
        }
    }

    public void visit(Atomic_c a) {
        new Template("Atomic", a.body(), HjPrettyPrinterVisitor.getUniqueId_()).expand();
    }

    public void visit(Here_c a) {
        new Template("here").expand();
    }

    public void visit(Await_c c) {
        new Template("await", c.expr(), HjPrettyPrinterVisitor.getUniqueId_()).expand();
    }

    public void visit(Next_c d) {
        new Template("next").expand();
    }

    public void visit(NextWithSingle_c d) {
        new Template("NextWithSingle", d.body(), d.body().position().toString(), HjPrettyPrinterVisitor.getUniqueId_()).expand();
    }

    public void visit(Signal_c d) {
        new Template("signal").expand();
    }

    public void visit(Wait_c d) {
        new Template("wait").expand();
    }

    public void visit(Future_c f) {
        new Template("Future", f.place(), f.stmt(), f.body()).expand();
    }

    public void visit(ForLoop_c f) {
        HjFormal form = (HjFormal)f.formal();
        if (Configuration.LOOP_OPTIMIZATIONS && form.hasExplodedVars()) {
            String regVar = HjPrettyPrinterVisitor.getId();
            ArrayList<String> idxs = new ArrayList<String>();
            ArrayList<String> lims = new ArrayList<String>();
            ArrayList<String> idx_vars = new ArrayList<String>();
            ArrayList<Integer> vals = new ArrayList<Integer>();
            LocalInstance[] lis = form.localInstances();
            int rank = lis.length;
            for (int i = 0; i < rank; ++i) {
                idxs.add(HjPrettyPrinterVisitor.getId());
                lims.add(HjPrettyPrinterVisitor.getId());
                idx_vars.add(lis[i].name());
                vals.add(new Integer(i));
            }
            Object body = f.body();
            if (!form.isUnnamed()) {
                body = new Join("\n", new Template("point-create", new Object[]{form.flags().translate(), form.type(), form.name(), new Join(",", idxs)}), body);
            }
            body = new Join("\n", new Loop("final-var-assign", new CircularList("int"), idx_vars, idxs), body);
            new Template("forloop-mult", new Object[]{f.domain(), regVar, new Loop("forloop-mult-each", idxs, new CircularList(regVar), vals, lims), body, new Template("forloop", new Object[]{form.flags().translate(), form.type(), form.name(), regVar, new Join("\n", new Join("\n", f.locals()), f.body())})}).expand();
        } else {
            new Template("forloop", new Object[]{form.flags().translate(), form.type(), form.name(), f.domain(), new Join("\n", new Join("\n", f.locals()), f.body())}).expand();
        }
    }

    private void processPhaseredLoop(String template, HjPhasedLoop l) {
        new Template(template, new Object[]{l.formal().flags().translate(), l.formal().type(), l.formal().name(), l.domain(), new Join("\n", new Join("\n", l.locals()), l.body()), this.processPhasers(l), new Join("\n", l.locals())}).expand();
    }

    public void visit(ForEach_c f) {
        this.processPhaseredLoop("foreach", f);
    }

    public void visit(AtEach_c f) {
        this.processPhaseredLoop("ateach", f);
    }

    public void visit(Now_c n) {
        new Template("Now", n.phaser(), n.body()).expand();
    }

    public void visit(Field_c n) {
        boolean is_location_access;
        Receiver target = n.target();
        Type t = target.type();
        String f_name = n.fieldInstance().name();
        ReferenceType f_container = n.fieldInstance().container();
        boolean bl = is_location_access = f_name != null && "location".equals(f_name) && f_container instanceof HjReferenceType;
        if (!(target instanceof TypeNode || !(t instanceof HjReferenceType) || n.isTargetImplicit() || target instanceof Special || t.isClass() && t.toClass().isAnonymous() || is_location_access || !QueryEngine.INSTANCE().needsHereCheck((Field)n))) {
            new Template("place-check", t.translate(null), target).expand();
            this.w.write(".");
            this.w.write(n.name());
        } else {
            this.visit((Node)n);
        }
    }

    private Stmt optionalBreak(Stmt s) {
        NodeFactory nf = this.tr.nodeFactory();
        if (s.reachable()) {
            return nf.Break(s.position());
        }
        return null;
    }

    public void visit(When_c w) {
        new Template("when", new Object[]{w.expr(), w.stmt()}).expand();
    }

    public void visit(Finish_c a) {
        if (Configuration.HJ) {
            new Template("finish-hab", a.body(), HjPrettyPrinterVisitor.getUniqueId_()).expand();
        } else {
            new Template("finish", a.body(), HjPrettyPrinterVisitor.getUniqueId_()).expand();
        }
    }

    public void visit(ArrayConstructor_c a) {
        Type base_type = a.arrayBaseType().type();
        String kind = null;
        boolean refs_to_values = false;
        if (base_type.isPrimitive()) {
            kind = base_type.toPrimitive().kind().toString();
        } else {
            kind = USER_DEFINED;
            HjTypeSystem xt = (HjTypeSystem)base_type.typeSystem();
            refs_to_values = base_type instanceof HjType && xt.isValueType(base_type);
        }
        String runtimeName = (String)arrayTypeToRuntimeName.get(kind);
        if (runtimeName == null) {
            throw new Error("Unknown array type.");
        }
        HjParsedClassType type = (HjParsedClassType)a.type();
        if (runtimeName.equals("DoubleArray") && type.isRect() && type.isRankThree() && type.isZeroBased()) {
            runtimeName = runtimeName + "3d";
        }
        Expr init = a.initializer() instanceof Closure ? this.handleArrayInitClosure((Closure_c)a.initializer()) : a.initializer();
        String tmpl = Configuration.ARRAY_OPTIMIZATIONS ? "array_specialized_init" : "array_new_init";
        new Template(tmpl, new Object[]{runtimeName, a.distribution(), init != null ? init : "(hj.array.Operator.Pointwise)null", new Boolean(a.isSafe()), new Boolean(!a.isValue()), new Boolean(refs_to_values)}).expand();
    }

    private TypeNode getParameterType(HjType at) {
        if (at.isParametric()) {
            NodeFactory nf = this.tr.nodeFactory();
            return nf.CanonicalTypeNode(Position.COMPILER_GENERATED, at.typeParameters().get(0));
        }
        return null;
    }

    private String runtimeClassNameForPrimitiveArray(HjTypeSystem xt, Type base_type) {
        String arrayClass;
        if (xt.isBooleanArray(base_type)) {
            arrayClass = "hj.array.sharedmemory.BooleanArray_c";
        } else if (xt.isCharArray(base_type)) {
            arrayClass = "hj.array.sharedmemory.CharArray_c";
        } else if (xt.isByteArray(base_type)) {
            arrayClass = "hj.array.sharedmemory.ByteArray_c";
        } else if (xt.isShortArray(base_type)) {
            arrayClass = "hj.array.sharedmemory.ShortArray_c";
        } else if (xt.isIntArray(base_type)) {
            arrayClass = "hj.array.sharedmemory.IntArray_c";
        } else if (xt.isLongArray(base_type)) {
            arrayClass = "hj.array.sharedmemory.LongArray_c";
        } else if (xt.isFloatArray(base_type)) {
            arrayClass = "hj.array.sharedmemory.FloatArray_c";
        } else if (xt.isDoubleArray(base_type)) {
            arrayClass = "hj.array.sharedmemory.DoubleArray_c";
        } else {
            throw new Error("Unknown primitive array type.");
        }
        return arrayClass;
    }

    public void visit(HjArrayAccess1_c a) {
        Template template;
        if (QueryEngine.INSTANCE().isRectangularRankOneLowZero(a) && a.index().type().isPrimitive()) {
            Type at = a.array().type();
            HjTypeSystem xts = (HjTypeSystem)at.typeSystem();
            if (xts.isNullable(at)) {
                at = ((NullableType)at).base();
            }
            if (xts.isPrimitiveTypeArray(at)) {
                String arrayClass = this.runtimeClassNameForPrimitiveArray(xts, at);
                template = new Template("array_get_primitive_rect_rank_1_low_0", a.array(), a.index(), arrayClass);
            } else {
                template = xts.isHjArray(at) ? new Template("array_get_rect_rank_1_low_0", a.array(), a.index()) : new Template("array_get", a.array(), a.index());
            }
        } else {
            template = new Template("array_get", a.array(), a.index());
        }
        TypeNode elt_type = this.getParameterType((HjType)a.array().type());
        if (elt_type != null) {
            template = new Template("parametric", elt_type, template);
        }
        template.expand();
    }

    public void visit(HjArrayAccess_c a) {
        List index = a.index();
        assert (index.size() > 1);
        String tmpl = QueryEngine.INSTANCE().needsHereCheck(a) ? "array_get" : "array_get";
        Template template = new Template(tmpl, a.array(), new Join(",", index));
        TypeNode elt_type = this.getParameterType((HjType)a.array().type());
        if (elt_type != null) {
            template = new Template("parametric", elt_type, template);
        }
        template.expand();
    }

    public void visit(HjArrayAccess1Assign_c a) {
        Template template;
        String operator = a.operator().toString();
        HjArrayAccess1_c left = (HjArrayAccess1_c)a.left();
        if (QueryEngine.INSTANCE().isRectangularRankOneLowZero(left) && left.index().type().isPrimitive()) {
            Type base_type = left.array().type();
            HjTypeSystem xt = (HjTypeSystem)base_type.typeSystem();
            if (xt.isPrimitiveTypeArray(base_type)) {
                String arrayClass = this.runtimeClassNameForPrimitiveArray(xt, base_type);
                template = new Template("array_set_primitive_rect_rank_1_low_0", new Object[]{left.array(), left.index(), a.right(), operator, arrayClass});
            } else {
                template = xt.isHjArray(base_type) ? new Template("array_set_rect_rank_1_low_0", new Object[]{left.array(), left.index(), a.right(), operator}) : new Template("array_set", new Object[]{left.array(), left.index(), a.right(), a.opString(a.operator())});
            }
        } else {
            template = new Template("array_set", new Object[]{left.array(), left.index(), a.right(), a.opString(a.operator())});
        }
        TypeNode elt_type = this.getParameterType((HjType)a.type());
        if (elt_type != null) {
            template = new Template("parametric", elt_type, template);
        }
        template.expand();
    }

    public void visit(HjArrayAccessAssign_c a) {
        String tmpl = QueryEngine.INSTANCE().needsHereCheck(a) ? "array_set" : "array_set";
        HjArrayAccess_c left = (HjArrayAccess_c)a.left();
        List index = left.index();
        assert (index.size() > 1);
        Template template = new Template(tmpl, new Object[]{left.array(), new Join(",", index), a.right(), a.opString(a.operator())});
        TypeNode elt_type = this.getParameterType((HjType)a.type());
        if (elt_type != null) {
            template = new Template("parametric", elt_type, template);
        }
        template.expand();
    }

    public void visit(HjArrayAccess1Unary_c a) {
        Template template;
        if (a.expr() instanceof ArrayAccess) {
            this.visit((Node)a);
            return;
        }
        String operator = a.operator().toString();
        HjArrayAccess1_c expr = (HjArrayAccess1_c)a.expr();
        if (QueryEngine.INSTANCE().isRectangularRankOneLowZero(expr) && expr.index().type().isPrimitive()) {
            Type base_type = expr.array().type();
            HjTypeSystem xt = (HjTypeSystem)base_type.typeSystem();
            if (xt.isPrimitiveTypeArray(base_type)) {
                String arrayClass = this.runtimeClassNameForPrimitiveArray(xt, base_type);
                String tmpl = a.operator().isPrefix() ? "array_unary_prefix_primitive_rect_rank_1_low_0" : "array_unary_postfix_primitive_rect_rank_1_low_0";
                template = new Template(tmpl, new Object[]{expr.array(), expr.index(), arrayClass, operator});
            } else if (xt.isHjArray(base_type)) {
                String tmpl = a.operator().isPrefix() ? "array_unary_prefix_rect_rank_1_low_0" : "array_unary_postfix_rect_rank_1_low_0";
                template = new Template(tmpl, expr.array(), expr.index(), operator);
            } else {
                template = new Template("array_unary", expr.array(), expr.index(), a.opString(a.operator()));
            }
        } else {
            template = new Template("array_unary", expr.array(), expr.index(), a.opString(a.operator()));
        }
        TypeNode elt_type = this.getParameterType((HjType)a.type());
        if (elt_type != null) {
            template = new Template("parametric", elt_type, template);
        }
        template.expand();
    }

    public void visit(HjArrayAccessUnary_c a) {
        if (a.expr() instanceof ArrayAccess) {
            this.visit((Node)a);
            return;
        }
        String tmpl = QueryEngine.INSTANCE().needsHereCheck(a) ? "array_unary" : "array_unary";
        HjArrayAccess_c expr = (HjArrayAccess_c)a.expr();
        List index = expr.index();
        assert (index.size() > 1);
        Template template = new Template(tmpl, expr.array(), new Join(",", index), a.opString(a.operator()));
        TypeNode elt_type = this.getParameterType((HjType)a.type());
        if (elt_type != null) {
            new Template("parametric", elt_type, template);
        }
        template.expand();
    }

    private void printType(Type type) {
        type.print(this.w);
    }

    public void visit(NullableNode_c n) {
        Type t = n.type();
        if (t != null) {
            this.printType(t);
        } else {
            this.visit((Node)n);
        }
    }

    public void visit(FutureNode_c n) {
        Type t = n.type();
        if (t != null) {
            this.printType(t);
        } else {
            this.visit((Node)n);
        }
    }

    public void visit(HjCanonicalTypeNode_c n) {
        Type t = n.type();
        if (t != null) {
            this.printType(t);
        } else {
            this.visit((Node)n);
        }
    }

    public void visit(HjBinary_c n) {
        Expr left = n.left();
        HjType l = (HjType)left.type();
        Expr right = n.right();
        HjType r = (HjType)right.type();
        HjTypeSystem xts = (HjTypeSystem)this.tr.typeSystem();
        NodeFactory nf = this.tr.nodeFactory();
        Binary.Operator op = n.operator();
        Binary.Operator GT = Binary.GT;
        Binary.Operator LT = Binary.LT;
        Binary.Operator GE = Binary.GE;
        Binary.Operator LE = Binary.LE;
        if ((op == GT || op == LT || op == GE || op == LE) & (xts.isPoint(l) || xts.isPlace(l))) {
            String name = op == GT ? "gt" : (op == LT ? "lt" : (op == GE ? "ge" : "le"));
            this.generateStaticOrInstanceCall(n.position(), left, name, right);
            return;
        }
        Binary.Operator COND_OR = Binary.COND_OR;
        Binary.Operator COND_AND = Binary.COND_AND;
        if (op == COND_OR && (xts.isDistribution(l) || xts.isRegion(l) || xts.isPrimitiveTypeArray(l))) {
            this.generateStaticOrInstanceCall(n.position(), left, "union", right);
            return;
        }
        if (op == COND_AND && (xts.isRegion(l) || xts.isDistribution(l))) {
            this.generateStaticOrInstanceCall(n.position(), left, "intersection", right);
            return;
        }
        Binary.Operator BIT_OR = Binary.BIT_OR;
        Binary.Operator BIT_AND = Binary.BIT_AND;
        if (op == BIT_OR && (xts.isDistribution(l) || xts.isDistributedArray(l) || xts.isPlace(l))) {
            this.generateStaticOrInstanceCall(n.position(), left, "restriction", right);
            return;
        }
        Binary.Operator SUB = Binary.SUB;
        Binary.Operator ADD = Binary.ADD;
        Binary.Operator MUL = Binary.MUL;
        Binary.Operator DIV = Binary.DIV;
        if (op == SUB && (xts.isDistribution(l) || xts.isRegion(l))) {
            this.generateStaticOrInstanceCall(n.position(), left, "difference", right);
            return;
        }
        if ((op == SUB || op == ADD || op == MUL || op == DIV) && xts.isPrimitiveTypeArray(l)) {
            String name = op == SUB ? "sub" : (op == ADD ? "add" : (op == MUL ? "mul" : "div"));
            this.generateStaticOrInstanceCall(n.position(), left, name, right);
            return;
        }
        if ((op == SUB || op == ADD || op == MUL || op == DIV) && xts.isPoint(l) && !xts.isSubtype(r, (Type)xts.String())) {
            String name = op == SUB ? "sub" : (op == ADD ? "add" : (op == MUL ? "mul" : "div"));
            this.generateStaticOrInstanceCall(n.position(), left, name, right);
            return;
        }
        if ((op == SUB || op == ADD || op == MUL || op == DIV) && xts.isPoint(r) && !xts.isSubtype(l, (Type)xts.String())) {
            String name = "inv" + (op == SUB ? "sub" : (op == ADD ? "add" : (op == MUL ? "mul" : "div")));
            this.generateStaticOrInstanceCall(n.position(), right, name, left);
            return;
        }
        this.visit((Binary_c)n);
    }

    private void generateStaticOrInstanceCall(Position pos, Expr left, String name, Expr right) {
        HjTypeSystem xts = (HjTypeSystem)this.tr.typeSystem();
        NodeFactory nf = this.tr.nodeFactory();
        ReferenceType lType = (ReferenceType)left.type();
        Type rType = right.type();
        try {
            try {
                MethodInstance mi = xts.findMethod(lType, name, Collections.singletonList(rType), xts.Object());
                this.tr.print(null, (Node)nf.Call(pos, (Receiver)left, nf.Id(pos, name), right).methodInstance(mi).type(mi.returnType()), this.w);
            }
            catch (NoMemberException e) {
                MethodInstance mi = xts.findMethod((ReferenceType)xts.ArrayOperations(), name, Arrays.asList(lType, rType), xts.Object());
                this.tr.print(null, (Node)nf.Call(pos, (Receiver)nf.CanonicalTypeNode(pos, (Type)xts.ArrayOperations()), nf.Id(pos, name), left, right).methodInstance(mi), this.w);
                return;
            }
        }
        catch (SemanticException e) {
            throw new InternalCompilerError(e.getMessage(), pos, (Throwable)e);
        }
    }

    private void prettyPrint(Object o) {
        if (o instanceof Expander) {
            ((Expander)o).expand();
        } else if (o instanceof Node) {
            ((Node)o).del().translate(this.w, this.tr);
        } else {
            if (o instanceof Type) {
                throw new InternalCompilerError("Should not attempt to pretty-print a type");
            }
            if (o != null) {
                this.w.write(o.toString());
            }
        }
    }

    private void dump(String id, Object[] components) {
        String regex = HjPrettyPrinterVisitor.translate(id);
        int len = regex.length();
        int start = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (regex.charAt(pos) == '\n') {
                this.w.write(regex.substring(start, pos));
                this.w.newline(0);
                start = pos + 1;
                continue;
            }
            if (regex.charAt(pos) != '#') continue;
            this.w.write(regex.substring(start, pos));
            Integer idx = new Integer(regex.substring(pos + 1, pos + 2));
            start = ++pos + 1;
            if (idx >= components.length) {
                throw new InternalCompilerError("Template '" + id + "' uses #" + idx);
            }
            this.prettyPrint(components[idx]);
        }
        this.w.write(regex.substring(start));
    }

    private static List asList(Object a, Object b) {
        ArrayList<Object> l = new ArrayList<Object>(2);
        l.add(a);
        l.add(b);
        return l;
    }

    private static List asList(Object a, Object b, Object c) {
        ArrayList<Object> l = new ArrayList<Object>(3);
        l.add(a);
        l.add(b);
        l.add(c);
        return l;
    }

    static String translate(String id) {
        String cached = (String)translationCache_.get(id);
        if (cached != null) {
            return cached;
        }
        try {
            int read;
            String rname = Configuration.COMPILER_FRAGMENT_DATA_DIRECTORY + id + ".xcd";
            InputStream is = HjPrettyPrinterVisitor.class.getClassLoader().getResourceAsStream(rname);
            if (is == null) {
                throw new IOException("Cannot find resource '" + rname + "'");
            }
            byte[] b = new byte[is.available()];
            for (int off = 0; off < b.length; off += read) {
                read = is.read(b, off, b.length - off);
            }
            String trans = new String(b, "UTF-8");
            while (trans.indexOf("// SYNOPSIS: ") == 0) {
                trans = trans.substring(trans.indexOf(10) + 1);
            }
            if (trans.lastIndexOf(10) == trans.length() - 1) {
                trans = trans.substring(0, trans.length() - 1);
            }
            boolean newline = trans.lastIndexOf(10) == trans.length() - 1;
            trans = "/* template:" + id + " { */" + trans + "/* } */";
            if (newline) {
                trans = trans + "\n";
            }
            translationCache_.put(id, trans);
            is.close();
            return trans;
        }
        catch (IOException io) {
            throw new Error("No translation for " + id + " found!", io);
        }
    }

    static {
        arrayTypeToRuntimeName = new HashMap();
        arrayTypeToRuntimeName.put(PrimitiveType.BOOLEAN.toString(), "BooleanArray");
        arrayTypeToRuntimeName.put(PrimitiveType.BYTE.toString(), "ByteArray");
        arrayTypeToRuntimeName.put(PrimitiveType.CHAR.toString(), "CharArray");
        arrayTypeToRuntimeName.put(PrimitiveType.SHORT.toString(), "ShortArray");
        arrayTypeToRuntimeName.put(PrimitiveType.INT.toString(), "IntArray");
        arrayTypeToRuntimeName.put(PrimitiveType.LONG.toString(), "LongArray");
        arrayTypeToRuntimeName.put(PrimitiveType.FLOAT.toString(), "FloatArray");
        arrayTypeToRuntimeName.put(PrimitiveType.DOUBLE.toString(), "DoubleArray");
        arrayTypeToRuntimeName.put(USER_DEFINED, "GenericArray");
        translationCache_ = new HashMap();
    }

    public class Join
    extends Expander {
        private final String delimiter;
        private final List args;

        public Join(String delimiter, Object a, Object b) {
            this(delimiter, HjPrettyPrinterVisitor.asList(a, b));
        }

        public Join(String delimiter, Object a, Object b, Object c) {
            this(delimiter, HjPrettyPrinterVisitor.asList(a, b, c));
        }

        public Join(String delimiter, List args) {
            this.delimiter = delimiter;
            this.args = args;
        }

        public void expand() {
            HjPrettyPrinterVisitor.this.w.write("/* Join: { */");
            int N = this.args.size();
            Iterator i = this.args.iterator();
            while (i.hasNext()) {
                HjPrettyPrinterVisitor.this.prettyPrint(i.next());
                if (!i.hasNext()) continue;
                HjPrettyPrinterVisitor.this.prettyPrint(this.delimiter);
            }
            HjPrettyPrinterVisitor.this.w.write("/* } */");
        }
    }

    public class Loop
    extends Expander {
        private final String id;
        private final List[] lists;
        private final int N;

        public Loop(String id, List arg) {
            this(id, new List[]{arg});
        }

        public Loop(String id, List arg1, List arg2) {
            this(id, new List[]{arg1, arg2});
        }

        public Loop(String id, List arg1, List arg2, List arg3) {
            this(id, new List[]{arg1, arg2, arg3});
        }

        public Loop(String id, List arg1, List arg2, List arg3, List arg4) {
            this(id, new List[]{arg1, arg2, arg3, arg4});
        }

        public Loop(String id, List[] components) {
            int i;
            this.id = id;
            this.lists = components;
            assert (this.lists.length > 0);
            int n = -1;
            for (i = 0; i < this.lists.length && n == -1; ++i) {
                n = this.lists[i].size();
            }
            while (i < this.lists.length) {
                assert (this.lists[i].size() == n || this.lists[i].size() == -1);
                ++i;
            }
            this.N = n;
        }

        public void expand() {
            HjPrettyPrinterVisitor.this.w.write("/* Loop: { */");
            Object[] args = new Object[this.lists.length];
            Iterator[] iters = new Iterator[this.lists.length];
            for (int j = 0; j < this.lists.length; ++j) {
                iters[j] = this.lists[j].iterator();
            }
            for (int i = 0; i < this.N; ++i) {
                for (int j = 0; j < args.length; ++j) {
                    args[j] = iters[j].next();
                }
                HjPrettyPrinterVisitor.this.dump(this.id, args);
            }
            HjPrettyPrinterVisitor.this.w.write("/* } */");
        }
    }

    public static class CircularList
    extends AbstractList {
        private Object o;

        public CircularList(Object o) {
            this.o = o;
        }

        public Iterator iterator() {
            return new Iterator(){

                public boolean hasNext() {
                    return true;
                }

                public Object next() {
                    return CircularList.this.o;
                }

                public void remove() {
                }
            };
        }

        public Object get(int i) {
            return this.o;
        }

        public int size() {
            return -1;
        }
    }

    public class Template
    extends Expander {
        private final String id;
        private final Object[] args;

        public Template(String id) {
            this(id, new Object[0]);
        }

        public Template(String id, Object arg) {
            this(id, new Object[]{arg});
        }

        public Template(String id, Object arg1, Object arg2) {
            this(id, new Object[]{arg1, arg2});
        }

        public Template(String id, Object arg1, Object arg2, Object arg3) {
            this(id, new Object[]{arg1, arg2, arg3});
        }

        public Template(String id, Object[] args) {
            this.id = id;
            this.args = args;
        }

        public void expand() {
            HjPrettyPrinterVisitor.this.dump(this.id, this.args);
        }
    }

    public abstract class Expander {
        public abstract void expand();
    }
}

