/*
 * Decompiled with CFR 0.152.
 */
package polyglot.objinl.hj.visit;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Do;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.For;
import polyglot.ast.Id;
import polyglot.ast.If;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ast.While;
import polyglot.ext.hj.ExtensionInfo;
import polyglot.ext.hj.ast.ArrayConstructor;
import polyglot.ext.hj.ast.ConstantDistMaker;
import polyglot.ext.hj.ast.HjArrayAccess1;
import polyglot.ext.hj.ast.HjCall_c;
import polyglot.ext.hj.ast.HjLoop;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.RectRegionMaker;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Job;
import polyglot.frontend.goals.Goal;
import polyglot.objinl.hj.visit.HjPointRankTypeAnalyzer;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjCanonicalizer
extends NodeVisitor {
    public static boolean hjCanonicalizedAllJobs = false;
    public static int cntr = 1;
    Job job;
    HjNodeFactory nf;
    HjTypeSystem ts;
    ExtensionInfo.HjScheduler sched;
    Collection jobs;

    public HjCanonicalizer(Job job, HjNodeFactory nf, HjTypeSystem ts, ExtensionInfo.HjScheduler sched, Collection jobs) {
        this.job = job;
        this.nf = nf;
        this.ts = ts;
        this.sched = sched;
        this.jobs = jobs;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof Block) {
            return this.factorBlockStmts((Block)n);
        }
        if (n instanceof For) {
            For f = (For)n;
            Stmt body = f.body();
            if (!(body instanceof Block)) {
                Block block = this.nf.Block(body.position(), body);
                f = f.body((Stmt)block);
            }
            return f;
        }
        if (n instanceof HjLoop) {
            Block block;
            HjLoop xLoop = (HjLoop)n;
            LinkedList<Stmt> factorOutStmts = new LinkedList<Stmt>();
            Expr domain = (Expr)this.factorOutDistRegionConstr((Receiver)xLoop.domain(), factorOutStmts);
            Stmt body = (xLoop = xLoop.domain(domain)).body();
            if (!(body instanceof Block)) {
                block = this.nf.Block(body.position(), body);
                xLoop = xLoop.body((Stmt)block);
            }
            if (!factorOutStmts.isEmpty()) {
                factorOutStmts.add((Stmt)xLoop);
                block = this.nf.Block(n.position(), factorOutStmts);
                return block;
            }
            return xLoop;
        }
        if (n instanceof While) {
            While w = (While)n;
            Stmt body = w.body();
            if (!(body instanceof Block)) {
                Block block = this.nf.Block(body.position(), body);
                w = w.body((Stmt)block);
            }
            return w;
        }
        if (n instanceof Do) {
            Do d = (Do)n;
            Stmt body = d.body();
            if (!(body instanceof Block)) {
                Block block = this.nf.Block(body.position(), body);
                d = d.body((Stmt)block);
            }
            return d;
        }
        if (n instanceof If) {
            Block block;
            If i = (If)n;
            Stmt conseq = i.consequent();
            Stmt alt = i.alternative();
            if (!(conseq instanceof Block)) {
                block = this.nf.Block(conseq.position(), conseq);
                i = i.consequent((Stmt)block);
            }
            if (alt != null && !(alt instanceof Block)) {
                block = this.nf.Block(alt.position(), alt);
                i = i.consequent((Stmt)block);
            }
            return i;
        }
        if (n instanceof HjCall_c && (HjPointRankTypeAnalyzer.hjPointConstr((HjCall_c)n, this.ts) || HjPointRankTypeAnalyzer.hjRectRegionConstr((HjCall_c)n, this.ts))) {
            n = this.canonicalPointOrRegionConstr((Call)n);
            return n;
        }
        if (n instanceof HjCall_c && this.ts.isPoint(((HjCall_c)n).target().type())) {
            HjCall_c xc = (HjCall_c)n;
            if (xc.name().equals("get")) {
                HjArrayAccess1 xaa1 = this.nf.HjArrayAccess1(xc.position(), (Expr)xc.target(), (Expr)xc.arguments().get(0));
                xaa1 = (HjArrayAccess1)xaa1.type((Type)this.ts.Int());
                return xaa1;
            }
            return n;
        }
        return n;
    }

    private Block factorBlockStmts(Block block) {
        LinkedList<Stmt> newBlockStmts = new LinkedList<Stmt>();
        Iterator blockStmtIt = block.statements().iterator();
        LinkedList<Stmt> factorOutStmts = new LinkedList<Stmt>();
        while (blockStmtIt.hasNext()) {
            Stmt currStmt = (Stmt)blockStmtIt.next();
            if (currStmt instanceof LocalDecl) {
                LocalDecl ld = (LocalDecl)currStmt;
                if (this.factoredLocalDecl(ld, newBlockStmts, factorOutStmts)) continue;
                newBlockStmts.add((Stmt)ld);
                continue;
            }
            if (currStmt instanceof Eval) {
                Eval eval = (Eval)currStmt;
                if (this.factoredAssign(eval, newBlockStmts, factorOutStmts)) continue;
                newBlockStmts.add((Stmt)eval);
                continue;
            }
            newBlockStmts.add(currStmt);
        }
        block = block.statements(newBlockStmts);
        return block;
    }

    private boolean factoredLocalDecl(LocalDecl ld, LinkedList<Stmt> newBlockStmts, LinkedList<Stmt> factorOutStmts) {
        Expr init = ld.init();
        if (init instanceof ConstantDistMaker) {
            ConstantDistMaker cdm = (ConstantDistMaker)init;
            LinkedList<Expr> newArgs = new LinkedList<Expr>();
            newArgs.addAll(cdm.arguments());
            int regPos = 0;
            Expr regExpr = (Expr)newArgs.get(regPos);
            newArgs.set(regPos, (Expr)this.factorOutDistRegionConstr((Receiver)regExpr, factorOutStmts));
            if (!factorOutStmts.isEmpty()) {
                newBlockStmts.addAll(factorOutStmts);
                cdm = (ConstantDistMaker)cdm.arguments(newArgs);
                ld = ld.init((Expr)cdm);
                newBlockStmts.add((Stmt)ld);
                factorOutStmts.clear();
                return true;
            }
        } else if (init instanceof ArrayConstructor) {
            ArrayConstructor ac = (ArrayConstructor)init;
            Expr distExpr = ac.distribution();
            ac = ac.distribution((Expr)this.factorOutDistRegionConstr((Receiver)distExpr, factorOutStmts));
            if (!factorOutStmts.isEmpty()) {
                newBlockStmts.addAll(factorOutStmts);
                ld = ld.init((Expr)ac);
                newBlockStmts.add((Stmt)ld);
                factorOutStmts.clear();
                return true;
            }
        }
        return false;
    }

    private boolean factoredAssign(Eval eval, LinkedList<Stmt> newBlockStmts, LinkedList<Stmt> factorOutStmts) {
        if (!(eval.expr() instanceof Assign)) {
            return false;
        }
        Assign assign = (Assign)eval.expr();
        Expr right = assign.right();
        if (right instanceof ConstantDistMaker) {
            ConstantDistMaker cdm = (ConstantDistMaker)right;
            LinkedList<Expr> newArgs = new LinkedList<Expr>();
            newArgs.addAll(cdm.arguments());
            int regPos = 0;
            Expr regExpr = (Expr)newArgs.get(regPos);
            newArgs.set(regPos, (Expr)this.factorOutDistRegionConstr((Receiver)regExpr, factorOutStmts));
            if (!factorOutStmts.isEmpty()) {
                newBlockStmts.addAll(factorOutStmts);
                cdm = (ConstantDistMaker)cdm.arguments(newArgs);
                assign = assign.right((Expr)cdm);
                eval = eval.expr((Expr)assign);
                newBlockStmts.add((Stmt)eval);
                factorOutStmts.clear();
                return true;
            }
        } else if (right instanceof ArrayConstructor) {
            ArrayConstructor ac = (ArrayConstructor)right;
            Expr distExpr = ac.distribution();
            ac = ac.distribution((Expr)this.factorOutDistRegionConstr((Receiver)distExpr, factorOutStmts));
            if (!factorOutStmts.isEmpty()) {
                newBlockStmts.addAll(factorOutStmts);
                assign = assign.right((Expr)ac);
                eval = eval.expr((Expr)assign);
                newBlockStmts.add((Stmt)eval);
                factorOutStmts.clear();
                return true;
            }
        }
        return false;
    }

    private Local factorRegionMaker(RectRegionMaker rm, List<Stmt> factorList) {
        Position pos = rm.position();
        LocalDecl ld = this.createLocalDeclForFactoring(pos, rm.type(), (Expr)rm);
        Local local = this.createLocalRefForFactoring(pos, ld.localInstance(), ld.declType());
        factorList.add((Stmt)ld);
        return local;
    }

    private Local factorDistMaker(ConstantDistMaker cdm, LinkedList<Stmt> factorList) {
        Position pos = cdm.position();
        Expr regArg = (Expr)cdm.arguments().get(0);
        if ((regArg = this.factorOutDistRegionConstr((Receiver)regArg, factorList)) != null) {
            LinkedList<Expr> args = new LinkedList<Expr>();
            args.addAll(cdm.arguments());
            args.set(0, regArg);
            cdm = (ConstantDistMaker)cdm.arguments(args);
        }
        LocalDecl ld = this.createLocalDeclForFactoring(pos, cdm.type(), (Expr)cdm);
        Local local = this.createLocalRefForFactoring(pos, ld.localInstance(), ld.declType());
        factorList.add((Stmt)ld);
        return local;
    }

    private Call canonicalPointOrRegionConstr(Call c) {
        List args = c.arguments();
        Expr firstArg = null;
        if (!args.isEmpty()) {
            firstArg = (Expr)args.get(0);
        }
        if (args.size() != 1) {
            return c;
        }
        if (!(firstArg instanceof NewArray)) {
            return c;
        }
        NewArray na = (NewArray)firstArg;
        ArrayInit ai = na.init();
        if (ai == null) {
            return c;
        }
        List newArgs = ai.elements();
        c = (Call)c.arguments(newArgs);
        return c;
    }

    private Receiver factorOutDistRegionConstr(Receiver expr, LinkedList<Stmt> factList) {
        if (expr instanceof RectRegionMaker) {
            RectRegionMaker rm = (RectRegionMaker)expr;
            return this.factorRegionMaker(rm, factList);
        }
        if (expr instanceof ConstantDistMaker) {
            ConstantDistMaker cdm = (ConstantDistMaker)expr;
            return this.factorDistMaker(cdm, factList);
        }
        if (expr instanceof Field) {
            Field f = (Field)expr;
            Receiver target = this.factorOutDistRegionConstr(f.target(), factList);
            f = f.target(target);
            return f;
        }
        if (expr instanceof Call) {
            Call c = (Call)expr;
            Receiver target = this.factorOutDistRegionConstr(c.target(), factList);
            c = c.target(target);
            return c;
        }
        return expr;
    }

    private void runAllJobs() {
        if (!hjCanonicalizedAllJobs) {
            hjCanonicalizedAllJobs = true;
            for (Job j : this.jobs) {
                if (j.equals((Object)this.job)) continue;
                Goal goal = this.sched.HjCanonicalized(j);
                this.sched.attemptGoal(goal);
            }
        }
    }

    private String createUniqueName() {
        return "syncCan_" + cntr++;
    }

    private LocalDecl createLocalDeclForFactoring(Position pos, Type type, Expr init) {
        String name = this.createUniqueName();
        Id id = this.nf.Id(pos, name);
        CanonicalTypeNode tn = this.nf.CanonicalTypeNode(pos, type);
        LocalInstance li = this.ts.localInstance(pos, Flags.FINAL, tn.type(), name);
        LocalDecl ld = this.nf.LocalDecl(pos, Flags.FINAL, (TypeNode)tn, id, init);
        ld = ld.localInstance(li);
        return ld;
    }

    private Local createLocalRefForFactoring(Position pos, LocalInstance li, Type type) {
        Id id = this.nf.Id(pos, li.name());
        Local local = this.nf.Local(pos, id);
        local = local.localInstance(li);
        local = (Local)local.type(type);
        return local;
    }
}

