/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.ArbitraryRegion;
import hj.array.ContiguousRange;
import hj.array.EmptyRegion;
import hj.lang.RankMismatchException;
import hj.lang.point;
import hj.lang.region;
import java.util.Iterator;

public class BandedRegion
extends region {
    private final int bands_;
    private final region[] dims_;
    private final int size_;
    private final int offset_;

    public BandedRegion(region[] dims, int bands, boolean zeroBased) {
        super(2, false, zeroBased);
        int i;
        assert (dims != null && dims.length == 2);
        int tmp_size = dims[0].size();
        assert (tmp_size > 0);
        for (i = 0; i < dims.length; ++i) {
            assert (dims[i] instanceof ContiguousRange);
            assert (dims[i].size() == tmp_size);
            if (zeroBased) assert (dims[i].low() == 0);
        }
        assert (bands >= 1 && bands % 2 == 1);
        assert (bands <= tmp_size);
        this.bands_ = bands;
        this.dims_ = dims;
        int size = tmp_size;
        for (i = this.bands_ - 1; i > 0; i -= 2) {
            tmp_size += 2 * (size - 1);
            --size;
        }
        this.size_ = tmp_size;
        int tmp = (this.bands_ - 1) / 2;
        this.offset_ = tmp * (tmp + 1) / 2;
    }

    public int size() {
        return this.size_;
    }

    public region rank(int index) {
        assert (index >= 0);
        assert (index < 2);
        return this.dims_[index];
    }

    public boolean isConvex() {
        return true;
    }

    public int low() {
        throw new UnsupportedOperationException("BandedRegion::low");
    }

    public int high() {
        throw new UnsupportedOperationException("BandedRegion::high");
    }

    public region union(region r) {
        assert (r != null);
        region ret = ArbitraryRegion.union(this, r);
        if (ret.size() == 0) {
            new EmptyRegion(2);
        }
        return ret;
    }

    public region intersection(region r) {
        assert (r != null);
        region ret = ArbitraryRegion.intersection(this, r);
        if (ret.size() == 0) {
            new EmptyRegion(2);
        }
        return ret;
    }

    public region difference(region r) {
        assert (r != null);
        region ret = ArbitraryRegion.difference(this, r);
        if (ret.size() == 0) {
            new EmptyRegion(2);
        }
        return ret;
    }

    public region convexHull() {
        return this;
    }

    public boolean contains(point p) {
        if (p.rank != 2) {
            throw new RankMismatchException(p, 2);
        }
        return this.contains_(p.get(0), p.get(1));
    }

    public boolean contains(int[] p) {
        assert (p != null);
        return p.length == 2 && this.contains_(p[0], p[1]);
    }

    private boolean contains_(int a, int b) {
        int a_ordinal = a - this.dims_[0].low();
        int b_ordinal = b - this.dims_[1].low();
        boolean size_criterion = this.dims_[0].contains(new int[]{a}) && this.dims_[1].contains(new int[]{b});
        boolean band_criterion = Math.abs(a_ordinal - b_ordinal) <= (this.bands_ - 1) / 2;
        return band_criterion && size_criterion;
    }

    public boolean disjoint(region r) {
        assert (r != null);
        return this.intersection(r).size() == 0;
    }

    public int ordinal(point p) throws ArrayIndexOutOfBoundsException {
        assert (p != null);
        if (p.rank != 2) {
            throw new RankMismatchException(p, 2);
        }
        if (this.size() == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.contains(p)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int ret = this.ordinal_(p.get(0), p.get(1));
        return ret;
    }

    private int ordinal_(int x, int y) {
        int x_ordinal = x - this.dims_[0].low();
        int y_ordinal = y - this.dims_[1].low();
        int ret = x_ordinal * this.bands_;
        ret += y_ordinal - x_ordinal + (this.bands_ - 1) / 2;
        return ret -= this.offset_;
    }

    public point coord(int ord) throws ArrayIndexOutOfBoundsException {
        assert (ord >= 0);
        if (ord >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int x_ordinal = (ord += this.offset_) / this.bands_;
        int y_ordinal = ord % this.bands_ + x_ordinal - (this.bands_ - 1) / 2;
        int[] tmp = new int[]{x_ordinal + this.dims_[0].low(), y_ordinal + this.dims_[1].low()};
        point ret = point.factory.point(tmp);
        return ret;
    }

    public Iterator iterator() {
        return new BandedRegionIterator_();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("banded-region(bands=" + this.bands_ + ", size=" + this.size_ + ", offset=" + this.offset_ + ", ");
        sb.append(this.dims_[0].toString());
        sb.append(", ");
        sb.append(this.dims_[1].toString());
        sb.append(")");
        return sb.toString();
    }

    private class BandedRegionIterator_
    implements Iterator {
        private int nextOrd_ = 0;

        private BandedRegionIterator_() {
        }

        public boolean hasNext() {
            return this.nextOrd_ < BandedRegion.this.size_;
        }

        public void remove() {
            throw new UnsupportedOperationException("BandedRegionIterator_::remove - not implemented");
        }

        public Object next() {
            assert (this.hasNext());
            return BandedRegion.this.coord(this.nextOrd_++);
        }
    }
}

