/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.Helper;
import hj.array.Operator;
import hj.lang.DoubleReferenceArray;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.doubleArray;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Place;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Iterator;

public abstract class DoubleArray
extends DoubleReferenceArray {
    public DoubleArray(dist d, boolean mutable) {
        super(d, mutable);
    }

    protected abstract DoubleArray newInstance(dist var1);

    protected abstract DoubleArray newInstance(dist var1, double var2);

    protected final DoubleArray newInstance(dist d, Operator.Pointwise p) {
        DoubleArray res = this.newInstance(d);
        if (p != null) {
            this.scan(res, p);
        }
        return res;
    }

    public abstract double getOrdinal(int var1);

    public abstract double setOrdinal(double var1, int var3);

    public double set(double v, point pos) {
        return this.set(v, pos, true, true);
    }

    public double set(double v, point pos, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public double set(double v, int d0) {
        return this.set(v, d0, true, true);
    }

    public double set(double v, int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public double set(double v, int d0, int d1) {
        return this.set(v, d0, d1, false, false);
    }

    public double set(double v, int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public double set(double v, int d0, int d1, int d2) {
        return this.set(v, d0, d1, d2, false, false);
    }

    public double set(double v, int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public double set(double v, int d0, int d1, int d2, int d3) {
        return this.set(v, d0, d1, d2, d3, true, true);
    }

    public double set(double v, int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public double get(point pos) {
        return this.get(pos, true, true);
    }

    public double get(point pos, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public double get(int d0) {
        return this.get(d0, true, true);
    }

    public double get(int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public double get(int d0, int d1) {
        return this.get(d0, d1, true, true);
    }

    public double get(int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public double get(int d0, int d1, int d2) {
        return this.get(d0, d1, d2, true, true);
    }

    public double get(int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public double get(int d0, int d1, int d2, int d3) {
        return this.get(d0, d1, d2, d3, true, true);
    }

    public double get(int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.getOrdinal(theIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueEquals(Indexable other) {
        DoubleArray o = (DoubleArray)other;
        if (!o.distribution.equals(this.distribution)) {
            return false;
        }
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point pos = (point)it.next();
                place pl = this.distribution.get(pos);
                Runtime.runtime.setCurrentPlace(pl);
                if (this.get(pos) == o.get(pos)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assign(DoubleArray rhs) {
        assert (rhs instanceof DoubleArray);
        assert (rhs.distribution.equals(this.distribution));
        Place here = Runtime.runtime.currentPlace();
        DoubleArray rhs_t = rhs;
        try {
            Iterator it = rhs_t.distribution.region.iterator();
            while (it.hasNext()) {
                point pos = (point)it.next();
                place pl = this.distribution.get(pos);
                Runtime.runtime.setCurrentPlace(pl);
                this.set(rhs_t.get(pos), pos);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointwise(DoubleArray res, Operator.Pointwise op, DoubleArray arg) {
        assert (res == null || res.distribution.equals(this.distribution));
        assert (arg != null);
        assert (arg.distribution.equals(this.distribution));
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                double arg1 = this.get(p);
                double arg2 = arg.get(p);
                double val = op.apply(p, arg1, arg2);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointwise(DoubleArray res, Operator.Pointwise op) {
        assert (res == null || res.distribution.equals(this.distribution));
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                double arg1 = this.get(p);
                double val = op.apply(p, arg1);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduction(Operator.Reduction op) {
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                double arg1 = this.get(p);
                op.apply(arg1);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(DoubleArray res, Operator.Unary op) {
        assert (res == null || res instanceof DoubleArray);
        assert (res.distribution.equals(this.distribution));
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                double arg1 = this.get(p);
                double val = op.apply(arg1);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(DoubleArray res, Operator.Pointwise op) {
        assert (res == null || res instanceof DoubleArray);
        assert (res.distribution.equals(this.distribution));
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                double val = op.apply(p, 0.0);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleReferenceArray lift(Operator.Binary op, doubleArray arg) {
        assert (arg.distribution.equals(this.distribution));
        DoubleArray result = this.newInstance(this.distribution);
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ((DoubleReferenceArray)result).set(op.apply(this.get(p), arg.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleReferenceArray lift(Operator.Unary op) {
        DoubleArray result = this.newInstance(this.distribution);
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ((DoubleReferenceArray)result).set(op.apply(this.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double reduce(Operator.Binary op, double unit, region r) {
        double result = unit;
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = r.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                result = op.apply(this.get(p), result);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleReferenceArray scan(Operator.Binary op, double unit) {
        double temp = unit;
        DoubleArray result = this.newInstance(this.distribution);
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                temp = op.apply(this.get(p), temp);
                result.set(temp, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleReferenceArray overlay(doubleArray d) {
        dist dist2 = this.distribution.overlay(d.distribution);
        DoubleArray ret = this.newInstance(dist2, 0.0);
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                double val = d.distribution.region.contains(p) ? d.get(p) : this.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(doubleArray d) {
        assert (this.region.contains(d.region));
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = d.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                this.set(d.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleReferenceArray union(doubleArray d) {
        dist dist2 = this.distribution.union(d.distribution);
        DoubleArray ret = this.newInstance(dist2, 0.0);
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                double val = this.distribution.region.contains(p) ? this.get(p) : d.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    public DoubleReferenceArray restriction(dist d) {
        return this.restriction(d.region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleReferenceArray restriction(region r) {
        dist dist2 = this.distribution.restriction(r);
        DoubleArray ret = this.newInstance(dist2, 0.0);
        Place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ret.set(this.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    public Object toJava() {
        final int[] dims_tmp = new int[this.distribution.rank];
        for (int i = 0; i < this.distribution.rank; ++i) {
            dims_tmp[i] = this.distribution.region.rank(i).high() + 1;
        }
        final Object ret = Array.newInstance(Double.TYPE, dims_tmp);
        this.pointwise(null, new Operator.Pointwise(){

            public double apply(point p, double arg) {
                int i;
                Object handle = ret;
                for (i = 0; i < dims_tmp.length - 1; ++i) {
                    handle = Array.get(handle, p.get(i));
                }
                Array.setDouble(handle, p.get(i), arg);
                return arg;
            }
        });
        return ret;
    }

    public doubleArray toValueArray() {
        if (!this.mutable_) {
            return this;
        }
        throw new Error("TODO: <T>ReferenceArray --> <T>ValueArray");
    }

    public static void printArray(String prefix, double[][] a) {
        DoubleArray.printArray(prefix, a, System.out);
    }

    public static void printArray(String prefix, double[][] a, PrintStream out) {
        out.print(prefix + "{");
        for (int i = 0; i < a.length; ++i) {
            out.print("{");
            for (int j = 0; j < a[i].length; ++j) {
                out.print(a[i][j]);
                if (j >= a[i].length - 1) continue;
                out.print(", ");
            }
            out.print("}");
            if (i >= a.length - 1) continue;
            out.print(", ");
        }
        out.println("}");
    }
}

