/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.Runtime;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Future_c;
import hj.runtime.wsh.ModCountDownLatch;
import hj.runtime.wsh.PhaserImpl;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.VMInterface;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinishState {
    private Stack<Throwable> finish_;
    protected Activity parent;
    protected ModCountDownLatch mcdl = new ModCountDownLatch(0);
    protected List<PhaserImpl> phaserList = new LinkedList<PhaserImpl>();
    private List<Future_c> futureList;

    public FinishState(Activity activity2) {
        this.parent = activity2;
    }

    public void waitForFinish() {
        if (this.mcdl.getCount() > 0L) {
            PoolRunner activityRunner = (PoolRunner)Thread.currentThread();
            activityRunner.getPlace().threadBlockedNotification();
            try {
                this.mcdl.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            activityRunner.getPlace().threadUnblockedNotification();
        }
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            ((Activity)Runtime.getCurrentActivity()).maxCritPathOps(this.mcdl.getCritPathOps());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((Activity)Runtime.getCurrentActivity()).maxCritPathTime(this.mcdl.getIdealTime());
                ((Activity)Runtime.getCurrentActivity()).setResumeTime();
            }
        }
    }

    public void notifySubActivitySpawn() {
        this.mcdl.updateCount();
        if (Report.should_report("activity", 5)) {
            Report.report(5, " updating " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushException(Throwable t) {
        FinishState finishState = this;
        synchronized (finishState) {
            this.getFinishStack().push(t);
        }
    }

    private Stack<Throwable> getFinishStack() {
        if (this.finish_ == null) {
            this.finish_ = new Stack();
        }
        return this.finish_;
    }

    public void notifySubActivityTermination() {
        this.mcdl.countDown();
    }

    public void notifySubActivityTermination(Throwable t) {
        this.pushException(t);
        this.notifySubActivityTermination();
    }

    public Stack exceptions() {
        if (this.futureList != null) {
            for (Future_c promise : this.futureList) {
                Throwable exception;
                if (promise.forced() || (exception = promise.getException()) == null) continue;
                this.getFinishStack().push(exception);
            }
        }
        return this.finish_;
    }

    public synchronized String toString() {
        return "<FinishState " + this.hashCode() + " " + this.mcdl.getCount() + "," + this.parent.shortString() + "," + this.finish_ + ">";
    }

    public List<PhaserImpl> getPhaserList() {
        return this.phaserList;
    }

    public void registerFailedFuture(Future_c future) {
        if (this.futureList == null) {
            this.futureList = new LinkedList<Future_c>();
        }
        this.futureList.add(future);
    }
}

