/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.abstractmetrics;

import hj.runtime.wsh.abstractmetrics.AbstractMetrics;

public class AbstractMetricsImpl
implements AbstractMetrics {
    private long totalOps = 0L;
    private long critPathOps = 0L;
    private long totalUnblockedTime = 0L;
    private long critPathTime = 0L;
    private long resumeTime = 0L;

    public synchronized long getTotalOps() {
        return this.totalOps;
    }

    public synchronized long getCritPathOps() {
        return this.critPathOps;
    }

    public synchronized void addLocalOps(long n) {
        this.totalOps += n;
    }

    public synchronized void addCritPathOps(long n) {
        this.critPathOps += n;
    }

    public synchronized void maxCritPathOps(long n) {
        this.critPathOps = Math.max(this.critPathOps, n);
    }

    public synchronized long getTotalUnblockedTime() {
        return this.totalUnblockedTime;
    }

    public synchronized long getCritPathTime() {
        return this.critPathTime;
    }

    public synchronized void maxCritPathTime(long t) {
        this.critPathTime = Math.max(this.critPathTime, t);
    }

    public synchronized long getResumeTime() {
        return this.resumeTime;
    }

    public synchronized void setResumeTime() {
        this.resumeTime = this.getCurrentTime();
    }

    public synchronized void updateIdealTime() {
        long delta = this.getCurrentTime() - this.getResumeTime();
        this.totalUnblockedTime += delta;
        this.critPathTime += delta;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public synchronized void addUnblockedTime(long t) {
        this.totalUnblockedTime += t;
    }
}

