/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.BadParseException;
import lpg.runtime.BadParseSymFileException;
import lpg.runtime.ConfigurationElement;
import lpg.runtime.ConfigurationStack;
import lpg.runtime.ErrorToken;
import lpg.runtime.IPrsStream;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.NotBacktrackParseTableException;
import lpg.runtime.ParseTable;
import lpg.runtime.PrsStream;
import lpg.runtime.RecoveryParser;
import lpg.runtime.RuleAction;
import lpg.runtime.Stacks;
import lpg.runtime.TokenStream;
import lpg.runtime.TokenStreamNotIPrsStreamException;

public class BacktrackingParser
extends Stacks {
    private Monitor monitor;
    private int START_STATE;
    private int NUM_RULES;
    private int NT_OFFSET;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ERROR_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private int lastToken;
    private int currentAction;
    private TokenStream tokStream;
    private ParseTable prs;
    private RuleAction ra;
    private IntTuple action = new IntTuple(0x100000);
    private IntTuple tokens;
    private int[] actionStack;
    private boolean skipTokens = false;
    private int markerTokenIndex = 0;

    private int getMarkerToken(int marker_kind, int start_token_index) {
        if (marker_kind == 0) {
            return 0;
        }
        if (this.markerTokenIndex == 0) {
            if (!(this.tokStream instanceof IPrsStream)) {
                throw new TokenStreamNotIPrsStreamException();
            }
            this.markerTokenIndex = ((IPrsStream)this.tokStream).makeErrorToken(this.tokStream.getPrevious(start_token_index), this.tokStream.getPrevious(start_token_index), this.tokStream.getPrevious(start_token_index), marker_kind);
        } else {
            ((IPrsStream)this.tokStream).getIToken(this.markerTokenIndex).setKind(marker_kind);
        }
        return this.markerTokenIndex;
    }

    public final int getToken(int i) {
        return this.tokens.get(this.locationStack[this.stateStackTop + (i - 1)]);
    }

    public final int getCurrentRule() {
        return this.currentAction;
    }

    public final int getFirstToken() {
        return this.tokStream.getFirstRealToken(this.getToken(1));
    }

    public final int getFirstToken(int i) {
        return this.tokStream.getFirstRealToken(this.getToken(i));
    }

    public final int getLastToken() {
        return this.tokStream.getLastRealToken(this.lastToken);
    }

    public final int getLastToken(int i) {
        int l = i >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokens.get(this.locationStack[this.stateStackTop + i] - 1);
        return this.tokStream.getLastRealToken(l);
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void reset() {
        this.action.reset();
        this.skipTokens = false;
        this.markerTokenIndex = 0;
    }

    public void reset(Monitor monitor, TokenStream tokStream) {
        this.monitor = monitor;
        this.tokStream = tokStream;
        this.reset();
    }

    public void reset(TokenStream tokStream) {
        this.reset(null, tokStream);
    }

    public void reset(Monitor monitor, TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.reset(monitor, tokStream);
        this.prs = prs;
        this.ra = ra;
        this.START_STATE = prs.getStartState();
        this.NUM_RULES = prs.getNumRules();
        this.NT_OFFSET = prs.getNtOffset();
        this.LA_STATE_OFFSET = prs.getLaStateOffset();
        this.EOFT_SYMBOL = prs.getEoftSymbol();
        this.ERROR_SYMBOL = prs.getErrorSymbol();
        this.ACCEPT_ACTION = prs.getAcceptAction();
        this.ERROR_ACTION = prs.getErrorAction();
        if (!prs.isValidForParser()) {
            throw new BadParseSymFileException();
        }
        if (!prs.getBacktrack()) {
            throw new NotBacktrackParseTableException();
        }
    }

    public void reset(TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.reset(null, tokStream, prs, ra);
    }

    public BacktrackingParser() {
    }

    public BacktrackingParser(TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.reset(null, tokStream, prs, ra);
    }

    public BacktrackingParser(Monitor monitor, TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.reset(monitor, tokStream, prs, ra);
    }

    public void reallocateOtherStacks(int start_token_index) {
        if (this.actionStack == null) {
            this.actionStack = new int[this.stateStack.length];
            this.locationStack = new int[this.stateStack.length];
            this.parseStack = new Object[this.stateStack.length];
            this.actionStack[0] = 0;
            this.locationStack[0] = start_token_index;
        } else if (this.actionStack.length < this.stateStack.length) {
            int old_length = this.actionStack.length;
            this.actionStack = new int[this.stateStack.length];
            System.arraycopy(this.actionStack, 0, this.actionStack, 0, old_length);
            this.locationStack = new int[this.stateStack.length];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, old_length);
            this.parseStack = new Object[this.stateStack.length];
            System.arraycopy(this.parseStack, 0, this.parseStack, 0, old_length);
        }
    }

    public Object fuzzyParse() throws BadParseException {
        return this.fuzzyParseEntry(0, Integer.MAX_VALUE);
    }

    public Object fuzzyParse(int max_error_count) throws BadParseException {
        return this.fuzzyParseEntry(0, max_error_count);
    }

    public Object fuzzyParseEntry(int marker_kind) throws BadParseException {
        return this.fuzzyParseEntry(marker_kind, Integer.MAX_VALUE);
    }

    public Object fuzzyParseEntry(int marker_kind, int max_error_count) throws BadParseException {
        int first_token;
        this.action.reset();
        this.tokStream.reset();
        this.reallocateStateStack();
        this.stateStackTop = 0;
        this.stateStack[0] = this.START_STATE;
        int start_token = first_token = this.tokStream.peek();
        int marker_token = this.getMarkerToken(marker_kind, first_token);
        this.tokens = new IntTuple(this.tokStream.getStreamLength());
        this.tokens.add(this.tokStream.getPrevious(first_token));
        int error_token = this.backtrackParse(this.action, marker_token);
        if (error_token != 0) {
            if (!(this.tokStream instanceof IPrsStream)) {
                throw new TokenStreamNotIPrsStreamException();
            }
            RecoveryParser rp = new RecoveryParser(this, this.monitor, this.action, this.tokens, (IPrsStream)this.tokStream, this.prs, max_error_count, 0L);
            start_token = rp.recover(marker_token, error_token);
        }
        if (marker_token != 0 && start_token == first_token) {
            this.tokens.add(marker_token);
        }
        int t = start_token;
        while (this.tokStream.getKind(t) != this.EOFT_SYMBOL) {
            this.tokens.add(t);
            t = this.tokStream.getNext(t);
        }
        this.tokens.add(t);
        return this.parseActions(marker_kind);
    }

    public Object parse() throws BadParseException {
        return this.parseEntry(0, 0);
    }

    public Object parse(int max_error_count) throws BadParseException {
        return this.parseEntry(0, max_error_count);
    }

    public Object parseEntry(int marker_kind) throws BadParseException {
        return this.parseEntry(marker_kind, 0);
    }

    public Object parseEntry(int marker_kind, int max_error_count) throws BadParseException {
        int initial_error_token;
        this.action.reset();
        this.tokStream.reset();
        this.reallocateStateStack();
        this.stateStackTop = 0;
        this.stateStack[0] = this.START_STATE;
        boolean bl = this.skipTokens = max_error_count < 0;
        if (max_error_count > 0 && this.tokStream instanceof IPrsStream) {
            max_error_count = 0;
        }
        this.tokens = new IntTuple(this.tokStream.getStreamLength());
        this.tokens.add(this.tokStream.getPrevious(this.tokStream.peek()));
        int start_token_index = this.tokStream.peek();
        int repair_token = this.getMarkerToken(marker_kind, start_token_index);
        int start_action_index = this.action.size();
        int[] temp_stack = new int[this.stateStackTop + 1];
        System.arraycopy(this.stateStack, 0, temp_stack, 0, temp_stack.length);
        int error_token = initial_error_token = this.backtrackParse(this.action, repair_token);
        int count = 0;
        while (error_token != 0) {
            if (count == max_error_count) {
                throw new BadParseException(initial_error_token);
            }
            this.action.reset(start_action_index);
            this.tokStream.reset(start_token_index);
            this.stateStackTop = temp_stack.length - 1;
            System.arraycopy(temp_stack, 0, this.stateStack, 0, temp_stack.length);
            this.reallocateOtherStacks(start_token_index);
            this.backtrackParseUpToError(repair_token, error_token);
            this.stateStackTop = this.findRecoveryStateIndex(this.stateStackTop);
            while (this.stateStackTop >= 0) {
                int recovery_token = this.tokens.get(this.locationStack[this.stateStackTop] - 1);
                repair_token = this.errorRepair((IPrsStream)this.tokStream, recovery_token >= start_token_index ? recovery_token : error_token, error_token);
                if (repair_token != 0) break;
                this.stateStackTop = this.findRecoveryStateIndex(this.stateStackTop - 1);
            }
            if (this.stateStackTop < 0) {
                throw new BadParseException(initial_error_token);
            }
            temp_stack = new int[this.stateStackTop + 1];
            System.arraycopy(this.stateStack, 0, temp_stack, 0, temp_stack.length);
            start_action_index = this.action.size();
            start_token_index = this.tokStream.peek();
            error_token = this.backtrackParse(this.action, repair_token);
            ++count;
        }
        if (repair_token != 0) {
            this.tokens.add(repair_token);
        }
        int t = start_token_index;
        while (this.tokStream.getKind(t) != this.EOFT_SYMBOL) {
            this.tokens.add(t);
            t = this.tokStream.getNext(t);
        }
        this.tokens.add(t);
        return this.parseActions(marker_kind);
    }

    private final void process_reductions() {
        do {
            this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
            this.ra.ruleAction(this.currentAction);
            this.currentAction = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(this.currentAction));
        } while (this.currentAction <= this.NUM_RULES);
    }

    private Object parseActions(int marker_kind) throws BadParseException {
        int ti = -1;
        this.lastToken = this.tokens.get(++ti);
        int curtok = this.tokens.get(++ti);
        this.allocateOtherStacks();
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        int i = 0;
        while (i < this.action.size()) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return null;
            }
            this.stateStack[++this.stateStackTop] = this.currentAction;
            this.locationStack[this.stateStackTop] = ti++;
            this.currentAction = this.action.get(i);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                this.process_reductions();
            } else {
                if (this.tokStream.getKind(curtok) > this.NT_OFFSET) {
                    ErrorToken badtok = (ErrorToken)((PrsStream)this.tokStream).getIToken(curtok);
                    throw new BadParseException(badtok.getErrorToken().getTokenIndex());
                }
                this.lastToken = curtok;
                curtok = this.tokens.get(ti);
                if (this.currentAction > this.ERROR_ACTION) {
                    this.currentAction -= this.ERROR_ACTION;
                    this.process_reductions();
                }
            }
            ++i;
        }
        return this.parseStack[marker_kind == 0 ? 0 : 1];
    }

    private int process_backtrack_reductions(int act) {
        do {
            this.stateStackTop -= this.prs.rhs(act) - 1;
        } while ((act = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(act))) <= this.NUM_RULES);
        return act;
    }

    int backtrackParse(int[] stack, int stack_top, IntTuple action, int initial_token) {
        this.stateStackTop = stack_top;
        System.arraycopy(stack, 0, this.stateStack, 0, this.stateStackTop + 1);
        return this.backtrackParse(action, initial_token);
    }

    private int backtrackParse(IntTuple action, int initial_token) {
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        int error_token = 0;
        int maxStackTop = this.stateStackTop;
        int start_token = this.tokStream.peek();
        int curtok = initial_token > 0 ? initial_token : this.tokStream.getToken();
        int current_kind = this.tokStream.getKind(curtok);
        int act = this.tAction(this.stateStack[this.stateStackTop], current_kind);
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return 0;
            }
            if (act <= this.NUM_RULES) {
                action.add(act);
                --this.stateStackTop;
                act = this.process_backtrack_reductions(act);
            } else if (act > this.ERROR_ACTION) {
                action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                act = this.process_backtrack_reductions(act - this.ERROR_ACTION);
            } else if (act < this.ACCEPT_ACTION) {
                action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
            } else {
                if (act == this.ERROR_ACTION) {
                    error_token = error_token > curtok ? error_token : curtok;
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    action.reset(configuration.action_length);
                    act = configuration.act;
                    curtok = configuration.curtok;
                    current_kind = this.tokStream.getKind(curtok);
                    this.tokStream.reset(curtok == initial_token ? start_token : this.tokStream.getNext(curtok));
                    this.stateStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.stateStack);
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(this.stateStack, this.stateStackTop, curtok)) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(this.stateStack, this.stateStackTop, act + 1, curtok, action.size());
                act = this.prs.baseAction(act);
                maxStackTop = this.stateStackTop > maxStackTop ? this.stateStackTop : maxStackTop;
                continue;
            }
            try {
                this.stateStack[++this.stateStackTop] = act;
            }
            catch (IndexOutOfBoundsException e) {
                this.reallocateStateStack();
                this.stateStack[this.stateStackTop] = act;
            }
            act = this.tAction(act, current_kind);
        }
        return act == this.ERROR_ACTION ? error_token : 0;
    }

    private void backtrackParseUpToError(int initial_token, int error_token) {
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        int start_token = this.tokStream.peek();
        int curtok = initial_token > 0 ? initial_token : this.tokStream.getToken();
        int current_kind = this.tokStream.getKind(curtok);
        int act = this.tAction(this.stateStack[this.stateStackTop], current_kind);
        this.tokens.add(curtok);
        this.locationStack[this.stateStackTop] = this.tokens.size();
        this.actionStack[this.stateStackTop] = this.action.size();
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return;
            }
            if (act <= this.NUM_RULES) {
                this.action.add(act);
                --this.stateStackTop;
                act = this.process_backtrack_reductions(act);
            } else if (act > this.ERROR_ACTION) {
                this.action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                this.tokens.add(curtok);
                act = this.process_backtrack_reductions(act - this.ERROR_ACTION);
            } else if (act < this.ACCEPT_ACTION) {
                this.action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                this.tokens.add(curtok);
            } else {
                if (act == this.ERROR_ACTION) {
                    if (curtok == error_token) break;
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    this.action.reset(configuration.action_length);
                    act = configuration.act;
                    int next_token_index = configuration.curtok;
                    this.tokens.reset(next_token_index);
                    curtok = this.tokens.get(next_token_index - 1);
                    current_kind = this.tokStream.getKind(curtok);
                    this.tokStream.reset(curtok == initial_token ? start_token : this.tokStream.getNext(curtok));
                    this.stateStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.stateStack);
                    this.locationStack[this.stateStackTop] = this.tokens.size();
                    this.actionStack[this.stateStackTop] = this.action.size();
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(this.stateStack, this.stateStackTop, this.tokens.size())) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(this.stateStack, this.stateStackTop, act + 1, this.tokens.size(), this.action.size());
                act = this.prs.baseAction(act);
                continue;
            }
            this.stateStack[++this.stateStackTop] = act;
            this.locationStack[this.stateStackTop] = this.tokens.size();
            this.actionStack[this.stateStackTop] = this.action.size();
            act = this.tAction(act, current_kind);
        }
    }

    private boolean repairable(int error_token) {
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        int start_token = this.tokStream.peek();
        int final_token = this.tokStream.getStreamLength();
        int curtok = 0;
        int current_kind = this.ERROR_SYMBOL;
        int act = this.tAction(this.stateStack[this.stateStackTop], current_kind);
        while (true) {
            if (act <= this.NUM_RULES) {
                --this.stateStackTop;
                act = this.process_backtrack_reductions(act);
            } else if (act > this.ERROR_ACTION) {
                curtok = this.tokStream.getToken();
                if (curtok > final_token) {
                    return true;
                }
                current_kind = this.tokStream.getKind(curtok);
                act = this.process_backtrack_reductions(act - this.ERROR_ACTION);
            } else if (act < this.ACCEPT_ACTION) {
                curtok = this.tokStream.getToken();
                if (curtok > final_token) {
                    return true;
                }
                current_kind = this.tokStream.getKind(curtok);
            } else {
                if (act == this.ERROR_ACTION) {
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    this.stateStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.stateStack);
                    act = configuration.act;
                    curtok = configuration.curtok;
                    if (curtok == 0) {
                        current_kind = this.ERROR_SYMBOL;
                        this.tokStream.reset(start_token);
                        continue;
                    }
                    current_kind = this.tokStream.getKind(curtok);
                    this.tokStream.reset(this.tokStream.getNext(curtok));
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(this.stateStack, this.stateStackTop, curtok)) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(this.stateStack, this.stateStackTop, act + 1, curtok, 0);
                act = this.prs.baseAction(act);
                continue;
            }
            try {
                if (curtok > error_token && final_token == this.tokStream.getStreamLength() && this.recoverableState(act)) {
                    final_token = this.skipTokens ? curtok : this.tokStream.getNext(curtok);
                }
                this.stateStack[++this.stateStackTop] = act;
            }
            catch (IndexOutOfBoundsException e) {
                this.reallocateStateStack();
                this.stateStack[this.stateStackTop] = act;
            }
            act = this.tAction(act, current_kind);
        }
        return act == this.ACCEPT_ACTION;
    }

    private boolean recoverableState(int state) {
        int k = this.prs.asi(state);
        while (this.prs.asr(k) != 0) {
            if (this.prs.asr(k) == this.ERROR_SYMBOL) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private int findRecoveryStateIndex(int start_index) {
        int i = start_index;
        while (i >= 0) {
            if (this.recoverableState(this.stateStack[i])) break;
            --i;
        }
        if (i >= 0) {
            int k = i - 1;
            while (k >= 0) {
                if (this.locationStack[k] != this.locationStack[i]) break;
                --k;
            }
            i = k + 1;
        }
        return i;
    }

    private int errorRepair(IPrsStream stream, int recovery_token, int error_token) {
        int[] temp_stack = new int[this.stateStackTop + 1];
        System.arraycopy(this.stateStack, 0, temp_stack, 0, temp_stack.length);
        while (stream.getKind(recovery_token) != this.EOFT_SYMBOL) {
            stream.reset(recovery_token);
            if (this.repairable(error_token)) break;
            this.stateStackTop = temp_stack.length - 1;
            System.arraycopy(temp_stack, 0, this.stateStack, 0, temp_stack.length);
            recovery_token = stream.getNext(recovery_token);
        }
        if (stream.getKind(recovery_token) == this.EOFT_SYMBOL) {
            stream.reset(recovery_token);
            if (!this.repairable(error_token)) {
                this.stateStackTop = temp_stack.length - 1;
                System.arraycopy(temp_stack, 0, this.stateStack, 0, temp_stack.length);
                return 0;
            }
        }
        this.stateStackTop = temp_stack.length - 1;
        System.arraycopy(temp_stack, 0, this.stateStack, 0, temp_stack.length);
        stream.reset(recovery_token);
        this.tokens.reset(this.locationStack[this.stateStackTop] - 1);
        this.action.reset(this.actionStack[this.stateStackTop]);
        return stream.makeErrorToken(this.tokens.get(this.locationStack[this.stateStackTop] - 1), stream.getPrevious(recovery_token), error_token, this.ERROR_SYMBOL);
    }

    private int lookahead(int act, int token) {
        return (act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(token))) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.getNext(token)) : act;
    }

    private int tAction(int act, int sym) {
        return (act = this.prs.tAction(act, sym)) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.peek()) : act;
    }
}

