/*
 * Decompiled with CFR 0.152.
 */
package hj.ant.task;

import hj.ant.utils.HjPlatformHelper;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class Hj
extends Java {
    public static final String JAVA_LIBRARY_PATH = "java.library.path";
    public static final String ENABLE_ASSERTION_FLAG = "-ea";
    private static final String HJ_MAIN_CLASS_WSH = "hj.lang.Runtime";
    private static final String HJ_MAIN_CLASS_WST = "notyetdefined";
    private static final String HJ_PROP_CONFIGURATION = "hj.configuration";
    private static final Object HJ_WSH_RUNTIME = "wsh";
    private static final Object HJ_WST_RUNTIME = "wst";
    private File hjHome;
    private String runtime;
    private Path libPath;
    private boolean showCommand = false;

    public File getHjHome() {
        return this.hjHome;
    }

    public void setHjHome(File file) {
        this.hjHome = file;
        Path path = this.buildHjHomePath();
        if (path != null) {
            super.setClasspath(path);
        }
    }

    protected Environment.Variable buildProperty(String string, String string2) {
        Environment.Variable variable = new Environment.Variable();
        variable.setKey(string);
        variable.setValue(string2);
        return variable;
    }

    protected Path buildHjHomePath() {
        File file = new File(this.hjHome + File.separator + "lib");
        if (file.exists()) {
            String[] stringArray = file.list();
            Path path = new Path(this.getProject());
            for (String string : stringArray) {
                if (!string.endsWith(".jar")) continue;
                path.add(new Path(this.getProject(), file.getAbsolutePath() + File.separator + string));
            }
            return path;
        }
        throw new BuildException("hjHome path is invalid");
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String string) {
        this.runtime = string;
    }

    public void setClasspath(Path path) {
        super.setClasspath(path);
    }

    public Path createClasspath() {
        return super.createClasspath();
    }

    public boolean getShowCommand() {
        return this.showCommand;
    }

    public void setShowCommand(boolean bl) {
        this.showCommand = bl;
    }

    public void setConfig(File file) {
        if (!file.exists()) {
            throw new BuildException("hj configuration file not found");
        }
        Environment.Variable variable = this.buildProperty(HJ_PROP_CONFIGURATION, file.getAbsolutePath());
        super.addSysproperty(variable);
    }

    public void setLibPath(Path path) {
        if (this.libPath == null) {
            this.libPath = path;
        } else {
            this.libPath.append(path);
        }
    }

    public void buildLibPath() {
        Path path = this.buildDefaultHjPath();
        path.append(this.libPath);
        Environment.Variable variable = this.buildProperty(JAVA_LIBRARY_PATH, path.toString());
        super.addSysproperty(variable);
    }

    public Path createLibPath() {
        if (this.libPath == null) {
            this.libPath = new Path(this.getProject());
        }
        return this.libPath.createPath();
    }

    protected Path buildDefaultHjPath() {
        String string = HjPlatformHelper.hjPlatform();
        String string2 = this.getHjHomeNativeLib() + File.separator + string;
        return new Path(this.getProject(), string2);
    }

    public void setMx(String string) {
        super.setMaxmemory(string);
    }

    public void execute() throws BuildException {
        super.setFork(true);
        this.buildLibPath();
        this.buildDefaultJvmOptions();
        String string = this.buildRuntime();
        super.setClassname(string);
        super.execute();
    }

    protected void buildDefaultJvmOptions() {
        Commandline.Argument argument = this.createJvmarg();
        argument.setValue(ENABLE_ASSERTION_FLAG);
    }

    protected String buildRuntime() {
        if (this.runtime == null || this.runtime.equals(HJ_WSH_RUNTIME)) {
            return HJ_MAIN_CLASS_WSH;
        }
        if (this.runtime.equals(HJ_WST_RUNTIME)) {
            return HJ_MAIN_CLASS_WST;
        }
        throw new BuildException("Unknown runtime \"" + this.getRuntime() + "\"");
    }

    public int executeJava() throws BuildException {
        if (this.showCommand) {
            System.out.println(this.getCommandLine());
        }
        return super.executeJava();
    }

    public File getHjHomeLib() {
        File file = new File(this.hjHome + File.separator + "lib");
        return file;
    }

    public File getHjHomeNativeLib() {
        File file = new File(this.getHjHomeLib() + File.separator + "native");
        return file;
    }
}

