/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.HjToJimple.jimple.ForEachRegionExpr;
import soot.HjToJimple.jimple.HjRegionEntry;
import soot.HjToJimple.jimple.RegionExit;
import soot.HjToJimple.util.HjValueBox;
import soot.HjToJimple.util.LoopDomain;
import soot.HjToJimple.util.Phaser;
import soot.HjToJimple.util.Place;
import soot.Local;
import soot.RefType;
import soot.Type;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjForEachRegionExpr
extends HjRegionEntry
implements ForEachRegionExpr {
    protected List<Local> locals;
    protected List<Phaser> phasers;
    protected List<Place> places;
    protected LoopDomain domains;

    public HjForEachRegionExpr() {
        this.locals = new ArrayList<Local>();
        this.phasers = new ArrayList<Phaser>();
        this.places = new ArrayList<Place>();
    }

    public HjForEachRegionExpr(List<Local> locals, List<Phaser> phasers, List<Place> places, LoopDomain domains) {
        this.locals = locals;
        this.phasers = phasers;
        this.places = places;
        this.domains = domains;
    }

    public HjForEachRegionExpr(List<Local> locals, List<Phaser> phasers, List<Place> places, LoopDomain domains, RegionExit regionExit) {
        this.locals = locals;
        this.phasers = phasers;
        this.places = places;
        this.domains = domains;
        this.regionExit = regionExit;
    }

    @Override
    public void apply(Switch sw) {
    }

    @Override
    public void addLocal(Local local) {
        this.locals.add(local);
    }

    @Override
    public List<Local> getLocals() {
        return this.locals;
    }

    @Override
    public void addLocals(List<Local> localList) {
        this.locals.addAll(localList);
    }

    @Override
    public void setLocals(List<Local> localList) {
        this.locals = localList;
    }

    @Override
    public void setPhasers(List<Phaser> phaserList) {
        this.phasers = phaserList;
    }

    @Override
    public List<Phaser> getPhasers() {
        return this.phasers;
    }

    @Override
    public void setDomains(LoopDomain domains) {
        this.domains = domains;
    }

    @Override
    public LoopDomain getDomains() {
        return this.domains;
    }

    @Override
    public boolean addPhaser(Phaser phaser) {
        if (this.phasers.contains(phaser)) {
            return false;
        }
        this.phasers.add(phaser);
        return true;
    }

    @Override
    public void addPhasers(List<Phaser> phaserList) {
        this.phasers.addAll(phaserList);
    }

    @Override
    public boolean removePhaser(Phaser phaser) {
        if (!this.phasers.contains(phaser)) {
            return false;
        }
        this.phasers.remove(phaser);
        return true;
    }

    @Override
    public boolean hasPhaser(Phaser phaser) {
        return this.phasers.contains(phaser);
    }

    @Override
    public void setPlaces(List<Place> places) {
        this.places = places;
    }

    @Override
    public List<Place> getPlaces() {
        return this.places;
    }

    @Override
    public boolean addPlace(Place place) {
        if (place == null || this.places.contains(place)) {
            return false;
        }
        this.places.add(place);
        return true;
    }

    @Override
    public void addPlaces(List<Place> placeList) {
        this.places.addAll(placeList);
    }

    @Override
    public boolean removePlace(Place place) {
        if (!this.places.contains(place)) {
            return false;
        }
        this.places.remove(place);
        return true;
    }

    @Override
    public boolean hasPlace(Place place) {
        return this.places.contains(place);
    }

    @Override
    public List getUseBoxes() {
        ArrayList<HjValueBox> useBoxesList = new ArrayList<HjValueBox>();
        Iterator<Place> placeIter = this.places.iterator();
        while (placeIter.hasNext()) {
            useBoxesList.addAll(placeIter.next().getUseBoxes());
        }
        Iterator<Phaser> phaserIter = this.phasers.iterator();
        while (phaserIter.hasNext()) {
            useBoxesList.addAll(phaserIter.next().getUseBoxes());
        }
        useBoxesList.addAll(this.domains.getUseBoxes());
        Iterator<Local> localIter = this.locals.iterator();
        while (localIter.hasNext()) {
            useBoxesList.add(new HjValueBox(localIter.next()));
        }
        return useBoxesList;
    }

    @Override
    public Type getType() {
        return RefType.v();
    }

    @Override
    public Object clone() {
        return new HjForEachRegionExpr(this.locals, this.phasers, this.places, this.domains.clone(), this.regionExit);
    }

    @Override
    public String toString() {
        String str = this.entryType() + "Region Entry Locals: ";
        Iterator<Local> localIter = this.locals.iterator();
        while (localIter.hasNext()) {
            str = str + localIter.next() + " ";
        }
        str = str + "\n Region Loop Domains: " + this.domains;
        str = str + "\n Region Places: ";
        Iterator<Place> placeIter = this.places.iterator();
        while (placeIter.hasNext()) {
            str = str + placeIter.next() + " ";
        }
        str = str + "\n Region Phasers: ";
        Iterator<Phaser> phaserIter = this.phasers.iterator();
        while (phaserIter.hasNext()) {
            str = str + phaserIter.next() + " ";
        }
        return str;
    }

    @Override
    public String entryType() {
        return "ForEach";
    }
}

