/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.Collection;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Access;
import soot.JastAddJ.Body;
import soot.JastAddJ.Expr;
import soot.JastAddJ.NameType;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Local;
import soot.Value;
import soot.jimple.Jimple;

public class ArrayAccess
extends Access
implements Cloneable {
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    public ArrayAccess clone() throws CloneNotSupportedException {
        ArrayAccess node = (ArrayAccess)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ArrayAccess copy() {
        try {
            ArrayAccess node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ArrayAccess fullCopy() {
        ArrayAccess res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void toString(StringBuffer s) {
        s.append("[");
        this.getExpr().toString(s);
        s.append("]");
    }

    public void typeCheck() {
        if (this.isQualified() && !this.qualifier().type().isArrayDecl() && !this.qualifier().type().isUnknown()) {
            this.error("the type " + this.qualifier().type().name() + " of the indexed element is not an array");
        }
        if (!this.getExpr().type().unaryNumericPromotion().isInt() || !this.getExpr().type().isIntegralType()) {
            this.error("array index must be int after unary numeric promotion which " + this.getExpr().type().typeName() + " is not");
        }
    }

    public Value eval(Body b) {
        Local arrayRef = b.newTemp(this.prevExpr().eval(b));
        Local arrayIndex = b.newTemp(this.getExpr().eval(b));
        return Jimple.v().newArrayRef(this.asLocal(b, arrayRef), this.asImmediate(b, arrayIndex));
    }

    public ArrayAccess() {
    }

    public ArrayAccess(Expr p0) {
        this.setChild(p0, 0);
    }

    protected int numChildren() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public boolean isDAafter(Variable v) {
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getExpr().isDAafter(v);
    }

    public boolean isDUafter(Variable v) {
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getExpr().isDUafter(v);
    }

    public boolean isArrayAccess() {
        boolean isArrayAccess_value = this.isArrayAccess_compute();
        return isArrayAccess_value;
    }

    private boolean isArrayAccess_compute() {
        return true;
    }

    public NameType predNameType() {
        NameType predNameType_value = this.predNameType_compute();
        return predNameType_value;
    }

    private NameType predNameType_compute() {
        return NameType.EXPRESSION_NAME;
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.isQualified() ? this.qualifier().type().componentType() : this.unknownType();
    }

    public boolean isVariable() {
        boolean isVariable_value = this.isVariable_compute();
        return isVariable_value;
    }

    private boolean isVariable_compute() {
        return true;
    }

    public TypeDecl unknownType() {
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isSource(this, caller);
    }

    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().lookupMethod(name);
        }
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().hasPackage(packageName);
        }
        return this.getParent().Define_boolean_hasPackage(this, caller, packageName);
    }

    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_isDest(this, caller);
    }

    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return NameType.EXPRESSION_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().lookupType(name);
        }
        return this.getParent().Define_SimpleSet_lookupType(this, caller, name);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

